#include "SzlFileLoader.h"
#include <algorithm>
#include <fstream>
#include "exportSubzonePlt.h"
#include "IntervalTree.h"
#include "writeValueArray.h"
using namespace std; namespace tecplot { namespace ___3933 { ___372 IntervalTree::addInterval(double minValue, double maxValue) { REQUIRE(m_minimums.size() == m_maximums.size()); REQUIRE(m_minimums.size() == m_curNumIntervals); ___372 ___2039 = ___4226; m_minimums.push_back(minValue); m_maximums.push_back(maxValue); m_curNumIntervals++; return ___2039; } ___372 IntervalTree::addIntervalsMinMaxArray(TreeIndex_t numMinMaxes, ___2481 const& arrayMinMaxes) { REQUIRE( arrayMinMaxes.size() == numMinMaxes );
 #ifndef NO_ASSERTS
for ( size_t ___1841 = 0; ___1841 < numMinMaxes; ___1841++ ) REQUIRE(arrayMinMaxes[___1841].___2067());
 #endif
___372 ___2039 = ___4226; for (TreeIndex_t ___1841=0; ___1841<numMinMaxes; ___1841++) { ___2479 const& MinMaxatii = arrayMinMaxes[___1841]; double const min = MinMaxatii.minValue(); double const max = MinMaxatii.maxValue(); ___2039 = IntervalTree::addInterval(min, max); } return ___2039; } void IntervalTree::queryNode( TreeIndex_t nodeOffset, double ___4298, TreeIndexVector& intervalList) { IntervalTree::TreeNode const& treeNode = m_treeNodes[nodeOffset]; if (___4298 <= treeNode.strikeValue) { TreeIndex_t list_start = treeNode.___3681; TreeIndex_t list_end   = list_start + treeNode.size; for (TreeIndex_t i = list_start; i < list_end; i++) { TreeIndex_t intervalNum = m_alEntries[i]; double minOfInterval = m_minimums[intervalNum]; if (___4298 >= minOfInterval) intervalList.push_back(intervalNum); else break; } if (treeNode.left != BAD_ANY_INDEX) { queryNode(treeNode.left, ___4298, intervalList); } } if (___4298 >= treeNode.strikeValue) { TreeIndex_t list_start = treeNode.___3681; TreeIndex_t list_end   = list_start + treeNode.size; ___372 NotEnd = true; for (TreeIndex_t i = list_start; i < list_end && NotEnd; i++) { TreeIndex_t IntervalNum = m_dhEntries[i]; double MaxOfInterval = m_maximums[IntervalNum]; if (___4298 <= MaxOfInterval) { intervalList.push_back(IntervalNum); } else { NotEnd = false; } } if (treeNode.right != BAD_ANY_INDEX) { queryNode(treeNode.right, ___4298, intervalList); } } } void IntervalTree::queryIntervals( double ___4314, TreeIndexVector& intervalList) { if (m_root == BAD_ANY_INDEX || m_treeNodes.empty() ) { ___478(size_t(m_curNumIntervals) == m_minimums.size() && size_t(m_curNumIntervals) == m_maximums.size()); TreeIndex_t const size = m_curNumIntervals; for (TreeIndex_t ___1841 = 0; ___1841 < size; ++___1841) { if (m_minimums[___1841] <= ___4314 && m_maximums[___1841] >= ___4314) intervalList.push_back(___1841); } } else { queryNode(m_root, ___4314, intervalList); } } double IntervalTree::medianOfVector(vector<double>& arrayValues, TreeIndex_t ___2795) { REQUIRE(arrayValues.size()==___2795); REQUIRE(___2795>0); double median; if (___2795 > 1) { vector<double>::iterator medianPos = arrayValues.begin()+___2795/2; std::nth_element(arrayValues.begin(), medianPos, arrayValues.end()); median = *medianPos; } else median = arrayValues[0]; return median; } ___372 IntervalTree::minAscendingCompare(TreeIndex_t i, TreeIndex_t ___2105) { ___372 isAscending = m_minimums[i] < m_minimums[___2105]; return isAscending; } ___372 IntervalTree::maxDescendingCompare(TreeIndex_t i, TreeIndex_t ___2105) { ___372 isDescending = (m_maximums[i] > m_maximums[___2105]); return isDescending; }
 #ifdef WIN32
 #pragma warning(disable:4512) 
 #endif
class ALIncreasing { private: vector<double> const& m_Minimums; public: ALIncreasing(vector<double> const& Minimums) : m_Minimums(Minimums) { } ___372 operator()(IntervalTree::TreeIndex_t a, IntervalTree::TreeIndex_t b) const { double const valA = m_Minimums[a]; double const valB = m_Minimums[b]; return valA < valB; } };
 #ifdef WIN32
 #pragma warning(disable:4512) 
 #endif
class DHDecreasing { private: vector<double> const& m_Maximums; public: DHDecreasing(vector<double> const& Maximums) : m_Maximums(Maximums) { } ___372 operator()(IntervalTree::TreeIndex_t a, IntervalTree::TreeIndex_t b) const { double const valA = m_Maximums[a]; double const valB = m_Maximums[b]; return valA > valB; } }; IntervalTree::TreeIndex_t IntervalTree::constructNode(TreeIndexVector const& list, TreeIndex_t ___2812) { TreeIndex_t left = BAD_ANY_INDEX; TreeIndex_t right = BAD_ANY_INDEX; TreeIndex_t numLeftItems = 0; TreeIndexVector leftList; TreeIndex_t numRightItems = 0; TreeIndexVector rightList; TreeIndex_t const alDHStartSize = m_numAlDhEntries; vector<double> combinedArray; for (TreeIndex_t ___1841=0; ___1841<___2812; ___1841++) { TreeIndex_t const interval = list[___1841]; combinedArray.push_back(m_minimums[interval]); combinedArray.push_back(m_maximums[interval]); } double const strikeValue = medianOfVector(combinedArray, ___2812*2); for (TreeIndex_t ___1841=0; ___1841<___2812; ___1841++) { TreeIndex_t const interval = list[___1841]; if (m_minimums[interval] <= strikeValue && strikeValue <= m_maximums[interval]) { m_alEntries.push_back(interval); m_dhEntries.push_back(interval); m_numAlDhEntries++; } else if (m_maximums[interval] < strikeValue) { leftList.push_back(interval); numLeftItems++; } else { ___478(m_minimums[interval] > strikeValue); rightList.push_back(interval); numRightItems++; } } ALIncreasing alIncreasing(m_minimums); std::sort(m_alEntries.begin()+alDHStartSize, m_alEntries.begin()+m_numAlDhEntries, alIncreasing); DHDecreasing dhDecreasing(m_maximums); std::sort(m_dhEntries.begin()+alDHStartSize, m_dhEntries.begin()+m_numAlDhEntries, dhDecreasing); TreeIndex_t const alDHListSize = m_numAlDhEntries - alDHStartSize; if (numLeftItems > 0) left = constructNode(leftList, numLeftItems); if (numRightItems > 0) right = constructNode(rightList, numRightItems); TreeNode currentNode; currentNode.left = left; currentNode.right = right; currentNode.strikeValue = strikeValue; currentNode.___3681 = alDHStartSize; currentNode.size  = alDHListSize; m_treeNodes.push_back(currentNode); m_numTreeNodes++; TreeIndex_t offsetToCurrentNode = m_numTreeNodes - 1; ENSURE(currentNode==m_treeNodes[offsetToCurrentNode]); return offsetToCurrentNode; } ___372 IntervalTree::constructTree() { TreeIndexVector list; ___372 ___2039 = resizeVector(list,m_curNumIntervals); if ( ___2039 ) { for ( TreeIndex_t ___1841 = 0; ___1841 < m_curNumIntervals; ___1841++ ) list[___1841] = ___1841; m_root = constructNode(list, m_curNumIntervals); } return ___2039; }
 #ifdef SCOTT
___372 IntervalTree::encodeAsciiTreeNodeValue(char*           str, TreeNode const& treeNode) { ___372 ___2039 = (sprintf(str, "%*.7e" " %*" PRIu32 " %*" PRIu32 " %*" PRIu32 " %*" PRIu32, -___196, treeNode.strikeValue, -___209, treeNode.___3681, -___209, treeNode.size, -___209, treeNode.left, -___209, treeNode.right) > 0); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 IntervalTree::___4550( FileWriterInterface& file, char const*          ___972, ___4636          ___1251) { INVARIANT(sizeof(TreeNode)==24); REQUIRE(file.___2041()); REQUIRE(VALID_DESCRIPTION(___972)); REQUIRE("extraID could have any value. NO_EXTRA_ID shows only the description"); REQUIRE(m_numTreeNodes > 0); REQUIRE(m_treeNodes.size() == m_numTreeNodes); return ___4563<TreeNode>(file, ___972, ___1251, m_numTreeNodes, &m_treeNodes[0], encodeAsciiTreeNodeValue, ___946/5); } ___372 IntervalTree::___4479( FileWriterInterface& file, char const*          ___972, ___4636          ___1251) { INVARIANT(sizeof(TreeIndex_t)==4); REQUIRE(file.___2041()); REQUIRE(VALID_DESCRIPTION(___972)); REQUIRE("extraID could have any value. NO_EXTRA_ID shows only the description"); REQUIRE(m_numAlDhEntries > 0); REQUIRE(m_alEntries.size() == m_numAlDhEntries); return ___4563<uint32_t, false, 0>(file, ___972, ___1251, m_numAlDhEntries, &m_alEntries[0], ___1163); } ___372 IntervalTree::___4505( FileWriterInterface& file, char const*          ___972, ___4636          ___1251) { INVARIANT(sizeof(TreeIndex_t)==4); REQUIRE(file.___2041()); REQUIRE(VALID_DESCRIPTION(___972)); REQUIRE("extraID could have any value. NO_EXTRA_ID shows only the description"); REQUIRE(m_numAlDhEntries > 0); REQUIRE(m_dhEntries.size() == m_numAlDhEntries); return ___4563<uint32_t, false, 0>(file, ___972, ___1251, m_numAlDhEntries, &m_dhEntries[0], ___1163); }
 #endif
___372 IntervalTree::writeTreeToFile( FileWriterInterface& file, ___1172           zone) { ___372 ___2039 = true; REQUIRE(file.___2041()); REQUIRE(m_numTreeNodes > 0); REQUIRE(m_treeNodes.size() == m_numTreeNodes); REQUIRE(m_alEntries.size() == m_curNumIntervals); REQUIRE(m_dhEntries.size() == m_curNumIntervals);
 #ifdef SCOTT
___4550(file, "TreeNodesForZone", zone); ___4479(file, "TreeALForZone", zone); ___4505(file, "TreeDHForZone", zone);
 #else
___4278(file); ___4278(zone);
 #endif
 #if 0 
INVARIANT(sizeof(___2479)==8); return ___4563<___2479>(file, ___972, ___1251, ___2795, &___2480[0], ___1159, ___946/2);
 #endif
return ___2039; }
 #if 0 
___372 IntervalTree::writeTreeToFile() { ___372 ___2039 = true; ofstream outfile("xvar.tree", ios::out | ios::binary); outfile.write((const char*)&m_numTreeNodes, sizeof(TreeIndex_t)); outfile.write((const char*)&m_curNumIntervals, sizeof(TreeIndex_t)); outfile.write((const char *)&m_treeNodes[0], m_numTreeNodes*sizeof(TreeNode)); outfile.write((const char *)&m_minimums[0], m_curNumIntervals*sizeof(double)); outfile.write((const char *)&m_maximums[0], m_curNumIntervals*sizeof(double)); return ___2039; }
 #endif
___372 IntervalTree::readTreeFromFile(FileWriterInterface& file) { ___4278(file); ___372 ___2039 = true; ifstream infile("xvar.tree", ios::in | ios::binary); TreeIndex_t ___2821; infile.read((char*)&___2821, sizeof(TreeIndex_t)); TreeIndex_t numIntervals; infile.read((char*)&numIntervals, sizeof(TreeIndex_t)); ___2039 = ___2039 && resizeVector(m_treeNodes, ___2821); ___2039 = ___2039 && resizeVector(m_minimums, numIntervals); ___2039 = ___2039 && resizeVector(m_maximums, numIntervals); if ( ___2039 ) { infile.read((char *)&m_treeNodes[0], ___2821*sizeof(TreeNode)); infile.read((char *)&m_minimums[0], numIntervals*sizeof(double)); infile.read((char *)&m_maximums[0], numIntervals*sizeof(double)); } return ___2039; } }}
