#include "MinMaxTree.h"
namespace tecplot { namespace ___3933 { void MinMaxTree::populateTree( EntryIndex_t ___2795) { REQUIRE(___2795 == m_size); REQUIRE(m_minMaxArraysByDepth.size() == MAX_DEPTH); REQUIRE(m_minMaxArraysByDepth[0].size() == ___2795); for (EntryIndex_t childDepth = 0; childDepth < MAX_DEPTH-1; ++childDepth) { ___2481 const& childMinMaxArray = m_minMaxArraysByDepth[childDepth]; EntryIndex_t const numChildEntries = getNumEntriesAtDepth(___2795,childDepth); REQUIRE(childMinMaxArray.size() == numChildEntries); EntryIndex_t const parentDepth = childDepth+1; ___2481& parentMinMaxArray = m_minMaxArraysByDepth[parentDepth]; EntryIndex_t const numParentEntries = getNumEntriesAtDepth(___2795,parentDepth); REQUIRE(parentMinMaxArray.size() == numParentEntries); for ( EntryIndex_t parent = 0; parent < numParentEntries; parent++ ) { EntryIndex_t childStart; EntryIndex_t childEnd; getChildRangeUsingNumEntries(parent, numChildEntries, childStart, childEnd); ___2479 minMax(childMinMaxArray[childStart]); for ( EntryIndex_t child = childStart+1; child < childEnd; child++ ) minMax.include(childMinMaxArray[child]); parentMinMaxArray[parent] = minMax; } } ENSURE(isValidlyPopulated(___2795)); ENSURE(isPopulated()); } void MinMaxTree::recursivelyFindEntriesContainingNVarValues( ___3269<MinMaxTree const*> const&     minMaxTrees, ___3269<double> const&                vals, EntryIndex_t                           depth, EntryIndex_t                           startPos, EntryIndex_t                           endPos, EntryIndex_t                           numEntriesInTree, ___2090::___2980               ___2977, ___3269<___2090::SubzoneAddress>& entryAddresses) { size_t const numTrees = minMaxTrees.size(); REQUIRE(!minMaxTrees.empty()); REQUIRE(VALID_REF(minMaxTrees[0]) && minMaxTrees[0]->isValidlyPopulated(numEntriesInTree)); REQUIRE(VALID_REF(minMaxTrees[numTrees/2]) && minMaxTrees[numTrees/2]->isValidlyPopulated(numEntriesInTree)); REQUIRE(VALID_REF(minMaxTrees[numTrees-1]) && minMaxTrees[numTrees-1]->isValidlyPopulated(numEntriesInTree)); REQUIRE(minMaxTrees.size() == vals.size()); REQUIRE(depth < MinMaxTree::MAX_DEPTH); REQUIRE(startPos < endPos); REQUIRE(endPos <= MinMaxTree::getNumEntriesAtDepth(numEntriesInTree,depth)); REQUIRE(numEntriesInTree == minMaxTrees[0]->size() && numEntriesInTree == minMaxTrees[numTrees/2]->size() && numEntriesInTree == minMaxTrees[numTrees-1]->size()); for ( EntryIndex_t pos = startPos; pos < endPos; ++pos ) { ___372 posContainsAllValues = ___4226; for (size_t treeIndex = 0; posContainsAllValues && treeIndex < numTrees; ++treeIndex) { ___2479 const& minMaxAtDepth = minMaxTrees[treeIndex]->getMinMaxAtDepth(depth,pos); posContainsAllValues = minMaxAtDepth.containsValue(vals[treeIndex]); } if (posContainsAllValues) { if ( depth > 0 ) { EntryIndex_t childStart; EntryIndex_t childEnd; minMaxTrees[0]->getChildRange(numEntriesInTree, depth, pos, childStart, childEnd); ___478(childStart < childEnd); ___478(childEnd <= MinMaxTree::getNumEntriesAtDepth(numEntriesInTree,depth-1)); recursivelyFindEntriesContainingNVarValues( minMaxTrees, vals, depth-1, childStart, childEnd, numEntriesInTree, ___2977, entryAddresses); } else { if (entryAddresses.empty()) entryAddresses.reserve(MIN_ENTRIES_TO_ALLOCATE); else if (entryAddresses.size() >= entryAddresses.capacity()) entryAddresses.reserve(entryAddresses.size() * ALLOCATION_EXPANSION_FACTOR); entryAddresses.append(___2090::SubzoneAddress(___2977, pos)); } } } } }}
