#include "SZLFEPartitionedZoneHeaderWriter.h"
#include "ThirdPartyHeadersBegin.h"
#include <boost/assign.hpp>
#include "ThirdPartyHeadersEnd.h"
#include "AltTecUtil.h"
#include "ItemSetIterator.h"
#include "writeValueArray.h"
namespace tecplot { namespace ___3933 { SZLFEPartitionedZoneHeaderWriter::SZLFEPartitionedZoneHeaderWriter( ItemSetIterator&                  varIter, ___4636                       zone, ___4636                       ___341, ___37&                       ___36, ___2240<int32_t> const& partitionFileNums, UInt64Array const&                partitionHeaderFilePositions, UInt32Array const&                partitionNumCells, UInt32Array const&                partitionNumNodes, VarZoneMinMaxArray const&         varPartitionMinMaxes) : ZoneHeaderWriterAbstract(varIter, zone, ___341, ___36) , m_partitionFileNums(partitionFileNums) , m_partitionHeaderFilePositions(partitionHeaderFilePositions) , m_partitionNumCells(partitionNumCells) , m_partitionNumNodes(partitionNumNodes) , m_varPartitionMinMaxes(varPartitionMinMaxes) {} SZLFEPartitionedZoneHeaderWriter::~SZLFEPartitionedZoneHeaderWriter() {} uint64_t SZLFEPartitionedZoneHeaderWriter::sizeInFile(bool ___2002) const { uint64_t ___3358 = zoneHeaderTagsSizeInFile(6, ___2002); size_t numPartitions = static_cast<size_t>(___2337.zoneGetNumPartitions(___2677 + 1)); ___3358 += arraySizeInFile<int32_t, false>(numPartitions, ___2002); ___3358 += 2 * arraySizeInFile<uint32_t, false>(numPartitions, ___2002); ___3358 += arraySizeInFile<uint64_t, true  >(numPartitions, ___2002); m_varIter.reset(); while (m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); FieldDataType_e ___1363 = const_cast<___37&>(___2337).___923(___2677 + 1, datasetVar + 1); switch (___1363) { case FieldDataType_Float: ___3358 += arraySizeInFile<std::pair<float, float>, false >(numPartitions, ___2002); break; case FieldDataType_Double: ___3358 += arraySizeInFile<std::pair<double, double>, false >(numPartitions, ___2002); break; case FieldDataType_Int32: ___3358 += arraySizeInFile<std::pair<int32_t, int32_t>, false >(numPartitions, ___2002); break; case FieldDataType_Int16: ___3358 += arraySizeInFile<std::pair<int16_t, int16_t>, false >(numPartitions, ___2002); break; case FieldDataType_Byte: case ___1365: ___3358 += arraySizeInFile<std::pair<uint8_t, uint8_t>, false >(numPartitions, ___2002); break; default: ___478(___1305); break; } } return ___3358; } ___372 SZLFEPartitionedZoneHeaderWriter::write(FileWriterInterface& fileWriter) const { REQUIRE(fileWriter.___2041()); ___4636 numPartitions = ___2337.zoneGetNumPartitions(___2677 + 1); ___372 ___2039 = ___4226; try { ___3945 ___3944 = boost::assign::map_list_of<uint16_t, uint64_t> (NUM_PARTITIONS_TAG, uint64_t(numPartitions)) (PARTITION_FILE_NUM_TAG, ___330) (PARTITION_FILE_LOC_TAG, ___330) (PARTITION_NUM_CELLS_TAG, ___330) (PARTITION_NUM_NODES_TAG, ___330) (VAR_PARTITION_MIN_MAX_TAG, ___330); ___1393 headerFileLoc = fileWriter.fileLoc(); ___2039 = ___4565(fileWriter, ___3944); ___4636 const fileZone = ___2677 - m_baseZone; if (___2039) { ___3944[PARTITION_FILE_NUM_TAG] = fileWriter.fileLoc(); ___2039 = ___4563<int32_t, false, 0>(fileWriter, appendZoneSuffix(PARTITION_FILE_NUM_DESCRIPTION).c_str(), fileZone, numPartitions, &m_partitionFileNums[0]); } if (___2039) { ___3944[PARTITION_FILE_LOC_TAG] = fileWriter.fileLoc(); ___2039 = ___4563<uint64_t, true, 0>(fileWriter, appendZoneSuffix(PARTITION_FILE_LOC_DESCRIPTION).c_str(), fileZone, numPartitions, &m_partitionHeaderFilePositions[0]); } if (___2039) { ___3944[PARTITION_NUM_CELLS_TAG] = fileWriter.fileLoc(); ___2039 = ___4563<uint32_t, false, 0>(fileWriter, appendZoneSuffix(PARTITION_NUM_CELLS_DESCRIPTION).c_str(), fileZone, numPartitions, &m_partitionNumCells[0]); } if (___2039) { ___3944[PARTITION_NUM_NODES_TAG] = fileWriter.fileLoc(); ___2039 = ___4563<uint32_t, false, 0>(fileWriter, appendZoneSuffix(PARTITION_NUM_NODES_DESCRIPTION).c_str(), fileZone, numPartitions, &m_partitionNumNodes[0]); } if (___2039) { ___3944[VAR_PARTITION_MIN_MAX_TAG] = fileWriter.fileLoc(); m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (___2039 && m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; FieldDataType_e ___1363 = const_cast<___37&>(___2337).___923(___2677 + 1, datasetVar + 1); switch (___1363) { case FieldDataType_Float: ___2039 = ___2039 && ___4528<float>(fileWriter, VAR_PARTITION_MIN_MAX_DESCRIPTION "ForVar", fileVar, numPartitions, &m_varPartitionMinMaxes[fileVar][0], ___946 / 2); break; case FieldDataType_Double: ___2039 = ___2039 && ___4528<double>(fileWriter, VAR_PARTITION_MIN_MAX_DESCRIPTION "ForVar", fileVar, numPartitions, &m_varPartitionMinMaxes[fileVar][0], ___946 / 2); break; case FieldDataType_Int32: ___2039 = ___2039 && ___4528<int32_t>(fileWriter, VAR_PARTITION_MIN_MAX_DESCRIPTION "ForVar", fileVar, numPartitions, &m_varPartitionMinMaxes[fileVar][0], ___946 / 2);
break; case FieldDataType_Int16: ___2039 = ___2039 && ___4528<int16_t>(fileWriter, VAR_PARTITION_MIN_MAX_DESCRIPTION "ForVar", fileVar, numPartitions, &m_varPartitionMinMaxes[fileVar][0], ___946 / 2); break; case FieldDataType_Byte: case ___1365: ___2039 = ___2039 && ___4528<uint8_t>(fileWriter, VAR_PARTITION_MIN_MAX_DESCRIPTION "ForVar", fileVar, numPartitions, &m_varPartitionMinMaxes[fileVar][0], ___946 / 2); break; default: ___478(___1305); break; } } } ___1393 endFileLoc = fileWriter.fileLoc(); ___2039 = ___2039 && fileWriter.___3459(headerFileLoc) && ___4565(fileWriter, ___3944) && fileWriter.___3459(endFileLoc); } catch(std::bad_alloc const&) { ___2039 = ___1186("Out of memory while writing zone %d header.", ___2677 + 1); } catch(...) { ___2039 = ___1186("Unrecoverable error while writing zone %d header.", ___2677 + 1); } return ___4226; } }}
