#include "SZLFEPartitionedZoneWriter.h"
#include "ThirdPartyHeadersBegin.h"
#include <boost/assign.hpp>
#include <boost/make_shared.hpp>
#include <boost/ref.hpp>
#include <boost/scoped_ptr.hpp>
#include <new>
#include <set>
#include "ThirdPartyHeadersEnd.h"
#include "FEZoneInfo.h"
#include "FieldData.h"
#include "ItemSetIterator.h"
#include "SZLFEPartitionWriter.h"
#include "writeValueArray.h"
#include "ZoneInfoCache.h"
namespace tecplot { namespace ___3933 { SZLFEPartitionedZoneWriter::SZLFEPartitionedZoneWriter( ItemSetIterator&              varIter, ___4636                   zone, ___4636                   ___341, std::vector<___372> const& ___4564, ___372                     ___4499, ___37&                   ___36, ZoneInfoCache&                zoneInfoCache) : ___4709(varIter, zone, ___341, ___4564, ___4499, ___36) , m_headerWriter( varIter, zone, ___341, ___36, m_partitionFileNums, m_partitionHeaderFilePositions, m_partitionNumCells, m_partitionNumNodes, m_varPartitionMinMaxes) , ___2680(zoneInfoCache) , m_partitionTecUtil(___36, zone + 1) { REQUIRE(0 <= zone && ___36.___4638(zone + 1)); REQUIRE(VALID_BOOLEAN(___4499)); REQUIRE(___36.zoneIsPartitioned(zone + 1)); size_t const numVarsToWrite = static_cast<size_t>(m_varIter.___2812()); size_t const numPartitions = static_cast<size_t>(___36.zoneGetNumPartitions(zone + 1)); if (!m_partitionFileNums.alloc(numPartitions, 0) || !m_partitionHeaderFilePositions.alloc(numPartitions, ___330) || !m_partitionNumCells.alloc(numPartitions, 0) || !m_partitionNumNodes.alloc(numPartitions, 0) || !___3356(m_varPartitionMinMaxes, numVarsToWrite, numPartitions)) throw std::bad_alloc(); } SZLFEPartitionedZoneWriter::~SZLFEPartitionedZoneWriter() {} namespace { bool gatherConnectedCellInfo( boost::unordered_set<___2090::SubzoneOffset_t>& cellSubzones, std::vector<___2479>&                                varMinMaxes, int64_t ___2709, ___2724 const&                        ___2723, PartitionTecUtilDecorator const&                    partitionTecUtil, std::vector<___1352> const&                       fieldDatas, ___1350 const&                                   zoneInfo, boost::unordered_set<int64_t> const&                ghostCellSet) { REQUIRE(cellSubzones.empty()); REQUIRE(varMinMaxes.size() == fieldDatas.size()); REQUIRE(0 < ___2709); REQUIRE(___2723.___2067()); REQUIRE(IMPLICATION(fieldDatas[0].___2067(), fieldDatas[0].___1786() == ___4330)); REQUIRE(IMPLICATION(fieldDatas.back().___2067(), fieldDatas.back().___1786() == ___4330)); bool foundConnectedNonGhostCell = false; ___2742 nodeToElemMap = partitionTecUtil.dataNodeToElemMapGetReadableRef(zoneInfo.getPartition() + 1); for(___465 elemIndex = 1; elemIndex <= partitionTecUtil.dataNodeToElemMapGetNumElems(nodeToElemMap, ___2709); ++elemIndex) { ___465 ___449 = partitionTecUtil.dataNodeToElemMapGetElem(nodeToElemMap, ___2709, elemIndex); if (ghostCellSet.find(___449) != ghostCellSet.end()) continue; foundConnectedNonGhostCell = true; ___2090 szCoordinate = zoneInfo.szCoordinateAtZoneCell(___449 - 1); cellSubzones.insert(szCoordinate.subzoneOffset()); for(int32_t ___681 = 1; ___681 <= ___2723.___1764(); ++___681) { int64_t ___2709 = ___2723.___1763(___449, ___681); for(size_t i = 0; i < varMinMaxes.size(); ++i) { if (fieldDatas[i].___2067()) { double ___4298 = fieldDatas[i].___1780(___2709); varMinMaxes[i].include(___4298); } else { varMinMaxes[i].include(0.0); } } } } return foundConnectedNonGhostCell; } } void SZLFEPartitionedZoneWriter::gatherNeighborCellSubzoneInfo( NeighborCellSubzoneInfoMap& neighborCellSubzoneInfoMap, ___2090::___2980 ___2977, ___4352 ___2843, ___2724& ___2723, std::vector<___1352> const& fieldDatas, ___1350 const& zoneInfo) { boost::unordered_set<int64_t> ghostCellSet; GhostInfo_pa partitionGhostCellInfo = ___2337.zonePartitionGhostCellInfoGetRef(___2677 + 1, ___2977 + 1); for(___81 itemNum = 1; itemNum <= ___2337.ghostInfoGetNumItemsByRef(partitionGhostCellInfo); ++itemNum) { ___81 ___449 = ___2337.ghostInfoGetItemByRef(partitionGhostCellInfo, itemNum); ghostCellSet.insert(static_cast<int32_t>(___449)); } GhostInfo_pa partitionGhostNodeInfo = ___2337.zonePartitionGhostNodeInfoGetRef(___2677 + 1, ___2977 + 1); for(___81 itemNum = 1; itemNum <= ___2337.ghostInfoGetNumItemsByRef(partitionGhostNodeInfo); ++itemNum) { ___81 ___2709 = ___2337.ghostInfoGetItemByRef(partitionGhostNodeInfo, itemNum); ___2090::___2980 neighbor = ___2337.ghostInfoGetNeighborByRef(partitionGhostNodeInfo, itemNum); ___81 neighborNode = ___2337.ghostInfoGetNeighborItemByRef(partitionGhostNodeInfo, itemNum); boost::unordered_set<___2090::SubzoneOffset_t> cellSubzones; std::vector<___2479> varMinMaxes(___2843); if (gatherConnectedCellInfo(cellSubzones, varMinMaxes, ___2709, ___2723, m_partitionTecUtil, fieldDatas, zoneInfo, ghostCellSet)) { NeighborCellSubzoneInfo& neighborCellSubzoneInfo = neighborCellSubzoneInfoMap[neighbor - 1]; neighborCellSubzoneInfo.m_nodes.push_back(___2709 - 1); neighborCellSubzoneInfo.m_neighborNodes.push_back(neighborNode - 1); neighborCellSubzoneInfo.m_cellSubzones.push_back(cellSubzones); neighborCellSubzoneInfo.m_varMinMaxes.push_back(varMinMaxes); }
} } void SZLFEPartitionedZoneWriter::exchangeGhostInfo(std::vector<boost::shared_ptr<___1350> >& partitionInfos) { PartitionTecUtilDecorator partitionTecUtilDecorator(___2337, ___2677 + 1); ___4352 const numVarsToWrite = m_varIter.___2812(); ___2090::___2980 const numPartitions = static_cast<___2090::___2980>(___2337.zoneGetNumPartitions(___2677 + 1)); for(___2090::___2980 ___2977 = 0; ___2977 < numPartitions; ++___2977) { ___2724 ___2723(&partitionTecUtilDecorator, ___2977 + 1); std::vector<___1352> fieldDatas(numVarsToWrite); m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; if (___2337.___4353(datasetVar + 1) && !___2337.___926(___2677 + 1, datasetVar + 1)) { if (___2337.___910(___2677 + 1, datasetVar + 1) == ___4330) fieldDatas[fileVar] = ___1352(&partitionTecUtilDecorator, ___2977 + 1, datasetVar + 1, false, false); else fieldDatas[fileVar] = ___1352(&partitionTecUtilDecorator, ___2977 + 1, datasetVar + 1, false, true); } } NeighborCellSubzoneInfoMap neighborCellSubzoneInfoMap; gatherNeighborCellSubzoneInfo(neighborCellSubzoneInfoMap, ___2977, numVarsToWrite, ___2723, fieldDatas, *(partitionInfos[___2977])); std::set<___2090::___2980> referencedPartitions; for(___2090::___2980 i = 0; i < partitionInfos[___2977]->getNumReferencedPartitions(); ++i) referencedPartitions.insert(partitionInfos[___2977]->getReferencedPartitions()[i]); BOOST_FOREACH(NeighborCellSubzoneInfoMap::value_type const& valuePair, neighborCellSubzoneInfoMap) { ___2090::___2980 const neighbor = valuePair.first; NeighborCellSubzoneInfo const& neighborCellSubzoneInfo = valuePair.second; referencedPartitions.insert(neighbor); partitionInfos[neighbor]->addNeighborCszInfo(___2977, neighborCellSubzoneInfo.m_neighborNodes, neighborCellSubzoneInfo.m_cellSubzones, neighborCellSubzoneInfo.m_varMinMaxes); for(size_t i = 0; i < neighborCellSubzoneInfo.m_nodes.size(); ++i) { ___2090 szCoordinate = partitionInfos[neighbor]->___3924(neighborCellSubzoneInfo.m_neighborNodes[i]); partitionInfos[___2977]->addNeighborNodeCoordinate(neighborCellSubzoneInfo.m_nodes[i], szCoordinate); } } if (!referencedPartitions.empty()) partitionInfos[___2977]->addReferencedPartitions(referencedPartitions); } } void SZLFEPartitionedZoneWriter::createPartitionWriters() { std::vector<boost::shared_ptr<___1350> > partitionInfos; for(___4636 ___2977 = 0; ___2977 < ___2337.zoneGetNumPartitions(___2677 + 1); ++___2977) { partitionInfos.push_back(___2680.getFEZonePartitionInfo(___2677, m_baseZone, ___2977, m_partitionTecUtil)); m_partitionNumCells[___2977] = static_cast<uint32_t>(partitionInfos[___2977]->___1766() - partitionInfos[___2977]->getNumGhostCells()); m_partitionNumNodes[___2977] = static_cast<uint32_t>(partitionInfos[___2977]->___1768() - partitionInfos[___2977]->getNumGhostNodes()); } exchangeGhostInfo(partitionInfos); for(___4636 ___2977 = 0; ___2977 < ___2337.zoneGetNumPartitions(___2677 + 1); ++___2977) { m_partitionWriters[___2977] = boost::make_shared<SZLFEPartitionWriter> ( boost::ref(m_varIter), ___2677, m_baseZone, ___2977, boost::ref(m_writeVariables), m_writeConnectivity, boost::ref(m_partitionTecUtil), partitionInfos[___2977]); } } ___372 SZLFEPartitionedZoneWriter::writeZoneData(FileWriterInterface& szpltFile) { if (m_partitionWriters.empty()) createPartitionWriters(); for(___4636 ___2977 = 0; ___2977 < ___2337.zoneGetNumPartitions(___2677 + 1); ++___2977) { m_partitionWriters[___2977]->writeZone(szpltFile, szpltFile.fileLoc()); m_partitionHeaderFilePositions[___2977] = m_partitionWriters[___2977]->getZoneHeaderFilePosition(); m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; m_varPartitionMinMaxes[fileVar][___2977] = m_partitionWriters[___2977]->varMinMax(datasetVar); } } return ___4226; } uint64_t SZLFEPartitionedZoneWriter::zoneDataFileSize(bool ___2002) { if (m_partitionWriters.empty()) createPartitionWriters(); uint64_t ___3358 = 0; for(___4636 ___2977 = 0; ___2977 < ___2337.zoneGetNumPartitions(___2677 + 1); ++___2977) ___3358 += m_partitionWriters[___2977]->zoneFileSize(___2002); return ___3358; } ___372 SZLFEPartitionedZoneWriter::writeZoneConnectivity(FileWriterInterface&  ) { return ___4226; } uint64_t SZLFEPartitionedZoneWriter::zoneConnectivityFileSize(bool  ) { return 0; } ___372 SZLFEPartitionedZoneWriter::writeZoneHeader(FileWriterInterface& szpltFile) { REQUIRE(szpltFile.___2041()); return m_headerWriter.write(szpltFile); } uint64_t SZLFEPartitionedZoneWriter::zoneHeaderFileSize(bool ___2002)
{ return m_headerWriter.sizeInFile(___2002); } }}
