#include "SZLFEZoneWriter.h"
#include "ThirdPartyHeadersBegin.h"
#include <boost/assign.hpp>
#include <boost/bind.hpp>
#include <boost/function.hpp>
#include <boost/make_shared.hpp>
#include <boost/unordered_set.hpp>
#include "ThirdPartyHeadersEnd.h"
 #if !defined TECIOMPI
#include "AtomicMinMax.h"
 #endif
#include "checkPercentDone.h"
#include "FECellSubzoneCompressor.h"
#include "FieldData.h"
#include "gatherOffsets.h"
#include "IJKZoneInfo.h"
#include "ItemSetIterator.h"
#include "NodeMap.h"
#include "writeValueArray.h"
 #define MINMAX_MAX_TASKS_PER_CORE 16 
 #define MINMAX_MIN_CSZ_TASK_SIZE 16 
 #define MINMAX_MIN_NODE_TASK_SIZE 16 
 #define FEWRITER_MIN_CSZS_PER_CHUNK 1000 
 #define FEWRITER_MAX_CSZS_PER_CHUNK 1000 
namespace tecplot { namespace ___3933 { SZLFEZoneWriter::SZLFEZoneWriter( ItemSetIterator&                           varIter, ___4636                                zone, ___4636                                ___341, std::vector<___372> const&              ___4564, ___372                                  ___4499, ___37&                                ___36, boost::shared_ptr<___1350 const> const& zoneInfo) : ___4709(varIter, zone, ___341, ___4564, ___4499, ___36) , m_headerWriter(varIter, zone, ___341, ___36, *zoneInfo, (___4499 == ___4226), ___2673, m_cszConnectivityFileLocs, m_nszConnectivityFileLocs, m_numRefNodeSubzones, m_numRefCellSubzones, m_cszIncludesPartitionOffsetsBitArray, m_nszIncludesPartitionOffsetsBitArray) , m_feZoneInfo(zoneInfo) , m_zoneNumberLabel(SZPLT_ZONE_NUM_DESCRIPTION) { ___4352 const numVarsToWrite = m_varIter.___2812(); if (!___2673.alloc(numVarsToWrite, ___330)) { std::ostringstream ___2892; ___2892 << "Unable to allocate arrays for outputting zone " << zone; throw std::runtime_error(___2892.str()); } } SZLFEZoneWriter::~SZLFEZoneWriter() {} void SZLFEZoneWriter::setZoneNumberLabel(std::string const& zoneNumberLabel) { REQUIRE(!zoneNumberLabel.empty()); m_zoneNumberLabel = zoneNumberLabel; } namespace { void calculateAndApplyCellMinMaxes( ___2090::SubzoneOffset_t              cellSubzoneStart, ___2090::SubzoneOffset_t              cellSubzoneEnd, ___1350 const&                         ___1349, ___2724 const&                            ___2723, ___1352 const&                          nlFieldData, ___1352 const&                          ccFieldData,
 #if defined TECIOMPI
___2481&                          cszMinMaxArray, ___2481&                          ___2762)
 #else
___2240<___225<double> >& cszMinMaxArray, ___2240<___225<double> >& ___2762)
 #endif
{ REQUIRE(___2723.___2067()); REQUIRE(nlFieldData.___2067()); ___682 const ___2789 = static_cast<___682>(___2723.___1764()); ___478(___2789 <= MAX_NUM_CELL_CORNERS); for (___2090::SubzoneOffset_t ___469 = cellSubzoneStart; ___469 < cellSubzoneEnd; ++___469) { ___2090::ItemOffset_t const ___2782 = ___1349.___2782(___469); for (___2090::ItemOffset_t cszOffset = 0; cszOffset < ___2782; cszOffset++) { ___2090 ___688(___2090::UNKNOWN_PARTITION, ___469, cszOffset); ___465 const zoneCell = ___1349.___4608(___688); ___2718 zoneNodeAtCorner[MAX_NUM_CELL_CORNERS]; ___2479 cellMinMax; for (___682 ___681 = 0; ___681 < ___2789; ++___681) { ___2718 const ___4656 = ___2723.___1763(zoneCell + 1, ___681 + 1) - 1; zoneNodeAtCorner[___681] = ___4656; cellMinMax.include(nlFieldData.___1780(___4656 + 1)); } for (___682 ___681 = 0; ___681 < ___2789; ++___681) { ___2090 const ___2759 = ___1349.___3924(zoneNodeAtCorner[___681]); ___2090::___2980 const ___2977 = ___2759.___2977(); if (___2977 == ___1349.getPartition()) { ___2090::SubzoneOffset_t const ___2734 = ___2759.subzoneOffset(); ___2762[___2734].include(cellMinMax); } } if ( ccFieldData.___2067() ) cellMinMax.include(ccFieldData.___1780(zoneCell + 1)); cszMinMaxArray[___469].include(cellMinMax); } } } } namespace {
 #if !defined TECIOMPI
void applyNodalValuesToNodeSubzoneMinMaxes( ___2718 nodeStart, ___2718 nodeEnd, ___1352 const& ___1351, ___1350 const& ___1349, boost::unordered_set<___2718> const& ghostNodeSet,
 #if defined TECIOMPI
___2481& ___2762)
 #else
___2240<___225<double> >& ___2762)
 #endif
{ REQUIRE(___1351.___2067()); for (___2718 ___4656 = nodeStart; ___4656 < nodeEnd; ++___4656) { if (ghostNodeSet.find(___4656) == ghostNodeSet.end()) { double const ___4298 = ___1351.___1780(___4656 + 1); ___2090 const ___2759 = ___1349.___3924(___4656); ___478 (___2759.___2977() == ___1349.getPartition()); ___2090::SubzoneOffset_t const ___2757 = ___2759.subzoneOffset(); ___2762[___2757].include(___4298); } } } typedef boost::function<void(void)> VoidFunction; void STDCALL threadPoolJob(___90 ___2123) { VoidFunction* voidFunction = reinterpret_cast<VoidFunction*>(___2123); (*voidFunction)(); delete voidFunction; } ___372 calculateAndApplyCellMinMaxesMultithreaded( ___37 &___36, ___1350 const& ___1349, ___4636 zone, ___2724& ___2723, ___1352 const& nlFieldData, ___1352 const& ccFieldData, ___2481 &cszMinMaxArray, ___2481 &___2762) { ___2240<___225<double> > atomicCszMinMaxArray; ___2240<___225<double> > atomicNszMinMaxArray; ___2090::SubzoneOffset_t const ___2783 = ___1349.___2783(); ___2090::SubzoneOffset_t const ___2823 = ___1349.___2823(); ___372 ___2039 = atomicCszMinMaxArray.alloc(___2783) && atomicNszMinMaxArray.alloc(___2823); if (___2039) { size_t const maxNumTasks = static_cast<size_t>(___36.___4157() * MINMAX_MAX_TASKS_PER_CORE); size_t const numCszTasksAtMinJobSize = static_cast<size_t>(___2783 + MINMAX_MIN_CSZ_TASK_SIZE - 1) / MINMAX_MIN_CSZ_TASK_SIZE; size_t const numCszTasks = std::min(numCszTasksAtMinJobSize, maxNumTasks); ___2120 ___2119 = ___36.___4158(); ___2090::SubzoneOffset_t cellSubzoneStart = 0; for (size_t task = 1; task <= numCszTasks; ++task) { ___2090::SubzoneOffset_t const cellSubzoneEnd = static_cast<___2090::SubzoneOffset_t>(___2783 * task / numCszTasks); ___478(cellSubzoneStart < cellSubzoneEnd); VoidFunction* voidFunction = new VoidFunction(boost::bind( &calculateAndApplyCellMinMaxes, cellSubzoneStart, cellSubzoneEnd, boost::ref(___1349), boost::ref(___2723), boost::ref(nlFieldData), boost::ref(ccFieldData), boost::ref(atomicCszMinMaxArray), boost::ref(atomicNszMinMaxArray))); ___36.___4156(threadPoolJob, (___90)voidFunction, ___2119); cellSubzoneStart = cellSubzoneEnd; } ___2718 const ___2821 = ___1349.___1768(); size_t const numNodesTasksAtMinJobSize = static_cast<size_t>(___2821 + MINMAX_MIN_NODE_TASK_SIZE - 1) / MINMAX_MIN_NODE_TASK_SIZE; size_t const numNodeTasks = std::min(numNodesTasksAtMinJobSize, maxNumTasks); boost::unordered_set<___2718> ghostNodeSet; GhostInfo_pa ghostNodeInfo = ___36.zoneGhostNodeInfoGetRef(zone + 1); if (ghostNodeInfo) for (___81 i = 0; i < ___36.ghostInfoGetNumItemsByRef(ghostNodeInfo); ++i) ghostNodeSet.insert(static_cast<___2718>(___36.ghostInfoGetItemByRef(ghostNodeInfo, i + 1) - 1)); ___2718 nodeStart = 0; for (size_t task = 1; task <= numNodeTasks; ++task) { ___2718 const nodeEnd = static_cast<___2718>(___2821 * task / numNodeTasks); ___478(nodeStart < nodeEnd); VoidFunction *voidFunction = new VoidFunction(boost::bind( applyNodalValuesToNodeSubzoneMinMaxes, nodeStart, nodeEnd, nlFieldData, boost::ref(___1349), boost::ref(ghostNodeSet), boost::ref(atomicNszMinMaxArray))); ___36.___4156(threadPoolJob, (___90)voidFunction, ___2119); nodeStart = nodeEnd; } ___36.___4161(___2119); ___36.___4159(&___2119); if (___2039) { for (___2090::SubzoneOffset_t ___469 = 0; ___469 < ___2783; ++___469) { ENSURE(atomicCszMinMaxArray[___469].___2067()); cszMinMaxArray[___469].include(atomicCszMinMaxArray[___469].minValue()); cszMinMaxArray[___469].include(atomicCszMinMaxArray[___469].maxValue()); } for (___2090::SubzoneOffset_t ___2734 = 0; ___2039 && ___2734 < ___2823; ++___2734) { ENSURE(atomicNszMinMaxArray[___2734].___2067()); ___2762[___2734].include(atomicNszMinMaxArray[___2734].minValue()); ___2762[___2734].include(atomicNszMinMaxArray[___2734].maxValue()); } atomicCszMinMaxArray.___937(); atomicNszMinMaxArray.___937(); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #endif 
___372 ___1667( ___37&        ___36, ___1350 const&  ___1349, ___4636        zone, ___4352         fileVar, ___1352 const&   nlFieldData, ___1352 const&   ccFieldData, ___2481&       cszMinMaxArray, ___2481&       ___2762) { REQUIRE(zone >= 0); REQUIRE(fileVar >= 0); REQUIRE(nlFieldData.___2067()); REQUIRE("ccFieldData might be invalid if not CC data"); ___372 ___2039 = ___4226; ___2729 ___2723 = boost::make_shared<___2724>(&___36, zone + 1); if (!___2723->___2067()) ___2039 = ___1305; if (___2039) {
 #ifndef NO_ASSERTS
___2090::SubzoneOffset_t const ___2783 = ___1349.___2783(); ___2090::SubzoneOffset_t const ___2823 = ___1349.___2823(); for (___2090::SubzoneOffset_t ___2734 = 0; ___2734 < ___2823; ___2734++) ___478(!___2762[___2734].___2067()); for (___2090::SubzoneOffset_t ___469 = 0; ___469 < ___2783; ___469++) ___478(!cszMinMaxArray[___469].___2067());
 #endif
___1350::NszMinMaxMap const& nszMinMaxes = ___1349.getNszMinMaxes(); BOOST_FOREACH(___1350::NszMinMaxMap::value_type const& valuePair, nszMinMaxes) ___2762[valuePair.first].include(valuePair.second[fileVar]);
 #if defined TECIOMPI
calculateAndApplyCellMinMaxes(0, ___1349.___2783(), ___1349, *___2723, nlFieldData, ccFieldData, cszMinMaxArray, ___2762);
 #else
___2039 = calculateAndApplyCellMinMaxesMultithreaded(___36, ___1349, zone, *___2723, nlFieldData, ccFieldData, cszMinMaxArray, ___2762);
 #endif
} ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 SZLFEZoneWriter::calculateVarSubzoneMinMaxes( ___4352   datasetVar, ___2481& ___2762, ___2481& cszMinMaxArray) { REQUIRE(cszMinMaxArray.empty()); REQUIRE(___2762.empty()); REQUIRE(m_writeVariables[datasetVar - m_varIter.baseItem()]); ___372 ___2039 = ___4226; ___2039 = ___2039 && cszMinMaxArray.alloc(m_feZoneInfo->___2783(), ___2479()); ___2039 = ___2039 && ___2762.alloc(m_feZoneInfo->___2823(), ___2479()); if (___2039) { if (___2337.___910(___2677 + 1, datasetVar + 1) == ___4330) { ___1352 nlFieldData(&___2337, ___2677 + 1, datasetVar + 1, false , false/*___964*/); ___1352 ccFieldData; ___2039 = nlFieldData.___2067() && ___1667(___2337, *m_feZoneInfo, ___2677, datasetVar - m_varIter.baseItem(), nlFieldData, ccFieldData, cszMinMaxArray, ___2762); } else { ___1352 nlFieldData(&___2337, ___2677 + 1, datasetVar + 1, false , true/*___964*/); ___1352 ccFieldData(&___2337, ___2677 + 1, datasetVar + 1, false , false/*___964*/); ___2039 = nlFieldData.___2067() && ccFieldData.___2067() && ___1667(___2337, *m_feZoneInfo, ___2677, datasetVar - m_varIter.baseItem(), nlFieldData, ccFieldData, cszMinMaxArray, ___2762); } } return ___2039; } ___372 SZLFEZoneWriter::___4501( FileWriterInterface&         file, ___2090::SubzoneOffset_t ___469) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); if (file.___2002()) { ___2039 = writeValue<uint32_t, false, 0>(file, "cszConnectivityMarker*", SZPLT_CSZ_CONNECTIVITY_MARKER) && writeValue<uint32_t, false, 0>(file, m_zoneNumberLabel.c_str(), (___2677 - m_baseZone + 1)) && writeValue<uint64_t, false, 0>(file, "subzoneNum*", ___469 + 1); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } uint64_t SZLFEZoneWriter::cszConnectivityHeaderFileSize(bool ___2002) { uint64_t ___3358 = 0; if (___2002) { ___3358 += 2 * valueSizeInFile<uint32_t, false>(___2002) + valueSizeInFile<uint64_t, false>(___2002); } return ___3358; } ___372 SZLFEZoneWriter::___4500( FileWriterInterface&           file, ___1339 const& compressor, bool                           outputPartitionIndices) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; if (outputPartitionIndices) { if (compressor.numRefPartitions() <= MAX_REFS_FOR_2_BIT_COMPRESSION) { uint8_t const* refPtn2BitOffsets = compressor.refPtn2BitOffsets(); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, "refPtn2BitOffsets", ___2745, (compressor.numRefNszs() + 3) / 4, &refPtn2BitOffsets[0], ___946 / 4); } else if (compressor.numRefPartitions() <= MAX_REFS_FOR_4_BIT_COMPRESSION) { uint8_t const* refPtn4BitOffsets = compressor.refPtn4BitOffsets(); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, "refPtn4BitOffsets", ___2745, (compressor.numRefNszs() + 1) / 2, &refPtn4BitOffsets[0], ___946 / 2); } else if (compressor.numRefPartitions() <= MAX_REFS_FOR_8_BIT_COMPRESSION) { uint8_t const* refPtn8BitOffsets = compressor.refPtn8BitOffsets(); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, "refPtn8BitOffsets", ___2745, compressor.numRefNszs(), &refPtn8BitOffsets[0]); } else { uint16_t const* refPtn16BitOffsets = compressor.refPtn16BitOffsets(); ___2039 = ___2039 && ___4563<uint16_t, true, 0>(file, "refPtn16BitOffsets", ___2745, compressor.numRefNszs(), &refPtn16BitOffsets[0]); } } ___2039 = ___2039 && ___4563<uint32_t, false, 1>(file, CSZ_CONNECT_REF_NSZ_ARRAY_DESCRIPTION, ___2745, compressor.numRefNszs(), &compressor.___3319()[0]); size_t ___2795 = static_cast<size_t>(compressor.___2782() * m_feZoneInfo->___1767()); if (compressor.numRefNszs() <= MAX_REFS_FOR_2_BIT_COMPRESSION) { uint8_t const* refNsz2BitOffsets = compressor.refNsz2BitOffsets(); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, CSZ_CONNECT_REF_NSZ_OFFSET_2BIT_ARRAY_DESCRIPTION, ___2745, ___2795 / 4, &refNsz2BitOffsets[0], m_feZoneInfo->___1767()/4); } else if (compressor.numRefNszs() <= MAX_REFS_FOR_4_BIT_COMPRESSION) { uint8_t const* ___3321 = compressor.___3321(); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, CSZ_CONNECT_REF_NSZ_OFFSET_4BIT_ARRAY_DESCRIPTION, ___2745, ___2795 / 2, &___3321[0], m_feZoneInfo->___1767()/2); } else if (compressor.numRefNszs() <= MAX_REFS_FOR_8_BIT_COMPRESSION) { uint8_t const* ___3322 = compressor.___3322(); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, CSZ_CONNECT_REF_NSZ_OFFSET_8BIT_ARRAY_DESCRIPTION, ___2745, ___2795, &___3322[0], m_feZoneInfo->___1767()); } else { uint16_t const* ___3320 = compressor.___3320(); ___2039 = ___2039 && ___4563<uint16_t, true, 0>(file, CSZ_CONNECT_REF_NSZ_OFFSET_16BIT_ARRAY_DESCRIPTION, ___2745, ___2795, &___3320[0], m_feZoneInfo->___1767());
} uint8_t const* ___2764 = compressor.___2764(); ___2039 = ___2039 && ___4563<uint8_t, false, 0>(file, CSZ_CONNECT_NSZ_OFFSET_ARRAY_DESCRIPTION, ___2745, ___2795, &___2764[0], m_feZoneInfo->___1767()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } uint64_t SZLFEZoneWriter::cszConnectivityDataFileSize( bool ___2002, size_t totalNumCellCorners, size_t numRefNszs, ___2090::___2980 numRefPartitions, bool outputPartitionIndices) { uint64_t ___3358 = 0; if (outputPartitionIndices) { if (numRefPartitions <= MAX_REFS_FOR_2_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >((numRefNszs + 3) / 4, ___2002); else if (numRefPartitions <= MAX_REFS_FOR_4_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >((numRefNszs + 1) / 2, ___2002); else if (numRefPartitions <= MAX_REFS_FOR_8_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >(numRefNszs, ___2002); else ___3358 += arraySizeInFile<uint16_t, true  >(numRefNszs, ___2002); } ___3358 += arraySizeInFile<uint32_t, false>(numRefNszs, ___2002); if (numRefNszs <= MAX_REFS_FOR_2_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >(totalNumCellCorners / 4, ___2002); else if (numRefNszs <= MAX_REFS_FOR_4_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >(totalNumCellCorners / 2, ___2002); else if (numRefNszs <= MAX_REFS_FOR_8_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >(totalNumCellCorners, ___2002); else ___3358 += arraySizeInFile<uint16_t, true  >(totalNumCellCorners, ___2002); ___3358 += arraySizeInFile<uint8_t, false>(totalNumCellCorners, ___2002); return ___3358; } struct CompressSubzoneJobData { ___2240<___1339>* m_compressorVector; ___2729 ___2497; ___1350 const* m_feZoneInfo; ___2090::SubzoneOffset_t m_compressorBegin; ___2090::SubzoneOffset_t m_subzoneBegin; ___2090::SubzoneOffset_t m_subzoneCount; }; void STDCALL compressSubzoneJob(___90 ___2123) { CompressSubzoneJobData* compressSubzoneJobData = reinterpret_cast<CompressSubzoneJobData*>(___2123); ___2240<___1339>& compressorVector = *compressSubzoneJobData->m_compressorVector; ___2729 ___2723 = compressSubzoneJobData->___2497; ___1350 const& ___1349 = *compressSubzoneJobData->m_feZoneInfo; ___2090::SubzoneOffset_t const compressorBegin = compressSubzoneJobData->m_compressorBegin; ___2090::SubzoneOffset_t const subzoneBegin = compressSubzoneJobData->m_subzoneBegin; ___2090::SubzoneOffset_t const subzoneCount = compressSubzoneJobData->m_subzoneCount; for (___2090::SubzoneOffset_t i = 0; i < subzoneCount; ++i) { ___2090::SubzoneOffset_t const whichCompressor = compressorBegin + i; ___2090::SubzoneOffset_t const ___3880 = subzoneBegin + i; ___1339& feCellSubzoneCompressor = compressorVector[whichCompressor]; feCellSubzoneCompressor.___536(___2723, ___1349, ___3880); } } ___372 SZLFEZoneWriter::writeCszConnectivity( FileWriterInterface&      szpltFile, ___2729                ___2723, PartitionSubzoneSetArray& nszRefPtnCszSets) { REQUIRE(szpltFile.___2041()); REQUIRE(___2723->___2067()); REQUIRE(nszRefPtnCszSets.size() == size_t(m_feZoneInfo->___2823())); ___372 ___2039 = ___4226; size_t const ___2783 = size_t(m_feZoneInfo->___2783()); ___478(___2783 > 0); size_t const ___2827 = size_t(___2337.___4157()); size_t const numChunks = 1 + (___2783-1)/FEWRITER_MIN_CSZS_PER_CHUNK; size_t const numTasks = std::min(___2827, numChunks); size_t const subzonesPerTask = std::min<size_t>(FEWRITER_MAX_CSZS_PER_CHUNK, 1 + (___2783-1)/numTasks); size_t const subzonesPerChunk = numTasks * subzonesPerTask; ___2240<___1339> compressorVector; if (!compressorVector.alloc(subzonesPerChunk)) throw std::bad_alloc(); ___2240<CompressSubzoneJobData> compressSubzoneJobDataVector; if (!compressSubzoneJobDataVector.alloc(numTasks)) throw std::bad_alloc(); for(size_t task = 0; task < numTasks; ++task) { compressSubzoneJobDataVector[task].m_compressorVector = &compressorVector; compressSubzoneJobDataVector[task].___2497 = ___2723; compressSubzoneJobDataVector[task].m_feZoneInfo = m_feZoneInfo.get(); } ___2120 ___2119 = ___2337.___4158();
 #if defined OUTPUT_TIMES
uint64_t compressTime = 0; uint64_t ___4549 = 0; uint64_t ___3687 = ___717();
 #endif
for (size_t chunkSubzoneBegin = 0; ___2039 && chunkSubzoneBegin < ___2783; chunkSubzoneBegin += subzonesPerChunk) { size_t const chunkSubzoneEnd = std::min(chunkSubzoneBegin + subzonesPerChunk, ___2783); size_t const numCszsThisChunk = chunkSubzoneEnd-chunkSubzoneBegin; size_t const subzonesPerTaskThisChunk = 1 + (numCszsThisChunk-1)/numTasks; size_t const numTasksThisChunk = 1 + (numCszsThisChunk-1)/subzonesPerTaskThisChunk; for(size_t task = 0; task < numTasksThisChunk; ++task) { size_t const threadSubzoneBegin = chunkSubzoneBegin + task * subzonesPerTaskThisChunk; size_t const threadSubzoneEnd = std::min(threadSubzoneBegin + subzonesPerTaskThisChunk, ___2783); CompressSubzoneJobData* compressSubzoneJobData = &compressSubzoneJobDataVector[task]; compressSubzoneJobData->m_subzoneBegin = ___2090::SubzoneOffset_t(threadSubzoneBegin); compressSubzoneJobData->m_subzoneCount = ___2090::SubzoneOffset_t(threadSubzoneEnd - threadSubzoneBegin); compressSubzoneJobData->m_compressorBegin = ___2090::SubzoneOffset_t(threadSubzoneBegin - chunkSubzoneBegin); ___2337.___4156(compressSubzoneJob, (___90)compressSubzoneJobData, ___2119); } ___2337.___4161(___2119);
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); compressTime += (___1167 - ___3687); ___3687 = ___1167;
 #endif
___4636 const fileZone = ___2677 - m_baseZone; for(___2090::SubzoneOffset_t ___3923 = ___2090::SubzoneOffset_t(chunkSubzoneBegin); ___2039 && ___3923 < ___2090::SubzoneOffset_t(chunkSubzoneEnd); ++___3923) { m_cszConnectivityFileLocs[___3923] = szpltFile.fileLoc(); ___1339& feCellSubzoneCompressor = compressorVector[___3923 - chunkSubzoneBegin]; ___2090::SubzoneOffset_t const numRefNszs = feCellSubzoneCompressor.numRefNszs(); bool outputPartitionIndices = false; for(___2090::SubzoneOffset_t ___3323 = 0; ___3323 < numRefNszs; ++___3323) { ___2090::___2980 ___2977 = feCellSubzoneCompressor.refPtnNszs()[___3323].first; if (___2977 == ___2090::INVALID_PARTITION || static_cast<___4636>(___2977) == fileZone) { ___2090::SubzoneOffset_t const ___2757 = feCellSubzoneCompressor.refPtnNszs()[___3323].second; PartitionSubzone ptnCsz(fileZone, ___3923); nszRefPtnCszSets[___2757].insert(ptnCsz); } else { outputPartitionIndices = true; } } ___2039 = ___2039 && ___4501(szpltFile, ___3923); ___2039 = ___2039 && ___4500(szpltFile, compressorVector[___3923 - chunkSubzoneBegin], outputPartitionIndices); if (outputPartitionIndices) setBit(m_cszIncludesPartitionOffsetsBitArray, ___3923); m_numRefNodeSubzones[___3923] = compressorVector[___3923 - chunkSubzoneBegin].numRefNszs(); }
 #if defined OUTPUT_TIMES
___1167 = ___717(); ___4549 += (___1167 - ___3687); ___3687 = ___1167;
 #endif
}
 #if defined OUTPUT_TIMES
___1931(NULL, "%g seconds compressing cell subzones.", (double)(compressTime) / 1000.0); ___1931(NULL, "%g seconds writing cell subzones.", (double)(___4549) / 1000.0);
 #endif
___2337.___4159(&___2119); return ___2039; } uint64_t SZLFEZoneWriter::cszConnectivityFileSize(bool ___2002, PartitionSubzoneSetArray& nszRefPtnCszSets) { uint64_t ___3358 = m_feZoneInfo->___2783() * cszConnectivityHeaderFileSize(___2002); ___2724 ___2723(&___2337, ___2677 + 1); ___2227 ___2789 = ___2723.___1764(); ___4636 const fileZone = ___2677 - m_baseZone; for(___2090::SubzoneOffset_t ___686 = 0; ___686 < m_feZoneInfo->___2783(); ++___686) { boost::unordered_set<PartitionSubzone> refPtnNszSet; bool outputPartitionIndices = false; for(___2090::ItemOffset_t off = 0; off < m_feZoneInfo->___2782(___686); ++off) { ___2090 cellCoordinate(___2090::UNKNOWN_PARTITION, ___686, off); ___465 ___449 = m_feZoneInfo->___4608(cellCoordinate); for(int32_t ___681 = 1; ___681 <= ___2789; ++___681) { int64_t ___2709 = ___2723.___1763(___449 + 1, ___681); ___2090 nodeCoordinate = m_feZoneInfo->___3924(___2709 - 1); ___2090::___2980 ___2977 = nodeCoordinate.___2977(); ___2090::SubzoneOffset_t ___2757 = nodeCoordinate.subzoneOffset(); if (___2977 == ___2090::INVALID_PARTITION || static_cast<___4636>(___2977) == fileZone) { refPtnNszSet.insert(PartitionSubzone(fileZone, ___2757)); nszRefPtnCszSets[___2757].insert(PartitionSubzone(fileZone, ___686)); } else { refPtnNszSet.insert(PartitionSubzone(___2977, ___2757)); outputPartitionIndices = true; } } } size_t totalNumCellCorners = static_cast<size_t>(m_feZoneInfo->___2782(___686)) * ___2789; uint64_t cszDataFileSize = cszConnectivityDataFileSize( ___2002, totalNumCellCorners, refPtnNszSet.size(), m_feZoneInfo->getNumReferencedPartitions(), outputPartitionIndices); ___3358 += cszDataFileSize; } return ___3358; } ___372 SZLFEZoneWriter::___4537( FileWriterInterface&         file, ___2090::SubzoneOffset_t ___2734) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); if (file.___2002()) { ___2039 = writeValue<uint32_t, false, 0>(file, "nszConnectivityMarker*", SZPLT_NSZ_CONNECTIVITY_MARKER) && writeValue<uint32_t, false, 0>(file, m_zoneNumberLabel.c_str(), (___2677 - m_baseZone + 1)) && writeValue<uint64_t, false, 0>(file, "subzoneNum*", ___2734 + 1); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } uint64_t SZLFEZoneWriter::nszConnectivityHeaderFileSize(bool ___2002) { uint64_t ___3358 = 0; if (___2002) ___3358 += 2 * valueSizeInFile<uint32_t, false>(___2002) + valueSizeInFile<uint64_t, false>(___2002); return ___3358; } namespace { inline ___372 ___4536( FileWriterInterface&       file, char const*                ___972, PartitionSubzoneSet const& refPtnCszSet, PartitionArray const&      referencedPartitions, ___2090::___2980   numReferencedPartitions, bool                       outputPartitionIndices) { ___4278(___972); if (refPtnCszSet.size() > uint16_t(-1)) { std::cerr << "Overflow while writing Node subzone. Too many cells use the same node (> 65536)." << std::endl; return ___1305; } UInt32Array refPtnArray; UInt32Array refCszArray; uint16_t const numRefCszs = uint16_t(refPtnCszSet.size()); ___372 ___2039 = ___4226; if (___2039 && numRefCszs > 0) { ___2039 = refPtnArray.alloc(numRefCszs) && refCszArray.alloc(numRefCszs); if ( ___2039 ) { ___2090::SubzoneOffset_t refCszIndex = 0; for (PartitionSubzoneSet::const_iterator iter = refPtnCszSet.begin(); iter != refPtnCszSet.end(); iter++) { ___2090::___2980 ___2977 = iter->first; refPtnArray[refCszIndex] = ___2977; refCszArray[refCszIndex] = iter->second; refCszIndex++; } ___478(refCszIndex==numRefCszs); if (outputPartitionIndices) { if (numReferencedPartitions <= MAX_REFS_FOR_2_BIT_COMPRESSION) { UInt8Array refPtn2BitOffsets; ___2039 = refPtn2BitOffsets.alloc(numRefCszs / 4 + 1); if (___2039) { gather2BitOffsets(&refPtn2BitOffsets[0], &refPtnArray[0], numRefCszs, &referencedPartitions[0], numReferencedPartitions); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, "refPtn2BitOffsets", ___2745, (numRefCszs + 3) / 4, &refPtn2BitOffsets[0], ___946 / 4); } } else if (numReferencedPartitions <= MAX_REFS_FOR_4_BIT_COMPRESSION) { UInt8Array refPtn4BitOffsets; ___2039 = refPtn4BitOffsets.alloc(numRefCszs / 2 + 1); if (___2039) { gather4BitOffsets(&refPtn4BitOffsets[0], &refPtnArray[0], numRefCszs, &referencedPartitions[0], numReferencedPartitions); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, "refPtn4BitOffsets", ___2745, (numRefCszs + 1) / 2, &refPtn4BitOffsets[0], ___946 / 2); } } else if (numReferencedPartitions <= MAX_REFS_FOR_8_BIT_COMPRESSION) { UInt8Array refPtn8BitOffsets; ___2039 = refPtn8BitOffsets.alloc(numRefCszs); if (___2039) { gatherOffsets(&refPtn8BitOffsets[0], &refPtnArray[0], numRefCszs, &referencedPartitions[0], numReferencedPartitions); ___2039 = ___2039 && ___4563<uint8_t, true, 0>(file, "refPtn8BitOffsets", ___2745, numRefCszs, &refPtn8BitOffsets[0]); } } else { UInt16Array refPtn16BitOffsets;
___2039 = refPtn16BitOffsets.alloc(numRefCszs); if (___2039) { gatherOffsets(&refPtn16BitOffsets[0], &refPtnArray[0], numRefCszs, &referencedPartitions[0], numReferencedPartitions); ___2039 = ___2039 && ___4563<uint16_t, true, 0>(file, "refPtn16BitOffsets", ___2745, numRefCszs, &refPtn16BitOffsets[0]); } } } ___2039 = ___2039 && ___4563<uint32_t, false, 1>(file, NSZ_CONNECT_REF_CSZS, ___2745, numRefCszs, &refCszArray[0]); } refPtnArray.___937(); refCszArray.___937(); } ENSURE(refPtnArray.empty()); ENSURE(refCszArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } uint64_t nszConnectivityDataFileSize( bool ___2002, ___2090::___2980 numReferencedPartitions, bool outputPartitionIndices, PartitionSubzoneSet const& refPtnCszSet) { uint64_t ___3358 = 0; size_t const numRefCszs = refPtnCszSet.size(); if (outputPartitionIndices) { if (numReferencedPartitions <= MAX_REFS_FOR_2_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >((numRefCszs + 3) / 4, ___2002); else if (numReferencedPartitions <= MAX_REFS_FOR_4_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >((numRefCszs + 1) / 2, ___2002); else if (numReferencedPartitions <= MAX_REFS_FOR_8_BIT_COMPRESSION) ___3358 += arraySizeInFile<uint8_t, true  >(numRefCszs, ___2002); else ___3358 += arraySizeInFile<uint16_t, true  >(numRefCszs, ___2002); } ___3358 += arraySizeInFile<uint32_t, false>(numRefCszs, ___2002); return ___3358; } } ___372 SZLFEZoneWriter::___4535( FileWriterInterface&      szpltFile, PartitionSubzoneSetArray& nszRefPtnCszSets) { ___372 ___2039 = ___4226; BOOST_FOREACH(___1350::NeighborCszRefMap::value_type const& entry, m_feZoneInfo->getNeighborCszRefs()) { ___2090::SubzoneOffset_t ___2734 = entry.first; BOOST_FOREACH(PartitionSubzone const& ptnCsz, entry.second) nszRefPtnCszSets[___2734].insert(ptnCsz); } ___4636 const fileZone = ___2677 - m_baseZone; for (___2090::SubzoneOffset_t ___2734 = 0; ___2039 && ___2734 < m_feZoneInfo->___2823(); ___2734++) { m_nszConnectivityFileLocs[___2734] = szpltFile.fileLoc(); m_numRefCellSubzones[___2734] = static_cast<uint16_t>(nszRefPtnCszSets[___2734].size()); bool outputPartitionIndices = false; BOOST_FOREACH(PartitionSubzone const& partitionSubzone, nszRefPtnCszSets[___2734]) { ___2090::___2980 ptnIndex = partitionSubzone.first; if (ptnIndex != ___2090::INVALID_PARTITION && static_cast<___4636>(ptnIndex) != fileZone) { outputPartitionIndices = true; } } if (outputPartitionIndices) setBit(m_nszIncludesPartitionOffsetsBitArray, ___2734); ___2039 = ___2039 && ___4537(szpltFile, ___2734); ___2039 = ___2039 && ___4536(szpltFile, "nszConnectivity", nszRefPtnCszSets[___2734], m_feZoneInfo->getReferencedPartitions(), m_feZoneInfo->getNumReferencedPartitions(), outputPartitionIndices); } return ___2039; } uint64_t SZLFEZoneWriter::nszConnectivityFileSize(bool ___2002, PartitionSubzoneSetArray& nszRefPtnCszSets) { uint64_t ___3358 = m_feZoneInfo->___2823() * nszConnectivityHeaderFileSize(___2002); BOOST_FOREACH(___1350::NeighborCszRefMap::value_type const& entry, m_feZoneInfo->getNeighborCszRefs()) { ___2090::SubzoneOffset_t ___2734 = entry.first; BOOST_FOREACH(PartitionSubzone const& ptnCsz, entry.second) nszRefPtnCszSets[___2734].insert(ptnCsz); } ___4636 const fileZone = ___2677 - m_baseZone; for(___2090::SubzoneOffset_t ___2757 = 0; ___2757 < m_feZoneInfo->___2823(); ++___2757) { bool outputPartitionIndices = false; BOOST_FOREACH(PartitionSubzone const& partitionSubzone, nszRefPtnCszSets[___2757]) { ___2090::___2980 ptnIndex = partitionSubzone.first; if (ptnIndex != ___2090::INVALID_PARTITION && static_cast<___4636>(ptnIndex) != fileZone) outputPartitionIndices = true; } ___3358 += nszConnectivityDataFileSize(___2002, m_feZoneInfo->getNumReferencedPartitions(), outputPartitionIndices, nszRefPtnCszSets[___2757]); } return ___3358; } ___372 SZLFEZoneWriter::writeZoneConnectivity(FileWriterInterface& szpltFile) { ___372 ___2039 = ___4226; if (m_writeConnectivity) { ___2337.___858(); PartitionSubzoneSetArray nszRefPtnCszSets;
 #if defined OUTPUT_TIMES
uint64_t ___3687 = ___717();
 #endif
___2039 = ___2039 && ___485(SzPltWriteOperation_WriteConnectivity, ___2337, 0 , ___2677); ___2039 = ___2039 && nszRefPtnCszSets.alloc(m_feZoneInfo->___2823()); ___2039 = ___2039 && m_cszConnectivityFileLocs.alloc(m_feZoneInfo->___2783(), ___330); ___2039 = ___2039 && m_numRefNodeSubzones.alloc(m_feZoneInfo->___2783(), 0); ___2039 = ___2039 && m_numRefCellSubzones.alloc(m_feZoneInfo->___2823(), 0); ___2039 = ___2039 && m_cszIncludesPartitionOffsetsBitArray.alloc(numBytesForNumBits(m_feZoneInfo->___2783()), 0); ___2039 = ___2039 && m_nszIncludesPartitionOffsetsBitArray.alloc(numBytesForNumBits(m_feZoneInfo->___2823()), 0); ___2729 ___2723 = boost::make_shared<___2724>(&___2337, ___2677 + 1); if (!___2723->___2067()) ___2039 = ___1305; try { ___2039 = ___2039 && writeCszConnectivity(szpltFile, ___2723, nszRefPtnCszSets);
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); ___1931(NULL, "%g seconds writing cell subzone connectivity.", (double)(___1167 - ___3687) / 1000.0); ___3687 = ___1167;
 #endif
} catch (___1339::Error const& e) { std::cerr << "Error compressing node map: " << e.what() << std::endl; ___2039 = ___1305; } ___2039 = ___2039 && m_nszConnectivityFileLocs.alloc(m_feZoneInfo->___2823(), ___330); ___2039 = ___2039 && ___4535(szpltFile, nszRefPtnCszSets);
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); ___1931(NULL, "%g seconds writing node subzone connectivity.", (double)(___1167 - ___3687) / 1000.0);
 #endif
___2337.___859(); } return ___2039; } uint64_t SZLFEZoneWriter::zoneConnectivityFileSize(bool ___2002) { uint64_t ___3358 = 0; if (m_writeConnectivity) { PartitionSubzoneSetArray nszRefPtnCszSets; if (nszRefPtnCszSets.alloc(m_feZoneInfo->___2823())) { ___3358 += cszConnectivityFileSize(___2002, nszRefPtnCszSets); ___3358 += nszConnectivityFileSize(___2002, nszRefPtnCszSets); } } return ___3358; } ___372 SZLFEZoneWriter::___4512( FileWriterInterface&         file, ValueLocation_e              ___4326, ___4352                   datasetVar, ___2090::SubzoneOffset_t ___3880) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(___4326 == ___4328 || ___4326 == ___4330); if (file.___2002()) { if ( ___4326 == ___4328 ) ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, "cszFieldDataMarker*", SZPLT_CSZ_FIELD_DATA_MARKER); else ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, "nszFieldDataMarker*", SZPLT_NSZ_FIELD_DATA_MARKER); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, "variableNum*", (datasetVar - m_varIter.baseItem() + 1)); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, m_zoneNumberLabel.c_str(), (___2677 - m_baseZone + 1)); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, "subzoneNum*", ___3880 + 1); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } uint64_t SZLFEZoneWriter::fieldDataSubzoneHeaderFileSize(bool ___2002) { uint64_t ___3358 = 0; if (___2002) { ___3358 += 3 * valueSizeInFile<uint32_t, false>(___2002) + valueSizeInFile<uint64_t, false>(___2002); } return ___3358; } template <typename T, bool isBitArray> uint64_t SZLFEZoneWriter::cellSubzoneFieldDataFileSize(bool ___2002, ___2090::SubzoneOffset_t ___469) const { size_t ___2782 = static_cast<size_t>(m_feZoneInfo->___2782(___469)); return arraySizeInFile<T, false>(___2782, ___2002); } template <> uint64_t SZLFEZoneWriter::cellSubzoneFieldDataFileSize<uint8_t, true>(bool ___2002, ___2090::SubzoneOffset_t ___469) const { size_t ___2782 = static_cast<size_t>(m_feZoneInfo->___2782(___469)); return arraySizeInFile<uint8_t, false>(numBytesForNumBits(___2782), ___2002); } template <typename T, bool isBitArray> uint64_t SZLFEZoneWriter::nodeSubzoneFieldDataFileSize(bool ___2002, ___2090::SubzoneOffset_t ___2734) const { size_t ___2822 = static_cast<size_t>(m_feZoneInfo->___2822(___2734)); return arraySizeInFile<T, false>(___2822, ___2002); } template <> uint64_t SZLFEZoneWriter::nodeSubzoneFieldDataFileSize<uint8_t, true>(bool ___2002, ___2090::SubzoneOffset_t ___2734) const { size_t ___2822 = static_cast<size_t>(m_feZoneInfo->___2822(___2734)); return arraySizeInFile<uint8_t, false>(numBytesForNumBits(___2822), ___2002); } template <typename T, bool isBitArray  > uint64_t SZLFEZoneWriter::subzoneFieldDataFileSize(bool ___2002, ___2090::SubzoneOffset_t ___3880, ValueLocation_e ___4326) const { if (___4326 == ___4328) return cellSubzoneFieldDataFileSize<T, isBitArray>(___2002, ___3880); else return nodeSubzoneFieldDataFileSize<T, isBitArray>(___2002, ___3880); } template <typename T, bool isBitArray  > uint64_t SZLFEZoneWriter::variableFileSize(bool ___2002, ValueLocation_e ___4326) { uint64_t ___3358 = 0; ___2090::SubzoneOffset_t const ___2823 = m_feZoneInfo->___2823(); ___3358 += arraySizeInFile<std::pair<T, T>, false >(static_cast<size_t>(___2823), ___2002); ___2090::SubzoneOffset_t const ___2783 = m_feZoneInfo->___2783(); ___3358 += arraySizeInFile<std::pair<T, T>, false >(static_cast<size_t>(___2783), ___2002); ___2090::SubzoneOffset_t const numDataSubzones = (___4326 == ___4328) ? ___2783 : ___2823; for (___2090::SubzoneOffset_t ___3923 = 0; ___3923 < numDataSubzones; ___3923++) { ___3358 += fieldDataSubzoneHeaderFileSize(___2002); ___3358 += subzoneFieldDataFileSize<T, isBitArray>(___2002, ___3923, ___4326); } return ___3358; } uint64_t SZLFEZoneWriter::zoneDataFileSize(bool ___2002) { uint64_t ___3358 = 0; m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; if (!m_writeVariables[fileVar]) continue; FieldDataType_e const ___1363 = ___2337.___923(___2677 + 1, fileVar + 1); ValueLocation_e const ___4326 = ___2337.___910(___2677 + 1, fileVar + 1); switch (___1363) { case FieldDataType_Float: ___3358 += variableFileSize<float, false>(___2002, ___4326); break; case FieldDataType_Double: ___3358 += variableFileSize<double, false>(___2002, ___4326); break; case FieldDataType_Int32: ___3358 += variableFileSize<int32_t, false>(___2002, ___4326);
break; case FieldDataType_Int16: ___3358 += variableFileSize<int16_t, false>(___2002, ___4326); break; case FieldDataType_Byte: ___3358 += variableFileSize<uint8_t, false>(___2002, ___4326); break; case ___1365: ___3358 += variableFileSize<uint8_t, true>(___2002, ___4326); break; default: ___478(___1305); break; } } return ___3358; } template <typename T, bool isBitArray  > ___372 SZLFEZoneWriter::___4496( FileWriterInterface&         szpltFile, ___1352 const&             ___1351, ___2090::SubzoneOffset_t ___469) { ___372 ___2039 = ___4226; REQUIRE(szpltFile.___2041()); REQUIRE(___1351.___2067()); REQUIRE(___1351.___1786() == ___4328); ___2240<T> valueArray; ___2090::SubzoneOffset_t ___2782 = m_feZoneInfo->___2782(___469); ___2039 = ___2039 && valueArray.alloc(___2782); T* rawPointer = static_cast<T*>(___1351.getRawPointer()); if (___2039) { for (___2090::ItemOffset_t cszOffset = 0; cszOffset < ___2782; cszOffset++) { ___2090 const ___688(___2090::UNKNOWN_PARTITION, ___469, cszOffset); ___465 const ___449 = m_feZoneInfo->___4608(___688); if (rawPointer) valueArray[cszOffset] = rawPointer[___449]; else valueArray[cszOffset] = static_cast<T>(___1351.___1780(___449 + 1)); } } ___2039 = ___2039 && ___4563<T, false, 0>(szpltFile, "cszFieldData", ___2745, ___2782, &valueArray[0]); valueArray.___937(); ENSURE(valueArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <> ___372 SZLFEZoneWriter::___4496<uint8_t, true>( FileWriterInterface&         szpltFile, ___1352 const&             ___1351, ___2090::SubzoneOffset_t ___469) { ___372 ___2039 = ___4226; REQUIRE(szpltFile.___2041()); REQUIRE(___1351.___2067()); REQUIRE(___1351.___1786() == ___4328); ___2240<uint8_t> valueArray; ___2090::SubzoneOffset_t ___2782 = m_feZoneInfo->___2782(___469); uint64_t arraySize = numBytesForNumBits(___2782); ___2039 = ___2039 && valueArray.alloc(arraySize); if (___2039) { for (___2090::ItemOffset_t cszItemOffset = 0; cszItemOffset < ___2782; cszItemOffset++) { ___2090 const ___688(___2090::UNKNOWN_PARTITION, ___469, cszItemOffset); ___465 const ___449 = m_feZoneInfo->___4608(___688); double const ___4298 = ___1351.___1780(___449 + 1); if (___4298 < 1.0) clearBit(valueArray, cszItemOffset); else setBit(valueArray, cszItemOffset); } } ___2039 = ___2039 && ___4563<uint8_t, false, 0>(szpltFile, "cszFieldData", ___2745, arraySize, &valueArray[0]); valueArray.___937(); ENSURE(valueArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <typename T, bool isBitArray  > ___372 SZLFEZoneWriter::___4531( FileWriterInterface&         szpltFile, ___1352 const&             ___1351, ___2090::SubzoneOffset_t ___2734) { ___372 ___2039 = ___4226; REQUIRE(szpltFile.___2041()); REQUIRE(___1351.___2067()); REQUIRE(___1351.___1786() == ___4330); ___2240<T> valueArray; ___2090::ItemOffset_t ___2822 = m_feZoneInfo->___2822(___2734); ___2039 = ___2039 && valueArray.alloc(___2822); T* rawPointer = static_cast<T*>(___1351.getRawPointer()); if (___2039) { for (___2090::ItemOffset_t nszItemOffset = 0; nszItemOffset < ___2822; nszItemOffset++) { ___2090 const ___2759(___2090::UNKNOWN_PARTITION, ___2734, nszItemOffset); ___2718 const ___2709 = m_feZoneInfo->___4657(___2759); if (rawPointer) valueArray[nszItemOffset] = rawPointer[___2709]; else valueArray[nszItemOffset] = static_cast<T>(___1351.___1780(___2709 + 1)); } } ___2039 = ___2039 && ___4563<T, false, 0>(szpltFile, "nszFieldData", ___2745, ___2822, &valueArray[0]); valueArray.___937(); ENSURE(valueArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <> ___372 SZLFEZoneWriter::___4531<uint8_t, true>( FileWriterInterface&         szpltFile, ___1352 const&             ___1351, ___2090::SubzoneOffset_t ___2734) { ___372 ___2039 = ___4226; REQUIRE(szpltFile.___2041()); REQUIRE(___1351.___2067()); REQUIRE(___1351.___1786() == ___4330); ___2240<uint8_t> valueArray; ___2090::ItemOffset_t ___2822 = m_feZoneInfo->___2822(___2734); uint64_t arraySize = numBytesForNumBits(___2822); ___2039 = ___2039 && valueArray.alloc(arraySize); if (___2039) { for (___2090::ItemOffset_t ___2763 = 0; ___2763 < ___2822; ___2763++) { ___2090 const ___2759(___2090::UNKNOWN_PARTITION, ___2734, ___2763); ___2718 const ___2709 = m_feZoneInfo->___4657(___2759); double const ___4298 = ___1351.___1780(___2709 + 1); if (___4298 < 1.0)
clearBit(valueArray, ___2763); else setBit(valueArray, ___2763); } } ___2039 = ___2039 && ___4563<uint8_t, false, 0>(szpltFile, "nszFieldData", ___2745, arraySize, &valueArray[0]); valueArray.___937(); ENSURE(valueArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <typename T, bool isBitArray  > ___372 SZLFEZoneWriter::writeVariable( FileWriterInterface&     szpltFile, ___4352 const         datasetVar, ___2481 const&       nszDataMinMax, ___2481 const&       cszDataMinMax) { ___2090::SubzoneOffset_t const ___2783 = m_feZoneInfo->___2783(); ___2090::SubzoneOffset_t const ___2823 = m_feZoneInfo->___2823(); ___4352 const fileVar = datasetVar - m_varIter.baseItem(); ___372 ___2039 = ___4528<T>(szpltFile, NODE_SUBZONE_DATA_MIN_MAX_ARRAY_DESCRIPTION, fileVar, ___2823, &nszDataMinMax[0], ___946 / 2) && ___4528<T>(szpltFile, CELL_SUBZONE_DATA_MIN_MAX_ARRAY_DESCRIPTION, fileVar, ___2783, &cszDataMinMax[0], ___946 / 2); ___1352 ___1351(&___2337, ___2677 + 1, datasetVar + 1); ___2039 = ___2039 && ___1351.___2067(); ValueLocation_e const ___4326 = ___1351.___1786(); ___2090::SubzoneOffset_t const numDataSubzones = (___4326 == ___4328) ? ___2783 : ___2823; for (___2090::SubzoneOffset_t ___3923 = 0; ___2039 && ___3923 < numDataSubzones; ___3923++) { ___2039 = ___4512(szpltFile, ___4326, datasetVar, ___3923); if (___4326 == ___4328) ___2039 = ___2039 && ___4496<T, isBitArray>(szpltFile, ___1351, ___3923); else ___2039 = ___2039 && ___4531<T, isBitArray>(szpltFile, ___1351, ___3923); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 SZLFEZoneWriter::writeZoneData(FileWriterInterface& szpltFile) {
 #if defined OUTPUT_TIMES
uint64_t ___3687 = ___717(); uint64_t minMaxTime = 0; uint64_t ___4549 = 0;
 #endif
___372 ___2039 = ___4226; ___2481 ___2762; ___2481 cszMinMaxArray; m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (___2039 && m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; if (!m_writeVariables[fileVar]) continue; ___2337.___858(); ___2039 = ___485(SzPltWriteOperation_WriteFieldData, ___2337, datasetVar, ___2677); ___2039 = ___2039 && calculateVarSubzoneMinMaxes(datasetVar, ___2762, cszMinMaxArray);
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); minMaxTime += (___1167 - ___3687); ___3687 = ___1167;
 #endif
___2673[fileVar] = szpltFile.fileLoc(); if (___2039) { switch (___2337.___923(___2677 + 1, datasetVar + 1)) { case FieldDataType_Float: ___2039 = writeVariable<float, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Double: ___2039 = writeVariable<double, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Int32: ___2039 = writeVariable<int32_t, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Int16: ___2039 = writeVariable<int16_t, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Byte: ___2039 = writeVariable<uint8_t, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case ___1365: ___2039 = writeVariable<uint8_t, true>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; default: ___478(___1305); ___2039 = ___1305; break; } } ___2762.___937(); cszMinMaxArray.___937();
 #if defined OUTPUT_TIMES
___1167 = ___717(); ___4549 += (___1167 - ___3687); ___3687 = ___1167;
 #endif
___2337.___859(); }
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); ___1931(NULL, "%g seconds calculating variable ranges.", (double)(minMaxTime) / 1000.0); ___1931(NULL, "%g seconds writing zone data.", (double)(___4549) / 1000.0);
 #endif
ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 SZLFEZoneWriter::writeZoneHeader(FileWriterInterface& szpltFile) { REQUIRE(szpltFile.___2041()); return m_headerWriter.write(szpltFile); } uint64_t SZLFEZoneWriter::zoneHeaderFileSize(bool ___2002) { return m_headerWriter.sizeInFile(___2002); } }}
