#include "SZLOrderedZoneWriter.h"
#include "ThirdPartyHeadersBegin.h"
#include <sstream>
#include <stdexcept>
#include <boost/assign.hpp>
#include <boost/foreach.hpp>
#include "ThirdPartyHeadersEnd.h"
 #if !defined TECIOMPI
#include "AtomicMinMax.h"
 #endif
#include "checkPercentDone.h"
#include "FieldData.h"
#include "fileStuff.h"
#include "IJKZoneInfo.h"
#include "ItemSetIterator.h"
#include "writeValueArray.h"
namespace tecplot { namespace ___3933 { namespace { int const MINMAX_MAX_TASKS_PER_CORE = 16; int const MINMAX_MIN_CSZ_TASK_SIZE = 16; } SZLOrderedZoneWriter::SZLOrderedZoneWriter( ItemSetIterator&                            varIter, ___4636                                 zone, ___4636                                 ___341, std::vector<___372> const&               ___4564, ___372                                   ___4499, ___37&                                 ___36, boost::shared_ptr<___1881 const> const& ijkZoneInfo) : ___4709(varIter, zone, ___341, ___4564, ___4499, ___36) , m_headerWriter(varIter, zone, ___341, ___36, *ijkZoneInfo, ___2673) , m_ijkZoneInfo(ijkZoneInfo) , m_zoneNumberLabel(SZPLT_ZONE_NUM_DESCRIPTION) { ___4352 const numVarsToWrite = m_varIter.___2812(); if (!___2673.alloc(numVarsToWrite, ___330)) { std::ostringstream ___2892; ___2892 << "Unable to allocate arrays for outputting zone " << zone; throw std::runtime_error(___2892.str()); } } SZLOrderedZoneWriter::~SZLOrderedZoneWriter() {} void SZLOrderedZoneWriter::setZoneNumberLabel(std::string const& zoneNumberLabel) { REQUIRE(!zoneNumberLabel.empty()); m_zoneNumberLabel = zoneNumberLabel; } namespace { struct CellMinMaxData { ___2090::SubzoneOffset_t cellSubzoneStart; ___2090::SubzoneOffset_t cellSubzoneEnd; ___1881 const& ijkZoneInfo; ___1352 const& nlFieldData; ___1352 const& ccFieldData;
 #if defined TECIOMPI
___2481& cszMinMaxArray; ___2481& ___2762;
 #else
___2240<___225<double> >& cszMinMaxArray; ___2240<___225<double> >& ___2762;
 #endif
CellMinMaxData( ___2090::SubzoneOffset_t cellSubzoneStart, ___2090::SubzoneOffset_t cellSubzoneEnd, ___1881 const& ijkZoneInfo, ___1352 const& nlFieldData, ___1352 const& ccFieldData,
 #if defined TECIOMPI
___2481& cszMinMaxArray, ___2481& ___2762)
 #else
___2240<___225<double> >& cszMinMaxArray, ___2240<___225<double> >& ___2762)
 #endif
: cellSubzoneStart(cellSubzoneStart) , cellSubzoneEnd(cellSubzoneEnd) , ijkZoneInfo(ijkZoneInfo) , nlFieldData(nlFieldData) , ccFieldData(ccFieldData) , cszMinMaxArray(cszMinMaxArray) , ___2762(___2762) {} }; ___1844 calculateStoredNodeIJK(___1881 const& ijkZoneInfo) { ___1844 ___3358 = ijkZoneInfo.___2714(); if (!ijkZoneInfo.includeIMaxNodesInSubzones()) ___3358.setI(___3358.i() + 1); if (!ijkZoneInfo.includeJMaxNodesInSubzones()) ___3358.setJ(___3358.___2105() + 1); if (!ijkZoneInfo.includeKMaxNodesInSubzones()) ___3358.___3497(___3358.___2134() + 1); return ___3358; } void STDCALL calculateAndApplyCellMinMaxes(___90 ___2123) { CellMinMaxData* cellMinMaxData = reinterpret_cast<CellMinMaxData*>(___2123); REQUIRE(cellMinMaxData->nlFieldData.___2067()); ___1844 outputIJK = cellMinMaxData->ijkZoneInfo.___2714(); ___1844 storedIJK = calculateStoredNodeIJK(cellMinMaxData->ijkZoneInfo); ___81 cellCorners[] = { 0, 1, storedIJK.i(), storedIJK.i() + 1, storedIJK.i() * storedIJK.___2105(), storedIJK.i() * storedIJK.___2105() + 1, storedIJK.i() * storedIJK.___2105() + storedIJK.i(), storedIJK.i() * storedIJK.___2105() + storedIJK.i() + 1 }; ___81 nodes[8]; ___3269<___81> nodeArray(nodes, 8); for (___2090::SubzoneOffset_t ___469 = cellMinMaxData->cellSubzoneStart; ___469 < cellMinMaxData->cellSubzoneEnd; ++___469) { ___1844 ___1880 = cellMinMaxData->ijkZoneInfo.___690(___469); ___1844 ___1852 = cellMinMaxData->ijkZoneInfo.___689(___469); for (___81 i = ___1880.i(); i <= ___1852.i(); ++i) { for (___81 ___2105 = ___1880.___2105(); ___2105 <= ___1852.___2105(); ++___2105) { for (___81 ___2134 = ___1880.___2134(); ___2134 <= ___1852.___2134(); ++___2134) { ___2479 cellMinMax; ___81 const datasetPt = (___2134 * storedIJK.___2105() + ___2105) * storedIJK.i() + i; for (int n = 0; n < 8; ++n) cellMinMax.include(cellMinMaxData->nlFieldData.___1780(datasetPt + cellCorners[n] + 1)); nodeArray.clear(); nodeArray.append((___2134 * outputIJK.___2105() + ___2105) * outputIJK.i() + i); if (i < outputIJK.i() - 1) nodeArray.append(nodeArray[0] + 1); if (___2105 < outputIJK.___2105() - 1) { size_t ___2821 = nodeArray.size(); for (size_t n = 0; n < ___2821; ++n) nodeArray.append(nodeArray[n] + outputIJK.i()); } if (___2134 < outputIJK.___2134() - 1) { size_t ___2821 = nodeArray.size(); for (size_t n = 0; n < ___2821; ++n) nodeArray.append(nodeArray[n] + outputIJK.i() * outputIJK.___2105()); } for (size_t n = 0; n < nodeArray.size(); ++n) { ___2090 nodeAddress = cellMinMaxData->ijkZoneInfo.nodeAddressAtNodeIndex(nodeArray[n]); ___2090::SubzoneOffset_t ___2734 = nodeAddress.subzoneOffset(); cellMinMaxData->___2762[___2734].include(cellMinMax); } if (cellMinMaxData->ccFieldData.___2067()) cellMinMax.include(cellMinMaxData->ccFieldData.___1780(datasetPt + 1)); cellMinMaxData->cszMinMaxArray[___469].include(cellMinMax); } } } } delete cellMinMaxData; } ___372 getIJKCellAndNodeSubzoneMinMaxes( ___37& ___36, ___1881 const& ijkZoneInfo, ___4352 fileVar, ___1352 const& nlFieldData, ___1352 const& ccFieldData, ___2481& cszMinMaxArray, ___2481& ___2762) { REQUIRE(fileVar >= 0); REQUIRE(nlFieldData.___2067()); REQUIRE("ccFieldData might be invalid if not CC data"); ___372 ___2039 = ___4226; ___2090::SubzoneOffset_t const ___2783 = ijkZoneInfo.getNumCszs(); ___2090::SubzoneOffset_t const ___2823 = ijkZoneInfo.getNumNszs();
 #ifndef NO_ASSERTS
for (___2090::SubzoneOffset_t ___2734 = 0; ___2734 < ___2823; ___2734++) ___478(!___2762[___2734].___2067()); for (___2090::SubzoneOffset_t ___469 = 0; ___469 < ___2783; ___469++) ___478(!cszMinMaxArray[___469].___2067());
 #endif
 #if defined TECIOMPI
CellMinMaxData* cellMinMaxData = new CellMinMaxData(0, ___2783, ijkZoneInfo, nlFieldData, ccFieldData, cszMinMaxArray, ___2762); calculateAndApplyCellMinMaxes(reinterpret_cast<___90>(cellMinMaxData));
 #else
___2240<___225<double> > atomicCszMinMaxArray; ___2240<___225<double> > atomicNszMinMaxArray; ___2039 = atomicCszMinMaxArray.alloc(___2783) && atomicNszMinMaxArray.alloc(___2823); if (___2039) { size_t const maxNumTasks = static_cast<size_t>(___36.___4157() * MINMAX_MAX_TASKS_PER_CORE); size_t const numCszTasksAtMinJobSize = static_cast<size_t>(___2783 + MINMAX_MIN_CSZ_TASK_SIZE - 1) / MINMAX_MIN_CSZ_TASK_SIZE; size_t const numCszTasks = std::min(numCszTasksAtMinJobSize, maxNumTasks); ___2120 ___2119 = ___36.___4158(); ___2090::SubzoneOffset_t cellSubzoneStart = 0; for (size_t task = 1; task <= numCszTasks; ++task) { ___2090::SubzoneOffset_t const cellSubzoneEnd = static_cast<___2090::SubzoneOffset_t>(___2783 * task / numCszTasks); ___478(cellSubzoneStart < cellSubzoneEnd); CellMinMaxData* cellMinMaxData = new CellMinMaxData(cellSubzoneStart, cellSubzoneEnd, ijkZoneInfo, nlFieldData, ccFieldData, atomicCszMinMaxArray, atomicNszMinMaxArray); ___36.___4156(calculateAndApplyCellMinMaxes, (___90)cellMinMaxData, ___2119); cellSubzoneStart = cellSubzoneEnd; } ___36.___4161(___2119); ___36.___4159(&___2119); for (___2090::SubzoneOffset_t ___469 = 0; ___469 < ___2783; ++___469) { ENSURE(atomicCszMinMaxArray[___469].___2067()); cszMinMaxArray[___469].include(atomicCszMinMaxArray[___469].minValue()); cszMinMaxArray[___469].include(atomicCszMinMaxArray[___469].maxValue()); } for (___2090::SubzoneOffset_t ___2734 = 0; ___2039 && ___2734 < ___2823; ++___2734) { ENSURE(atomicNszMinMaxArray[___2734].___2067()); ___2762[___2734].include(atomicNszMinMaxArray[___2734].minValue()); ___2762[___2734].include(atomicNszMinMaxArray[___2734].maxValue()); } atomicCszMinMaxArray.___937(); atomicNszMinMaxArray.___937(); }
 #endif
if (___2039) { ___1881::NszMinMaxMap const& nszMinMaxes = ijkZoneInfo.getNszMinMaxes(); BOOST_FOREACH(___1881::NszMinMaxMap::value_type const& valuePair, nszMinMaxes) ___2762[valuePair.first].include(valuePair.second[fileVar]); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 SZLOrderedZoneWriter::calculateVarSubzoneMinMaxes( ___4352   datasetVar, ___2481& ___2762, ___2481& cszMinMaxArray) { REQUIRE(cszMinMaxArray.empty()); REQUIRE(___2762.empty()); REQUIRE(m_writeVariables[datasetVar - m_varIter.baseItem()]); ___372 ___2039 = ___4226; ___2039 = ___2039 && cszMinMaxArray.alloc(m_ijkZoneInfo->getNumCszs(), ___2479()); ___2039 = ___2039 && ___2762.alloc(m_ijkZoneInfo->getNumNszs(), ___2479()); if (___2039) { if (___2337.___910(___2677 + 1, datasetVar + 1) == ___4330) { ___1352 nlFieldData(&___2337, ___2677 + 1, datasetVar + 1, false , false/*___964*/); ___1352 ccFieldData; ___2039 = nlFieldData.___2067() && getIJKCellAndNodeSubzoneMinMaxes(___2337, *m_ijkZoneInfo, datasetVar - m_varIter.baseItem(), nlFieldData, ccFieldData, cszMinMaxArray, ___2762); } else { ___1352 nlFieldData(&___2337, ___2677 + 1, datasetVar + 1, false , true/*___964*/); ___1352 ccFieldData(&___2337, ___2677 + 1, datasetVar + 1, false , false/*___964*/); ___2039 = nlFieldData.___2067() && ccFieldData.___2067() && getIJKCellAndNodeSubzoneMinMaxes(___2337, *m_ijkZoneInfo, datasetVar - m_varIter.baseItem(), nlFieldData, ccFieldData, cszMinMaxArray, ___2762); } } return ___2039; } ___372 SZLOrderedZoneWriter::___4512( FileWriterInterface&         file, ValueLocation_e              ___4326, ___4352                   datasetVar, ___2090::SubzoneOffset_t ___3880) { REQUIRE(file.___2041()); REQUIRE(___4326 == ___4328 || ___4326 == ___4330); ___372 ___2039 = ___4226; if (file.___2002()) { if (___4326 == ___4328) ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, SZPLT_CSZ_FIELD_DATA_MARKER_DESCRIPTION, SZPLT_CSZ_FIELD_DATA_MARKER); else ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, SZPLT_NSZ_FIELD_DATA_MARKER_DESCRIPTION, SZPLT_NSZ_FIELD_DATA_MARKER); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, SZPLT_VARIABLE_NUM_DESCRIPTION, (datasetVar - m_varIter.baseItem()) + 1); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, m_zoneNumberLabel.c_str(), ___2677 - m_baseZone + 1); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZPLT_SUBZONE_NUM_DESCRIPTION, ___3880 + 1); ___1844 const ___1880 = (___4326 == ___4328) ? m_ijkZoneInfo->___690(___3880) : m_ijkZoneInfo->___2761(___3880); ___1844 const ___1852 = (___4326 == ___4328) ? m_ijkZoneInfo->___689(___3880) : m_ijkZoneInfo->___2760(___3880); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZL_ISTART_DESCRIPTION, ___1880.i()+1); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZL_IEND_DESCRIPTION, ___1852.i()+1); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZL_JSTART_DESCRIPTION, ___1880.___2105()+1); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZL_JEND_DESCRIPTION, ___1852.___2105()+1); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZL_KSTART_DESCRIPTION, ___1880.___2134()+1); ___2039 = ___2039 && writeValue<uint64_t, false, 0>(file, SZL_KEND_DESCRIPTION, ___1852.___2134()+1); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template<typename T, bool isBitArray  > ___372 SZLOrderedZoneWriter::___1779( ___1352 const& ___1351, ___1844 const&       ___1880, ___1844 const&       ___1852, ___1844 const&       ___1861, ___2240<T>& ___4299) { ___372 ___2039 = ___4226; REQUIRE(___1351.___2067()); REQUIRE(___1861>=2); REQUIRE(0<=___1880 && ___1880 <= ___1852 && ___1852 < ___1861); size_t const ___3268 = size_t(___1877(___1880, ___1852)); ___478(___4299.empty()); ___2039 = ___2039 && ___4299.alloc(___3268); T* rawPointer = static_cast<T*>(___1351.getRawPointer()); if (___2039) { ___81 const ijMax = ___1861.i()*___1861.___2105(); ___81 ___4300 = 0; for ( ___81 ___2158 = ___1880.___2134(); ___2158 <= ___1852.___2134(); ___2158++ ) { ___81 const ___2164 = ___2158*ijMax; for ( ___81 ___2113 = ___1880.___2105(); ___2113 <= ___1852.___2105(); ___2113++ ) { ___81 const jkOffset = ___2164 + ___2113*___1861.i(); for ( ___81 ___1841 = ___1880.i(); ___1841 <= ___1852.i(); ___1841++ ) { ___81 const datasetPt = jkOffset + ___1841; if (rawPointer) ___4299[___4300] = rawPointer[datasetPt]; else ___4299[___4300] = static_cast<T>(___1351.___1780(datasetPt + 1)); ___4300++; } } } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template<> ___372 SZLOrderedZoneWriter::___1779<uint8_t, true>( ___1352 const& ___1351, ___1844 const&       ___1880, ___1844 const&       ___1852, ___1844 const&       ___1861, ___2240<uint8_t>& ___4299) { ___372 ___2039 = ___4226; REQUIRE(___1351.___2067()); REQUIRE(___1861>=2); REQUIRE(0<=___1880 && ___1880 <= ___1852 && ___1852 < ___1861);
size_t const ___3268 = size_t(numBytesForNumBits(___1877(___1880, ___1852))); ___478(___4299.empty()); ___2039 = ___2039 && ___4299.alloc(___3268); memset(&___4299[0], 0, ___3268); if (___2039) { ___81 const ijMax = ___1861.i()*___1861.___2105(); ___81 ___4300 = 0; for ( ___81 ___2158 = ___1880.___2134(); ___2158 <= ___1852.___2134(); ___2158++ ) { ___81 const ___2164 = ___2158*ijMax; for ( ___81 ___2113 = ___1880.___2105(); ___2113 <= ___1852.___2105(); ___2113++ ) { ___81 const jkOffset = ___2164 + ___2113*___1861.i(); for ( ___81 ___1841 = ___1880.i(); ___1841 <= ___1852.i(); ___1841++ ) { ___81 const datasetPt = jkOffset + ___1841 + 1; double const ___4298 = ___1351.___1780(datasetPt); if (___4298 < 1.0) clearBit(___4299, ___4300); else setBit(___4299, ___4300); ___4300++; } } } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <typename T, bool isBitArray> ___372 SZLOrderedZoneWriter::___4496( FileWriterInterface&         szpltFile, ___1352 const&             ___1351, ___2090::SubzoneOffset_t ___469) { ___372 ___2039 = ___4226; REQUIRE(szpltFile.___2041()); REQUIRE(___1351.___2067()); REQUIRE(___1351.___1786() == ___4328); ___2240<T> valueArray; ___2090::ItemOffset_t ___2782 = m_ijkZoneInfo->getNumCellsInCsz(___469); ___1844 const cellIJKStart = m_ijkZoneInfo->___690(___469); ___1844 const cellIJKEnd   = m_ijkZoneInfo->___689(___469); ___2039 = ___2039 && ___1779<T, isBitArray>( ___1351, cellIJKStart, cellIJKEnd, m_ijkZoneInfo->___2895(), valueArray); if (isBitArray) ___2039 = ___2039 && ___4563<T, false, 0>(szpltFile, "cszFieldData", ___2745, numBytesForNumBits(___2782), &valueArray[0]); else ___2039 = ___2039 && ___4563<T, false, 0>(szpltFile, "cszFieldData", ___2745, ___2782, &valueArray[0]); valueArray.___937(); ENSURE(valueArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <typename T, bool isBitArray> ___372 SZLOrderedZoneWriter::___4531( FileWriterInterface&         szpltFile, ___1352 const&             ___1351, ___1844 const&                   storedIJK, ___2090::SubzoneOffset_t ___2734) { ___372 ___2039 = ___4226; REQUIRE(szpltFile.___2041()); REQUIRE(___1351.___2067()); REQUIRE(___1351.___1786() == ___4330); ___2240<T> valueArray; ___2090::ItemOffset_t ___2822 = m_ijkZoneInfo->getNumNodesInNsz(___2734); ___1844 const nodeIJKStart = m_ijkZoneInfo->___2761(___2734); ___1844 const nodeIJKEnd   = m_ijkZoneInfo->___2760(___2734); ___2039 = ___2039 && ___1779<T, isBitArray>( ___1351, nodeIJKStart, nodeIJKEnd, storedIJK, valueArray); if (isBitArray) ___2039 = ___2039 && ___4563<T, false, 0>(szpltFile, "nszFieldData", ___2745, numBytesForNumBits(___2822), &valueArray[0]); else ___2039 = ___2039 && ___4563<T, false, 0>(szpltFile, "nszFieldData", ___2745, ___2822, &valueArray[0]); valueArray.___937(); ENSURE(valueArray.empty()); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template <typename T, bool isBitArray> ___372 SZLOrderedZoneWriter::writeVariable( FileWriterInterface&     szpltFile, ___4352 const         datasetVar, ___2481 const&       nszDataMinMax, ___2481 const&       cszDataMinMax) { ___2090::SubzoneOffset_t const ___2783 = m_ijkZoneInfo->getNumCszs(); ___2090::SubzoneOffset_t const ___2823 = m_ijkZoneInfo->getNumNszs(); ___4352 const fileVar = datasetVar - m_varIter.baseItem(); ___372 ___2039 = ___4528<T>(szpltFile, NODE_SUBZONE_DATA_MIN_MAX_ARRAY_DESCRIPTION, fileVar, ___2823, &nszDataMinMax[0], ___946 / 2) && ___4528<T>(szpltFile, CELL_SUBZONE_DATA_MIN_MAX_ARRAY_DESCRIPTION, fileVar, ___2783, &cszDataMinMax[0], ___946 / 2); ___1352 ___1351(&___2337, ___2677 + 1, datasetVar + 1); ___2039 = ___2039 && ___1351.___2067(); ValueLocation_e const ___4326 = ___1351.___1786(); ___2090::SubzoneOffset_t const numDataSubzones = (___4326 == ___4328) ? ___2783 : ___2823; ___1844 storedNodeIJK = calculateStoredNodeIJK(*m_ijkZoneInfo); for (___2090::SubzoneOffset_t ___3923 = 0; ___2039 && ___3923 < numDataSubzones; ___3923++) { ___2039 = ___4512(szpltFile, ___4326, datasetVar, ___3923); if (___4326 == ___4328) ___2039 = ___2039 && ___4496<T, isBitArray>(szpltFile, ___1351, ___3923); else ___2039 = ___2039 && ___4531<T, isBitArray>(szpltFile, ___1351, storedNodeIJK, ___3923); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 SZLOrderedZoneWriter::writeZoneData(FileWriterInterface& szpltFile) {
 #if defined OUTPUT_TIMES
uint64_t ___3687 = ___717(); uint64_t minMaxTime = 0; uint64_t ___4549 = 0;
 #endif
___372 ___2039 = ___4226; ___2481 ___2762; ___2481 cszMinMaxArray; m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (___2039 && m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; if (!m_writeVariables[fileVar]) continue; ___2337.___858(); ___2039 = ___485(SzPltWriteOperation_WriteFieldData, ___2337, datasetVar, ___2677); ___2039 = ___2039 && calculateVarSubzoneMinMaxes(datasetVar, ___2762, cszMinMaxArray);
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); minMaxTime += (___1167 - ___3687); ___3687 = ___1167;
 #endif
___2673[fileVar] = szpltFile.fileLoc(); if (___2039) { switch (___2337.___923(___2677 + 1, datasetVar + 1)) { case FieldDataType_Float: ___2039 = writeVariable<float, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Double: ___2039 = writeVariable<double, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Int32: ___2039 = writeVariable<int32_t, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Int16: ___2039 = writeVariable<int16_t, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case FieldDataType_Byte: ___2039 = writeVariable<uint8_t, false>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; case ___1365: ___2039 = writeVariable<uint8_t, true>(szpltFile, datasetVar, ___2762, cszMinMaxArray); break; default: ___478(___1305); break; } } ___2762.___937(); cszMinMaxArray.___937();
 #if defined OUTPUT_TIMES
___1167 = ___717(); ___4549 += (___1167 - ___3687); ___3687 = ___1167;
 #endif
___2337.___859(); }
 #if defined OUTPUT_TIMES
uint64_t ___1167 = ___717(); ___1931(NULL, "%g seconds calculating variable ranges.", (double)(minMaxTime) / 1000.0); ___1931(NULL, "%g seconds writing zone data.", (double)(___4549) / 1000.0);
 #endif
ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } uint64_t SZLOrderedZoneWriter::fieldDataSubzoneHeaderFileSize(bool ___2002) { if (___2002) return 3 * valueSizeInFile<uint32_t, false>(___2002) + 7 * valueSizeInFile<uint64_t, false>(___2002); else return 0; } template <typename T, bool isBitArray> uint64_t SZLOrderedZoneWriter::cellSubzoneFieldDataFileSize(bool ___2002, ___2090::SubzoneOffset_t ___469) const { size_t ___2782 = static_cast<size_t>(m_ijkZoneInfo->getNumCellsInCsz(___469)); return arraySizeInFile<T, false>(___2782, ___2002); } template <> uint64_t SZLOrderedZoneWriter::cellSubzoneFieldDataFileSize<uint8_t, true>(bool ___2002, ___2090::SubzoneOffset_t ___469) const { size_t ___2782 = static_cast<size_t>(m_ijkZoneInfo->getNumCellsInCsz(___469)); return arraySizeInFile<uint8_t, false>(numBytesForNumBits(___2782), ___2002); } template <typename T, bool isBitArray> uint64_t SZLOrderedZoneWriter::nodeSubzoneFieldDataFileSize(bool ___2002, ___2090::SubzoneOffset_t ___2734) const { size_t ___2822 = static_cast<size_t>(m_ijkZoneInfo->getNumNodesInNsz(___2734)); return arraySizeInFile<T, false>(___2822, ___2002); } template <> uint64_t SZLOrderedZoneWriter::nodeSubzoneFieldDataFileSize<uint8_t, true>(bool ___2002, ___2090::SubzoneOffset_t ___2734) const { size_t ___2822 = static_cast<size_t>(m_ijkZoneInfo->getNumNodesInNsz(___2734)); return arraySizeInFile<uint8_t, false>(numBytesForNumBits(___2822), ___2002); } template <typename T, bool isBitArray> uint64_t SZLOrderedZoneWriter::subzoneFieldDataFileSize(bool ___2002, ___2090::SubzoneOffset_t ___3880, ValueLocation_e ___4326) const { if (___4326 == ___4328) return cellSubzoneFieldDataFileSize<T, isBitArray>(___2002, ___3880); else return nodeSubzoneFieldDataFileSize<T, isBitArray>(___2002, ___3880); } template <typename T, bool isBitArray> uint64_t SZLOrderedZoneWriter::variableFileSize(bool ___2002, ValueLocation_e ___4326) { uint64_t ___3358 = 0; ___2090::SubzoneOffset_t const ___2823 = m_ijkZoneInfo->getNumNszs(); ___3358 += arraySizeInFile<std::pair<T, T>, false >(static_cast<size_t>(___2823), ___2002); ___2090::SubzoneOffset_t const ___2783 = m_ijkZoneInfo->getNumCszs(); ___3358 += arraySizeInFile<std::pair<T, T>, false >(static_cast<size_t>(___2783), ___2002); ___2090::SubzoneOffset_t const numDataSubzones = (___4326 == ___4328) ? ___2783 : ___2823; for (___2090::SubzoneOffset_t ___3923 = 0; ___3923 < numDataSubzones; ___3923++) { ___3358 += fieldDataSubzoneHeaderFileSize(___2002); ___3358 += subzoneFieldDataFileSize<T, isBitArray>(___2002, ___3923, ___4326); } return ___3358; } uint64_t SZLOrderedZoneWriter::zoneDataFileSize(bool ___2002) { uint64_t ___3358 = 0; m_varIter.reset(); ___4352 const baseVar = m_varIter.baseItem(); while (m_varIter.hasNext()) { ___4352 const datasetVar = m_varIter.next(); ___4352 const fileVar = datasetVar - baseVar; if (!m_writeVariables[fileVar]) continue; FieldDataType_e const ___1363 = ___2337.___923(___2677 + 1, fileVar + 1); ValueLocation_e const ___4326 = ___2337.___910(___2677 + 1, fileVar + 1); switch (___1363) { case FieldDataType_Float: ___3358 += variableFileSize<float, false>(___2002, ___4326); break; case FieldDataType_Double: ___3358 += variableFileSize<double, false>(___2002, ___4326); break; case FieldDataType_Int32: ___3358 += variableFileSize<int32_t, false>(___2002, ___4326); break; case FieldDataType_Int16: ___3358 += variableFileSize<int16_t, false>(___2002, ___4326); break; case FieldDataType_Byte: ___3358 += variableFileSize<uint8_t, false>(___2002, ___4326); break; case ___1365: ___3358 += variableFileSize<uint8_t, true>(___2002, ___4326); break; default: ___478(___1305); break; } } return ___3358; } ___372 SZLOrderedZoneWriter::writeZoneConnectivity(FileWriterInterface&  ) { return ___4226; } uint64_t SZLOrderedZoneWriter::zoneConnectivityFileSize(bool  ) { return 0; } uint64_t SZLOrderedZoneWriter::zoneHeaderFileSize(bool ___2002) { return m_headerWriter.sizeInFile(___2002); } ___372 SZLOrderedZoneWriter::writeZoneHeader(FileWriterInterface& szpltFile) { return m_headerWriter.write(szpltFile); } }}
