#include <stdlib.h>
#include <string.h>
#include "CodeContract.h"
#include "Scanner.h"
using std::string;
 #if defined MSWIN
 #define STRTOLL _strtoi64
 #else
 #define STRTOLL strtoll
 #endif
namespace tecplot { string const ___3441::noDelimiters(""); string const ___3441::whitespaceDelimiters(" \t\n\r"); string const ___3441::newlineDelimiters("\n\r"); void ___3441::___1932( string const& source, string const& delimiters) { m_sourceStr         = source; m_sourcePos         = 0; m_defaultDelimiters = delimiters; } ___3441::___3441() { ___1932("", whitespaceDelimiters); } ___3441::___3441(const ___3441& ___2888) { m_sourceStr         = ___2888.m_sourceStr; m_sourcePos         = ___2888.m_sourcePos; m_defaultDelimiters = ___2888.m_defaultDelimiters; m_savedPositions    = ___2888.m_savedPositions; } ___3441::___3441(string const& source) { ___1932(source, whitespaceDelimiters); } ___3441::___3441( string const& source, char          delimiter) { string delimiterString; delimiterString += delimiter; ___1932(source, delimiterString); } ___3441::___3441( string const& source, string const& delimiters) { ___1932(source, delimiters); } ___3441::~___3441() { REQUIRE(m_savedPositions.empty()); } ___3441& ___3441::operator =(___3441 const& ___2888) { if (this != &___2888) { m_sourceStr         = ___2888.m_sourceStr; m_sourcePos         = ___2888.m_sourcePos; m_defaultDelimiters = ___2888.m_defaultDelimiters; m_savedPositions    = ___2888.m_savedPositions; } return *this; } void ___3441::reset() { REQUIRE(m_savedPositions.empty()); m_sourcePos = 0; } void ___3441::reset(string const& source) { REQUIRE(m_savedPositions.empty()); ___1932(source, m_defaultDelimiters); } void ___3441::reset( string const& source, string const& delimiters) { REQUIRE(m_savedPositions.empty()); ___1932(source, delimiters); } string const& ___3441::source() const { return m_sourceStr; } string::size_type ___3441::position() const { return m_sourcePos; } void ___3441::savePosition() { m_savedPositions.push(m_sourcePos); ENSURE(!m_savedPositions.empty()); } void ___3441::forgetPosition() { REQUIRE(!m_savedPositions.empty()); m_savedPositions.pop(); } void ___3441::eraseToPosition() { REQUIRE(!m_savedPositions.empty()); string::size_type lastPos = m_sourcePos; restorePosition(); m_sourceStr.erase(m_sourcePos, lastPos - m_sourcePos); } void ___3441::restorePosition() { REQUIRE(!m_savedPositions.empty()); m_sourcePos = m_savedPositions.top(); m_savedPositions.pop(); } static inline size_t getTokenStart( char const* cSourceStr, size_t      sourcePos, char const* cDelimiters) { REQUIRE(VALID_REF(cSourceStr)); REQUIRE("0 <= sourcePos" && sourcePos <= strlen(cSourceStr)); REQUIRE(VALID_REF(cDelimiters)); size_t ___3358 = (sourcePos + strspn(&cSourceStr[sourcePos], cDelimiters)); return ___3358; } static inline size_t getTokenLength( char const* cSourceStr, size_t      tokenStart, char const* cDelimiters) { REQUIRE(VALID_REF(cSourceStr)); REQUIRE("0 <= tokenStart" && tokenStart <= strlen(cSourceStr)); REQUIRE(VALID_REF(cDelimiters)); size_t ___3358; if (strlen(cDelimiters) != 0) ___3358 = strcspn(&cSourceStr[tokenStart], cDelimiters); else if (cSourceStr[tokenStart] != '\0') ___3358 = 1; else ___3358 = 0; return ___3358; } bool ___3441::hasNextToken() const { bool ___3358 = hasNextToken(m_defaultDelimiters); return ___3358; } bool ___3441::hasNextToken(char customDelimiter) const { string customDelimiterString; customDelimiterString += customDelimiter; bool ___3358 = hasNextToken(customDelimiterString); return ___3358; } bool ___3441::hasNextToken(string const& customDelimiters) const { char const* cSourceStr = m_sourceStr.c_str(); char const* cCustomDelimiters = customDelimiters.c_str(); size_t tokenStart = getTokenStart(cSourceStr, m_sourcePos, cCustomDelimiters); size_t tokenLength = getTokenLength(cSourceStr, tokenStart, cCustomDelimiters); bool ___3358 = (tokenLength != 0); return ___3358; } bool ___3441::hasNextInt64Token() const { bool ___3358 = hasNextInt64Token(m_defaultDelimiters); return ___3358; } bool ___3441::hasNextInt64Token(char customDelimiter) const { string customDelimiterString; customDelimiterString += customDelimiter; bool ___3358 = hasNextInt64Token(customDelimiterString); return ___3358; } bool ___3441::hasNextInt64Token(string const& customDelimiters) const { bool ___3358 = hasNextToken(customDelimiters); if (___3358) { char *endScan = NULL; string const tokenString = peekNextToken(customDelimiters); char const* cTokenString = tokenString.c_str(); int64_t strtoll_result = STRTOLL(cTokenString, &endScan, 10); (void)strtoll_result; ___3358 = (*endScan == '\0'); } return ___3358; } bool ___3441::hasNextDoubleToken() const { bool ___3358 = hasNextDoubleToken(m_defaultDelimiters); return ___3358; } bool ___3441::hasNextDoubleToken(char customDelimiter) const { string customDelimiterString; customDelimiterString += customDelimiter; bool ___3358 = hasNextDoubleToken(customDelimiterString); return ___3358; } bool ___3441::hasNextDoubleToken(string const& customDelimiters) const { bool ___3358 = hasNextToken(customDelimiters); if (___3358) { char *endScan = NULL; string const tokenString = peekNextToken(customDelimiters); char const* cTokenString = tokenString.c_str(); double strtod_result = strtod(cTokenString, &endScan);
(void)strtod_result; ___3358 = (*endScan == '\0'); } return ___3358; } bool ___3441::hasNextTokenBeginningWith(string const& pattern) const { bool ___3358 = hasNextTokenBeginningWith(pattern, m_defaultDelimiters); return ___3358; } bool ___3441::hasNextTokenBeginningWith( string const& pattern, char          customDelimiter) const { string customDelimiterString; customDelimiterString += customDelimiter; bool ___3358 = hasNextTokenBeginningWith(pattern, customDelimiterString); return ___3358; } bool ___3441::hasNextTokenBeginningWith( string const& pattern, string const& customDelimiters) const { bool ___3358 = (hasNextToken() && peekNextToken(customDelimiters).find(pattern) == 0); return ___3358; } bool ___3441::hasNextTokenEndingWith(string const& pattern) const { bool ___3358 = hasNextTokenEndingWith(pattern, m_defaultDelimiters); return ___3358; } bool ___3441::hasNextTokenEndingWith( string const& pattern, char          customDelimiter) const { string customDelimiterString; customDelimiterString += customDelimiter; bool ___3358 = hasNextTokenEndingWith(pattern, customDelimiterString); return ___3358; } bool ___3441::hasNextTokenEndingWith( string const& pattern, string const& customDelimiters) const { bool ___3358 = false; if (hasNextToken(customDelimiters)) { string token = peekNextToken(customDelimiters); size_t tokenLength = token.length(); size_t ___2986 = pattern.length(); ___3358 = (tokenLength >= ___2986 && token.substr(tokenLength - ___2986).find(pattern) == 0); } return ___3358; } bool ___3441::hasNextTokenContaining(string const& pattern) const { bool ___3358 = hasNextTokenContaining(pattern, m_defaultDelimiters); return ___3358; } bool ___3441::hasNextTokenContaining( string const& pattern, char          customDelimiter) const { string customDelimiterString; customDelimiterString += customDelimiter; bool ___3358 = hasNextTokenContaining(pattern, customDelimiterString); return ___3358; } bool ___3441::hasNextTokenContaining( string const& pattern, string const& customDelimiters) const { bool ___3358 = (hasNextToken(customDelimiters) && peekNextToken(customDelimiters).find(pattern) != string::npos); return ___3358; } bool ___3441::hasNextChar() const { bool ___3358 = (m_sourcePos < m_sourceStr.length()); return ___3358; } bool ___3441::hasNextChar(char matchChar) const { REQUIRE(matchChar != '\0'); bool ___3358 = (m_sourceStr[m_sourcePos] == matchChar); return ___3358; } bool ___3441::hasNext(string const& pattern) const { bool ___3358 = (m_sourceStr.find(pattern.c_str(), m_sourcePos, pattern.length()) == m_sourcePos); return ___3358; } bool ___3441::hasNextInt64() const { char const* cSourceStr = m_sourceStr.c_str(); char *endScan = NULL; int64_t strtoll_result = STRTOLL(&cSourceStr[m_sourcePos], &endScan, 10); (void)strtoll_result; size_t scanLength = (endScan - &cSourceStr[m_sourcePos]); bool ___3358 = (scanLength != 0); return ___3358; } bool ___3441::hasNextDouble() const { char const* cSourceStr = m_sourceStr.c_str(); char *endScan = NULL; double strtod_result = strtod(&cSourceStr[m_sourcePos], &endScan); (void)strtod_result; size_t scanLength = (endScan - &cSourceStr[m_sourcePos]); bool ___3358 = (scanLength != 0); return ___3358; } bool ___3441::hasNextLine() const { char const* cSourceStr = m_sourceStr.c_str(); char const* cNewLineDelimiters = newlineDelimiters.c_str(); size_t lineLength = getTokenLength(cSourceStr, m_sourcePos, cNewLineDelimiters); bool ___3358 = (cSourceStr[m_sourcePos+lineLength] != '\0'); return ___3358; } string ___3441::nextToken() { REQUIRE(hasNextToken(m_defaultDelimiters)); return nextToken(m_defaultDelimiters); } string ___3441::nextToken(char customDelimiter) { REQUIRE(hasNextToken(customDelimiter)); string customDelimiterString; customDelimiterString += customDelimiter; return nextToken(customDelimiterString); } string ___3441::nextToken(string const& customDelimiters) { REQUIRE(hasNextToken(customDelimiters)); char const* cSourceStr = m_sourceStr.c_str(); char const* cCustomDelimiters = customDelimiters.c_str(); size_t tokenStart = getTokenStart(cSourceStr, m_sourcePos, cCustomDelimiters); size_t tokenLength = getTokenLength(cSourceStr, tokenStart, cCustomDelimiters); string ___3358(&cSourceStr[tokenStart], tokenLength); m_sourcePos = (tokenStart + tokenLength); return ___3358; } string ___3441::peekNextToken() const { REQUIRE(hasNextToken(m_defaultDelimiters)); return peekNextToken(m_defaultDelimiters); } string ___3441::peekNextToken(char customDelimiter) const { REQUIRE(hasNextToken(customDelimiter)); string customDelimiterString; customDelimiterString += customDelimiter; return peekNextToken(customDelimiterString); } string ___3441::peekNextToken(string const& customDelimiters) const { REQUIRE(hasNextToken(customDelimiters)); char const* cSourceStr = m_sourceStr.c_str(); char const* cCustomDelimiters = customDelimiters.c_str(); size_t tokenStart = getTokenStart(cSourceStr, m_sourcePos, cCustomDelimiters); size_t tokenLength = getTokenLength(cSourceStr, tokenStart, cCustomDelimiters);
string ___3358(&cSourceStr[tokenStart], tokenLength); return ___3358; } int64_t ___3441::nextInt64Token() { REQUIRE(hasNextInt64Token(m_defaultDelimiters)); return nextInt64Token(m_defaultDelimiters); } int64_t ___3441::nextInt64Token(char customDelimiter) { REQUIRE(hasNextInt64Token(customDelimiter)); string customDelimiterString; customDelimiterString += customDelimiter; return nextInt64Token(customDelimiterString); } int64_t ___3441::nextInt64Token(string const& customDelimiters) { REQUIRE(hasNextInt64Token(customDelimiters)); int64_t ___3358 = STRTOLL(nextToken(customDelimiters).c_str(), NULL, 10); return ___3358; } double ___3441::nextDoubleToken() { REQUIRE(hasNextDoubleToken(m_defaultDelimiters)); return nextDoubleToken(m_defaultDelimiters); } double ___3441::nextDoubleToken(char customDelimiter) { REQUIRE(hasNextDoubleToken(customDelimiter)); string customDelimiterString; customDelimiterString += customDelimiter; return nextDoubleToken(customDelimiterString); } double ___3441::nextDoubleToken(string const& customDelimiters) { REQUIRE(hasNextDoubleToken(customDelimiters)); double ___3358 = strtod(nextToken(customDelimiters).c_str(), NULL); return ___3358; } void ___3441::skipWhitespace() { skipDelimiters(whitespaceDelimiters); } void ___3441::skipDelimiters() { skipDelimiters(m_defaultDelimiters); } void ___3441::skipDelimiters(char customDelimiter) { string customDelimiterString; customDelimiterString += customDelimiter; skipDelimiters(customDelimiterString); } void ___3441::skipDelimiters(string const& customDelimiters) { char const* cSourceStr = m_sourceStr.c_str(); char const* cCustomDelimiters = customDelimiters.c_str(); m_sourcePos = getTokenStart(cSourceStr, m_sourcePos, cCustomDelimiters); ENSURE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); } char ___3441::nextChar() { REQUIRE(hasNextChar()); return m_sourceStr[m_sourcePos++]; } char ___3441::peekNextChar() const { REQUIRE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return m_sourceStr[m_sourcePos]; } string ___3441::peekNext(string::size_type numChars) const { REQUIRE(numChars == string::npos || numChars > 0); REQUIRE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return m_sourceStr.substr(m_sourcePos, numChars); } string ___3441::next(string::size_type numChars) { REQUIRE(numChars == string::npos || numChars > 0); REQUIRE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); string ___3358 = m_sourceStr.substr(m_sourcePos, numChars); m_sourcePos += ___3358.length(); return ___3358; } string ___3441::remaining() { REQUIRE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return next(string::npos); } int64_t ___3441::nextInt64() { REQUIRE(hasNextInt64()); char const* cSourceStr = m_sourceStr.c_str(); char *endScan = NULL; int64_t ___3358 = STRTOLL(&cSourceStr[m_sourcePos], &endScan, 10); size_t scanLength = (endScan - &cSourceStr[m_sourcePos]); m_sourcePos += scanLength; ENSURE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return ___3358; } double ___3441::nextDouble() { REQUIRE(hasNextDouble()); char const* cSourceStr = m_sourceStr.c_str(); char *endScan = NULL; double ___3358 = strtod(&cSourceStr[m_sourcePos], &endScan); size_t scanLength = (endScan - &cSourceStr[m_sourcePos]); m_sourcePos += scanLength; ENSURE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return ___3358; } string ___3441::nextLine() { REQUIRE(hasNextLine()); char const* cSourceStr = m_sourceStr.c_str(); char const* cNewLineDelimiters = newlineDelimiters.c_str(); size_t lineLength = getTokenLength(cSourceStr, m_sourcePos, cNewLineDelimiters); string ___3358(&cSourceStr[m_sourcePos], lineLength); m_sourcePos += lineLength; if (m_sourcePos < m_sourceStr.length()) { if (cSourceStr[m_sourcePos] == '\r' && cSourceStr[m_sourcePos+1] == '\n') m_sourcePos++; m_sourcePos++; } ENSURE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return ___3358; } bool ___3441::findInLine(string const& pattern) { bool ___3358 = false; if (hasNextToken(newlineDelimiters)) { char const* cSourceStr = m_sourceStr.c_str(); char const* cNewLineDelimiters = newlineDelimiters.c_str(); size_t lineLength = getTokenLength(cSourceStr, m_sourcePos, cNewLineDelimiters); char const* cPattern = pattern.c_str(); char const* cTarget = (char const*)strstr(&cSourceStr[m_sourcePos], cPattern); ___3358 = (cTarget != NULL && ((cTarget - cSourceStr) - m_sourcePos) <= lineLength); if (___3358) m_sourcePos = (cTarget - cSourceStr) + pattern.length(); } ENSURE("0 <= m_sourcePos" && m_sourcePos <= m_sourceStr.length()); return ___3358; } bool ___3441::find(string const& pattern) { while (hasNextToken(newlineDelimiters)) { if (findInLine(pattern)) return true; if (hasNextLine()) nextLine(); else return false; } return false; } bool ___3441::skipTokens(size_t NumTokensToSkip) { bool CanSkip = true; for (size_t i = 1; i <= NumTokensToSkip && CanSkip; i++) { if (hasNextToken()) nextToken(); else CanSkip = false; } return CanSkip; } }
