#include "ThirdPartyHeadersBegin.h"
#include <exception>
#include <iostream>
#include <limits>
#include <new>
#include <sstream>
#include <stdlib.h>
#include <string>
#include <utility>
#include <boost/algorithm/string.hpp>
#include <boost/assign.hpp>
#include <boost/foreach.hpp>
#include <boost/make_shared.hpp>
#include <boost/scoped_array.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/static_assert.hpp>
#include <boost/tokenizer.hpp>
#include <boost/unordered_map.hpp>
 #if defined TECIOMPI
#include <iomanip>
#include <sstream>
#include <string>
#include <vector>
#include <mpi.h> 
 #endif 
#include "ThirdPartyHeadersEnd.h"
#include "MASTER.h"
#include "GLOBAL.h"
#include "ClassicFEZoneConnectivityWriter.h"
#include "ClassicZoneVariableWriter.h"
#include "CHARTYPE.h"
#include "CodeContract.h"
#include "CszConnectivity.h"
#include "DataSetWriter.h"
#include "DataWriteStatisticsInterface.h"
#include "exportSubzonePlt.h"
#include "fileStuff.h"
#include "FileStreamReader.h"
#include "FileStreamWriter.h"
#include "importSzPltFile.h"
 #if defined TECIOMPI
#include "DataSetWriterMPI.h"
#include "MPICommunicator.h"
#include "MPIFileWriter.h"
#include "MPINonBlockingCommunicationCollection.h"
 #endif
#include "SZLFEZoneWriter.h"
#include "SZLOrderedZoneWriter.h"
#include "TecioData.h"
#include "TecioSZL.h"
#include "TecioTecUtil.h"
#include "writeValueArray.h"
#include "ZoneMetadata.h"
#include "zoneUtil.h"
#include "TecplotVersion.h"
 #if defined MSWIN && defined _DEBUG
 #define ___3184(s) do { OutputDebugStringA(s); } while (0)
 #define ___3185(s,a1) do { char ___416[4096]; sprintf(___416,s,a1); OutputDebugStringA(___416); } while (0)
 #define ___3186(s,a1,a2) do { char ___416[4096]; sprintf(___416,s,a1,a2); OutputDebugStringA(___416); } while (0)
 #define ___3187(s,a1,a2,a3) do { char ___416[4096]; sprintf(___416,s,a1,a2,a3); OutputDebugStringA(___416); } while (0)
 #define PRINT4(s,a1,a2,a3,a4) do { char ___416[4096]; sprintf(___416,s,a1,a2,a3,a4); OutputDebugStringA(___416); } while (0)
 #define PRINT5(s,a1,a2,a3,a4,a5) do { char ___416[4096]; sprintf(___416,s,a1,a2,a3,a4,a5); OutputDebugStringA(___416); } while (0)
 #else
 #define ___3184(s) printf(s)
 #define ___3185(s,a1) printf(s,a1)
 #define ___3186(s,a1,a2) printf(s,a1,a2)
 #define ___3187(s,a1,a2,a3) printf(s,a1,a2,a3)
 #define PRINT4(s,a1,a2,a3,a4) printf(s,a1,a2,a3,a4)
 #define PRINT5(s,a1,a2,a3,a4,a5) printf(s,a1,a2,a3,a4,a5)
 #endif
 #define ___23(n, T, s) (new T[n])
 #define ___1530(a, s) (delete[] a);
 #define ___2380 10
using namespace tecplot::___3933;
 #if defined TECIOMPI
namespace { int const ZONE_NUMBER = 0x0001FADE; } using namespace tecplot::teciompi;
 #endif
bool _showMessage( MessageBoxType_e messageBoxType, char const*      ___2432) { switch(messageBoxType) { case ___2443: ___3185(___2432,"%s\n"); ___3184("...aborting.\n"); return false; case ___2447: case ___2448: ___3184("Warning: "); ___3185(___2432,"%s\n"); ___3184("...continuing.\n"); return true; case ___2444: ___3184("Information: "); ___3185(___2432,"%s\n"); ___3184("...continuing.\n"); return true; case ___2446: case ___2449: case ___2450: ___3184("Encountered question: "); ___3185(___2432,"%s\n"); ___3184("...assuming Yes and continuing.\n"); return true; default: return false; } } namespace tecplot { namespace tecioszl { namespace { struct OutputInfo { OutputInfo() : m_numValuesWritten(0) , m_numErrs(0) , m_geom(tecioszl::___1556::invalidGeom()) , m_text(tecioszl::Text::invalidText()) {} OutputInfo( std::string const& ___4177, std::string const& ___4350, std::string const& ___1394, std::string const& ___3447, int32_t            ___1407, int32_t            debugLevel, int32_t            defaultVarType, OutputInfo*        gridOutputInfo) : ___2649(___4177) , m_variables(___4350) , ___2461(___1394) , ___2620(___3447) , m_fileType(___1407) , m_debugLevel(debugLevel) , m_defaultVarType(defaultVarType) , m_gridOutputInfo(gridOutputInfo) , m_numValuesWritten(0) , m_numErrs(0) , m_tecioData(___4177, ___4350, defaultVarType) , m_geom(tecioszl::___1556::invalidGeom()) , m_text(tecioszl::Text::invalidText()) { size_t extensionPos = ___2461.find_last_of('.'); if (extensionPos == std::string::npos || (___2461.substr(extensionPos) != std::string(".szplt") && ___2461.substr(extensionPos) != std::string(".szptn"))) { ___2461 += ".szplt"; } } std::string ___2649; std::string m_variables; std::string ___2461; std::string ___2620; int32_t  m_fileType; int32_t  m_debugLevel; int32_t  m_defaultVarType; OutputInfo* m_gridOutputInfo; uint64_t m_numValuesWritten; int m_numErrs; ___3970 m_tecioData; tecioszl::___1556 m_geom; tecioszl::Text m_text; boost::shared_ptr<___4016> m_tecioTecUtil; boost::shared_ptr<DataSetWriter> m_dataSetWriter;
 #if defined TECIOMPI
MPI_Comm m_comm; boost::scoped_ptr<MPICommunicator> m_communicator; boost::scoped_ptr<MPINonBlockingCommunicationCollection> ___2396; int m_mainProcess; int m_localProcess;
 #endif
}; std::vector<boost::shared_ptr<OutputInfo> > outputInfos; boost::shared_ptr<OutputInfo> ___1812; class DataWriteStatistics : public tecplot::___3933::___936 { public: DataWriteStatistics() {} virtual ~DataWriteStatistics() {} virtual void addWriteTime(uint64_t  ) {} virtual void ___7(uint64_t  ) {} virtual void addTreeBytesWritten(uint64_t  ) {} virtual void setMemoryInfoString(std::string const&  ) {} }; bool getOutputInfo(OutputInfo** outputInfo, void* fileHandle, char const* routineName) { REQUIRE(VALID_REF(outputInfo)); REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(routineName)); *outputInfo = (OutputInfo*)fileHandle; if (!*outputInfo) { ___3185("%s : invalid parameter fileHandle.\n", routineName); return false; } return true; } bool zoneOrPartitionDataAreComplete( OutputInfo* outputInfo, int32_t     zone, int32_t     ___2977, bool        checkConnectivity, char const* routineName) { REQUIRE(VALID_REF(outputInfo)); REQUIRE(zone > 0); REQUIRE(___2977 >= 0); Zone_s* zonePtr = outputInfo->m_tecioData.zonePtr(zone); if (zonePtr && !zonePtr->m_partitionMap.empty()) { Zone_s::ZoneMap::const_iterator it = zonePtr->m_partitionMap.find(___2977 - 1); if (it == zonePtr->m_partitionMap.end()) zonePtr = NULL; else zonePtr = it->second.get(); } if (!zonePtr) return true; bool ___3358 = true; for (size_t ___4336 = 0; ___4336 < zonePtr->___2496.size(); ++___4336) { if (!zonePtr->m_passiveVars[___4336] && !zonePtr->m_shareVarFromZone[___4336] && zonePtr->___2496[___4336]->storedValueCount() < zonePtr->___2496[___4336]->___2668) { std::ostringstream ___2892; int64_t valuesNeeded = zonePtr->___2496[___4336]->___2668 - zonePtr->___2496[___4336]->storedValueCount(); ___2892 << routineName << ": Not all variable values for zone " << zone; if (___2977 > 0) ___2892 << " partition " << ___2977; ___2892 << " have been written." << std::endl << "Currently need " << valuesNeeded << " for variable " << ___4336 + 1 << "." << std::endl; ___3185("%s", ___2892.str().c_str()); ++outputInfo->m_numErrs; ___3358 = false; } } if (checkConnectivity) { if (zonePtr->___2497 && zonePtr->___2497->___2392 * zonePtr->___2497->___2500 > zonePtr->___2497->storedValueCount()) { int64_t valuesNeeded = zonePtr->___2497->___2392 * zonePtr->___2497->___2500 - zonePtr->___2497->storedValueCount(); std::ostringstream ___2892; ___2892 << routineName << ": Not all node map values for zone " << zone; if (___2977 > 0) ___2892 << " partition " << ___2977; ___2892 << " have been written." << std::endl << "Currently need " << valuesNeeded << " more values."; ___3185("%s", ___2892.str().c_str()); ++outputInfo->m_numErrs; ___3358 = false; } } return ___3358; } bool zoneDataAreComplete( OutputInfo* outputInfo, int32_t     zone, bool        checkConnectivity, char const* routineName) { REQUIRE(VALID_REF(outputInfo)); REQUIRE(zone > 0); if (outputInfo->m_tecioData.numZonePartitions(zone) == 0) { return zoneOrPartitionDataAreComplete(outputInfo, zone, 0, checkConnectivity, routineName); } else { for (int32_t ___2977 = 1; ___2977 <= outputInfo->m_tecioData.numZonePartitions(zone); ++___2977) { if (!zoneOrPartitionDataAreComplete(outputInfo, zone, ___2977, checkConnectivity, routineName)) return false; } } return true; } bool dataAreComplete(OutputInfo* outputInfo, char const* routineName) { REQUIRE(VALID_REF(outputInfo)); bool checkConnectivity = (outputInfo->m_fileType != 2); bool ___3358 = true; for (int32_t i = 1; i <= outputInfo->m_tecioData.___2846(); ++i) if (!zoneDataAreComplete(outputInfo, i, checkConnectivity, routineName)) ___3358 = false; return ___3358; } ___372 includeRevisionNumber() { ___372 ___3358 = ___4226;
 #if defined LINUX
{ char const* envName = "EXCLUDE_SZPLT_REVISION_NUMBER"; char const* envResult = getenv(envName); if (envResult != NULL) { if (boost::iequals(envResult, "TRUE")) ___3358 = ___1305; else if (boost::iequals(envResult, "FALSE")) ___3358 = ___4226; else fprintf(stderr, "Err: %s(%d): If environment variable (%s) is set, its value should be TRUE or FALSE; ignoring setting, (%s).", __FILE__, __LINE__, envName, envResult); } }
 #endif
return ___3358; } int32_t writeFile(OutputInfo* outputInfo, char const* routineName) { if (!dataAreComplete(outputInfo, routineName)) return -1; bool const ___4480 =
 #if defined TECIOMPI && defined _DEBUG
true;
 #elif defined WRITEASCII
true;
 #else
false;
 #endif
___1388 ___1387( ___4480, static_cast<DataFileType_e>(outputInfo->m_fileType), DEFAULT_SUBZONE_MAX_IJK_DIM, DEFAULT_SUBZONE_MAX_FE_SIZE); ___1387.setFileVersion(SZPLT_CUR_WRITE_VERSION); ___1387.setCodeRevision(1); if (___1387.___844() == ___848) {
 #if defined TECIOMPI
___1812->___2396->___4446();
 #endif
try { outputInfo->m_tecioData.copyConnectivity(outputInfo->m_gridOutputInfo->m_tecioData); } catch (std::exception const& e) { ___3186("%s: %s", routineName, e.what()); return -1; } } outputInfo->m_tecioTecUtil = boost::make_shared<___4016>(boost::ref(outputInfo->m_tecioData)); DataWriteStatistics ___935; boost::scoped_ptr<FileWriterInterface> szpltFile;
 #if defined TECIOMPI
szpltFile.reset(new MPIFileWriter(outputInfo->___2461.c_str(), outputInfo->m_comm));
 #else
szpltFile.reset(new FileStreamWriter(outputInfo->___2461.c_str()));
 #endif
if (___1387.___844() == ___848) { if (!outputInfo->m_gridOutputInfo || !outputInfo->m_gridOutputInfo->m_dataSetWriter) { ___3186("%s: For SZL solution files (FileType = 2), you must output and call %s\n", routineName, routineName); ___3185("for a grid file (FileType = 1) prior to calling %s for the solution file.\n", routineName); return -1; } outputInfo->m_dataSetWriter = outputInfo->m_gridOutputInfo->m_dataSetWriter; outputInfo->m_dataSetWriter->replaceDataSource(outputInfo->m_tecioTecUtil.get(), ___3501(0), ___3501(0)); } else {
 #if defined TECIOMPI
outputInfo->m_dataSetWriter = boost::make_shared<DataSetWriterMPI>( outputInfo->m_tecioTecUtil.get(), ___3501(0), ___3501(0), ___1387.___1757(), ___1387.___1756(), ___4480, outputInfo->m_comm, outputInfo->m_mainProcess, outputInfo->m_localProcess);
 #else
outputInfo->m_dataSetWriter = boost::make_shared<DataSetWriter>( outputInfo->m_tecioTecUtil.get(), ___3501(0), ___3501(0), ___1387.___1757(), ___1387.___1756(), ___4480);
 #endif
} int ___3358 = 0; if (!szpltFile->open()) { ___3358 = -1; ++outputInfo->m_numErrs; } else { szpltFile->___3494(___4480 ? ___4226 : ___1305); szpltFile->setDataFileType(___1387.___844());
 #if defined TECIOMPI
if (outputInfo->m_localProcess != outputInfo->m_mainProcess) { ___1392 szpltZoneHeaderFileLocs; if (outputInfo->m_tecioTecUtil->___896() && (!szpltZoneHeaderFileLocs.alloc(outputInfo->m_tecioTecUtil->___891()) || !outputInfo->m_dataSetWriter->writeDataSet(*szpltFile, szpltZoneHeaderFileLocs))) { ___3358 = -1; ++outputInfo->m_numErrs; } } else
 #endif
{ if (!___1242( *outputInfo->m_tecioTecUtil, *szpltFile, ___1387, includeRevisionNumber(), *outputInfo->m_dataSetWriter, ___3501(0), ___3501(0), ___935)) { ___3358 = -1; ++outputInfo->m_numErrs; } } } szpltFile->close(___3358 == 0); outputInfo->m_dataSetWriter->replaceDataSource(NULL, ___3501(0), ___3501(0)); return ___3358; } } int32_t tecFileWriterOpen_SZL( char const* ___1394, char const* dataSetTitle, char const* variableList, int32_t     ___1407, int32_t     defaultVarType, void*       gridFileHandle, void**      fileHandle) { try { OutputInfo* gridOutputInfo = (OutputInfo*)gridFileHandle; if (___1407 == 2) { if (!gridOutputInfo) { ___3184("tecFileWriterOpen: You must supply an open grid file (FileType = 1)\nto output a solution file (FileType = 2).\n"); return -1; } if (gridOutputInfo->m_debugLevel) { ___3184("Writing grid file prior to opening first solution file.\n"); } if (!gridOutputInfo->m_dataSetWriter && writeFile(gridOutputInfo, "tecFileWriterOpen") != 0) { return -1; } } OutputInfo* outputInfo = new OutputInfo( dataSetTitle, variableList, ___1394, ".", ___1407, 0, defaultVarType, gridOutputInfo); *fileHandle = outputInfo;
 #if defined TECIOMPI
outputInfo->m_comm = MPI_COMM_SELF; outputInfo->m_communicator.reset(new MPICommunicator(MPI_COMM_SELF)); outputInfo->___2396.reset(new MPINonBlockingCommunicationCollection(MPI_COMM_SELF)); outputInfo->m_localProcess = 0; outputInfo->m_mainProcess = 0;
 #endif
} catch (std::exception const& e) { ___3185("tecFileWriterOpen: %s\n", e.what()); return -1; } return 0; } int32_t tecFileSetDiagnosticsLevel_SZL(void* fileHandle, int32_t level) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecFileSetDiagnosticsLevel")) return -1; outputInfo->m_debugLevel = level; if (outputInfo->m_debugLevel) { ___3185("Enabling diagnostics for file \"%s\"\n", outputInfo->___2461.c_str()); ___3185("NumVars = %d\n", outputInfo->m_tecioData.___2843()); } return 0; }
 #if defined TECIOMPI
namespace {
 #if !defined NO_ASSERTS
size_t mpiSizeof(MPI_Datatype mpiDatatype) { int datatypeSize; if (MPI_Type_size(mpiDatatype, &datatypeSize) != MPI_SUCCESS) return 0; else return static_cast<size_t>(datatypeSize); }
 #endif
bool mpiBroadcastString(std::string& str, OutputInfo& outputInfo) { int length = static_cast<int>(str.size()); if (MPI_Bcast(&length, 1, MPI_INT, outputInfo.m_mainProcess, outputInfo.m_comm) != MPI_SUCCESS) return false; str.resize(static_cast<size_t>(length)); return (MPI_Bcast(&str[0], length, MPI_CHAR, outputInfo.m_mainProcess, outputInfo.m_comm) == MPI_SUCCESS); } int32_t szlMPIInit(OutputInfo* outputInfo, MPI_Comm comm, int mainProcess) { int32_t  ___3358 = 0; int rank; if (MPI_Comm_rank(comm, &rank) != MPI_SUCCESS) ___3358 = -1; if (___3358 == 0) { outputInfo->m_comm = comm; outputInfo->m_communicator.reset(new MPICommunicator(comm)); outputInfo->___2396.reset(new MPINonBlockingCommunicationCollection(comm)); outputInfo->m_mainProcess = mainProcess; outputInfo->m_localProcess = rank; if (!mpiBroadcastString(outputInfo->___2461, *outputInfo)) ___3358 = -1; } return ___3358; } } int32_t tecMPIInitialize_SZL(void* fileHandle, MPI_Comm communicator, int32_t mainRank) { BOOST_STATIC_ASSERT(sizeof(int) == 4); INVARIANT(mpiSizeof(MPI_INT) == 4); OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecMPIInitialize")) return -1; return szlMPIInit(outputInfo, communicator, mainRank); }
 #endif
namespace { char const* zoneTypeStrings[] = { "ORDERED", "FELINESEG", "FETRIANGLE", "FEQUADRILATERAL", "FETETRAHEDRON", "FEBRICK", "FEPOLYGON", "FEPOLYHEDRON" }; char const* varTypeStrings[] = { "", "FLOAT", "DOUBLE", "INT32", "INT16", "BYTE" }; void printVarInfo(int32_t const* varTypes, int32_t const* ___3551, int ___2843) { if (___3551) { std::ostringstream ___2892; for (int i = 0; i < ___2843; ++i) { if (i > 0) ___2892 << ","; ___2892 << ___3551[i]; } ___3185("      shareVarFromZone = %s\n", ___2892.str().c_str()); } else if (varTypes) { std::ostringstream ___2892; for (int i = 0; i < ___2843; ++i) { if (i > 0) ___2892 << ","; ___2892 << varTypeStrings[varTypes[i]]; } ___3185("      varTypes = %s\n", ___2892.str().c_str()); } } } int32_t tecZoneCreateIJK_SZL( void*          fileHandle, char const*    ___4690, int64_t        imax, int64_t        jmax, int64_t        kmax, int32_t const* varTypes, int32_t const* ___3551, int32_t const* valueLocations, int32_t const* ___2982, int32_t        shareFaceNeighborsFromZone, int64_t        ___2802, int32_t        ___1284, int32_t*       zone) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecZoneCreateIJK")) return -1; try { outputInfo->m_tecioData.___19( ___4690, 0, imax, jmax, kmax, 0.0, 0, 0, ___2802, ___1284, 0, 0, 0, varTypes, ___2982, valueLocations, ___3551, shareFaceNeighborsFromZone); *zone = static_cast<int32_t>(outputInfo->m_tecioData.___2846()); outputInfo->m_numValuesWritten = 0; if (outputInfo->m_debugLevel) { ___3185("Creating Zone %d:\n", outputInfo->m_tecioData.___2846()); ___3185("      Title = %s\n", ___4690); ___3184("      Type  = ORDERED\n"); ___3185("      IMax  = %" PRId64 "\n", imax); ___3185("      JMax  = %" PRId64 "\n", jmax); ___3185("      KMax  = %" PRId64 "\n", kmax); printVarInfo(varTypes, ___3551, outputInfo->m_tecioData.___2843()); } } catch (std::exception const& e) { ___3185("tecZoneCreateIJK: %s\n", e.what()); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecZoneCreateFE_SZL( void*          fileHandle, char const*    ___4690, int32_t        ___4692, int64_t        ___2821, int64_t        ___2781, int32_t const* varTypes, int32_t const* ___3551, int32_t const* valueLocations, int32_t const* ___2982, int32_t        ___3549, int64_t        ___2802, int32_t        ___1284, int32_t*       zone) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecZoneCreateFE")) return -1; try { outputInfo->m_tecioData.___19( ___4690, ___4692, ___2821, ___2781, 0, 0.0, 0, 0, ___2802, ___1284, 0, 0, 0, varTypes, ___2982, valueLocations, ___3551, ___3549); *zone = static_cast<int32_t>(outputInfo->m_tecioData.___2846()); outputInfo->m_numValuesWritten = 0; if (outputInfo->m_debugLevel) { ___3185("Creating Zone %d:\n", outputInfo->m_tecioData.___2846()); ___3185("      Title = %s\n", ___4690); ___3185("      Type  = %s\n", zoneTypeStrings[___4692]); ___3185("      NumNodes  = %" PRId64 "\n", ___2821); ___3185("      NumCells  = %" PRId64 "\n", ___2781); printVarInfo(varTypes, ___3551, outputInfo->m_tecioData.___2843()); } } catch (std::exception const& e) { ___3185("tecZoneCreateFE: %s\n", e.what()); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecZoneCreatePoly_SZL( void*          fileHandle, char const*    ___4690, int32_t        ___4692, int64_t        ___2821, int64_t        numFaces, int64_t        ___2781, int64_t        ___4192, int32_t const* varTypes, int32_t const* ___3551, int32_t const* valueLocations, int32_t const* ___2982, int32_t        ___3549, int64_t        ___2786, int64_t        ___4188, int32_t*       zone) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecZoneCreatePoly")) return -1; try { outputInfo->m_tecioData.___19( ___4690, ___4692, ___2821, ___2781, numFaces, 0.0, 0, 0, 0, 0, ___4192, ___2786, ___4188, varTypes, ___2982, valueLocations, ___3551, ___3549); *zone = static_cast<int32_t>(outputInfo->m_tecioData.___2846()); outputInfo->m_numValuesWritten = 0; if (outputInfo->m_debugLevel) { ___3185("Creating Zone %d:\n", outputInfo->m_tecioData.___2846()); ___3185("      Title = %s\n", ___4690); ___3185("      Type  = %s\n", zoneTypeStrings[___4692]); ___3185("      NumNodes  = %" PRId64 "\n", ___2821); ___3185("      NumFaces  = %" PRId64 "\n", numFaces); ___3185("      NumCells  = %" PRId64 "\n", ___2781); printVarInfo(varTypes, ___3551, outputInfo->m_tecioData.___2843()); } } catch (std::exception const& e) { ___3185("tecZoneCreatePoly: %s\n", e.what()); ++outputInfo->m_numErrs;
return -1; } return 0; } namespace { bool getOutputInfoAndZonePtr(OutputInfo** outputInfo, Zone_s** zonePtr, void* fileHandle, int32_t zone, char const* routineName) { REQUIRE(VALID_REF(outputInfo)); REQUIRE(VALID_REF(zonePtr)); REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(routineName)); if (!getOutputInfo(outputInfo, fileHandle, routineName)) return false; if (zone <= 0 || !(*outputInfo)->m_tecioData.zonePtr(zone)) { ___3186("%s : invalid zone input parameter (%d).\n", routineName, zone); ++(*outputInfo)->m_numErrs; return false; } *zonePtr = (*outputInfo)->m_tecioData.zonePtr(zone); return true; } } int32_t tecZoneSetUnsteadyOptions_SZL( void*   fileHandle, int32_t zone, double  ___3640, int32_t ___3785) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZonePtr(&outputInfo, &zonePtr, fileHandle, zone, "tecZoneSetUnsteadyOptions")) return -1; if (___3785 < 0) { ___3185("tecZoneSetUnsteadyOptions : invalid strandID input parameter (%d).\n", ___3785); ++outputInfo->m_numErrs; return -1; } zonePtr->___2621 = ___3640; zonePtr->___2622 = ___3785; return 0; } int32_t tecZoneSetParentZone_SZL(void* fileHandle, int32_t zone, int32_t ___2974) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZonePtr(&outputInfo, &zonePtr, fileHandle, zone, "tecZoneSetParentZone")) return -1; if (zone == ___2974 || outputInfo->m_tecioData.___2846() <= ___2974) { ___3185("tecZoneSetParentZone : invalid parentZone input parameter (%d).\n", ___2974); ++outputInfo->m_numErrs; return -1; } zonePtr->___2614 = ___2974; return 0; }
 #if defined TECIOMPI
int32_t tecZoneMapPartitionsToMPIRanks_SZL( void*          fileHandle, int32_t        zone, int32_t        numPartitions, int32_t const* mpiRanksForPartitions) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZonePtr(&outputInfo, &zonePtr, fileHandle, zone, "tecZoneMapPartitionsToMPIRanks")) return -1; if (numPartitions < 1) { ___3185("tecZoneMapPartitionsToMPIRanks : invalid numPartitions input parameter (%d).\n", numPartitions); ++outputInfo->m_numErrs; return -1; } try { std::vector<int> partitionOwners(mpiRanksForPartitions, mpiRanksForPartitions + numPartitions); outputInfo->m_tecioData.setPartitionOwners(partitionOwners); if (outputInfo->m_localProcess == outputInfo->m_mainProcess) { int32_t zone = outputInfo->m_tecioData.___2846(); BOOST_FOREACH(int owner, partitionOwners) { if (owner != outputInfo->m_localProcess) outputInfo->___2396->sendScalarCopy(zone, owner, ZONE_NUMBER); } } else { bool keepZone = false; BOOST_FOREACH(int owner, partitionOwners) { if (owner == outputInfo->m_localProcess) { keepZone = true; int32_t zone; outputInfo->m_communicator->receiveScalar(zone, outputInfo->m_mainProcess, ZONE_NUMBER); if (zone > outputInfo->m_tecioData.___2846()) { outputInfo->m_tecioData.renumberLastZone(zone); } } } if (!keepZone) { outputInfo->m_tecioData.dropLastZone(); } } } catch (std::exception const& e) { ___3185("tecZoneMapPartitionsToMPIRanks: %s\n", e.what()); ++outputInfo->m_numErrs; return (2); } return 0; }
 #endif
namespace { template <typename T> int32_t fePartitionCreate( char const*    routineName, void*          fileHandle, int32_t        zone, int32_t        ___2977, int64_t        ___2821, int64_t        ___2781, int64_t        numGhostNodes, T const*       ghostNodes, int32_t const* neighborPartitions, T const*       neighborPartitionNodes, int64_t        numGhostCells, T const*       ghostCells) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZonePtr(&outputInfo, &zonePtr, fileHandle, zone, "tecFEPartitionCreate64")) return -1; if (___2977 < 1) { ___3186("%s: invalid partition input parameter (%d).\n", routineName, ___2977); ++outputInfo->m_numErrs; return -1; } if (!___3894(zonePtr->___2684)) { ___3185("%s: Called for the wrong zone type; can be called only for 3D FE zones.\n", routineName); ++outputInfo->m_numErrs; return -1; } if (___2821 < 1) { ___3186("%s: Invalid numNodes input parameter (%" PRId64 ").\n", routineName, ___2821); ++outputInfo->m_numErrs; return -1; } if (___2781 < 1) { ___3186("%s: Invalid numCells input parameter (%" PRId64 ").\n", routineName, ___2781); ++outputInfo->m_numErrs; return -1; } if (numGhostNodes < 0) { ___3186("%s: Invalid numGhostNodes input parameter (%" PRId64 ").\n", routineName, numGhostNodes); ++outputInfo->m_numErrs; return -1; } if (numGhostNodes > 0) { if (!ghostNodes) { ___3185("%s: Invalid ghostNodes input parameter.\n", routineName); ++outputInfo->m_numErrs; return -1; } else if (!neighborPartitions) { ___3185("%s: Invalid neighborPartitions input parameter.\n", routineName); ++outputInfo->m_numErrs; return -1; } else if (!neighborPartitionNodes) { ___3185("%s: Invalid neighborPartitionNodes input parameter.\n", routineName); ++outputInfo->m_numErrs; return -1; } } if (numGhostCells < 0) { ___3186("%s: Invalid NGCells input parameter (%" PRId64 ").\n", routineName, numGhostCells); ++outputInfo->m_numErrs; return -1; } if (numGhostCells > 0 && !ghostCells) { ___3185("%s: Invalid ghostCells input parameter.\n", routineName); ++outputInfo->m_numErrs; return -1; } try {
 #if defined TECIOMPI
if (zonePtr->m_partitionOwners.empty()) { throw std::logic_error(std::string("Must call tecZoneMapPartitionsToMPIRanks prior to calling ") + routineName); } else if (static_cast<size_t>(___2977) > zonePtr->m_partitionOwners.size()) { std::ostringstream ___2892; ___2892 << "Invalid partition number passed to " << routineName << ": " << ___2977; throw std::logic_error(___2892.str().c_str()); }
 #endif 
outputInfo->m_tecioData.addFEZonePartition( zone, ___2977, ___2821, ___2781, std::vector<T>(ghostNodes, ghostNodes + numGhostNodes), std::vector<int32_t>(neighborPartitions, neighborPartitions + numGhostNodes), std::vector<T>(neighborPartitionNodes, neighborPartitionNodes + numGhostNodes), std::vector<T>(ghostCells, ghostCells + numGhostCells)); } catch (std::exception const& e) { ___3186("%s: %s\n", routineName, e.what()); ++outputInfo->m_numErrs; return -1; } return 0; } } int32_t tecFEPartitionCreate32_SZL( void*          fileHandle, int32_t        zone, int32_t        ___2977, int64_t        ___2821, int64_t        ___2781, int64_t        numGhostNodes, int32_t const* ghostNodes, int32_t const* neighborPartitions, int32_t const* neighborPartitionNodes, int64_t        numGhostCells, int32_t const* ghostCells) { return fePartitionCreate( "tecFEPartitionCreate32", fileHandle, zone, ___2977, ___2821, ___2781, numGhostNodes, ghostNodes, neighborPartitions, neighborPartitionNodes, numGhostCells, ghostCells); } int32_t tecFEPartitionCreate64_SZL( void*          fileHandle, int32_t        zone, int32_t        ___2977, int64_t        ___2821, int64_t        ___2781, int64_t        numGhostNodes, int64_t const* ghostNodes, int32_t const* neighborPartitions, int64_t const* neighborPartitionNodes, int64_t        numGhostCells, int64_t const* ghostCells) { return fePartitionCreate( "tecFEPartitionCreate64", fileHandle, zone, ___2977, ___2821, ___2781, numGhostNodes, ghostNodes, neighborPartitions, neighborPartitionNodes, numGhostCells, ghostCells); } namespace { bool checkParameter(int64_t parameter, char const* parameterName, int64_t minValue, int64_t maxValue) { if (parameter < minValue || parameter > maxValue) { ___3186("tecIJKPartitionCreate: Invalid %s input parameter (%" PRId64 ").\n", parameterName, parameter); return false; } else { return true; } } } int32_t tecIJKPartitionCreate_SZL( void*   fileHandle, int32_t zone, int32_t ___2977, int64_t imin, int64_t jmin, int64_t kmin, int64_t imax, int64_t jmax, int64_t kmax) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZonePtr(&outputInfo, &zonePtr, fileHandle, zone, "tecIJKPartitionCreate")) return -1; if (___2977 < 1) { ___3185("tecIJKPartitionCreate : invalid partition input parameter (%d).\n", ___2977); ++outputInfo->m_numErrs; return -1; } if (!supportedOrderedVolumeZoneType(zonePtr->___2684, zonePtr->___2682)) { ___3184("tecIJKPartitionCreate: Called for the wrong zone type; can be called only for 3D ordered zones.\n"); ++outputInfo->m_numErrs; return -1; } if (___2977 < 1) { ___3185("tecIJKPartitionCreate: Invalid Partition input parameter (%d).\n", ___2977); ++outputInfo->m_numErrs; return -1; } if (!checkParameter(imin, "imin", 1, zonePtr->___2682.i()) || !checkParameter(jmin, "jmin", 1, zonePtr->___2682.___2105()) || !checkParameter(kmin, "kmin", 1, zonePtr->___2682.___2134()) || !checkParameter(imax, "imax", imin, zonePtr->___2682.i()) || !checkParameter(jmax, "jmax", jmin, zonePtr->___2682.___2105()) || !checkParameter(kmax, "kmax", kmin, zonePtr->___2682.___2134())) { ++outputInfo->m_numErrs; return -1; } try {
 #if defined TECIOMPI
if (zonePtr->m_partitionOwners.empty()) { throw std::logic_error("Must call tecZoneMapPartitionsToMPIRanks prior to calling tecIJKPartitionCreate"); } else if (static_cast<size_t>(___2977) > zonePtr->m_partitionOwners.size()) { std::ostringstream ___2892; ___2892 << "Invalid partition number passed to tecIJKPartitionCreate: " << ___2977; throw std::logic_error(___2892.str().c_str()); }
 #endif 
outputInfo->m_tecioData.addIJKZonePartition(zone, ___2977, imin, jmin, kmin, imax, jmax, kmax); } catch (std::exception const& e) { ___3185("tecZoneMapPartitionsToMPIRanks: %s\n", e.what()); ++outputInfo->m_numErrs; return -1; } return 0; } namespace { bool getOutputInfoAndZoneOrPartitionPtr(OutputInfo** outputInfo, Zone_s** zoneOrPartitionPtr, void* fileHandle, int32_t zone, int32_t ___2977, char const* routineName) { REQUIRE(VALID_REF(outputInfo)); REQUIRE(VALID_REF(zoneOrPartitionPtr)); REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___2977 >= 0); REQUIRE(VALID_REF(routineName)); if (!getOutputInfoAndZonePtr(outputInfo, zoneOrPartitionPtr, fileHandle, zone, routineName)) return false; if (!(*zoneOrPartitionPtr)->m_partitionMap.empty()) { if ((*zoneOrPartitionPtr)->m_partitionMap.find(___2977 - 1) == (*zoneOrPartitionPtr)->m_partitionMap.end()) { ___3186("%s : invalid partition input parameter (%d).\n", routineName, ___2977); ++(*outputInfo)->m_numErrs; return false; } (*zoneOrPartitionPtr) = (*zoneOrPartitionPtr)->m_partitionMap[___2977 - 1].get(); } return true; } template <typename T> int32_t zoneVarWriteValues( void*       fileHandle, int32_t     zone, int32_t     ___4336, int32_t     ___2977, int64_t     count, T const*    values, char const* routineName) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZoneOrPartitionPtr(&outputInfo, &zonePtr, fileHandle, zone, ___2977, routineName)) return -1; if (zonePtr->m_passiveVars[___4336 - 1]) { ___3186("%s : Variable %d is a passive var, so values cannot be written to it.\n", routineName, ___4336); ++outputInfo->m_numErrs; return -1; } else if (zonePtr->m_shareVarFromZone[___4336 - 1]) { ___3187("%s : Variable %d is shared with zone %d, so values cannot be written to it.\n", routineName, ___4336, zone); ++outputInfo->m_numErrs; return -1; } ___1362* ___1351 = zonePtr->___2496[___4336 - 1].get(); if (outputInfo->m_debugLevel && (count > 1)) ___3187("Writing %" PRId64 " values to zone %d, var %d.\n", count, zone, ___4336); if (___1351->storedValueCount() == 0) ___1351->reserveValues(___1351->___2668); for (int64_t i = 0; i < count; ++i) { if (___1351->___2668 == ___1351->storedValueCount()) { int64_t extraValues = count - i; if (___2977 == 0) PRINT4("%s: Too many values supplied for zone %d var %d (%" PRId64 " extra values).\n", routineName, zone, ___4336, extraValues); else PRINT5("%s: Too many values supplied for zone %d var %d partition %d (%" PRId64 " extra values).\n", routineName, zone, ___4336, ___2977, extraValues); ++outputInfo->m_numErrs; return -1; } ___1351->appendValue(static_cast<double>(values[i])); if (zonePtr->___2684 == ___4704 && ___1351->___2669 == ___4328) { if (___1351->storedValueCount() % zonePtr->___2682.i() == static_cast<size_t>(zonePtr->___2682.i() - 1)) ___1351->appendValue(___1362::GHOST_VALUE); if (___1351->storedValueCount() % (zonePtr->___2682.i() * zonePtr->___2682.___2105()) == static_cast<size_t>(zonePtr->___2682.i() * (zonePtr->___2682.___2105() - 1))) for(___2227 ___1841 = 0; ___1841 < static_cast<___2227>(zonePtr->___2682.i()); ++___1841) ___1351->appendValue(___1362::GHOST_VALUE); } } return 0; } } int32_t tecZoneVarWriteDoubleValues_SZL( void*         fileHandle, int32_t       zone, int32_t       ___4336, int32_t       ___2977, int64_t       count, double const* values) { return zoneVarWriteValues( fileHandle, zone, ___4336, ___2977, count, values, "tecZoneVarWriteDoubleValues"); } int32_t tecZoneVarWriteFloatValues_SZL( void*         fileHandle, int32_t       zone, int32_t       ___4336, int32_t       ___2977, int64_t       count, float const*  values) { return zoneVarWriteValues( fileHandle, zone, ___4336, ___2977, count, values, "tecZoneVarWriteFloatValues"); } int32_t tecZoneVarWriteInt32Values_SZL( void*          fileHandle, int32_t        zone, int32_t        ___4336, int32_t        ___2977, int64_t        count, int32_t const* values) { return zoneVarWriteValues( fileHandle, zone, ___4336, ___2977, count, values, "tecZoneVarWriteInt32Values"); } int32_t tecZoneVarWriteInt16Values_SZL( void*          fileHandle, int32_t        zone, int32_t        ___4336, int32_t        ___2977, int64_t        count, int16_t const* values) { return zoneVarWriteValues( fileHandle, zone, ___4336, ___2977, count, values, "tecZoneVarWriteInt16Values"); } int32_t tecZoneVarWriteUInt8Values_SZL( void*          fileHandle, int32_t        zone, int32_t        ___4336, int32_t        ___2977, int64_t        count, uint8_t const* values) { return zoneVarWriteValues( fileHandle, zone, ___4336, ___2977, count, values, "tecZoneVarWriteUInt8Values"); } namespace { template <typename T> int32_t zoneNodeMapWrite( void*       fileHandle, int32_t     zone, int32_t     ___2977, int32_t     nodesAreOneBased, int64_t     count, T const*    nodes, char const* routineName) { OutputInfo* outputInfo; Zone_s* zonePtr; if (!getOutputInfoAndZoneOrPartitionPtr(&outputInfo, &zonePtr, fileHandle, zone, ___2977, routineName))
return -1; if (count + zonePtr->___2497->storedValueCount() > zonePtr->___2497->___2500 * zonePtr->___2497->___2392) { ___3187("%s : Too many node map values for this zone. %" PRIu64 " supplied, need only %" PRIu64 ".\n", routineName, count, zonePtr->___2497->___2500 * zonePtr->___2497->___2392 - zonePtr->___2497->storedValueCount()); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel && (count > 1)) ___3186("Writing %" PRId64 " nodes to zone %d.\n", count, zone); for (int64_t i = 0; i < count; ++i) { T ___2709 = nodes[i]; if (nodesAreOneBased) --___2709; if (___2709 < 0 || zonePtr->___2682.i() <= (___81)___2709) { T maxValue = static_cast<T>(zonePtr->___2682.i()); if (!nodesAreOneBased) --maxValue; std::ostringstream ___2892; ___2892 << routineName << " : Invalid node map value at position " << i << std::endl << "     node map value = " << nodes[i] << ", max value = " << maxValue << "." << std::endl; ___3185("%s", ___2892.str().c_str()); ++outputInfo->m_numErrs; return -1; } zonePtr->___2497->appendValue(___2709); } return 0; } } int32_t tecZoneNodeMapWrite32_SZL( void*          fileHandle, int32_t        zone, int32_t        ___2977, int32_t        nodesAreOneBased, int64_t        count, int32_t const* nodes) { return zoneNodeMapWrite(fileHandle, zone, ___2977, nodesAreOneBased, count, nodes, "tecZoneNodeMapWrite32"); } int32_t tecZoneNodeMapWrite64_SZL( void*          fileHandle, int32_t        zone, int32_t        ___2977, int32_t        nodesAreOneBased, int64_t        count, int64_t const* nodes) { return zoneNodeMapWrite(fileHandle, zone, ___2977, nodesAreOneBased, count, nodes, "tecZoneNodeMapWrite64"); } namespace { template <typename T> int32_t zoneFaceNbrWriteConnections( void*       fileHandle, int32_t     zone, T const*    faceNeighbors, char const* routineName) { OutputInfo* outputInfo = (OutputInfo*)fileHandle; Zone_s* zonePtr = outputInfo->m_tecioData.zonePtr(zone); if (!getOutputInfoAndZonePtr(&outputInfo, &zonePtr, fileHandle, zone, routineName)) return -1; if (outputInfo->m_debugLevel) ___3185("\nInserting face neighbor data for zone %d\n", zone); try { if (outputInfo->m_debugLevel) ___3185("\nInserting face neighbor data for zone %d\n", zone); outputInfo->m_tecioData.___431(zonePtr, faceNeighbors); } catch (std::exception const& e) { ___3186("%s: %s\n", routineName, e.what()); ++outputInfo->m_numErrs; return -1; } return 0; } } int32_t tecZoneFaceNbrWriteConnections32_SZL( void*          fileHandle, int32_t        zone, int32_t const* faceNeighbors) { return zoneFaceNbrWriteConnections(fileHandle, zone, faceNeighbors, "tecZoneFaceNbrWriteConnections32"); } int32_t tecZoneFaceNbrWriteConnections64_SZL( void*          fileHandle, int32_t        zone, int64_t const* faceNeighbors) { return zoneFaceNbrWriteConnections(fileHandle, zone, faceNeighbors, "tecZoneFaceNbrWriteConnections64"); } int32_t tecZoneWritePolyFaces32_SZL( void*           , int32_t         , int32_t         , int32_t         , int32_t const*  , int32_t const*  , int32_t const*  , int32_t const*  , int32_t         ) { return 0; } int32_t tecZoneWritePolyFaces64_SZL( void*           , int32_t         , int32_t         , int64_t         , int32_t const*  , int64_t const*  , int64_t const*  , int64_t const*  , int32_t         ) { return 0; } int32_t tecZoneWritePolyBoundaryConnections32_SZL( void*           , int32_t         , int32_t         , int32_t         , int32_t const*  , int32_t const*  , int32_t const*  , int32_t         ) { return 0; } int32_t tecZoneWritePolyBoundaryConnections64_SZL( void*           , int32_t         , int32_t         , int64_t         , int32_t const*  , int64_t const*  , int32_t const*  , int32_t         ) { return 0; } namespace { bool auxDataIsValidNameChar(char c, bool isLeadChar) { REQUIRE(0 <= c && "c <= 127"); bool isValidNameChar = (c == '_' || tecplot::___1998(c)); if (!isLeadChar) isValidNameChar = (isValidNameChar || c == '.' || tecplot::___2012(c)); return isValidNameChar; } bool auxDataIsValidName(char const* ___2685) { REQUIRE(VALID_REF(___2685)); bool isValidName = auxDataIsValidNameChar(*___2685, true); for (char const* nPtr = ___2685; isValidName && *nPtr != '\0'; ++nPtr) isValidName = auxDataIsValidNameChar(*nPtr, false); return isValidName; } bool checkAuxNameAndValue(OutputInfo* outputInfo, char const* ___2685, char const* ___4314, char const* routineName) { if ((___2685 == NULL) || !auxDataIsValidName(___2685)) { ___3185("%s: Invalid Name string\n", routineName); ++outputInfo->m_numErrs; return false; } if ((___4314 == NULL) || (*___4314 == '\0')) { ___3185("%s: Invalid Value string\n", routineName); ++outputInfo->m_numErrs; return false; } return true; } } int32_t tecDataSetAddAuxData_SZL( void*       fileHandle, char const* ___2685, char const* ___4314) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecDataSetAddAuxData")) return -1; if (outputInfo->m_debugLevel) ___3186("\nInserting data set aux data: '%s' = '%s'\n", ___2685, ___4314);
if (!checkAuxNameAndValue(outputInfo, ___2685, ___4314, "TECAUXSTR")) return (-1); outputInfo->m_tecioData.___8(___2685, ___4314); return 0; } int32_t tecVarAddAuxData_SZL( void*       fileHandle, int32_t     ___4336, char const* ___2685, char const* ___4314) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecVarAddAuxData")) return -1; if (outputInfo->m_debugLevel) ___3186("\nInserting variable aux data: '%s' = '%s'\n", ___2685, ___4314); if (!checkAuxNameAndValue(outputInfo, ___2685, ___4314, "tecVarAddAuxData")) return (-1); outputInfo->m_tecioData.___18(___4336, ___2685, ___4314); return 0; } int32_t tecZoneAddAuxData_SZL( void*       fileHandle, int32_t     zone, char const* ___2685, char const* ___4314) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecZoneAddAuxData")) return -1; if (outputInfo->m_debugLevel) ___3186("\nInserting zone aux data: '%s' = '%s'\n", ___2685, ___4314); if (!checkAuxNameAndValue(outputInfo, ___2685, ___4314, "tecZoneAddAuxData")) return (-1); outputInfo->m_tecioData.___20(zone, ___2685, ___4314); return 0; } namespace { char const* geomTypeStrings[] = { "2D Line", "Rectangle", "Square", "Circle", "Ellipse", "3D Line" }; } int32_t tecGeom2DLineSegmentsBegin_SZL( void*         fileHandle, double        xOrigin, double        yOrigin, int32_t       numPoints, double const* relativeX, double const* relativeY, int32_t       ___3159) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeom2DLineSegmentsBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeom2DLineSegmentsBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (numPoints < 2) { ___3185("tecGeom2DLineSegmentsBegin: numPoints = %d. numPoints must be >= 2.\n", numPoints); ++outputInfo->m_numErrs; return -1; } if (___3159 != 0 && ___3159 != 1) { ___3185("tecGeom2DLineSegmentsBegin: posCoordMode = %d. posCoordMode must be 0 or 1.\n", numPoints); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting line segment Geometry\n"); try { outputInfo->m_geom.___2617[0] = xOrigin; outputInfo->m_geom.___2617[1] = yOrigin; outputInfo->m_geom.___2464.resize(1); outputInfo->m_geom.___2464[0].reserve(numPoints); for (int i = 0; i < numPoints; ++i) { outputInfo->m_geom.___2464[0].push_back(___4580(relativeX[i], relativeY[i], 0.0)); } outputInfo->m_geom.___2466 = GeomType_LineSegs; outputInfo->m_geom.___2616 = (CoordSys_e)___3159; } catch (std::bad_alloc const&) { ___3184("tecGeom2DLineSegmentsBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeom2DMultiLineSegmentsBegin_SZL( void*          fileHandle, double         xOrigin, double         yOrigin, int32_t        ___2835, int32_t const* numSegmentPoints, double const*  relativeX, double const*  relativeY, int32_t        ___3159) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeom2DMultiLineSegmentsBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeom2DMultiLineSegmentsBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (___2835 <= 0) { ___3185("tecGeom2DMultiLineSegmentsBegin: numSegments = %d. numSegments must be > 0.\n", ___2835); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting multi-line segment Geometry\n"); try { outputInfo->m_geom.___2617[0] = xOrigin; outputInfo->m_geom.___2617[1] = yOrigin; outputInfo->m_geom.___2464.resize(___2835); int pos = 0; for (int i = 0; i < ___2835; ++i) { if (numSegmentPoints[i] < 2) { ___3186("tecGeom2DMultiLineSegmentsBegin: numSegmentsPoints[%d] = %d. Each entry of numSegmentPoints must be >= 2.\n", i, numSegmentPoints[i]); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2464[i].reserve(numSegmentPoints[i]); for (int ___2105 = 0; ___2105 < numSegmentPoints[i]; ++___2105) { outputInfo->m_geom.___2464[i].push_back(___4580(relativeX[pos], relativeY[pos], 0.0)); ++pos; } } outputInfo->m_geom.___2466 = GeomType_LineSegs; outputInfo->m_geom.___2616 = (CoordSys_e)___3159; } catch (std::bad_alloc const&) { ___3184("tecGeom2DMultiLineSegmentsBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeom3DLineSegmentsBegin_SZL( void* fileHandle, double xOrigin, double yOrigin, double zOrigin, int32_t numPoints, double const* relativeX, double const* relativeY, double const* relativeZ) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeom3DLineSegmentsBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeom3DLineSegmentsBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n");
++outputInfo->m_numErrs; return -1; } if (numPoints < 2) { ___3185("tecGeom3DLineSegmentsBegin: numPoints = %d. numPoints must be >= 2.\n", numPoints); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting 3D line segment Geometry\n"); try { outputInfo->m_geom.___2617[0] = xOrigin; outputInfo->m_geom.___2617[1] = yOrigin; outputInfo->m_geom.___2617[2] = zOrigin; outputInfo->m_geom.___2464.resize(1); outputInfo->m_geom.___2464[0].reserve(numPoints); for (int i = 0; i < numPoints; ++i) { outputInfo->m_geom.___2464[0].push_back(___4580(relativeX[i], relativeY[i], relativeZ[i])); } outputInfo->m_geom.___2466 = GeomType_LineSegs3D; outputInfo->m_geom.___2616 = CoordSys_Grid3D; } catch (std::bad_alloc const&) { ___3184("tecGeom3DLineSegmentsBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeom3DMultiLineSegmentsBegin_SZL( void*          fileHandle, double         xOrigin, double         yOrigin, double         zOrigin, int32_t        ___2835, int32_t const* numSegmentPoints, double const*  relativeX, double const*  relativeY, double const*  relativeZ) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeom3DMultiLineSegmentsBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeom3DMultiLineSegmentsBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (___2835 <= 0) { ___3185("tecGeom3DMultiLineSegmentsBegin: numSegments = %d. numSegments must be > 0.\n", ___2835); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting 3D multi-line segment Geometry\n"); try { outputInfo->m_geom.___2617[0] = xOrigin; outputInfo->m_geom.___2617[1] = yOrigin; outputInfo->m_geom.___2617[2] = zOrigin; outputInfo->m_geom.___2464.resize(___2835); int pos = 0; for (int i = 0; i < ___2835; ++i) { if (numSegmentPoints[i] < 2) { ___3186("tecGeom3DMultiLineSegmentsBegin: numSegmentsPoints[%d] = %d. Each entry of numSegmentPoints must be >= 2.\n", i, numSegmentPoints[i]); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2464[i].reserve(numSegmentPoints[i]); for (int ___2105 = 0; ___2105 < numSegmentPoints[i]; ++___2105) { outputInfo->m_geom.___2464[i].push_back(___4580(relativeX[pos], relativeY[pos], relativeZ[pos])); ++pos; } } outputInfo->m_geom.___2466 = GeomType_LineSegs3D; outputInfo->m_geom.___2616 = CoordSys_Grid3D; } catch (std::bad_alloc const&) { ___3184("tecGeom3DMultiLineSegmentsBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeomCircleBegin_SZL( void*   fileHandle, double  xCenter, double  yCenter, double  radius, int32_t ___3159) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomCircleBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeomCircleBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting circle Geometry\n"); outputInfo->m_geom.___2617[0] = xCenter; outputInfo->m_geom.___2617[1] = yCenter; outputInfo->m_geom.___2466 = GeomType_Circle; outputInfo->m_geom.___2616 = (CoordSys_e)___3159; try { outputInfo->m_geom.___2464.resize(1); outputInfo->m_geom.___2464[0].push_back(___4580(radius, 0.0, 0.0)); } catch (std::bad_alloc const&) { ___3184("tecGeomCircleBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeomEllipseBegin_SZL( void*   fileHandle, double  xCenter, double  yCenter, double  ___4458, double  ___1826, int32_t ___3159) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomEllipseBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeomEllipseBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting ellipse Geometry\n"); outputInfo->m_geom.___2617[0] = xCenter; outputInfo->m_geom.___2617[1] = yCenter; outputInfo->m_geom.___2466 = GeomType_Ellipse; outputInfo->m_geom.___2616 = (CoordSys_e)___3159; try { outputInfo->m_geom.___2464.resize(1); outputInfo->m_geom.___2464[0].push_back(___4580(___4458, ___1826, 0.0)); } catch (std::bad_alloc const&) { ___3184("tecGeomEllipseBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeomRectangleBegin_SZL( void*   fileHandle, double  xMin, double  yMin, double  xMax, double  yMax, int32_t ___3159) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomRectangleBegin"))
return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeomRectangleBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting rectangle Geometry\n"); outputInfo->m_geom.___2617[0] = xMin; outputInfo->m_geom.___2617[1] = yMin; outputInfo->m_geom.___2466 = GeomType_Rectangle; outputInfo->m_geom.___2616 = (CoordSys_e)___3159; try { outputInfo->m_geom.___2464.resize(1); outputInfo->m_geom.___2464[0].push_back(___4580(xMax - xMin, yMax - yMin, 0.0)); } catch (std::bad_alloc const&) { ___3184("tecGeomRectangleBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeomSquareBegin_SZL( void*   fileHandle, double  xMin, double  yMin, double  size, int32_t ___3159) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomSquareBegin")) return -1; if (outputInfo->m_geom.___2067()) { ___3184("tecGeomSquareBegin: You must end the current geometry by calling tecGeomEnd before beginning a new geometry.\n"); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_debugLevel) ___3184("\nInserting square Geometry\n"); outputInfo->m_geom.___2617[0] = xMin; outputInfo->m_geom.___2617[1] = yMin; outputInfo->m_geom.___2466 = GeomType_Square; outputInfo->m_geom.___2616 = (CoordSys_e)___3159; try { outputInfo->m_geom.___2464.resize(1); outputInfo->m_geom.___2464[0].push_back(___4580(size, 0.0, 0.0)); } catch (std::bad_alloc const&) { ___3184("tecGeomSquareBegin : Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecGeomArrowheadSetInfo_SZL( void*   fileHandle, double  ___56, int32_t attachment, double  size, int32_t style) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomArrowheadSetInfo")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomArrowheadSetInfo: You must begin a geometry by calling tecGeom2DLineSegmentsBegin\n" "or tecGeom3DLineSegmentsBegin before calling tecGeomArrowheadSetInfo.\n"); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_geom.___2466 != GeomType_LineSegs && outputInfo->m_geom.___2466 != GeomType_LineSegs3D) { ___3185("tecGeomArrowheadSetInfo: Warning: Arrowhead info affects only line segment geometries.\n" " The current grometry type is %s. Continuing...\n", geomTypeStrings[outputInfo->m_geom.___2466]); } if (___56 <= 0.0) { ___3185("tecGeomArrowheadSetInfo: angle = %g. angle must be > 0.\n", ___56); ++outputInfo->m_numErrs; return -1; } if (attachment < 0 || 3 < attachment) { ___3185("tecGeomArrowheadSetInfo: attachment = %d. Must be 0 <= attachment <= 3.\n", attachment); ++outputInfo->m_numErrs; return -1; } if (size < 0.0) { ___3185("tecGeomArrowheadSetInfo: size = %g. size must be >= 0.\n", size); ++outputInfo->m_numErrs; return -1; } if (style < 0 || 2 < style) { ___3185("tecGeomArrowheadSetInfo: style = %d. Must be 0 <= style <= 2.\n", style); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2340      = ___56; outputInfo->m_geom.___2341 = (ArrowheadAttachment_e)attachment; outputInfo->m_geom.___2342       = size; outputInfo->m_geom.___2343      = (ArrowheadStyle_e)style; return 0; } int32_t tecGeomEllipseSetNumPoints_SZL( void*   fileHandle, int32_t numEllipsePoints) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomEllipseSetNumPoints")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomSetNumEllipsePoints: You must begin a geometry before calling tecGeomEllipseSetNumPoints.\n"); ++outputInfo->m_numErrs; return -1; } if (numEllipsePoints < 3 || 720 < numEllipsePoints) { ___3185("tecGeomEllipseSetNumPoints: numEllipsePoints = %d. Must be 3 <= numEllipsePoints <= 720.\n", numEllipsePoints); ++outputInfo->m_numErrs; return -1; } if (outputInfo->m_geom.___2466 != GeomType_Circle && outputInfo->m_geom.___2466 != GeomType_Ellipse) { ___3185("tecGeomEllipseSetNumPoints: Warning: numEllipsePts affects only circle and ellipse geometries.\n" "The current geometry's type is %s. Continuing...\n", geomTypeStrings[outputInfo->m_geom.___2466]); } outputInfo->m_geom.___2502 = static_cast<uint16_t>(numEllipsePoints); return 0; } int32_t tecGeomSetClipping_SZL( void*   fileHandle, int32_t ___495) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomSetClipping")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomSetClipping: You must begin a geometry before calling tecGeomSetClipping.\n"); ++outputInfo->m_numErrs; return -1; } if (___495 != 0 && ___495 != 1) { ___3185("tecGeomSetClipping: clipping = %d. clipping must = 0 or 1.\n", ___495); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2394 = static_cast<Clipping_e>(___495); return 0; } int32_t tecGeomSetLineInfo_SZL(
void*   fileHandle, int32_t ___2263, double  ___2986, double  thickness, int32_t color) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomSetLineInfo")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomSetLineInfo: You must begin a geometry before calling tecGeomSetLineInfo.\n"); ++outputInfo->m_numErrs; return -1; } if (___2263 < 0 || 5 < ___2263) { ___3185("tecGeomSetLineInfo: ___2263 = %d. Must be 0 <= ___2263 <= 5.\n", ___2263); ++outputInfo->m_numErrs; return -1; } if (___2986 < .0001 || 100.0 < ___2986) { ___3185("tecGeomSetLineInfo: ___2986 = %g. Must be 0.0001 <= ___2986 <= 100.\n", ___2986); ++outputInfo->m_numErrs; return -1; } if (thickness < .01 || 100.0 < thickness) { ___3185("tecGeomSetLineInfo: thickness = %g. Must be 0.01 <= thickness <= 100.\n", thickness); ++outputInfo->m_numErrs; return -1; } if (color < 0 || 15 < color) { ___3185("tecGeomSetLineInfo: color = %d. Must be 0 <= color <= 15.\n", color); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2489 = (LinePattern_e)___2263; outputInfo->m_geom.___2615 = ___2986; outputInfo->m_geom.___2490 = thickness; outputInfo->m_geom.___2395 = color; return 0; } int32_t tecGeomSetMacroFunctionCmd_SZL( void*       fileHandle, char const* macroFunctionCmd) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomSetMacroFunctionCmd")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomSetMacroFunctionCmd: You must begin a geometry before calling tecGeomSetMacroFunctionCmd.\n"); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2491 = macroFunctionCmd; return 0; } int32_t tecGeomSetScope_SZL( void*   fileHandle, int32_t ___3442) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomSetScope")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomSetScope: You must begin a geometry before calling tecGeomSetScope.\n"); ++outputInfo->m_numErrs; return -1; } if (___3442 != 0 && ___3442 != 1) { ___3185("tecGeomSetScope: ___3442 = %d. Must be 0 or 1.\n", ___3442); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2619 = (Scope_e)___3442; return 0; } int32_t tecGeomAttachToZone_SZL( void*   fileHandle, int32_t zone) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomAttachToZone")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomAttachToZone: You must begin a geometry before calling tecGeomAttachToZone.\n"); ++outputInfo->m_numErrs; return -1; } if (zone <= 0) { ___3185("tecGeomAttachToZone: zone = %d. Must be > 0.\n", zone); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2484 = ___4226; outputInfo->m_geom.___2677 = zone; return 0; } int32_t tecGeomFill_SZL( void*   fileHandle, int32_t ___1411) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomFill")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomFill: You must begin a geometry before calling tecGeomFill.\n"); ++outputInfo->m_numErrs; return -1; } if (___1411 < 0 || 15 < ___1411) { ___3185("tecGeomFill: ___1411 = %d. Must be 0 <= ___1411 <= 15.\n", ___1411); ++outputInfo->m_numErrs; return -1; } outputInfo->m_geom.___2486 = ___4226; outputInfo->m_geom.___2462 = ___1411; return 0; } int32_t tecGeomEnd_SZL(void* fileHandle) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecGeomEnd")) return -1; if (!outputInfo->m_geom.___2067()) { ___3184("tecGeomEnd: You must begin a geometry before calling tecGeomEnd.\n"); ++outputInfo->m_numErrs; return -1; } try { outputInfo->m_tecioData.___9(outputInfo->m_geom); outputInfo->m_geom = ___1556::invalidGeom(); return 0; } catch (std::bad_alloc const&) { ___3184("tecGeomEnd: Out of memory.\n"); outputInfo->m_geom = ___1556::invalidGeom(); ++outputInfo->m_numErrs; return -1; } } int32_t tecCustomLabelsAddSet_SZL( void*       fileHandle, char const* ___2173) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecCustomLabelsAddSet")) return -1; if (outputInfo->m_debugLevel) ___3184("\nInserting Custom Labels:\n"); std::string inputString(___2173); boost::escaped_list_separator<char> ___3475("\\", ", \t", "\""); boost::tokenizer<boost::escaped_list_separator<char> > labelTokenizer(inputString, ___3475); std::vector<std::string> ___2171; BOOST_FOREACH(std::string label, labelTokenizer) { if (!label.empty()) { boost::trim(label); ___2171.push_back(label); if (outputInfo->m_debugLevel) ___3185("          %s\n", label.c_str()); } } outputInfo->m_tecioData.___6(___2171); return 0; } namespace { bool validateTextHeightAndUnits(OutputInfo* outputInfo, double ___1826, int32_t sizeUnits, char const* routineName) { if (sizeUnits < 0 || 2 < sizeUnits) { ___3186("%s: sizeUnits = %d. Must be 0 <= sizeUnits <= 2.\n", routineName, sizeUnits); ++outputInfo->m_numErrs; return false; } if (sizeUnits == 1)
{ if (___1826 < 0.0 || 100.0 < ___1826) { ___3186("%s: height = %g. Must 0 <= height <= 100 when sizeUnits = 1 (Frame coordinates).\n", routineName, ___1826); ++outputInfo->m_numErrs; return false; } } else if (___1826 < 0.0) { ___3186("%s: height = %g. height must >= 0.\n", routineName, ___1826); ++outputInfo->m_numErrs; return false; } return true; } } int32_t tecText2DBegin_SZL( void*       fileHandle, char const* string, double      x, double      ___4583, int32_t     ___3159, double      ___1826, int32_t     sizeUnits) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecText2DBegin")) return -1; if (outputInfo->m_text.___2067()) { ___3184("tecText2DBegin: You must end the current text by calling tecTextEnd before beginning a new text.\n"); ++outputInfo->m_numErrs; return -1; } if (!VALID_REF(string)) { ___3184("tecText2DBegin: Invalid string input parameter.\n"); ++outputInfo->m_numErrs; return -1; } if (___3159 != 0 && ___3159 != 1) { ___3185("tecText2DBegin: posCoordMode = %d. posCoordMode must be zero or 1.\n", ___3159); ++outputInfo->m_numErrs; return -1; } if (!validateTextHeightAndUnits(outputInfo, ___1826, sizeUnits, "tecText2DBegin")) return -1; if (outputInfo->m_debugLevel) ___3185("\nInserting Text: %s\n", string); try { outputInfo->m_text.___2643 = string; outputInfo->m_text.___2626[0] = x; outputInfo->m_text.___2626[1] = ___4583; outputInfo->m_text.___2639 = (CoordSys_e)___3159; outputInfo->m_text.___2635 = ___1826; outputInfo->m_text.___2642 = (Units_e)sizeUnits; } catch (std::bad_alloc const&) { ___3184("tecText2DBegin: Out of memory.\n"); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecText3DBegin_SZL( void*       fileHandle, char const* string, double      x, double      ___4583, double      z, double      ___1826, int32_t     sizeUnits) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecText3DBegin")) return -1; if (outputInfo->m_text.___2067()) { ___3184("tecText3DBegin: You must end the current text by calling tecTextEnd before beginning a new text.\n"); ++outputInfo->m_numErrs; return -1; } if (!VALID_REF(string)) { ___3184("tecText3DBegin: Invalid string input parameter.\n"); ++outputInfo->m_numErrs; return -1; } if (!validateTextHeightAndUnits(outputInfo, ___1826, sizeUnits, "tecText3DBegin")) return -1; if (outputInfo->m_debugLevel) ___3185("\nInserting 3D Text: %s\n", string); try { outputInfo->m_text.___2643 = string; outputInfo->m_text.___2626[0] = x; outputInfo->m_text.___2626[1] = ___4583; outputInfo->m_text.___2626[1] = z; outputInfo->m_text.___2639 = CoordSys_Grid3D; outputInfo->m_text.___2635 = ___1826; outputInfo->m_text.___2642 = (Units_e)sizeUnits; } catch (std::bad_alloc const&) { ___3184("tecText2DBegin: Out of memory.\n"); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecTextAttachToZone_SZL(void* fileHandle, int32_t zone) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextAttachToZone")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextAttachToZone: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextAttachToZone.\n"); ++outputInfo->m_numErrs; return -1; } if (zone <= 0) { ___3185("tecTextAttachToZone: zone = %d. zone must be > 0.\n", zone); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2647 = zone; return 0; } int32_t tecTextBoxSetInfo_SZL( void*   fileHandle, int32_t ___410, int32_t lineColor, int32_t ___1411, double  ___2289, double  margin) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextBoxSetInfo")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextBoxSetInfo: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextBoxSetInfo.\n"); ++outputInfo->m_numErrs; return -1; } if (___410 < 0 || 2 < ___410) { ___3185("tecTextBoxSetInfo: boxType = %d. Must be 0 <= boxType <= 2.\n", ___410); ++outputInfo->m_numErrs; return -1; } if (lineColor < 0 || 15 < lineColor) { ___3185("tecTextBoxSetInfo: lineColor = %d. Must be 0 <= lineColor <= 15.\n", lineColor); ++outputInfo->m_numErrs; return -1; } if (___1411 < 0 || 15 < ___1411) { ___3185("tecTextBoxSetInfo: fillColor = %d. Must be 0 <= fillColor <= 15.\n", ___1411); ++outputInfo->m_numErrs; return -1; } if (___2289 < .0001 || 100.0 < ___2289) { ___3185("tecTextBoxSetInfo: lineThickness = %g. Must be 0.0001 <= lineThickness <= 100.\n", ___2289); ++outputInfo->m_numErrs; return -1; } if (margin < 0.0 || 100.0 < margin) { ___3185("tecTextBoxSetInfo: margin = %g. Must be 0 <= margin <= 100.\n", margin); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2632 = (TextBox_e)___410; outputInfo->m_text.___2628 = lineColor; outputInfo->m_text.___2629 = ___1411; outputInfo->m_text.___2630 = ___2289; outputInfo->m_text.___2631 = margin;
return 0; } int32_t tecTextSetAnchor_SZL( void*   fileHandle, int32_t ___38) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetAnchor")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetAnchor: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetAnchor.\n"); ++outputInfo->m_numErrs; return -1; } if (___38 < 0 || 8 < ___38) { ___3185("tecTextSetAnchor: anchor = %d. Must be 0 <= anchor <= 8.\n", ___38); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2625 = (TextAnchor_e)___38; return 0; } int32_t tecTextSetAngle_SZL( void*  fileHandle, double ___56) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetAngle")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetAngle: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetAngle.\n"); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2627 = ___56; return 0; } int32_t tecTextSetClipping_SZL( void*   fileHandle, int32_t ___495) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetClipping")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetClipping: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetClipping.\n"); ++outputInfo->m_numErrs; return -1; } if (___495 != 0 && ___495 != 1) { ___3185("tecTextSetClipping: clipping = %d. Must be 0 or 1.\n", ___495); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2633 = (Clipping_e)___495; return 0; } int32_t tecTextSetColor_SZL( void*   fileHandle, int32_t color) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetColor")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetColor: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetColor.\n"); ++outputInfo->m_numErrs; return -1; } if (color < 0 || 15 < color) { ___3185("tecTextSetColor: color = %d. Must be 0 <= color <= 15.\n", color); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2634 = color; return 0; } int32_t tecTextSetTypeface_SZL( void*       fileHandle, char const* family, int32_t     isBold, int32_t     isItalic) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetTypeface")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetTypeface: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetTypeface.\n"); ++outputInfo->m_numErrs; return -1; } if (!VALID_REF(family)) { ___3184("tecTextSetTypeface: Invalid family input parameter.\n"); ++outputInfo->m_numErrs; return -1; } try { outputInfo->m_text.___2644 = family; if (isBold) outputInfo->m_text.___2645 = true; else outputInfo->m_text.___2645 = false; if (isItalic) outputInfo->m_text.___2646 = true; else outputInfo->m_text.___2646 = false; } catch (std::bad_alloc const&) { ___3184("tecTextSetTypeface: Out of memory.\n"); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecTextSetLineSpacing_SZL( void*  fileHandle, double ___2287) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetLineSpacing")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetLineSpacing: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetLineSpacing.\n"); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2637 = ___2287; return 0; } int32_t tecTextSetMacroFunctionCmd_SZL( void*       fileHandle, char const* macroFunctionCmd) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetMacroFunctionCmd")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetMacroFunctionCmd: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetMacroFunctionCmd.\n"); ++outputInfo->m_numErrs; return -1; } try { outputInfo->m_text.___2638 = macroFunctionCmd; } catch (std::bad_alloc const&) { ___3184("tecTextSetMacroFunctionCmd: Out of memory.\n"); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecTextSetScope_SZL( void*   fileHandle, int32_t ___3442) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextSetScope")) return -1; if (!outputInfo->m_text.___2067()) { ___3184("tecTextSetScope: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextSetScope.\n"); ++outputInfo->m_numErrs; return -1; } if (___3442 != 0 && ___3442 != 1) { ___3185("tecTextSetScope: scope = %d. Must be 0 or 1.\n", ___3442); ++outputInfo->m_numErrs; return -1; } outputInfo->m_text.___2641 = (Scope_e)___3442; return 0; } int32_t tecTextEnd_SZL(void* fileHandle) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecTextEnd")) return -1; if (!outputInfo->m_text.___2067())
{ ___3184("tecTextEnd: You must begin a text by calling tecText2DBegin or tecText3DBegin before calling tecTextEnd.\n"); ++outputInfo->m_numErrs; return -1; } try { outputInfo->m_tecioData.___16(outputInfo->m_text); outputInfo->m_text = tecioszl::Text::invalidText(); } catch (std::bad_alloc const&) { ___3184("tecTextEnd: Out of memory.\n"); outputInfo->m_text = tecioszl::Text::invalidText(); ++outputInfo->m_numErrs; return -1; } return 0; } int32_t tecUserRecAdd_SZL( void*       fileHandle, char const*  ) { OutputInfo* outputInfo; if (!getOutputInfo(&outputInfo, fileHandle, "tecUserRecAdd")) return -1; ___3184("tecUserRecAdd: User records not currently supported for subzone-load-on-demand files.\n"); ++outputInfo->m_numErrs; return -1; } int32_t tecFileWriterClose_SZL(void** fileHandle) { OutputInfo* outputInfo; if (!fileHandle || !getOutputInfo(&outputInfo, *fileHandle, "tecFileWriterClose")) return -1; if (static_cast<DataFileType_e>(outputInfo->m_fileType) == END_DataFileType_e) { std::ostringstream ___2892; ___2892 << outputInfo->___2461 << ".test";
 #if defined TECIOMPI
___2892 << outputInfo->m_localProcess;
 #endif
bool const ___4480 =
 #if defined TECIOMPI && defined _DEBUG
true;
 #elif defined WRITEASCII
true;
 #else
false;
 #endif
outputInfo->m_tecioData.writeToFile(___2892.str(), ___4480); delete outputInfo; *fileHandle = NULL; return 0; } int32_t ___3358 = writeFile(outputInfo, "tecFileWriterClose"); if (outputInfo->m_debugLevel) { ___3185("File %s closed.\n", outputInfo->___2461.c_str()); if (outputInfo->m_numErrs) { ___3184("********************************************\n"); ___3185("      %d Errors occurred on this file\n", outputInfo->m_numErrs); ___3184("********************************************\n"); } } delete outputInfo; *fileHandle = NULL; return ___3358; } int32_t  ___4004(int32_t  ___1397) { REQUIRE(0 <= ___1397 && ___1397 < ___2380); return outputInfos[___1397]->m_tecioData.___2846(); } int32_t  ___4003(int32_t  ___1397) { REQUIRE(0 <= ___1397 && ___1397 < ___2380); return outputInfos[___1397]->m_tecioData.___2843(); } namespace { int checkFile( int32_t     ___1397, char const* routineName) { if ((___1397 < 0) || (___1397 >= ___2380)) { ___3187("%s: Attempt to use invalid file %d file must be between 1 and %d inclusive.\n", routineName, ___1397+1, ___2380); return (-1); } if (outputInfos.empty() || !outputInfos[___1397]) { ___3186("%s: Attempt to use file %d that hasn't been initialized with TECINI.\n", routineName, ___1397+1); return (-1); } return (0); } } namespace { int checkData( int32_t     ___1397, char const* routineName) { try { bool checkConnectivity = (outputInfos[___1397]->m_fileType != 2); outputInfos[___1397]->m_tecioData.___4166(checkConnectivity); } catch (std::exception const& e) { ___3186("%s: Wrong number of data values in file %d:\n", routineName, ___1397+1); ___3185("%s\n", e.what()); ++outputInfos[___1397]->m_numErrs; return (-1); } return (0); } } int32_t  ___3999( int32_t          fileNum, char const*      ___4177, char const*      ___4350, char const*      ___1394, char const*      ___3447, int32_t  const*  ___1407, int32_t  const*  ___941, int32_t  const*  ___2013) { outputInfos.resize(___2380); if (*___1407 == 2 && !___1812) { ___3184("TECINI: For SZL files, you must output a grid file (FileType = 1)\nprior to outputting a solution file (FileType = 2).\n"); return -1; } if ((size_t)fileNum < outputInfos.size() && outputInfos[fileNum]) { ___3185("TECINI: Attempting to initialize file %d twice before calling TECEND.\n", fileNum + 1); ++outputInfos[fileNum]->m_numErrs; return -1; } try { outputInfos[fileNum] = boost::make_shared<OutputInfo>( ___4177, ___4350, ___1394, ___3447, *___1407, *___941, (*___2013 ? FieldDataType_Double : FieldDataType_Float), ___1812.get()); if (*___1407 == 1) { ___1812 = outputInfos[fileNum]; } if (outputInfos[fileNum]->m_debugLevel) { ___3186("Dest    File #%d: %s\n", fileNum + 1, outputInfos[fileNum]->___2461.c_str()); ___3185("NumVars=%d\n", outputInfos[fileNum]->m_tecioData.___2843()); }
 #if defined TECIOMPI
outputInfos[fileNum]->m_comm = MPI_COMM_SELF; outputInfos[fileNum]->m_communicator.reset(new MPICommunicator(MPI_COMM_SELF)); outputInfos[fileNum]->___2396.reset(new MPINonBlockingCommunicationCollection(MPI_COMM_SELF)); outputInfos[fileNum]->m_localProcess = 0; outputInfos[fileNum]->m_mainProcess = 0;
 #endif
} catch(std::exception const& e) { ___3185("TECINI: %s\n", e.what()); return -1; } return 0; } int32_t  ___4014( int32_t         ___1397, char const*     ___4691, int32_t  const* ___4693, int32_t  const* ___1910, int32_t  const* ___2117, int32_t  const* ___2162, int32_t  const*  , int32_t  const*  , int32_t  const*  , double const*   ___3641, int32_t  const* ___3786, int32_t  const* ___2975, int32_t  const* ___2006, int32_t  const* ___2803, int32_t  const* ___1285, int32_t  const* ___4193, int32_t  const* ___2787, int32_t  const* ___4189, int32_t  const* ___2983, int32_t  const* ___4327, int32_t  const* ___3552, int32_t  const* ___3550) { if (checkFile(___1397, "TECZNE") < 0 || checkData(___1397, "TECZNE") < 0) return (-1); if (*___2006 != 1) { ___3186("TECZNE: Point data is not currently allowed. " " Please use block format for file %ld, zone %ld.\n", ldfmt_t(___1397+1), ldfmt_t(outputInfos[___1397]->m_tecioData.___2846())); ++outputInfos[___1397]->m_numErrs; return (-1); } try { if (outputInfos[___1397]->m_debugLevel) { ___3185("Writing Zone %d:\n", outputInfos[___1397]->m_tecioData.___2846() + 1); ___3185("      Title = %s\n", ___4691); ___3185("      Type  = %s\n", zoneTypeStrings[*___4693]); ___3185("      IMax  = %d\n", *___1910); ___3185("      JMax  = %d\n", *___2117); ___3185("      KMax  = %d\n", *___2162); if (___3552) { std::ostringstream ___2892; for (int i = 0; i < outputInfos[___1397]->m_tecioData.___2843(); ++i) { if (i > 0) ___2892 <<  ","; ___2892 << ___3552[i]; } ___3185("      DupList = %s\n", ___2892.str().c_str()); } } outputInfos[___1397]->m_tecioData.___19( ___4691, *___4693, *___1910, *___2117, *___2162, *___3641, *___3786, *___2975, *___2803, *___1285, ___4193 ? *___4193 : 0, ___2787 ? *___2787 : 0, ___4189 ? *___4189 : 0, NULL, ___2983, ___4327, ___3552, *___3550); outputInfos[___1397]->m_numValuesWritten = 0; } catch (std::exception const& e) { ___3185("TECZNE: %s\n", e.what()); ++outputInfos[___1397]->m_numErrs; return -1; } return 0; } int32_t  ___3994( int32_t         ___1397, int32_t  const* N, void const*     ___1352, int32_t  const* ___2014) { if (checkFile(___1397, "TECDAT") < 0) return (-1); try { outputInfos[___1397]->m_tecioData.___430((___2227)*N, ___1352, (*___2014 != 0)); if (outputInfos[___1397]->m_debugLevel && (*N > 1)) ___3186("Writing %d values to file %d.\n", *N, ___1397 + 1); if (outputInfos[___1397]->m_debugLevel > 1) { double* dPtr = (double*)___1352; float* fPtr = (float*)___1352; for(int i = 0; i < *N; ++i) { double ___4298 = (*___2014 ? dPtr[i] : fPtr[i]); ___3186("%" PRIu64 " %G\n", ++outputInfos[___1397]->m_numValuesWritten, ___4298); } } } catch (std::exception const& e) { ___3185("TECDAT: %s\n", e.what()); ++outputInfos[___1397]->m_numErrs; return -1; } return 0; } int32_t  ___4001( int32_t         ___1397, int32_t  const* ___2689) { if (checkFile(___1397, "TECNOD") < 0) return (-1); ___4636 curZone = outputInfos[___1397]->m_tecioData.___2846(); Zone_s* zonePtr = outputInfos[___1397]->m_tecioData.zonePtr(curZone); if (!zonePtr->m_partitionMap.empty()) { zonePtr = zonePtr->m_partitionMap.rbegin()->second.get(); } else if (!zonePtr->m_partitionOwners.empty()) { ___3184("TECNOD: Must call TECFEPTN to create a partition before calling TECDAT or TECNOD"); return (-1); } int32_t  N = (int32_t )(zonePtr->___2497->___2392 * zonePtr->___2497->___2500); return ___4002(___1397, &N, ___2689); } int32_t  ___4002( int32_t         ___1397, int32_t  const* N, int32_t  const* ___2689) { if (checkFile(___1397, "TECNODE") < 0) return (-1); try { outputInfos[___1397]->m_tecioData.___432((___2227)*N, ___2689); if (outputInfos[___1397]->m_debugLevel && (*N > 1)) ___3186("Writing %d nodes to file %d.\n", *N, ___1397 + 1); } catch (std::exception const& e) { ___3185("TECNODE: %s\n", e.what()); ++outputInfos[___1397]->m_numErrs; return -1; } return 0; } int32_t  ___3995(int32_t  ___1397) { if (checkFile(___1397, "TECEND") != 0 || checkData(___1397, "TECEND") != 0) return -1; bool const ___4480 =
 #if defined TECIOMPI && defined _DEBUG
true;
 #elif defined WRITEASCII
true;
 #else
false;
 #endif
if (static_cast<DataFileType_e>(outputInfos[___1397]->m_fileType) == END_DataFileType_e) { std::ostringstream ___2892; ___2892 << outputInfos[___1397]->___2461 << ".test";
 #if defined TECIOMPI
___2892 << outputInfos[___1397]->m_localProcess;
 #endif
outputInfos[___1397]->m_tecioData.writeToFile(___2892.str(), ___4480); outputInfos[___1397].reset(); return 0; } ___1388 ___1387( ___4480, static_cast<DataFileType_e>(outputInfos[___1397]->m_fileType), DEFAULT_SUBZONE_MAX_IJK_DIM, DEFAULT_SUBZONE_MAX_FE_SIZE); ___1387.setFileVersion(SZPLT_CUR_WRITE_VERSION); ___1387.setCodeRevision(1); if (___1387.___844() == ___848) {
 #if defined TECIOMPI
___1812->___2396->___4446();
 #endif
try { outputInfos[___1397]->m_tecioData.copyConnectivity(___1812->m_tecioData); } catch (std::exception const& e) { ___3185("TECEND: %s", e.what()); return -1; } } outputInfos[___1397]->m_tecioTecUtil = boost::make_shared<___4016>(boost::ref(outputInfos[___1397]->m_tecioData)); DataWriteStatistics ___935; boost::scoped_ptr<FileWriterInterface> szpltFile;
 #if defined TECIOMPI
szpltFile.reset(new MPIFileWriter(outputInfos[___1397]->___2461.c_str(), outputInfos[___1397]->m_comm));
 #else
szpltFile.reset(new FileStreamWriter(outputInfos[___1397]->___2461.c_str()));
 #endif
if (___1387.___844() == ___848) { if (!___1812 || !___1812->m_dataSetWriter) { ___3184("TECEND: For SZL solution files (FileType = 2), you must output and call TECEND\n"); ___3184("for a grid file (FileType = 1) prior to calling TECEND for the solution file.\n"); return -1; } outputInfos[___1397]->m_dataSetWriter = ___1812->m_dataSetWriter; outputInfos[___1397]->m_dataSetWriter->replaceDataSource(outputInfos[___1397]->m_tecioTecUtil.get(), ___3501(0), ___3501(0)); } else {
 #if defined TECIOMPI
outputInfos[___1397]->m_dataSetWriter = boost::make_shared<DataSetWriterMPI>( outputInfos[___1397]->m_tecioTecUtil.get(), ___3501(0), ___3501(0), ___1387.___1757(), ___1387.___1756(), ___4480, outputInfos[___1397]->m_comm, outputInfos[___1397]->m_mainProcess, outputInfos[___1397]->m_localProcess);
 #else
outputInfos[___1397]->m_dataSetWriter = boost::make_shared<DataSetWriter>( outputInfos[___1397]->m_tecioTecUtil.get(), ___3501(0), ___3501(0), ___1387.___1757(), ___1387.___1756(), ___4480);
 #endif
} int ___3358 = 0; if (!szpltFile->open()) { ___3358 = -1; ++outputInfos[___1397]->m_numErrs; } else { szpltFile->___3494(___4480 ? ___4226 : ___1305); szpltFile->setDataFileType(___1387.___844());
 #if defined TECIOMPI
if (outputInfos[___1397]->m_localProcess != outputInfos[___1397]->m_mainProcess) { ___1392 szpltZoneHeaderFileLocs; if (outputInfos[___1397]->m_tecioTecUtil->___896() && (!szpltZoneHeaderFileLocs.alloc(outputInfos[___1397]->m_tecioTecUtil->___891()) || !outputInfos[___1397]->m_dataSetWriter->writeDataSet(*szpltFile, szpltZoneHeaderFileLocs))) { ___3358 = -1; ++outputInfos[___1397]->m_numErrs; } } else
 #endif
{ if (!___1242( *outputInfos[___1397]->m_tecioTecUtil, *szpltFile, ___1387, includeRevisionNumber(), *outputInfos[___1397]->m_dataSetWriter, ___3501(0), ___3501(0), ___935)) { ___3358 = -1; ++outputInfos[___1397]->m_numErrs; } } } szpltFile->close(___3358 == 0); if (___1387.___844() == ___846) { ___1812 = outputInfos[___1397]; ___1812->m_dataSetWriter->replaceDataSource(NULL, ___3501(0), ___3501(0)); } if (!outputInfos.empty() && outputInfos[___1397]->m_debugLevel) { ___3185("File %d closed.\n", ___1397 + 1); if (outputInfos[___1397]->m_numErrs) { ___3184("********************************************\n"); ___3185("      %d Errors occurred on this file\n", outputInfos[___1397]->m_numErrs); ___3184("********************************************\n"); } } outputInfos[___1397].reset(); return ___3358; } int32_t  ___4000( int32_t     ___1397, char const* S) { if (checkFile(___1397, "TECLAB") < 0) return (-1); return tecCustomLabelsAddSet_SZL(outputInfos[___1397].get(), S); } int32_t  ___4011( int32_t     ___1397, char const*  ) { if (checkFile(___1397, "TECUSR") < 0) return (-1); ___3184("TECUSR: User records not currently supported for subzone-load-on-demand files.\n"); ++outputInfos[___1397]->m_numErrs; return 0; } int32_t  ___3998( int32_t         ___1397, double const*   ___4576, double const*   ___4593, double const*   ___4716, int32_t  const* ___3160, int32_t  const* ___227, int32_t  const* ___4600, int32_t  const* Color, int32_t  const* ___1412, int32_t  const* ___2023, int32_t  const* ___1652, int32_t  const* ___2264, double const*   ___2987, double const*   ___2290, int32_t  const* ___2794, int32_t  const* ___188, int32_t  const* ___176, double const*   ___187, double const*   ___171, int32_t  const* ___3443, int32_t  const* ___496, int32_t  const* ___2836, int32_t  const* ___2838, float const*    ___4570, float const*    ___4588, float const*    ___4597, char const*     mfc) { if (checkFile(___1397, "TECGEO") < 0) return (-1); if (outputInfos[___1397]->m_debugLevel) ___3184("\nInserting Geometry\n"); try { ___2227 const maxLocalBuffLen = 1024; ___2227 localNumSegPts[maxLocalBuffLen]; ___2227 *localNumSegPtsRef = *___2836 < maxLocalBuffLen ? localNumSegPts : new ___2227[*___2836]; for (int32_t sIndex = 0; sIndex < *___2836; ++sIndex) localNumSegPtsRef[sIndex] = ___2838[sIndex]; ___372 const ___2004 = (*___227 == 0 ? ___1305 : ___4226); outputInfos[___1397]->m_tecioData.___9(*___4576, *___4593, *___4716, (CoordSys_e)(*___3160), ___2004, *___4600, (___516)*Color, (___516)*___1412, (___372)*___2023, (GeomForm_e)(*___1652), (LinePattern_e)(*___2264), *___2987, *___2290, (uint16_t)(*___2794), (ArrowheadStyle_e)(*___188), (ArrowheadAttachment_e)(*___176), *___187, *___171, (Scope_e)(*___3443), (Clipping_e)(*___496), *___2836, localNumSegPtsRef, ___4570, ___4588, ___4597, mfc); if (localNumSegPtsRef != localNumSegPts) delete [] localNumSegPtsRef; } catch(...) { ___3184("TECGEO: Out of memory or unknown error\n"); ++outputInfos[___1397]->m_numErrs; return 1; } return 0; } int32_t  ___4010( int32_t         ___1397, double const*   ___4575, double const*   ___4592, double const*   ___4714, int32_t  const* ___3160, int32_t  const* ___227, int32_t  const* ___4600, int32_t  const* ___353, int32_t  const* ___1453, double const*   ___1451, int32_t  const* ___411, double const*   ___409, double const*   ___407, int32_t  const* ___403, int32_t  const* ___405, double const*   ___57, int32_t  const* ___39, double const*   ___2288, int32_t  const* ___4081, int32_t  const* ___3443, int32_t  const* ___496, char const*     ___3813, char const*     mfc) { if (checkFile(___1397, "TECTXT") < 0) return (-1); if (outputInfos[___1397]->m_debugLevel) ___3185("\nInserting Text: %s\n", ___3813); try { ___372 const ___2004 = (*___227 == 0 ? ___1305 : ___4226); outputInfos[___1397]->m_tecioData.___16(*___4575, *___4592, *___4714, (CoordSys_e)*___3160, ___2004, *___4600, (Font_e)*___353, (Units_e)*___1453, *___1451, (TextBox_e)*___411, *___409, *___407, (___516)*___403, (___516)*___405, *___57, (TextAnchor_e)*___39, *___2288, (___516)*___4081, (Scope_e)*___3443, (Clipping_e)*___496, ___3813, mfc); } catch(...) { ___3184("TECTXT: Out of memory or unknown error\n"); ++outputInfos[___1397]->m_numErrs; return 1; } return 0; } void ___3997( int32_t         ___1397, int32_t  const*   ) { if (checkFile(___1397, "TECFOREIGN") < 0) return; ___3184("TECFOREIGN: Foreign byte order not currently supported for subzone-load-on-demand files.\n"); ++outputInfos[___1397]->m_numErrs; } int32_t  ___3993( int32_t     ___1397, char const* ___2686, char const* ___4315)
{ if (checkFile(___1397, "TECAUXSTR") < 0) return (-1); if (outputInfos[___1397]->m_debugLevel) ___3186("\nInserting data set aux data: '%s' = '%s'\n", ___2686, ___4315); if (!checkAuxNameAndValue(outputInfos[___1397].get(), ___2686, ___4315, "TECAUXSTR")) return (-1); outputInfos[___1397]->m_tecioData.___8(___2686, ___4315); return 0; } int32_t  ___4013( int32_t     ___1397, char const* ___2686, char const* ___4315) { if (checkFile(___1397, "TECZAUXSTR") < 0) return (-1); if (outputInfos[___1397]->m_tecioData.___2846() == 0) { ___3184("TECZAUXSTR: Must call TECZNE prior to TECZAUXSTR\n"); ++outputInfos[___1397]->m_numErrs; return (-1); } if (outputInfos[___1397]->m_debugLevel) ___3186("\nInserting zone aux data: '%s' = '%s'\n", ___2686, ___4315); if (!checkAuxNameAndValue(outputInfos[___1397].get(), ___2686, ___4315, "TECZAUXSTR")) return (-1); int ___2846 = outputInfos[___1397]->m_tecioData.___2846(); outputInfos[___1397]->m_tecioData.___20(___2846, ___2686, ___4315); return 0; } int32_t  ___4012( int32_t         ___1397, int32_t  const* ___4337, char const*     ___2686, char const*     ___4315) { if (checkFile(___1397, "TECVAUXSTR") < 0) return (-1); if (outputInfos[___1397]->m_debugLevel) ___3186("\nInserting variable aux data: '%s' = '%s'\n", ___2686, ___4315); if (!checkAuxNameAndValue(outputInfos[___1397].get(), ___2686, ___4315, "TECVAUXSTR")) return (-1); outputInfos[___1397]->m_tecioData.___18(*___4337, ___2686, ___4315); return 0; } int32_t  ___3996( int32_t         ___1397, int32_t  const* ___1258) { if (checkFile(___1397, "TECFACE") < 0) return (-1); if (outputInfos[___1397]->m_debugLevel) ___3184("\nInserting face neighbor data\n"); Zone_s* zonePtr = outputInfos[___1397]->m_tecioData.zonePtr(outputInfos[___1397]->m_tecioData.___2846()); try { outputInfos[___1397]->m_tecioData.___431(zonePtr, ___1258); } catch (std::exception const& e) { ___3185("TECFACE: %s\n", e.what()); ++outputInfos[___1397]->m_numErrs; return -1; } return 0; } int32_t  ___4008(int32_t  ___1397) { ___4278(___1397); return 0; } int32_t  ___4009(int32_t  ___1397) { ___4278(___1397); return 0; } int32_t  ___4005( int32_t         ___1397, int32_t  const* ___1294, int32_t  const* ___1297, int32_t  const* ___1259, int32_t  const* ___1303, int32_t  const* ___1253, int32_t  const* ___1254, int32_t  const* ___1256) { ___4278(___1294); ___4278(___1297); ___4278(___1259); ___4278(___1303); ___4278(___1253); ___4278(___1254); ___4278(___1256); if (checkFile(___1397, "TECPOLY") < 0) return (-1); ___3184("TECPOLY: Polyhedral zones not currently supported for subzone-load-on-demand files.\n"); ++outputInfos[___1397]->m_numErrs; return 0; } int32_t  ___4007( int32_t         ___1397, int32_t  const* ___2806, int32_t  const* ___1294, int32_t  const* ___1297, int32_t  const* ___1259, int32_t  const* ___1303) { ___4278(___2806); ___4278(___1294); ___4278(___1297); ___4278(___1259); ___4278(___1303); if (checkFile(___1397, "TECPOLYFACE") < 0) return (-1); ___3184("TECPOLYFACE: Polyhedral zones not currently supported for subzone-load-on-demand files.\n"); ++outputInfos[___1397]->m_numErrs; return 0; } int32_t  ___4006( int32_t         ___1397, int32_t  const* ___2778, int32_t  const* ___1253, int32_t  const* ___1254, int32_t  const* ___1256) { ___4278(___2778); ___4278(___1253); ___4278(___1254); ___4278(___1256); if (checkFile(___1397, "TECPOLYBCONN") < 0) return (-1); ___478(TecplotSDKBinaryFileVersion == 112); ___3184("TECPOLYBCONN: Polyhedral zones not currently supported for subzone-load-on-demand files.\n"); ++outputInfos[___1397]->m_numErrs; return 0; }
 #if defined TECIOMPI
int32_t  TECIOSZL_MPIINIT( int32_t *       fileNum, void*           communicator, int32_t  const* mainrank) { BOOST_STATIC_ASSERT(sizeof(int) == 4); INVARIANT(mpiSizeof(MPI_INT) == 4); MPI_Comm comm;
 #if defined OPEN_MPI
MPI_Fint fComm = *(static_cast<MPI_Fint*>(communicator)); comm = MPI_Comm_f2c(fComm); if (!comm)
 #endif
comm = *(static_cast<MPI_Comm*>(communicator)); return szlMPIInit(outputInfos[*fileNum].get(), comm, *mainrank); } int32_t  TECIOSZL_ZNEMAP( int32_t         fileNum, int32_t  const* npartitions, int32_t  const* ptnworkers) { if (checkFile(fileNum, "TECZNEMAP") < 0) return (-1); try { std::vector<int> partitionOwners(ptnworkers, ptnworkers + *npartitions); outputInfos[fileNum]->m_tecioData.setPartitionOwners(partitionOwners); if (outputInfos[fileNum]->m_localProcess == outputInfos[fileNum]->m_mainProcess) { int32_t zone = outputInfos[fileNum]->m_tecioData.___2846(); BOOST_FOREACH(int owner, partitionOwners) { if (owner != outputInfos[fileNum]->m_localProcess) outputInfos[fileNum]->___2396->sendScalarCopy(zone, owner, ZONE_NUMBER); } } else { bool keepZone = false; BOOST_FOREACH(int owner, partitionOwners) { if (owner == outputInfos[fileNum]->m_localProcess) { keepZone = true; int32_t zone; outputInfos[fileNum]->m_communicator->receiveScalar(zone, outputInfos[fileNum]->m_mainProcess, ZONE_NUMBER); if (zone > outputInfos[fileNum]->m_tecioData.___2846()) { outputInfos[fileNum]->m_tecioData.renumberLastZone(zone); } } } if (!keepZone) { outputInfos[fileNum]->m_tecioData.dropLastZone(); } } } catch(std::exception const& e) { ___3185("TECZNEMAP: %s\n", e.what()); ++outputInfos[fileNum]->m_numErrs; return (2); } return 0; }
 #endif
int32_t  TECIOSZL_FEPTN( int32_t         fileNum, int32_t  const* ___2977, int32_t  const* numnodes, int32_t  const* numcells, int32_t  const* ngnodes, int32_t  const* gnodes, int32_t  const* gnpartitions, int32_t  const* gnpnodes, int32_t  const* ngcells, int32_t  const* gcells) { if (checkFile(fileNum, "TECFEPTN")) return (-1); if (outputInfos[fileNum]->m_tecioData.___2846() == 0) { ___3184("TECFEPTN: Must call TECZNE prior to calling TECFEPTN.\n"); ++outputInfos[fileNum]->m_numErrs; return 1; } Zone_s* zonePtr = outputInfos[fileNum]->m_tecioData.zonePtr(outputInfos[fileNum]->m_tecioData.___2846()); if (!___3894(zonePtr->___2684)) { ___3184("TECFEPTN: Called for the wrong zone type; can be called only for 3D FE zones.\n"); ++outputInfos[fileNum]->m_numErrs; return 1; } if (!___2977 || *___2977 < 1) { ___3184("TECFEPTN: Invalid Partition input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 2; } if (!numnodes || *numnodes < 1) { ___3184("TECFEPTN: Invalid NumNodes input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 3; } if (!numcells || *numcells < 1) { ___3184("TECFEPTN: Invalid NumCells input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 4; } if (!ngnodes || *ngnodes < 0) { ___3184("TECFEPTN: Invalid NGNodes input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 5; } if (*ngnodes > 0) { if (!gnodes) { ___3184("TECFEPTN: Invalid GNodes input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 6; } else if (!gnpartitions) { ___3184("TECFEPTN: Invalid GNPartitions input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 7; } else if (!gnpnodes) { ___3184("TECFEPTN: Invalid GNPNodes input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 8; } } if (!ngcells || *ngcells < 0) { ___3184("TECFEPTN: Invalid NGCells input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 9; } if (*ngcells > 0 && !gcells) { ___3184("TECFEPTN: Invalid GCells input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 10; } try { int32_t partitionZone = outputInfos[fileNum]->m_tecioData.___2846();
 #if defined TECIOMPI
___478(partitionZone > 0); Zone_s* zonePtr = outputInfos[fileNum]->m_tecioData.zonePtr(partitionZone); if (zonePtr->m_partitionOwners.empty()) { throw std::logic_error("Must call TECZNEMAP prior to calling TECFEPTN"); } else if (static_cast<size_t>(*___2977) > zonePtr->m_partitionOwners.size()) { std::ostringstream ___2892; ___2892 << "Invalid partition number passed to TECFEPTN: " << ___2977; throw std::logic_error(___2892.str().c_str()); }
 #else
___4278(___2977);
 #endif 
if (outputInfos[fileNum]->m_tecioData.numZonePartitions(partitionZone) > 0 && checkData(fileNum, "TECFEPTN") < 0) return (-3); outputInfos[fileNum]->m_tecioData.addFEZonePartition( partitionZone, *___2977, *numnodes, *numcells, std::vector<int64_t>(gnodes, gnodes + *ngnodes), std::vector<int32_t>(gnpartitions, gnpartitions + *ngnodes), std::vector<int64_t>(gnpnodes, gnpnodes + *ngnodes), std::vector<int64_t>(gcells, gcells + *ngcells)); } catch(std::exception const& e) { ___3185("TEFECPTN: %s\n", e.what()); ++outputInfos[fileNum]->m_numErrs; return (-4); } return (0); } namespace { bool checkParameter(int32_t  const* parameter, char const* parameterName, int32_t  minValue, int32_t  maxValue) { if (!parameter || *parameter < minValue || *parameter > maxValue) { ___3185("TECIJKPTN: Invalid %s input parameter.\n", parameterName); return false; } else { return true; } } } int32_t  TECIOSZL_IJKPTN( int32_t         fileNum, int32_t  const* ___2977, int32_t  const* imin, int32_t  const* jmin, int32_t  const* kmin, int32_t  const* imax, int32_t  const* jmax, int32_t  const* kmax) { if (checkFile(fileNum, "TECIJKPTN")) return (-1); if (outputInfos[fileNum]->m_tecioData.___2846() == 0) { ___3184("TECIJKPTN: Must call TECZNE prior to calling TECIJKPTN.\n"); ++outputInfos[fileNum]->m_numErrs; return 1; } Zone_s* zonePtr = outputInfos[fileNum]->m_tecioData.zonePtr(outputInfos[fileNum]->m_tecioData.___2846()); if (!supportedOrderedVolumeZoneType(zonePtr->___2684, zonePtr->___2682)) { ___3184("TECIJKPTN: Called for the wrong zone type; can be called only for 3D FE zones.\n"); ++outputInfos[fileNum]->m_numErrs; return 1; } if (!___2977 || *___2977 < 1) { ___3184("TECIJKPTN: Invalid Partition input parameter.\n"); ++outputInfos[fileNum]->m_numErrs; return 2; } if (!checkParameter(imin, "imin", 1,     static_cast<int32_t>(zonePtr->___2682.i()))) return 3; if (!checkParameter(jmin, "jmin", 1,     static_cast<int32_t>(zonePtr->___2682.___2105()))) return 4; if (!checkParameter(kmin, "kmin", 1,     static_cast<int32_t>(zonePtr->___2682.___2134()))) return 5; if (!checkParameter(imax, "imax", *imin, static_cast<int32_t>(zonePtr->___2682.i()))) return 6; if (!checkParameter(jmax, "jmax", *jmin, static_cast<int32_t>(zonePtr->___2682.___2105()))) return 7; if (!checkParameter(kmax, "kmax", *kmin, static_cast<int32_t>(zonePtr->___2682.___2134()))) return 8; try { int32_t partitionZone = outputInfos[fileNum]->m_tecioData.___2846();
 #if defined TECIOMPI
___478(partitionZone > 0); Zone_s* zonePtr = outputInfos[fileNum]->m_tecioData.zonePtr(partitionZone); if (zonePtr->m_partitionOwners.empty()) { throw std::logic_error("Must call TECZNEMAP prior to calling TECIJKPTN"); } else if (static_cast<size_t>(*___2977) > zonePtr->m_partitionOwners.size()) { std::ostringstream ___2892; ___2892 << "Invalid partition number passed to TECIJKPTN: " << ___2977; throw std::logic_error(___2892.str().c_str()); }
 #else
___4278(___2977);
 #endif 
if (outputInfos[fileNum]->m_tecioData.numZonePartitions(partitionZone) > 0 && checkData(fileNum, "TECIJKPTN") < 0) return (-3); outputInfos[fileNum]->m_tecioData.addIJKZonePartition( partitionZone, *___2977, *imin, *jmin, *kmin, *imax, *jmax, *kmax); } catch (std::exception const& e) { ___3185("TECIJKPTN: %s\n", e.what()); ++outputInfos[fileNum]->m_numErrs; return (-4); } return (0); } int32_t  tecioszl_convertrawdata(char const* ___1394) { std::string ___1944(___1394);
 #if defined TECIOMPI
int ___2676; MPI_Comm_rank(MPI_COMM_WORLD, &___2676); std::ostringstream ___2892; ___2892 << ___1944 << ___2676; ___1944 = ___2892.str();
 #endif
___3970 tecioData(___1944.c_str()); ___4016 ___4015(tecioData); bool const ___4480 =
 #if defined TECIOMPI && defined _DEBUG
true;
 #elif defined WRITEASCII
true;
 #else
false;
 #endif
___1388 ___1387( ___4480, ___845, DEFAULT_SUBZONE_MAX_IJK_DIM, DEFAULT_SUBZONE_MAX_FE_SIZE); ___1387.setFileVersion(SZPLT_CUR_WRITE_VERSION); ___1387.setCodeRevision(1); DataWriteStatistics ___935; boost::scoped_ptr<FileWriterInterface> szpltFile; boost::shared_ptr<DataSetWriter> dataSetWriter; std::string outputFileName(___1394); size_t suffixLocation = outputFileName.rfind(".szplt"); if (suffixLocation == std::string::npos) outputFileName += ".szplt"; else outputFileName.erase(suffixLocation + 6);
 #if defined TECIOMPI
{ szpltFile.reset(new MPIFileWriter(outputFileName.c_str(), MPI_COMM_WORLD)); dataSetWriter = boost::make_shared<DataSetWriterMPI>( &___4015, ___3501(0), ___3501(0), ___1387.___1757(), ___1387.___1756(), ___4480, static_cast<MPI_Comm>(MPI_COMM_WORLD), 0, ___2676); }
 #else
{ szpltFile.reset(new FileStreamWriter(outputFileName.c_str())); dataSetWriter = boost::make_shared<DataSetWriter>( &___4015, ___3501(0), ___3501(0), ___1387.___1757(), ___1387.___1756(), ___4480); }
 #endif
if (!szpltFile->open()) { std::cerr << "Unable to open file " << outputFileName << " for writing" << std::endl; return 2; } else { szpltFile->___3494(___1387.___2002()); szpltFile->setDataFileType(___1387.___844());
 #if defined TECIOMPI
if (___2676 != 0) { ___1392 szpltZoneHeaderFileLocs; if (!szpltZoneHeaderFileLocs.alloc(___4015.___891()) || !dataSetWriter->writeDataSet(*szpltFile, szpltZoneHeaderFileLocs)) { std::cerr << "Error writing file" << std::endl; return 3; } } else
 #endif
{ if (!___1242( ___4015, *szpltFile, ___1387, includeRevisionNumber(), *dataSetWriter, ___3501(0), ___3501(0), ___935)) { std::cerr << "Error writing file" << std::endl; return 3; } } } szpltFile->close(true); return 0; } namespace { template <typename T> bool allocVector(std::vector<T>& vec, size_t count, T ___4314) { try { vec.assign(count, ___4314); return true; } catch (std::bad_alloc const&) { return false; } } struct TecioSzlDataReaderCache { FileStreamReader szpltFile; ___1388  ___1387; ___4352       ___2843; ___4636      ___2846; std::string      dataSetTitle; ___1392     ___4629; ___2240<ZoneMetadata> zoneMetadata; ___2240<___4636>  zoneShareConnectivityArray; std::vector<std::pair<std::string, std::string> > dataSetAuxData; std::vector<std::vector<std::pair<std::string, std::string> > > varAuxData; std::vector<std::vector<std::pair<std::string, std::string> > > zoneAuxData; CustomLabelsArray customLabelsArray; GeomArray geomArray; TextArray textArray; ___3816 varNames; VarZoneMinMaxArray varZoneMinMaxArray; ___4391 varZoneValueLocationArray; ___4382 varZoneFieldDataTypeArray; ___4385 varZoneIsPassiveArray; ___4388 varZoneShareArray; ___2240<uint8_t> zoneHeaderIsRead; ___2240<___2240<char> > zonePartitionHeaderIsRead; TecioSzlDataReaderCache(char const* ___1394) : szpltFile(___1394) {} bool allocateArrays() { if (___2843 > 0 && ___2846 > 0) return ___4629.alloc(___2846) && zoneMetadata.alloc(___2846) && zoneShareConnectivityArray.alloc(___2846) && ___3356(varZoneMinMaxArray, ___2843, ___2846) && ___3356(varZoneValueLocationArray, ___2843, ___2846) && ___3356(varZoneFieldDataTypeArray, ___2843, ___2846) && ___3356(varZoneIsPassiveArray, ___2843, ___2846) && ___3356(varZoneShareArray, ___2843, ___2846) && zoneHeaderIsRead.alloc((uint64_t)___2846, (uint8_t)0) && zonePartitionHeaderIsRead.alloc((uint64_t)___2846); return true; } }; } int32_t tecioSZL_CustomLabelsGetNumSets(void* fileHandle, int32_t* numSets) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(numSets)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *numSets = static_cast<int32_t>(szlDataReaderCache->customLabelsArray.size()); return 0; } namespace { bool duplicateString(char const* source, char** target) { REQUIRE(VALID_REF(source)); REQUIRE(VALID_REF(target) && *target == NULL); try { *target = new char[strlen(source) + 1]; strcpy(*target, source); return true; } catch (std::bad_alloc const&) { std::cerr << "Error: Out of memory while duplicating string." << std::endl; return false; } } } int32_t tecioSZL_CustomLabelsGetSet(void* fileHandle, int32_t ___4453, char** labelSet) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4453 && ___4453 <= static_cast<int32_t>(szlDataReaderCache->customLabelsArray.size())); REQUIRE(VALID_REF(labelSet) && *labelSet == NULL); std::ostringstream ___2892; CustomLabelSet const& customLabelSet = szlDataReaderCache->customLabelsArray[___4453 - 1]; for (uint32_t i = 0; i < customLabelSet.m_numLabels - 1; ++i) ___2892 <<'"' << customLabelSet.m_labels[i] << "\", "; ___2892 << '"' << customLabelSet.m_labels[customLabelSet.m_numLabels - 1] << '"'; if (!duplicateString(___2892.str().c_str(), labelSet)) return -1; return 0; } namespace { int32_t duplicateAuxDataItem(std::pair<std::string, std::string> const& auxData, char** ___2685, char** ___4314) { REQUIRE(VALID_REF(___2685) && *___2685 == NULL); REQUIRE(VALID_REF(___4314) && *___4314 == NULL); int32_t ___3358 = 0; if (!duplicateString(auxData.first.c_str(), ___2685)) { ___3358 = -1; } else if (!duplicateString(auxData.second.c_str(), ___4314)) { delete[] *___2685; *___2685 = NULL; ___3358 = -1; } ENSURE(___3358 == 0 || ___3358 == -1); ENSURE(EQUIVALENCE(___3358 == 0, VALID_REF(*___2685))); ENSURE(EQUIVALENCE(___3358 == 0, VALID_REF(*___4314))); return ___3358; } } int32_t tecioSZL_DataSetAuxDataGetItem(void* fileHandle, int32_t whichItem, char** ___2685, char** ___4314) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < whichItem && whichItem <= static_cast<int32_t>(szlDataReaderCache->dataSetAuxData.size())); REQUIRE(VALID_REF(___2685) && *___2685 == NULL); REQUIRE(VALID_REF(___4314) && *___4314 == NULL); return duplicateAuxDataItem(szlDataReaderCache->dataSetAuxData[whichItem - 1], ___2685, ___4314); } int32_t tecioSZL_DataSetAuxDataGetNumItems(void* fileHandle, int32_t* ___2812) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(___2812)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle);
*___2812 = static_cast<int32_t>(szlDataReaderCache->dataSetAuxData.size()); return 0; } int32_t tecioSZL_DataSetGetNumVars(void* fileHandle, int32_t* ___2843) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(___2843)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___2843 = static_cast<int32_t>(szlDataReaderCache->___2843); return 0; } int32_t tecioSZL_DataSetGetNumZones(void* fileHandle, int32_t* ___2846) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(___2846)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___2846 = static_cast<int32_t>(szlDataReaderCache->___2846); return 0; } int32_t tecioSZL_DataSetGetTitle(void* fileHandle, char** ___4177) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(___4177) && *___4177 == NULL); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); if (!duplicateString(szlDataReaderCache->dataSetTitle.c_str(), ___4177)) return -1; return 0; } int32_t tecioSZL_FileGetType(void* fileHandle, int32_t* ___1407) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(___1407)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___1407 = static_cast<int32_t>(szlDataReaderCache->___1387.___844()); return 0; } int32_t tecioSZL_FileReaderClose(void** fileHandle) { TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(*fileHandle); int32_t returnCode = 0; if (!szlDataReaderCache->szpltFile.close(true)) returnCode = -1; delete szlDataReaderCache; *fileHandle = NULL; return returnCode; } namespace { bool readAndCategorizeAuxData(TecioSzlDataReaderCache* szlDataReaderCache, ___3945 ___3944) { REQUIRE(VALID_REF(szlDataReaderCache)); uint32_t auxDataCount = 0; AuxDataArray auxDataArray; szlDataReaderCache->varAuxData.resize(szlDataReaderCache->___2843); szlDataReaderCache->zoneAuxData.resize(szlDataReaderCache->___2846); bool ___3358 = (readAuxDataCount(szlDataReaderCache->szpltFile, ___3944, auxDataCount) == ___4226); if (auxDataCount > 0) { ___3358 = ___3358 && (auxDataArray.alloc(static_cast<uint64_t>(auxDataCount)) == ___4226) && (readAuxData(szlDataReaderCache->szpltFile, ___3944, 0, 0, 0, auxDataArray) == ___4226); } for (uint32_t i = 0; i < auxDataCount; ++i) { switch (auxDataArray[i].m_location) { case ___253: szlDataReaderCache->dataSetAuxData.push_back(std::make_pair(auxDataArray[i].___2495, auxDataArray[i].___2667)); break; case ___258: szlDataReaderCache->varAuxData[auxDataArray[i].m_entity - 1].push_back(std::make_pair(auxDataArray[i].___2495, auxDataArray[i].___2667)); break; case ___259: szlDataReaderCache->zoneAuxData[auxDataArray[i].m_entity - 1].push_back(std::make_pair(auxDataArray[i].___2495, auxDataArray[i].___2667)); break; default: ___478(___1305); break; } } return ___3358; } bool readAndStoreCustomLabels(TecioSzlDataReaderCache* szlDataReaderCache, ___3945 ___3944) { REQUIRE(VALID_REF(szlDataReaderCache)); uint32_t customLabelsCount = 0; bool ___3358 = (readCustomLabelsCount(szlDataReaderCache->szpltFile, ___3944, customLabelsCount) == ___4226); if (customLabelsCount > 0) { uint32_t ___2865 = 0; ___3358 = ___3358 && (szlDataReaderCache->customLabelsArray.alloc(static_cast<uint64_t>(customLabelsCount)) == ___4226) && readCustomLabels(szlDataReaderCache->szpltFile, ___3944, ___2865, szlDataReaderCache->customLabelsArray); } return ___3358; } bool readAndStoreGeoms(TecioSzlDataReaderCache* szlDataReaderCache, ___3945 ___3944) { REQUIRE(VALID_REF(szlDataReaderCache)); uint32_t geomCount = 0; bool ___3358 = (readGeometriesCount(szlDataReaderCache->szpltFile, ___3944, geomCount) == ___4226); if (geomCount > 0) { uint32_t ___2865 = 0; ___3358 = ___3358 && (szlDataReaderCache->geomArray.alloc(static_cast<uint64_t>(geomCount)) == ___4226) && readGeometries(szlDataReaderCache->szpltFile, ___3944, ___2865, szlDataReaderCache->geomArray); } return ___3358; } bool readAndStoreTexts(TecioSzlDataReaderCache* szlDataReaderCache, ___3945 ___3944) { REQUIRE(VALID_REF(szlDataReaderCache)); uint32_t textCount = 0; bool ___3358 = (readTextsCount(szlDataReaderCache->szpltFile, ___3944, textCount) == ___4226); if (textCount > 0) { uint32_t ___2865 = 0; ___3358 = ___3358 && (szlDataReaderCache->textArray.alloc(static_cast<uint64_t>(textCount)) == ___4226) && readTexts(szlDataReaderCache->szpltFile, ___3944, ___2865, szlDataReaderCache->textArray); } return ___3358; } } TecioSZLFileOpenResult_e tecioSZL_FileReaderOpen(char const* ___1394, void** fileHandle) { REQUIRE(VALID_REF(___1394) && strlen(___1394) > 0); REQUIRE(VALID_REF(fileHandle) && *fileHandle == NULL); TecioSZLFileOpenResult_e returnCode = TecioSZLFileOpenResult_OK; TecioSzlDataReaderCache* szlDataReaderCache = NULL; try { szlDataReaderCache = new TecioSzlDataReaderCache(___1394);
if (!szlDataReaderCache->szpltFile.open()) { returnCode = TecioSZLFileOpenResult_ErrorOpeningFile; } else { ___3945 ___3944; if (!readFileHeaderTags(szlDataReaderCache->szpltFile, szlDataReaderCache->___1387, ___3944) || !applyFileHeaderScalarTagValues(___3944, szlDataReaderCache->___2843, szlDataReaderCache->___2846) || !readDatasetTitle(szlDataReaderCache->szpltFile, ___3944, szlDataReaderCache->dataSetTitle) || !szlDataReaderCache->allocateArrays() || !readPerZoneFileHeader(szlDataReaderCache->szpltFile, ___3944, 0, szlDataReaderCache->___4629, szlDataReaderCache->zoneMetadata, szlDataReaderCache->zoneShareConnectivityArray) || !readPerVarFileHeader(szlDataReaderCache->szpltFile, ___3944, 0, szlDataReaderCache->varNames) || !readPerVarZoneFileHeader(szlDataReaderCache->szpltFile, ___3944, 0, 0, szlDataReaderCache->varZoneMinMaxArray, szlDataReaderCache->varZoneValueLocationArray, szlDataReaderCache->varZoneFieldDataTypeArray, szlDataReaderCache->varZoneIsPassiveArray, szlDataReaderCache->varZoneShareArray) || !readAndCategorizeAuxData(szlDataReaderCache, ___3944) || !readAndStoreCustomLabels(szlDataReaderCache, ___3944) || !readAndStoreGeoms(szlDataReaderCache, ___3944) || !readAndStoreTexts(szlDataReaderCache, ___3944)) returnCode = TecioSZLFileOpenResult_BadFormat; } } catch (std::bad_alloc const&) { returnCode = TecioSZLFileOpenResult_OutOfMemory; } if (returnCode == 0) *fileHandle = reinterpret_cast<void*>(szlDataReaderCache); else delete szlDataReaderCache; ENSURE(VALID_ENUM(returnCode, TecioSZLFileOpenResult_e)); ENSURE(EQUIVALENCE(returnCode == TecioSZLFileOpenResult_OK, VALID_REF(*fileHandle))); return returnCode; } int32_t tecioSZL_GeomArrowheadGetAngle(void* fileHandle, int32_t ___1555, double* ___56) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___56)); *___56 = szlDataReaderCache->geomArray[___1555 - 1].___2340; return 0; } int32_t tecioSZL_GeomArrowheadGetAttach(void* fileHandle, int32_t ___1555, int32_t* attachment) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(attachment)); *attachment = szlDataReaderCache->geomArray[___1555 - 1].___2341; return 0; } int32_t tecioSZL_GeomArrowheadGetSize(void* fileHandle, int32_t ___1555, double* arrowheadSize) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(arrowheadSize)); *arrowheadSize = szlDataReaderCache->geomArray[___1555 - 1].___2342; return 0; } int32_t tecioSZL_GeomArrowheadGetStyle(void* fileHandle, int32_t ___1555, int32_t* arrowheadStyle) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(arrowheadStyle)); *arrowheadStyle = szlDataReaderCache->geomArray[___1555 - 1].___2343; return 0; } int32_t tecioSZL_GeomCircleGetRadius(void* fileHandle, int32_t ___1555, double* radius) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(radius)); *radius = szlDataReaderCache->geomArray[___1555 - 1].___2464[0][0].x(); return 0; } int32_t tecioSZL_GeomEllipseGetNumPoints(void* fileHandle, int32_t ___1555, int32_t* numEllipsePoints) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(numEllipsePoints)); *numEllipsePoints = static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2502); return 0; } int32_t tecioSZL_GeomEllipseGetSize(void* fileHandle, int32_t ___1555, double* horizontalAxis, double* verticalAxis) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(horizontalAxis)); REQUIRE(VALID_REF(verticalAxis)); *horizontalAxis = szlDataReaderCache->geomArray[___1555 - 1].___2464[0][0].x(); *verticalAxis = szlDataReaderCache->geomArray[___1555 - 1].___2464[0][0].___4583();
return 0; } int32_t tecioSZL_GeomGetAnchorPos(void* fileHandle, int32_t ___1555, double* x, double* ___4583, double* z) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(x)); REQUIRE(VALID_REF(___4583)); REQUIRE(VALID_REF(z)); *x = szlDataReaderCache->geomArray[___1555 - 1].___2617[0]; *___4583 = szlDataReaderCache->geomArray[___1555 - 1].___2617[1]; *z = szlDataReaderCache->geomArray[___1555 - 1].___2617[2]; return 0; } int32_t tecioSZL_GeomGetClipping(void* fileHandle, int32_t ___1555, int32_t* ___495) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___495)); *___495 = szlDataReaderCache->geomArray[___1555 - 1].___2394; return 0; } int32_t tecioSZL_GeomGetColor(void* fileHandle, int32_t ___1555, int32_t* color) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(color)); *color = szlDataReaderCache->geomArray[___1555 - 1].___2395; return 0; } int32_t tecioSZL_GeomGetCoordMode(void* fileHandle, int32_t ___1555, int32_t* coordMode) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(coordMode)); *coordMode = szlDataReaderCache->geomArray[___1555 - 1].___2616; return 0; } int32_t tecioSZL_GeomGetFillColor(void* fileHandle, int32_t ___1555, int32_t* ___1411) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___1411)); *___1411 = szlDataReaderCache->geomArray[___1555 - 1].___2462; return 0; } int32_t tecioSZL_GeomGetLinePattern(void* fileHandle, int32_t ___1555, int32_t* ___2263) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___2263)); *___2263 = szlDataReaderCache->geomArray[___1555 - 1].___2489; return 0; } int32_t tecioSZL_GeomGetLineThickness(void* fileHandle, int32_t ___1555, double* ___2289) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___2289)); *___2289 = szlDataReaderCache->geomArray[___1555 - 1].___2490; return 0; } int32_t tecioSZL_GeomGetMacroFunctionCmd(void* fileHandle, int32_t ___1555, char** macroFunctionCmd) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(macroFunctionCmd) && *macroFunctionCmd == NULL); if (!duplicateString(szlDataReaderCache->geomArray[___1555 - 1].___2491.c_str(), macroFunctionCmd)) return -1; return 0; } int32_t tecioSZL_GeomGetNumGeoms(void* fileHandle, int32_t* numGeoms) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(VALID_REF(numGeoms)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *numGeoms = static_cast<int32_t>(szlDataReaderCache->geomArray.size()); return 0; } int32_t tecioSZL_GeomGetPatternLength(void* fileHandle, int32_t ___1555, double* ___2986) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___2986)); *___2986 = szlDataReaderCache->geomArray[___1555 - 1].___2615; return 0; } int32_t tecioSZL_GeomGetScope(void* fileHandle, int32_t ___1555, int32_t* ___3442) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___3442)); *___3442 = szlDataReaderCache->geomArray[___1555 - 1].___2619; return 0; } int32_t tecioSZL_GeomGetType(void* fileHandle, int32_t ___1555, int32_t* type)
{ REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(type)); *type = szlDataReaderCache->geomArray[___1555 - 1].___2466; return 0; } int32_t tecioSZL_GeomGetZone(void* fileHandle, int32_t ___1555, int32_t* zone) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(zone)); *zone = szlDataReaderCache->geomArray[___1555 - 1].___2677; return 0; } int32_t tecioSZL_GeomIsAttached(void* fileHandle, int32_t ___1555, int32_t* ___2004) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___2004)); *___2004 = szlDataReaderCache->geomArray[___1555 - 1].___2484; return 0; } int32_t tecioSZL_GeomIsFilled(void* fileHandle, int32_t ___1555, int32_t* ___2022) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___2022)); *___2022 = szlDataReaderCache->geomArray[___1555 - 1].___2486; return 0; } int32_t tecioSZL_GeomLineGetPoint(void* fileHandle, int32_t ___1555, int32_t segment, int32_t index, double* x, double* ___4583, double* z) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(0 < segment && segment <= static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464.size())); REQUIRE(0 < index && index <= static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464[segment - 1].size())); REQUIRE(VALID_REF(x)); REQUIRE(VALID_REF(___4583)); REQUIRE(VALID_REF(z)); *x = static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464[segment - 1][index - 1].x()); *___4583 = static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464[segment - 1][index - 1].___4583()); *z = static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464[segment - 1][index - 1].z()); return 0; } int32_t tecioSZL_GeomLineGetSegmentCount(void* fileHandle, int32_t ___1555, int32_t* segmentCount) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(segmentCount)); *segmentCount = static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464.size()); return 0; } int32_t tecioSZL_GeomLineSegmentGetPointCount(void* fileHandle, int32_t ___1555, int32_t segment, int32_t* pointCount) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(0 < segment && segment <= static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464.size())); REQUIRE(VALID_REF(pointCount)); *pointCount = static_cast<int32_t>(szlDataReaderCache->geomArray[___1555 - 1].___2464[segment - 1].size()); return 0; } int32_t tecioSZL_GeomRectangleGetSize(void* fileHandle, int32_t ___1555, double* ___4458, double* ___1826) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(VALID_REF(___4458)); REQUIRE(VALID_REF(___1826)); *___4458 = szlDataReaderCache->geomArray[___1555 - 1].___2464[0][0].x(); *___1826 = szlDataReaderCache->geomArray[___1555 - 1].___2464[0][0].___4583(); return 0; } int32_t tecioSZL_GeomSquareGetSize(void* fileHandle, int32_t ___1555, double* size) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___1555 && ___1555 <= static_cast<int32_t>(szlDataReaderCache->geomArray.size())); REQUIRE(szlDataReaderCache->geomArray[___1555 - 1].___2466 == GeomType_Square); REQUIRE(VALID_REF(size)); *size = szlDataReaderCache->geomArray[___1555 - 1].___2464[0][0].x(); return 0; } int32_t tecioSZL_TextBoxGetColor(void* fileHandle, int32_t ___4042, int32_t* ___402) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size()));
REQUIRE(VALID_REF(___402)); *___402 = szlDataReaderCache->textArray[___4042 - 1].___2628; return 0; } int32_t tecioSZL_TextBoxGetFillColor(void* fileHandle, int32_t ___4042, int32_t* ___404) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___404)); *___404 = szlDataReaderCache->textArray[___4042 - 1].___2629; return 0; } int32_t tecioSZL_TextBoxGetLineThickness(void* fileHandle, int32_t ___4042, double* ___406) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___406)); *___406 = szlDataReaderCache->textArray[___4042 - 1].___2630; return 0; } int32_t tecioSZL_TextBoxGetMargin(void* fileHandle, int32_t ___4042, double* ___408) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___408)); *___408 = szlDataReaderCache->textArray[___4042 - 1].___2631; return 0; } int32_t tecioSZL_TextBoxGetType(void* fileHandle, int32_t ___4042, int32_t* ___410) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___410)); *___410 = szlDataReaderCache->textArray[___4042 - 1].___2632; return 0; } int32_t tecioSZL_TextGetAnchor(void* fileHandle, int32_t ___4042, int32_t* ___38) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___38)); *___38 = szlDataReaderCache->textArray[___4042 - 1].___2625; return 0; } int32_t tecioSZL_TextGetAnchorPos(void* fileHandle, int32_t ___4042, double* x, double* ___4583, double* z) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(x)); REQUIRE(VALID_REF(___4583)); REQUIRE(VALID_REF(z)); *x = szlDataReaderCache->textArray[___4042 - 1].___2626[0]; *___4583 = szlDataReaderCache->textArray[___4042 - 1].___2626[1]; *z = szlDataReaderCache->textArray[___4042 - 1].___2626[2]; return 0; } int32_t tecioSZL_TextGetAngle(void* fileHandle, int32_t ___4042, double* ___56) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___56)); *___56 = szlDataReaderCache->textArray[___4042 - 1].___2627; return 0; } int32_t tecioSZL_TextGetClipping(void* fileHandle, int32_t ___4042, int32_t* ___495) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___495)); *___495 = szlDataReaderCache->textArray[___4042 - 1].___2633; return 0; } int32_t tecioSZL_TextGetColor(void* fileHandle, int32_t ___4042, int32_t* color) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(color)); *color = szlDataReaderCache->textArray[___4042 - 1].___2634; return 0; } int32_t tecioSZL_TextGetCoordMode(void* fileHandle, int32_t ___4042, int32_t* coordMode) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(coordMode)); *coordMode = szlDataReaderCache->textArray[___4042 - 1].___2639; return 0; } int32_t tecioSZL_TextGetHeight(void* fileHandle, int32_t ___4042, double* ___1826) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___1826)); *___1826 = szlDataReaderCache->textArray[___4042 - 1].___2635;
return 0; } int32_t tecioSZL_TextGetLineSpacing(void* fileHandle, int32_t ___4042, double* ___2287) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___2287)); *___2287 = szlDataReaderCache->textArray[___4042 - 1].___2637; return 0; } int32_t tecioSZL_TextGetMacroFunctionCmd(void* fileHandle, int32_t ___4042, char** macroFunctionCmd) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(macroFunctionCmd) && *macroFunctionCmd == NULL); if (duplicateString(szlDataReaderCache->textArray[___4042 - 1].___2638.c_str(), macroFunctionCmd)) return 0; return -1; } int32_t tecioSZL_TextGetScope(void* fileHandle, int32_t ___4042, int32_t* ___3442) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___3442)); *___3442 = static_cast<int32_t>(szlDataReaderCache->textArray[___4042 - 1].___2641); return 0; } int32_t tecioSZL_TextGetNumTexts(void* fileHandle, int32_t* numTexts) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(VALID_REF(numTexts)); *numTexts = static_cast<int32_t>(szlDataReaderCache->textArray.size()); return 0; } int32_t tecioSZL_TextGetSizeUnits(void* fileHandle, int32_t ___4042, int32_t* sizeUnits) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(sizeUnits)); *sizeUnits = szlDataReaderCache->textArray[___4042 - 1].___2642; return 0; } int32_t tecioSZL_TextGetString(void* fileHandle, int32_t ___4042, char** str) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(str) && *str == NULL); if (duplicateString(szlDataReaderCache->textArray[___4042 - 1].___2643.c_str(), str)) return 0; return 1; } int32_t tecioSZL_TextGetTypeface(void* fileHandle, int32_t ___4042, char** typeface) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(typeface) && *typeface == NULL); if (duplicateString(szlDataReaderCache->textArray[___4042 - 1].___2644.c_str(), typeface)) return 0; return 1; } int32_t tecioSZL_TextGetZone(void* fileHandle, int32_t ___4042, int32_t* zone) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(zone)); *zone = static_cast<int32_t>(szlDataReaderCache->textArray[___4042 - 1].___2647); return 0; } int32_t tecioSZL_TextIsAttached(void* fileHandle, int32_t ___4042, int32_t* ___2004) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(___2004)); *___2004 = (szlDataReaderCache->textArray[___4042 - 1].___2636 == ___4226 ? 1 : 0); return 0; } int32_t tecioSZL_TextIsBold(void* fileHandle, int32_t ___4042, int32_t* isBold) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(isBold)); *isBold = (szlDataReaderCache->textArray[___4042 - 1].___2645 == ___4226 ? 1 : 0); return 0; } int32_t tecioSZL_TextIsItalic(void* fileHandle, int32_t ___4042, int32_t* isItalic) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4042 && ___4042 <= static_cast<int32_t>(szlDataReaderCache->textArray.size())); REQUIRE(VALID_REF(isItalic)); *isItalic = (szlDataReaderCache->textArray[___4042 - 1].___2646 == ___4226 ? 1 : 0); return 0; } int32_t tecioSZL_VarAuxDataGetItem(void* fileHandle, int32_t ___4336, int32_t whichItem, char** ___2685, char** ___4314)
{ REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4336 && ___4336 <= szlDataReaderCache->___2843); REQUIRE(0 < whichItem && whichItem <= static_cast<int32_t>(szlDataReaderCache->varAuxData[___4336 - 1].size())); REQUIRE(VALID_REF(___2685) && *___2685 == NULL); REQUIRE(VALID_REF(___4314) && *___4314 == NULL); return duplicateAuxDataItem(szlDataReaderCache->varAuxData[___4336 - 1][whichItem - 1], ___2685, ___4314); } int32_t tecioSZL_VarAuxDataGetNumItems(void* fileHandle, int32_t ___4336, int32_t* ___2812) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4336 && ___4336 <= szlDataReaderCache->___2843); REQUIRE(VALID_REF(___2812)); *___2812 = static_cast<int32_t>(szlDataReaderCache->varAuxData[___4336 - 1].size()); return 0; } int32_t tecioSZL_VarGetName(void* fileHandle, int32_t ___4336, char** ___2685) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < ___4336 && ___4336 <= szlDataReaderCache->___2843); REQUIRE(VALID_REF(___2685) && *___2685 == NULL); return (duplicateString(szlDataReaderCache->varNames[___4336 - 1].c_str(), ___2685) ? 0 : -1); } int32_t tecioSZL_VarIsEnabled(void*  , int32_t /*___4336*/, int32_t* isEnabled) { *isEnabled = 1; return 0; } int32_t tecioSZL_ZoneAuxDataGetItem(void* fileHandle, int32_t zone, int32_t whichItem, char** ___2685, char** ___4314) { REQUIRE(VALID_REF(fileHandle)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); REQUIRE(0 < zone && zone <= szlDataReaderCache->___2846); REQUIRE(0 < whichItem && whichItem <= static_cast<int32_t>(szlDataReaderCache->zoneAuxData[zone - 1].size())); REQUIRE(VALID_REF(___2685) && *___2685 == NULL); REQUIRE(VALID_REF(___4314) && *___4314 == NULL); return duplicateAuxDataItem(szlDataReaderCache->zoneAuxData[zone - 1][whichItem - 1], ___2685, ___4314); } int32_t tecioSZL_ZoneAuxDataGetNumItems(void* fileHandle, int32_t zone, int32_t* ___2812) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(___2812)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___2812 = static_cast<int32_t>(szlDataReaderCache->zoneAuxData[zone - 1].size()); return 0; } int32_t tecioSZL_ZoneConnectivityGetSharedZone(void* fileHandle, int32_t zone, int32_t* sharedZone) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(sharedZone)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *sharedZone = static_cast<int32_t>(szlDataReaderCache->zoneShareConnectivityArray[zone - 1] + 1); return 0; } namespace { bool readZoneHeaderIfNecessary(TecioSzlDataReaderCache* szlDataReaderCache, int32_t zone) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(zone >= 0); bool ___3358 = true; if (!szlDataReaderCache->zoneHeaderIsRead[zone]) { ___3945 ___3944; if (!szlDataReaderCache->szpltFile.___3459(szlDataReaderCache->___4629[zone]) || !readZoneHeaders(szlDataReaderCache->szpltFile, szlDataReaderCache->___1387, zone, 0, szlDataReaderCache->___2843, szlDataReaderCache->varZoneMinMaxArray, szlDataReaderCache->varZoneFieldDataTypeArray, szlDataReaderCache->zoneMetadata[zone])) { std::cerr << "File seek/read error while reading zone header." << std::endl; ___3358 = false; } else { szlDataReaderCache->zoneHeaderIsRead[zone] = 1; if (szlDataReaderCache->zoneMetadata[zone].isSZL()) ___3358 = szlDataReaderCache->zonePartitionHeaderIsRead[zone].alloc((uint64_t)szlDataReaderCache->zoneMetadata[zone].getNumPartitions(), (uint8_t)0); if (!___3358) std::cerr << "Out of memory while reading zone header." << std::endl; } } return ___3358; } bool readZonePartitionHeaderIfNecessary(TecioSzlDataReaderCache* szlDataReaderCache, int32_t zone, ___2090::___2980 ___2977) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(zone >= 0); REQUIRE(___2977 >= 0); bool ___3358 = readZoneHeaderIfNecessary(szlDataReaderCache, zone); if (___3358 && szlDataReaderCache->zoneMetadata[zone].getNumPartitions() > 1 && !szlDataReaderCache->zonePartitionHeaderIsRead[zone][___2977]) { ZoneMetadata& zoneMetadata = szlDataReaderCache->zoneMetadata[zone]; if (!szlDataReaderCache->szpltFile.___3459(zoneMetadata.m_ptnHeaderFileLocs[___2977]) || !readPartitionHeader(szlDataReaderCache->szpltFile, szlDataReaderCache->___1387, szlDataReaderCache->___2843, 0, zone, ___2977, zoneMetadata, szlDataReaderCache->varZoneFieldDataTypeArray, zoneMetadata.m_ptnMetadata[___2977])) { std::cerr << "File seek/read error while reading partition header." << std::endl; ___3358 = false; } else { szlDataReaderCache->zonePartitionHeaderIsRead[zone][___2977] = 1; } } return ___3358; } int32_t incrementIndex(uint64_t& currentIndex, uint64_t numValues)
{ if (currentIndex < numValues - 1) { ++currentIndex; return 0; } else { std::cerr << "Wrong number of face neighbor values detected." << std::endl; return -1; } } } int32_t tecioSZL_ZoneFaceNbrGetConnections(void* fileHandle, int32_t zone, int32_t* connections) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(connections)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); int32_t ___3358 = readZoneHeaderIfNecessary(szlDataReaderCache, zone - 1) ? 0 : -1; if (___3358 == 0 && szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2663 != ___330) { uint64_t tempNumValues; ___1965 ___4299; if (!szlDataReaderCache->szpltFile.___3459(szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2663) || !readFaceNeighbors(szlDataReaderCache->szpltFile, zone - 1, tempNumValues, ___4299)) { std::cerr << "File seek/read error while reading face neighbors." << std::endl; ___3358 = -1; } else { FaceNeighborMode_e const ___2504 = szlDataReaderCache->zoneMetadata[zone - 1].getFaceNeighborMode(); bool const isOneToMany = (___2504 == ___1289 || ___2504 == ___1286); bool const isGlobal = (___2504 == ___1287 || ___2504 == ___1286); uint64_t currentIndex = 0; while (___3358 == 0 && currentIndex < tempNumValues) { int32_t numNeighbors = 1; connections[currentIndex] = ___4299[currentIndex] + 1; ___3358 = incrementIndex(currentIndex, tempNumValues); if (___3358 == 0) { connections[currentIndex] = ___4299[currentIndex] + 1; ___3358 = incrementIndex(currentIndex, tempNumValues); } if (___3358 == 0 && isOneToMany) { connections[currentIndex] = ___4299[currentIndex]; ___3358 = incrementIndex(currentIndex, tempNumValues); if (___3358 == 0) { numNeighbors = ___4299[currentIndex]; connections[currentIndex] = numNeighbors; ___3358 = incrementIndex(currentIndex, tempNumValues); } } for (int32_t i = 0; ___3358 == 0 && i < numNeighbors; ++i) { if (isGlobal) { connections[currentIndex] = ___4299[currentIndex] + 1; ___3358 = incrementIndex(currentIndex, tempNumValues); } if (___3358 == 0) { connections[currentIndex] = ___4299[currentIndex] + 1; if (i == numNeighbors - 1) ++currentIndex; else ___3358 = incrementIndex(currentIndex, tempNumValues); } } } } } return ___3358; } int32_t tecioSZL_ZoneFaceNbrGetConnections64(void* fileHandle, int32_t zone, int64_t* connections) { ___4278(fileHandle); ___4278(zone); ___4278(connections); ___478(!"Not implemented."); return 1; } int32_t tecioSZL_ZoneFaceNbrGetMode(void* fileHandle, int32_t zone, int32_t* ___2504) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(___2504)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___2504 = static_cast<int32_t>(szlDataReaderCache->zoneMetadata[zone - 1].getFaceNeighborMode()); return 0; } namespace { template <typename T> bool countFaceConnections(int64_t numFaceValues, ___3933::___2240<T> const& faceValues, int32_t ___2504, int64_t* numConnections) { REQUIRE(numFaceValues >= 0); REQUIRE(VALID_REF(numConnections)); int64_t index = 0; T nz; while (index < numFaceValues) { ++(*numConnections); switch (___2504) { case 0: index += 3; break; case 1: nz = faceValues[index + 3]; if (nz <= 0) { std::cerr << "tecZoneFaceNbrGetNumConnections: Face neighbors in file are invalid (Invalid # face neighbors for connection " << *numConnections << ")." << std::endl; *numConnections = 0; return false; } index += (nz + 4); break; case 2: index += 4; break; case 3: nz = faceValues[index + 3]; if (nz <= 0) { std::cerr << "tecZoneFaceNbrGetNumConnections: Face neighbors in file are invalid (Invalid # face neighbors for connection " << *numConnections << ")." << std::endl; *numConnections = 0; return false; } index += (2 * nz + 4); break; default: std::cerr << "tecZoneFaceNbrGetNumConnections: Face neighbors in file are invalid (invalid face neighbor mode)." << std::endl; return false; } if (index > numFaceValues) { std::cerr << "tecZoneFaceNbrGetNumConnections: Face neighbors in file are invalid (Array bound violation while parsing face neighbors)." << std::endl; return false; } } return true; } } int32_t tecioSZL_ZoneFaceNbrGetNumConnections(void* fileHandle, int32_t zone, int64_t* numConnections) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(numConnections)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); *numConnections = 0; bool ___3358 = readZoneHeaderIfNecessary(szlDataReaderCache, zone - 1); if (___3358 && szlDataReaderCache->zoneMetadata[zone - 1].getZoneType() != ___4696 && szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2663 != ___330) { int32_t are64Bit; int32_t ___2504 = 0; ___3358 = (tecioSZL_ZoneFaceNbrsAre64Bit(fileHandle, zone, &are64Bit) == 0) &&
(tecioSZL_ZoneFaceNbrGetMode(fileHandle, zone, &___2504) == 0); if (___3358) { if (are64Bit) { ___3358 = false; } else { uint64_t numValues; ___3933::___2240<int32_t> ___4299; if (!szlDataReaderCache->szpltFile.___3459(szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2663) || !readFaceNeighbors(szlDataReaderCache->szpltFile, zone - 1, numValues, ___4299)) { std::cerr << "File seek/read error while reading face neighbors." << std::endl; return 0; } else { ___3358 = countFaceConnections(numValues, ___4299, ___2504, numConnections); } } } } ENSURE(IMPLICATION(___3358, *numConnections >= 0)); return ___3358 ? 0 : -1; } int32_t tecioSZL_ZoneFaceNbrGetNumValues(void* fileHandle, int32_t zone, int64_t* numValues) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(numValues)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); *numValues = 0; uint64_t tempNumValues; ___1965 ___4299; bool ___3358 = readZoneHeaderIfNecessary(szlDataReaderCache, zone - 1); if (___3358 && szlDataReaderCache->zoneMetadata[zone - 1].getZoneType() != ___4696 && szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2663 != ___330) { if (!szlDataReaderCache->szpltFile.___3459(szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2663) || !readFaceNeighbors(szlDataReaderCache->szpltFile, zone - 1, tempNumValues, ___4299)) { std::cerr << "File seek/read error while reading face neighbors." << std::endl; ___3358 = false; } else { ___478(tempNumValues < static_cast<uint64_t>(std::numeric_limits<int64_t>::max())); *numValues = static_cast<int64_t>(tempNumValues); } } ENSURE(IMPLICATION(___3358, *numValues >= 0)); return ___3358 ? 0 : -1; } int32_t tecioSZL_ZoneFaceNbrsAre64Bit(void* fileHandle, int32_t zone, int32_t* are64Bit) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(are64Bit)); ___4278(fileHandle); ___4278(zone); *are64Bit = 0; return 0; } int32_t tecioSZL_ZoneGetIJK(void* fileHandle, int32_t zone, int64_t* iMax, int64_t* jMax, int64_t* kMax) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(iMax)); REQUIRE(VALID_REF(jMax)); REQUIRE(VALID_REF(kMax)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); ___1844 ___1843 = szlDataReaderCache->zoneMetadata[zone - 1].getZoneIJK(); *iMax = static_cast<int64_t>(___1843.i()); *jMax = static_cast<int64_t>(___1843.___2105()); *kMax = static_cast<int64_t>(___1843.___2134()); return 0; } int32_t tecioSZL_ZoneGetParentZone(void* fileHandle, int32_t zone, int32_t* ___2974) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(___2974)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___2974 = static_cast<int32_t>(szlDataReaderCache->zoneMetadata[zone - 1].getParentZone() + 1); return 0; } int32_t tecioSZL_ZoneGetSolutionTime(void* fileHandle, int32_t zone, double* ___3640) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(___3640)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___3640 = szlDataReaderCache->zoneMetadata[zone - 1].getSolutionTime(); return 0; } int32_t tecioSZL_ZoneGetStrandID(void* fileHandle, int32_t zone, int32_t* ___3785) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(___3785)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *___3785 = static_cast<int32_t>(szlDataReaderCache->zoneMetadata[zone - 1].getStrandID()); return 0; } int32_t tecioSZL_ZoneGetTitle(void* fileHandle, int32_t zone, char** ___4177) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(___4177)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); if (!duplicateString(szlDataReaderCache->zoneMetadata[zone - 1].getName().c_str(), ___4177)) return -1; return 0; } int32_t tecioSZL_ZoneGetType(void* fileHandle, int32_t zone, int32_t* type) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(VALID_REF(type)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); boost::unordered_map<ZoneType_e, int32_t> tecioZoneTypes = boost::assign::map_list_of (___4704, 0) (___4702, 2) (___4700, 3) (___4701, 4) (___4695, 5) (___4696, 1) (___4698, 6) (___4699, 7); *type = tecioZoneTypes[szlDataReaderCache->zoneMetadata[zone - 1].getZoneType()]; return 0; } int32_t tecioSZL_ZoneIsEnabled(void* fileHandle, int32_t zone, int32_t* isEnabled) { ___4278(fileHandle); ___4278(zone); *isEnabled = 1; return 0; } namespace { uint64_t getNumValuesInSubzone(TecioSzlDataReaderCache const* szlDataReaderCache, ValueLocation_e ___4326, int32_t zone, ___2090::___2980 ___2977, ___2090::SubzoneOffset_t ___3880)
{ REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(VALID_ENUM(___4326, ValueLocation_e)); REQUIRE(zone >= 0); REQUIRE(___2977 >= 0); REQUIRE(___3880 >= 0); uint64_t ___3358; if (szlDataReaderCache->zoneMetadata[zone].getZoneType() == ___4704) { if (___4326 == ___4330) ___3358 = szlDataReaderCache->zoneMetadata[zone].m_ijkZoneInfos[___2977].getNumNodesInNsz(___3880); else ___3358 = szlDataReaderCache->zoneMetadata[zone].m_ijkZoneInfos[___2977].getNumCellsInCsz(___3880); } else { uint64_t const valuesPerSubzone = static_cast<uint64_t>(szlDataReaderCache->___1387.___1756()); uint64_t numSubzones; uint64_t numValues; if (___4326 == ___4330) { numSubzones = static_cast<uint64_t>(szlDataReaderCache->zoneMetadata[zone].getNumNszsInPartition(___2977)); numValues = static_cast<uint64_t>(szlDataReaderCache->zoneMetadata[zone].m_ptnNumNodes[___2977]); } else { numSubzones = static_cast<uint64_t>(szlDataReaderCache->zoneMetadata[zone].getNumCszsInPartition(___2977)); numValues = static_cast<uint64_t>(szlDataReaderCache->zoneMetadata[zone].m_ptnNumCells[___2977]); } if (___3880 < numSubzones - 1) ___3358 = valuesPerSubzone; else ___3358 = numValues - (numSubzones - 1) * valuesPerSubzone; } return ___3358; } void getPartitionSubzoneAndOffset( TecioSzlDataReaderCache const* szlDataReaderCache, ValueLocation_e ___4326, int32_t zone, int64_t index, ___2090::___2980& ___2977, ___2090::SubzoneOffset_t& ___3880, uint64_t& itemOffset) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(VALID_ENUM(___4326, ValueLocation_e)); REQUIRE(zone >= 0); ZoneMetadata const& zoneMetadata = szlDataReaderCache->zoneMetadata[zone]; for (___2977 = 0; ___2977 < zoneMetadata.getNumPartitions(); ++___2977) { if (___4326 == ___4330) { if (index < zoneMetadata.m_ptnFirstNode[___2977] + zoneMetadata.m_ptnNumNodes[___2977]) break; } else { if (index < zoneMetadata.m_ptnFirstCell[___2977] + zoneMetadata.m_ptnNumCells[___2977]) break; } } ___478(___2977 < zoneMetadata.getNumPartitions()); ___2090::SubzoneOffset_t numSubzones; if (___4326 == ___4330) { itemOffset = static_cast<uint64_t>(index - zoneMetadata.m_ptnFirstNode[___2977]); numSubzones = zoneMetadata.m_ptnNumNszs[___2977]; } else { itemOffset = static_cast<uint64_t>(index - zoneMetadata.m_ptnFirstCell[___2977]); numSubzones = zoneMetadata.m_ptnNumCszs[___2977]; } ___478(numSubzones > 0); ___3880 = 0; while (___3880 < numSubzones) { uint64_t const valuesInSubzone = getNumValuesInSubzone(szlDataReaderCache, ___4326, zone, ___2977, ___3880); if (valuesInSubzone >= itemOffset) return; ++___3880; itemOffset -= valuesInSubzone; } ___478(___1305); } } int32_t tecioSZL_ZoneNodeMapGet(void* fileHandle, int32_t zone, int64_t startCell, int64_t ___2781, int32_t* ___2723) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(startCell > 0); REQUIRE(___2781 > 0); REQUIRE(VALID_REF(___2723)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); bool ___3358 = readZoneHeaderIfNecessary(szlDataReaderCache, zone - 1); ZoneType_e const ___4692 = szlDataReaderCache->zoneMetadata[zone - 1].getZoneType(); ___478(___4692 != ___4704); bool const ___2002 = (szlDataReaderCache->szpltFile.___2002() == ___4226); uint64_t const nodesPerCell = static_cast<uint64_t>(szlDataReaderCache->zoneMetadata[zone - 1].___1767()); if (___3358) { if (___4692 == ___4696 || ___4692 == ___4702 || ___4692 == ___4700) { uint64_t const sizeOfHeader = arraySizeInFile<int32_t, false  >(0, ___2002); uint64_t const bytesPerNumber = arrayValueSizeInFile<int32_t, false  >(___2002); uint64_t const fileLoc = szlDataReaderCache->zoneMetadata[zone - 1].m_classicZoneFileLocations.___2498 + ClassicFEZoneConnectivityWriter::nodeMapHeaderSizeInFile(___2002) + sizeOfHeader + (startCell - 1) * nodesPerCell * bytesPerNumber; uint64_t const valuesToRead = ___2781 * nodesPerCell; ___3358 = szlDataReaderCache->szpltFile.___3459(fileLoc) && readValues<int32_t, false, 0>(szlDataReaderCache->szpltFile, valuesToRead, ___2723, IODescription()); if (___3358) { for (uint64_t i = 0; i < ___2781 * nodesPerCell; ++i) ++___2723[i]; } } else { ___478(___4692 == ___4701 || ___4692 == ___4695); uint64_t const sizeOfHeader = SZLFEZoneWriter::cszConnectivityHeaderFileSize(___2002); uint64_t const valuesToRead = nodesPerCell * ___2781; uint64_t nodeMapIndex = 0; ZoneMetadata const& zoneMetadata = szlDataReaderCache->zoneMetadata[zone - 1]; ___2090::___2980 ___2977; ___2090::SubzoneOffset_t startingSubzone; uint64_t startingItemOffset; getPartitionSubzoneAndOffset(szlDataReaderCache, ___4328, zone - 1, startCell - 1, ___2977, startingSubzone, startingItemOffset); while (___3358 && nodeMapIndex < valuesToRead) { PartitionMetadata const& partitionMetadata = zoneMetadata.m_ptnMetadata[___2977];
for (___2090::SubzoneOffset_t ___3880 = startingSubzone; ___3358 && nodeMapIndex < valuesToRead && ___3880 < zoneMetadata.getNumCszsInPartition(___2977); ++___3880) { CszConnectivity cszConnectivity; ___3358 = szlDataReaderCache->szpltFile.___3459(partitionMetadata.m_cszConnectivityFileLocs[___3880] + sizeOfHeader) && readCszConnectivity(szlDataReaderCache->szpltFile, szlDataReaderCache->___1387, zoneMetadata, ___2977, ___3880, cszConnectivity); for (CszConnectivity::EntryIndex_t entry = static_cast<CszConnectivity::EntryIndex_t>(nodesPerCell * startingItemOffset); ___3358 && nodeMapIndex < valuesToRead && entry < static_cast<CszConnectivity::EntryIndex_t>(cszConnectivity.getNumEntries()); ++entry) { ___2090 const nodeAddress = cszConnectivity.getNodeAddress(entry); int64_t nodeNumber = nodeAddress.itemOffset(); if (nodeAddress.___2977()) nodeNumber += zoneMetadata.m_ptnFirstNode[nodeAddress.___2977()]; if (nodeAddress.subzoneOffset()) nodeNumber += nodeAddress.subzoneOffset() * szlDataReaderCache->___1387.___1756(); ___2723[nodeMapIndex] = static_cast<int32_t>(nodeNumber + 1); ++nodeMapIndex; } startingItemOffset = 0; } ++___2977; } } } return (___3358 ? 0 : -1); } int32_t tecioSZL_ZoneNodeMapGet64(void* fileHandle, int32_t zone, int64_t startCell, int64_t ___2781, int64_t* ___2723) { ___4278(fileHandle); ___4278(zone); ___4278(startCell); ___4278(___2781); ___4278(___2723); ___478(!"Not implemented."); return 1; } int32_t tecioSZL_ZoneNodeMapIs64Bit(void* fileHandle, int32_t zone, int32_t* is64Bit) { ___4278(fileHandle); ___4278(zone); ___4278(is64Bit); ___478(!"Not implemented."); return 1; } namespace { int64_t advanceCellIJKLocation(___1844 const &cellIJKSize, ___1844 &cellIJKLocation) { int64_t numValuesToSkip = 0; if (cellIJKSize.i() > 1) { cellIJKLocation.setI(0); if (cellIJKLocation.___2105() < cellIJKSize.___2105() - 1) { cellIJKLocation.setJ(cellIJKLocation.___2105() + 1); numValuesToSkip = 1; } else { cellIJKLocation.setJ(0); cellIJKLocation.___3497(cellIJKLocation.___2134() + 1); numValuesToSkip = cellIJKSize.i() + 2; } } else if (cellIJKSize.___2105() > 1) { cellIJKLocation.setJ(0); cellIJKLocation.___3497(cellIJKLocation.___2134() + 1); numValuesToSkip = 1; } return numValuesToSkip; } template <typename T> bool readSZLOrderedZoneVarValues(TecioSzlDataReaderCache* szlDataReaderCache, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, T* values) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); bool ___2002 = (szlDataReaderCache->szpltFile.___2002() == ___4226); uint64_t const sizeOfEachSzHeader = arraySizeInFile<T, false   >(0, ___2002) + SZLOrderedZoneWriter::fieldDataSubzoneHeaderFileSize(___2002); uint64_t const bytesPerNumber = arrayValueSizeInFile<T, false  >(___2002); ZoneMetadata const& zoneMetadata = szlDataReaderCache->zoneMetadata[zone - 1]; ValueLocation_e const ___4326 = static_cast<ValueLocation_e>(szlDataReaderCache->varZoneValueLocationArray[___4336 - 1][zone - 1]); ___1844 ___4632 = zoneMetadata.getZoneIJK(); if (___4326 == ___4328) ___4632 = (___4632 - 1).maxOp(1); int64_t remainingValues = numValues; bool ___3358 = true; boost::scoped_array<T> subzoneValues(new T[szlDataReaderCache->___1387.___1757().blockSize()]); for (___2090::___2980 ___2977 = 0; ___3358 && remainingValues > 0 && ___2977 < zoneMetadata.getNumPartitions(); ++___2977) { int64_t partitionFirstIndex; int64_t partitionLastIndex; ___2090::SubzoneOffset_t numSubzones; if (___4326 == ___4328) { partitionFirstIndex = zoneMetadata.m_ptnFirstCell[___2977]; partitionLastIndex = partitionFirstIndex + zoneMetadata.m_ptnNumCells[___2977] - 1; numSubzones = zoneMetadata.getNumCszsInPartition(___2977); } else { partitionFirstIndex = zoneMetadata.m_ptnFirstNode[___2977]; partitionLastIndex = partitionFirstIndex + zoneMetadata.m_ptnNumNodes[___2977] - 1; numSubzones = zoneMetadata.getNumNszsInPartition(___2977); } if (partitionLastIndex < startIndex - 1 || partitionFirstIndex >= startIndex + numValues - 1) continue; ___3358 = readZonePartitionHeaderIfNecessary(szlDataReaderCache, zone - 1, ___2977); ___1844 partitionMinIJK(0, 0, 0); if (zoneMetadata.getNumPartitions() > 1) partitionMinIJK = zoneMetadata.m_ptnNodeMinIJKs[___2977]; uint64_t fileLoc = zoneMetadata.m_ptnMetadata[___2977].m_szDataStartFileLocs[___4336 - 1] + sizeOfEachSzHeader; for (___2090::SubzoneOffset_t ___3880 = 0; ___3358 && remainingValues > 0 && ___3880 < numSubzones; ++___3880) { ___1844 subzoneIJKStart; ___1844 subzoneIJKEnd; if (___4326 == ___4328) { subzoneIJKStart = zoneMetadata.m_ijkZoneInfos[___2977].___690(___3880) + partitionMinIJK; subzoneIJKEnd = zoneMetadata.m_ijkZoneInfos[___2977].___689(___3880) + partitionMinIJK; } else { subzoneIJKStart = zoneMetadata.m_ijkZoneInfos[___2977].___2761(___3880) + partitionMinIJK;
subzoneIJKEnd = zoneMetadata.m_ijkZoneInfos[___2977].___2760(___3880) + partitionMinIJK; } ___1844 const subzoneIJKDim(subzoneIJKEnd - subzoneIJKStart + 1); int64_t const subzoneNumValues = subzoneIJKDim.blockSize(); int64_t const subzoneFirstIndex = ___4632.offsetAtIJK(subzoneIJKStart); int64_t const subzoneLastIndex = ___4632.offsetAtIJK(subzoneIJKEnd); if (subzoneLastIndex >= startIndex - 1 && subzoneFirstIndex < startIndex + numValues - 1) { if (szlDataReaderCache->szpltFile.___3459(fileLoc) && readValues<T, false, 0>(szlDataReaderCache->szpltFile, subzoneNumValues, subzoneValues.get(), IODescription())) { for (___2090::ItemOffset_t ___2085 = 0; ___2085 < subzoneNumValues; ++___2085) { int64_t const itemIndex = ___4632.offsetAtIJK(subzoneIJKStart + subzoneIJKDim.ijkAtOffset(___2085)); if (startIndex - 1 <= itemIndex && itemIndex < startIndex + numValues - 1) { values[itemIndex - startIndex + 1] = subzoneValues[___2085]; --remainingValues; } } } else { ___3358 = false; std::cerr << "Error reading value array." << std::endl; } } fileLoc += subzoneNumValues * bytesPerNumber + sizeOfEachSzHeader; } } ENSURE(IMPLICATION(___3358, remainingValues == 0)); return ___3358; } template <typename T> bool readSZLFEZoneVarValues(TecioSzlDataReaderCache* szlDataReaderCache, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, T* values) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); bool ___2002 = (szlDataReaderCache->szpltFile.___2002() == ___4226); uint64_t bytesPerNumber = arrayValueSizeInFile<T, false  >(___2002); ZoneMetadata const& zoneMetadata = szlDataReaderCache->zoneMetadata[zone - 1]; ValueLocation_e ___4326 = static_cast<ValueLocation_e>(szlDataReaderCache->varZoneValueLocationArray[___4336 - 1][zone - 1]); ___2090::___2980 ___2977; ___2090::SubzoneOffset_t startingSubzone; uint64_t itemOffset; getPartitionSubzoneAndOffset(szlDataReaderCache, ___4326, zone - 1, startIndex - 1, ___2977, startingSubzone, itemOffset); uint64_t destIndex = 0; uint64_t remainingValues = static_cast<uint64_t>(numValues); uint64_t valuesToSkip; if (___4326 == ___4330) valuesToSkip = startIndex - zoneMetadata.m_ptnFirstNode[___2977] - 1; else valuesToSkip = startIndex - zoneMetadata.m_ptnFirstCell[___2977] - 1; bool ___3358 = true; while (___3358 && remainingValues > 0) { ___3358 = readZonePartitionHeaderIfNecessary(szlDataReaderCache, zone - 1, ___2977); if (___3358) { if (___2002) { uint64_t const sizeOfEachSzHeader = arraySizeInFile<T, false  >(0, ___2002) + SZLFEZoneWriter::fieldDataSubzoneHeaderFileSize(___2002); uint64_t fileLoc = zoneMetadata.m_ptnMetadata[___2977].m_szDataStartFileLocs[___4336 - 1] + (startingSubzone + 1) * sizeOfEachSzHeader + valuesToSkip * bytesPerNumber; ___2090::SubzoneOffset_t const numSubzones = ___4326 == ___4330 ? zoneMetadata.getNumNszsInPartition(___2977) : zoneMetadata.getNumCszsInPartition(___2977); for (___2090::SubzoneOffset_t ___3880 = startingSubzone; ___3358 && remainingValues > 0 && ___3880 < numSubzones; ++___3880) { uint64_t const valuesInSubzone = getNumValuesInSubzone(szlDataReaderCache, ___4326, zone - 1, ___2977, ___3880); uint64_t const valuesToRead = std::min(remainingValues, valuesInSubzone - itemOffset); ___3358 = (szlDataReaderCache->szpltFile.___3459(fileLoc) == ___4226) && readValues<T, false, 0>(szlDataReaderCache->szpltFile, valuesToRead, &values[destIndex], IODescription()); destIndex += valuesToRead; remainingValues -= valuesToRead; fileLoc = szlDataReaderCache->szpltFile.fileLoc() + sizeOfEachSzHeader; itemOffset = 0; } } else { uint64_t fileLoc = zoneMetadata.m_ptnMetadata[___2977].m_szDataStartFileLocs[___4336 - 1] + valuesToSkip * bytesPerNumber; uint64_t valuesToRead; if (___4326 == ___4330) valuesToRead = std::min(remainingValues, zoneMetadata.m_ptnNumNodes[___2977] - valuesToSkip); else valuesToRead = std::min(remainingValues, zoneMetadata.m_ptnNumCells[___2977] - valuesToSkip); ___3358 = (szlDataReaderCache->szpltFile.___3459(fileLoc) == ___4226) && readValues<T, false, 0>(szlDataReaderCache->szpltFile, valuesToRead, &values[destIndex], IODescription()); destIndex += valuesToRead; remainingValues -= valuesToRead; } } ++___2977; valuesToSkip = 0; } return ___3358; } template <typename T> bool readClassicZoneVarValues(TecioSzlDataReaderCache* szlDataReaderCache, int32_t zone, int32_t ___4336, int64_t startIndex, bool ___3358, int64_t numValues, T* values) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); ZoneMetadata const& zoneMetadata = szlDataReaderCache->zoneMetadata[zone - 1]; ValueLocation_e ___4326 = static_cast<ValueLocation_e>(szlDataReaderCache->varZoneValueLocationArray[___4336 - 1][zone - 1]); bool ___2002 = (szlDataReaderCache->szpltFile.___2002() == ___4226);
uint64_t bytesPerNumber = arrayValueSizeInFile<T, false  >(___2002); if (___4326 == ___4330 || zoneMetadata.getZoneType() != ___4704) { uint64_t const fileLoc = zoneMetadata.m_classicZoneFileLocations.___2673[___4336 - 1] + ClassicZoneVariableWriter::varHeaderSizeInFile(___2002) + arraySizeInFile<T, false  >(0 /* ___2797 */, ___2002) + (startIndex - 1) * bytesPerNumber; ___3358 = (szlDataReaderCache->szpltFile.___3459(fileLoc) == ___4226) && readValues<T, false, 0>(szlDataReaderCache->szpltFile, static_cast<uint64_t>(numValues), values, IODescription()); } else { ___1844 const nodeIJKSize = zoneMetadata.getZoneIJK(); ___1844 const cellIJKSize = (nodeIJKSize - 1).maxOp(1); ___1844 cellIJKLocation = cellIJKSize.ijkAtOffset(static_cast<___81>(startIndex - 1)); int64_t const adjustedStartingIndex = static_cast<int64_t>(nodeIJKSize.offsetAtIJK(cellIJKLocation)); uint64_t fileLoc = zoneMetadata.m_classicZoneFileLocations.___2673[___4336 - 1] + ClassicZoneVariableWriter::varHeaderSizeInFile(___2002) + arraySizeInFile<T, false  >(0 /* ___2797 */, ___2002) + adjustedStartingIndex * bytesPerNumber; uint64_t destIndex = 0; uint64_t remainingNumValues = static_cast<uint64_t>(numValues); while (___3358 && remainingNumValues > 0) { uint64_t valuesToRead; if (cellIJKSize.i() > 1) valuesToRead = std::min(remainingNumValues, static_cast<uint64_t>(cellIJKSize.i() - cellIJKLocation.i())); else if (cellIJKSize.___2105() > 1) valuesToRead = std::min(remainingNumValues, static_cast<uint64_t>(cellIJKSize.___2105() - cellIJKLocation.___2105())); else valuesToRead = std::min(remainingNumValues, static_cast<uint64_t>(cellIJKSize.___2134() - cellIJKLocation.___2134())); ___3358 = (szlDataReaderCache->szpltFile.___3459(fileLoc) == ___4226) && readValues<T, false, 0>(szlDataReaderCache->szpltFile, valuesToRead, &(values[destIndex]), IODescription()); remainingNumValues -= valuesToRead; destIndex += valuesToRead; uint64_t numValuesToSkip; numValuesToSkip = advanceCellIJKLocation(cellIJKSize, cellIJKLocation); ASSERT_ONLY(if (numValuesToSkip == 0) ___478(remainingNumValues == 0);) fileLoc = szlDataReaderCache->szpltFile.fileLoc() + bytesPerNumber * numValuesToSkip; } } return ___3358; } template <typename T> bool readVarValues(TecioSzlDataReaderCache* szlDataReaderCache, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, T* values) { REQUIRE(VALID_REF(szlDataReaderCache)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); bool ___3358 = readZoneHeaderIfNecessary(szlDataReaderCache, zone - 1); if (___3358) { if (szlDataReaderCache->zoneMetadata[zone - 1].isSZL()) { if (szlDataReaderCache->zoneMetadata[zone - 1].getZoneType() == ___4704) ___3358 = readSZLOrderedZoneVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values); else ___3358 = readSZLFEZoneVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values); } else { ___3358 = readClassicZoneVarValues(szlDataReaderCache, zone, ___4336, startIndex, ___3358, numValues, values); } } return ___3358; } } int32_t tecioSZL_ZoneVarGetDoubleValues(void* fileHandle, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, double* values) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); if (!readVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values)) return -1; return 0; } int32_t tecioSZL_ZoneVarGetFloatValues(void* fileHandle, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, float* values) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); if (!readVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values)) return -1; return 0; } int32_t tecioSZL_ZoneVarGetInt16Values(void* fileHandle, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, int16_t* values) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); if (!readVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values)) return -1; return 0; } int32_t tecioSZL_ZoneVarGetInt32Values(void* fileHandle, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, int32_t* values) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); if (!readVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values))
return -1; return 0; } int32_t tecioSZL_ZoneVarGetSharedZone(void* fileHandle, int32_t zone, int32_t ___4336, int32_t* sharedZone) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(VALID_REF(sharedZone)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *sharedZone = static_cast<int32_t>(szlDataReaderCache->varZoneShareArray[___4336 - 1][zone - 1] + 1); return 0; } int32_t tecioSZL_ZoneVarGetType(void* fileHandle, int32_t zone, int32_t ___4336, int32_t* type) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(VALID_REF(type)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *type = static_cast<int32_t>(szlDataReaderCache->varZoneFieldDataTypeArray[___4336 - 1][zone - 1]); return 0; } int32_t tecioSZL_ZoneVarGetUInt8Values(void* fileHandle, int32_t zone, int32_t ___4336, int64_t startIndex, int64_t numValues, uint8_t* values) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(startIndex > 0); REQUIRE(numValues > 0); REQUIRE(VALID_REF(values)); TecioSzlDataReaderCache* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache*>(fileHandle); if (!readVarValues(szlDataReaderCache, zone, ___4336, startIndex, numValues, values)) return -1; return 0; } int32_t tecioSZL_ZoneVarGetValueLocation(void* fileHandle, int32_t zone, int32_t ___4336, int32_t* location) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(VALID_REF(location)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *location = static_cast<int32_t>(szlDataReaderCache->varZoneValueLocationArray[___4336 - 1][zone - 1]); return 0; } int32_t tecioSZL_ZoneVarIsPassive(void* fileHandle, int32_t zone, int32_t ___4336, int32_t* isPassive) { REQUIRE(VALID_REF(fileHandle)); REQUIRE(zone > 0); REQUIRE(___4336 > 0); REQUIRE(VALID_REF(isPassive)); TecioSzlDataReaderCache const* szlDataReaderCache = reinterpret_cast<TecioSzlDataReaderCache const*>(fileHandle); *isPassive = static_cast<int32_t>(szlDataReaderCache->varZoneIsPassiveArray[___4336 - 1][zone - 1]); return 0; } }}
