#include "ZoneInfoCache.h"
#include "ThirdPartyHeadersBegin.h"
#include <boost/make_shared.hpp>
#include <boost/ref.hpp>
#include "ThirdPartyHeadersEnd.h"
#include "FEZoneInfo.h"
#include "IJKZoneInfo.h"
#include "ItemSetIterator.h"
#include "ORBFESubzonePartitioner.h"
#include "NoOpFESubzonePartitioner.h"
#include "PartitionTecUtilDecorator.h"
#include "zoneUtil.h"
namespace tecplot { namespace ___3933 { ZoneInfoCache::ZoneInfoCache( ___37*               ___36, ItemSetIterator&          zoneIter, ___1844 const&                maxIJKSubzoneSize, ___2090::ItemOffset_t feSubzoneSize, bool                      sortFENodesAndCells) : ___2337(___36) , m_numZones(___2337->___896() ? zoneIter.___2812() : 0) , m_maxIJKSubzoneSize(maxIJKSubzoneSize) , m_feSubzoneSize(feSubzoneSize) , m_sortFENodesAndCells(sortFENodesAndCells) { if (___2337->___896()) { ___478(m_numZones > 0); m_ijkZoneInfos.resize(m_numZones); m_feZoneInfos.resize(m_numZones); m_ijkZonePartitionInfos.resize(m_numZones); m_feZonePartitionInfos.resize(m_numZones); zoneIter.reset(); while (zoneIter.hasNext()) { ___4636 const zone = zoneIter.next(); ___4636 const fileZone = zone - zoneIter.baseItem(); if (!___2337->___4638(zone + 1)) continue; if (___4642(*___2337, zone) && zoneIsPartitioned(*___2337, zone)) m_ijkZonePartitionInfos[fileZone].resize(___2337->zoneGetNumPartitions(zone + 1)); if (___4639(*___2337, zone) && zoneIsPartitioned(*___2337, zone)) m_feZonePartitionInfos[fileZone].resize(___2337->zoneGetNumPartitions(zone + 1)); } } } template<typename ZoneInfoType> void ZoneInfoCache::storeForSharedZones( std::vector<boost::shared_ptr<ZoneInfoType> >& zoneInfos, boost::shared_ptr<ZoneInfoType>                zoneInfo, ___4636                                    zone, ___4636                                    ___341) { ___3501 sharedZoneSet = ___2337->___545(zone + 1); if (sharedZoneSet) { for (___3493 sharedZone = ___2337->___3491(sharedZoneSet, zone + 1); sharedZone != 0; sharedZone = ___2337->___3491(sharedZoneSet, sharedZone)) { if (sharedZone - 1 < ___341) continue; if (sharedZone - 1 >= ___341 + m_numZones) break; ___4636 const sharedFileZone = static_cast<___4636>(sharedZone - 1) - ___341; zoneInfos[sharedFileZone] = zoneInfo; } ___2337->___3484(&sharedZoneSet); } } template <typename ZoneInfoType> void ZoneInfoCache::storeForSharedPartitions( std::vector<std::vector<boost::shared_ptr<ZoneInfoType> > >& zoneInfos, boost::shared_ptr<ZoneInfoType> zoneInfo, ___4636 zone, ___4636 ___341, ___4636 ___2977) { ___3501 sharedZoneSet = ___2337->___545(zone + 1); if (sharedZoneSet) { for (___3493 sharedZone = ___2337->___3491(sharedZoneSet, zone + 1); sharedZone != ___4039; sharedZone = ___2337->___3491(sharedZoneSet, sharedZone)) { if (sharedZone - 1 < ___341) continue; if (sharedZone - 1 >= ___341 + m_numZones) break; ___4636 const sharedFileZone = static_cast<___4636>(sharedZone - 1) - ___341; zoneInfos[sharedFileZone][___2977] = zoneInfo; } ___2337->___3484(&sharedZoneSet); } } boost::shared_ptr<___1881> ZoneInfoCache::getIJKZoneInfo( ___4636 zone, ___4636 ___341) { REQUIRE(___4641(*___2337, zone) && !zoneIsPartitioned(*___2337, zone)); REQUIRE(0 <= ___341 && ___341 <= zone && zone-___341 < m_numZones); ___4636 const fileZone = zone - ___341; boost::shared_ptr<___1881> zoneInfo = m_ijkZoneInfos[fileZone]; if (!zoneInfo) { ___1844 ___4633; ___2337->___4615(zone + 1, ___4633); zoneInfo = boost::make_shared<___1881>(___4633, m_maxIJKSubzoneSize, DEFAULT_MINIMIZE_IJK_NUM_SUBZONES); m_ijkZoneInfos[fileZone] = zoneInfo; storeForSharedZones(m_ijkZoneInfos, zoneInfo, zone, ___341); } zoneInfo->resetNeighborInfo(); return zoneInfo; } boost::shared_ptr<___1881> ZoneInfoCache::getIJKZonePartitionInfo( ___4636 zone, ___4636 ___341, ___4636 ___2977) { REQUIRE(0 <= zone && ___2337->___4638(zone + 1)); REQUIRE(___4641(*___2337, zone) && zoneIsPartitioned(*___2337, zone)); REQUIRE(0 <= ___341 && ___341 <= zone && zone - ___341 < m_numZones); REQUIRE(0 <= ___2977 && ___2977 < ___2337->zoneGetNumPartitions(zone + 1)); ___4636 const fileZone = zone - ___341; boost::shared_ptr<___1881> zoneInfo = m_ijkZonePartitionInfos[fileZone][___2977]; if (!zoneInfo) { ___1844 ___1843; ___2337->zonePartitionGetIJK(zone + 1, ___2977 + 1, ___1843); ___1844 partitionOffset; ___2337->zonePartitionGetIJKOffset(zone + 1, ___2977 + 1, partitionOffset); ___1844 partitionMaxCorner = ___1843 + partitionOffset; ___1844 ___4632; ___2337->___4615(zone + 1, ___4632); zoneInfo = boost::make_shared<___1881> (___1843, m_maxIJKSubzoneSize, ___2977, true, partitionMaxCorner.i() == ___4632.i(), partitionMaxCorner.___2105() == ___4632.___2105(), partitionMaxCorner.___2134() == ___4632.___2134()); m_ijkZonePartitionInfos[fileZone][___2977] = zoneInfo; storeForSharedPartitions(m_ijkZonePartitionInfos, zoneInfo, zone, ___341, ___2977); } zoneInfo->resetNeighborInfo(); return zoneInfo; } boost::shared_ptr<___1350> ZoneInfoCache::getFEZoneInfo( ___4636 zone,
___4636 ___341) { REQUIRE(0 <= zone && ___2337->___4638(zone + 1)); REQUIRE(!___4641(*___2337, zone) && !___4643(*___2337, zone) && !zoneIsPartitioned(*___2337, zone)); REQUIRE(0 <= ___341 && ___341 <= zone && zone-___341 < m_numZones); ___4636 const fileZone = zone - ___341; boost::shared_ptr<___1350> zoneInfo = m_feZoneInfos[fileZone]; if (!zoneInfo) { ___1844 ___1843; ___2337->___4615(zone + 1, ___1843); ___465 ___2781 = static_cast<___465>(___1843.___2105()); ___2718 ___2821 = static_cast<___2718>(___1843.i()); ___682 ___2789 = static_cast<___682>(___1843.___2134()); boost::shared_ptr<FESubzonePartitionerInterface> partitioner; if (___3894(___2337->___4620(zone + 1))) partitioner = boost::make_shared<OrbFESubzonePartitioner>(boost::ref(*___2337), zone, m_feSubzoneSize, m_sortFENodesAndCells); else partitioner = boost::make_shared<NoOpFESubzonePartitioner>(boost::ref(*___2337), zone); zoneInfo = boost::make_shared<___1350>(___2781, ___2821, ___2789, partitioner, static_cast<___2090::___2980>(zone)); m_feZoneInfos[fileZone] = zoneInfo; storeForSharedZones(m_feZoneInfos, zoneInfo, zone, ___341); } zoneInfo->resetNeighborInfo(); return zoneInfo; } boost::shared_ptr<___1350> ZoneInfoCache::getFEZonePartitionInfo( ___4636 zone, ___4636 ___341, ___4636 ___2977, PartitionTecUtilDecorator& partitionTecUtilDecorator) { REQUIRE(0 <= zone && ___2337->___4638(zone + 1)); REQUIRE(!___4641(*___2337, zone) && !___4643(*___2337, zone) && zoneIsPartitioned(*___2337, zone)); REQUIRE(0 <= ___341 && ___341 <= zone && zone-___341 < m_numZones); REQUIRE(0 <= ___2977 && ___2977 < ___2337->zoneGetNumPartitions(zone + 1)); ___4636 const fileZone = zone - ___341; boost::shared_ptr<___1350> zoneInfo = m_feZonePartitionInfos[fileZone][___2977]; if (!zoneInfo) { ___1844 ___1843; ___2337->zonePartitionGetIJK(zone + 1, ___2977 + 1, ___1843); ___465 ___2781 = static_cast<___465>(___1843.___2105()); ___2718 ___2821 = static_cast<___2718>(___1843.i()); ___682 ___2789 = static_cast<___682>(___1843.___2134()); ___465 numGhostCells = 0; GhostInfo_pa ghostCellInfo = ___2337->zonePartitionGhostCellInfoGetRef(zone + 1, ___2977 + 1); if (ghostCellInfo) numGhostCells = static_cast<___465>(___2337->ghostInfoGetNumItemsByRef(ghostCellInfo)); ___2718 numGhostNodes = 0; GhostInfo_pa ghostNodeInfo = ___2337->zonePartitionGhostNodeInfoGetRef(zone + 1, ___2977 + 1); if (ghostNodeInfo) numGhostNodes = static_cast<___465>(___2337->ghostInfoGetNumItemsByRef(ghostNodeInfo)); boost::shared_ptr<FESubzonePartitionerInterface> partitioner = boost::make_shared<OrbFESubzonePartitioner>(boost::ref(partitionTecUtilDecorator), ___2977, m_feSubzoneSize, m_sortFENodesAndCells); zoneInfo = boost::make_shared<___1350>(___2781, ___2821, ___2789, partitioner, ___2977, numGhostCells, numGhostNodes); m_feZonePartitionInfos[fileZone][___2977] = zoneInfo; storeForSharedPartitions(m_feZonePartitionInfos, zoneInfo, zone, ___341, ___2977); } zoneInfo->resetNeighborInfo(); return zoneInfo; } void ZoneInfoCache::remove( ___4636 zone, ___4636 ___341) { REQUIRE(0 <= ___341 && ___341 <= zone && zone-___341 < m_numZones); ___4636 const fileZone = zone - ___341; m_ijkZoneInfos[fileZone].reset(); m_feZoneInfos[fileZone].reset(); BOOST_FOREACH(boost::shared_ptr<___1881>& entry, m_ijkZonePartitionInfos[fileZone]) entry.reset(); BOOST_FOREACH(boost::shared_ptr<___1350>& entry, m_feZonePartitionInfos[fileZone]) entry.reset(); } void ZoneInfoCache::clear() { m_ijkZoneInfos.clear(); m_feZoneInfos.clear(); m_ijkZonePartitionInfos.clear(); m_feZonePartitionInfos.clear(); } void ZoneInfoCache::replaceDataSource(___37* ___36) { ___2337 = ___36; } }}
