#include "stdafx.h"
#include "MASTER.h"
 #define ARRLISTMODULE
#include "GLOBAL.h"
#include "TASSERT.h"
#include "ALLOC.h"
#include "ARRLIST.h"
static void CopyArrayItems(char*       TargetArray, ___2227   TargetOffset, char*       SourceArray, ___2227   SourceOffset, ___2227   ___684, int32_t ___2102) { REQUIRE(VALID_REF(TargetArray)); REQUIRE(TargetOffset >= 0); REQUIRE(VALID_REF(SourceArray)); REQUIRE(SourceOffset >= 0); REQUIRE(&TargetArray[TargetOffset] != &SourceArray[SourceOffset]); REQUIRE(___684 >= 1); REQUIRE(1 <= ___2102 && ___2102 <= static_cast<int32_t>(sizeof(ArrayListItem_u))); void* TargetPtr = &TargetArray[TargetOffset * ___2102]; void* SourcePtr = &SourceArray[SourceOffset * ___2102]; memmove(TargetPtr, SourcePtr, static_cast<size_t>(___684) * ___2102); } static ___2227 AdjustCapacityRequest(___134 ASSERT_ONLY(___94), ___2227    ___693, ___2227    ___3354, ___90   ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE((___3354 == 0 && ___693 == 0) || ___3354 > ___693); ___4278(___494); ___2227 ___3359; if (___3354 != 0 && ___693 == 0) { ___3359 = ___3354; } else { ___2227 const DEFAULT_CAPACITY = 32; ___2227       BlockSize = MAX(DEFAULT_CAPACITY, ___693 / 2); if (___3354 == 0) ___3359 = DEFAULT_CAPACITY; else ___3359 = ((___3354 - 1) / BlockSize + 1) * BlockSize; } ENSURE(___3359 == 0 || ___3359 >= ___3354); return ___3359; } static int32_t GetElementSize(ArrayListType_e ___4236) { REQUIRE(VALID_ENUM(___4236, ArrayListType_e)); int32_t ___3359; switch (___4236) { case ArrayListType_UInt8: ___3359 = static_cast<int32_t>(sizeof(uint8_t)); break; case ArrayListType_UInt16: ___3359 = static_cast<int32_t>(sizeof(uint16_t)); break; case ArrayListType_UInt32: ___3359 = static_cast<int32_t>(sizeof(uint32_t)); break; case ArrayListType_UInt64: ___3359 = static_cast<int32_t>(sizeof(uint64_t)); break; case ArrayListType_Int64: ___3359 = static_cast<int32_t>(sizeof(int64_t)); break; case ArrayListType_Char: ___3359 = static_cast<int32_t>(sizeof(char)); break; case ArrayListType_Short: ___3359 = static_cast<int32_t>(sizeof(short)); break; case ArrayListType_Int: ___3359 = static_cast<int32_t>(sizeof(int)); break; case ArrayListType_Long: ___3359 = static_cast<int32_t>(sizeof(long)); break; case ArrayListType_Float: ___3359 = static_cast<int32_t>(sizeof(float)); break; case ArrayListType_Double: ___3359 = static_cast<int32_t>(sizeof(double)); break; case ArrayListType_LgIndex: ___3359 = static_cast<int32_t>(sizeof(___2227)); break; case ArrayListType_EntIndex: ___3359 = static_cast<int32_t>(sizeof(___1172)); break; case ArrayListType_SmInteger: ___3359 = static_cast<int32_t>(sizeof(int32_t)); break; case ArrayListType_Boolean: ___3359 = static_cast<int32_t>(sizeof(___372)); break; case ArrayListType_ArbParam: ___3359 = static_cast<int32_t>(sizeof(___90)); break; case ArrayListType_UInt8Ptr: ___3359 = static_cast<int32_t>(sizeof(uint8_t*)); break; case ArrayListType_UInt16Ptr: ___3359 = static_cast<int32_t>(sizeof(uint16_t*)); break; case ArrayListType_UInt32Ptr: ___3359 = static_cast<int32_t>(sizeof(uint32_t*)); break; case ArrayListType_UInt64Ptr: ___3359 = static_cast<int32_t>(sizeof(uint64_t*)); break; case ArrayListType_Int64Ptr: ___3359 = static_cast<int32_t>(sizeof(int64_t*)); break; case ArrayListType_CharPtr: ___3359 = static_cast<int32_t>(sizeof(char*)); break; case ArrayListType_ShortPtr: ___3359 = static_cast<int32_t>(sizeof(short*)); break; case ArrayListType_IntPtr: ___3359 = static_cast<int32_t>(sizeof(int*)); break; case ArrayListType_LongPtr: ___3359 = static_cast<int32_t>(sizeof(long*)); break; case ArrayListType_FloatPtr: ___3359 = static_cast<int32_t>(sizeof(float*)); break; case ArrayListType_DoublePtr: ___3359 = static_cast<int32_t>(sizeof(double*)); break; case ArrayListType_LgIndexPtr: ___3359 = static_cast<int32_t>(sizeof(___2227*)); break; case ArrayListType_EntIndexPtr: ___3359 = static_cast<int32_t>(sizeof(___1172*)); break; case ArrayListType_SmIntegerPtr: ___3359 = static_cast<int32_t>(sizeof(int32_t*)); break; case ArrayListType_BooleanPtr: ___3359 = static_cast<int32_t>(sizeof(___372*)); break; case ArrayListType_ArbParamPtr: ___3359 = static_cast<int32_t>(sizeof(___90*)); break; case ArrayListType_VoidPtr: ___3359 = static_cast<int32_t>(sizeof(void*)); break; case ArrayListType_FunctionPtr: ___3359 = static_cast<int32_t>(sizeof(void (*)())); break; case ArrayListType_Any: ___3359 = static_cast<int32_t>(sizeof(ArrayListItem_u)); break; default: ___3359 = 0; ___478(___1305); break; } ENSURE(1 <= ___3359 && ___3359 <= static_cast<int32_t>(sizeof(ArrayListItem_u))); return ___3359; } static void DestroyItems(___134               ___94, ___2227                  ___2097, int32_t                ___2102, ___2227                  ___684, ArrayListItemDestructor_pf ___2094, ___90                 ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); REQUIRE(1 <= ___684 && ___2097 + ___684 <= ___94->___684);
REQUIRE(VALID_FN_REF(___2094)); for (___2227 ___1926 = 0; ___1926 < ___684; ___1926++) { ___2227 ___2096 = (___1926 + ___2097) * ___2102; ASSERT_ONLY(___372 CHECK_DoContinue =) ___2094(static_cast<void*>(&___94->Array[___2096]), ___494); ___478(CHECK_DoContinue); } } static ___372 DuplicateItems(char*                      TargetArray, ___2227                  TargetItemOffset, char*                      SourceArray, ___2227                  SourceItemOffset, int32_t                ___2102, ___2227                  ___684, ArrayListItemDuplicator_pf ___2095, ___90                 ___494) { REQUIRE(VALID_REF(TargetArray)); REQUIRE(TargetItemOffset >= 0); REQUIRE(VALID_REF(SourceArray)); REQUIRE(SourceItemOffset >= 0); REQUIRE(1 <= ___2102 && ___2102 <= (int32_t)sizeof(ArrayListItem_u)); REQUIRE(___684 >= 1); REQUIRE(VALID_FN_REF(___2095)); ___372 ___2040 = ___4226; for (___2227 ___1926 = 0; ___1926 < ___684 && ___2040; ___1926++) { ___2227 TargetItemIndex = (___1926 + TargetItemOffset) * ___2102; ___2227 SourceItemIndex = (___1926 + SourceItemOffset) * ___2102; ___2040 = ___2095(static_cast<void*>(&TargetArray[TargetItemIndex]), static_cast<void*>(&SourceArray[SourceItemIndex]), ___494); } ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___372 ArrayListIsValid(___134 ___94) { ___372 ___2068 = (VALID_REF(___94) && VALID_ENUM(___94->___4236, ArrayListType_e) && (1 <= ___94->___2102 && ___94->___2102 <= static_cast<int32_t>(sizeof(ArrayListItem_u))) && (0 <= ___94->___684 && ___94->___684 <= ___94->___439)); ENSURE(VALID_BOOLEAN(___2068)); return ___2068; } ArrayListType_e ArrayListGetType(___134 ___94) { REQUIRE(ArrayListIsValid(___94)); ArrayListType_e ___3359 = ___94->___4236; ENSURE(VALID_ENUM(___3359, ArrayListType_e)); return ___3359; } ___372 ArrayListEnlargeCapacity(___134 ___94, ___2227    ___3354) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(IMPLICATION(___3354 == 0, ___94->___439 == 0)); ___372 ___2040; if (___3354 == 0 || ___3354 > ___94->___439) { ___2227 AdjustedCapacity = ___94->___440(___94, ___94->___439, ___3354, ___94->___441); ___478(AdjustedCapacity == 0 || AdjustedCapacity >= ___3354); char* EnlargedArray = NULL; ___2040 = (AdjustedCapacity != 0); if (___2040) { EnlargedArray = ___23(AdjustedCapacity * ___94->___2102, char, "array list"); if (EnlargedArray == NULL) { if (___3354 != 0) AdjustedCapacity = ___3354; else AdjustedCapacity = 1; EnlargedArray = ___23(AdjustedCapacity * ___94->___2102, char, "array list"); } ___2040 = (EnlargedArray != NULL); } if (___2040) { memset(&EnlargedArray[___94->___684*___94->___2102], 0, (AdjustedCapacity - ___94->___684)*___94->___2102); if (___94->Array != NULL) { if (___94->___684 != 0) CopyArrayItems(EnlargedArray, 0, ___94->Array, 0, ___94->___684, ___94->___2102); ___1530(___94->Array, "array list"); } ___94->Array    = EnlargedArray; ___94->___439 = AdjustedCapacity; } } else { ___2040 = ___4226; } ENSURE(ArrayListIsValid(___94)); ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___134 ArrayListAlloc(___2227                           ___1188, ArrayListType_e                     ___4236, ArrayListCapacityRequestAdjuster_pf ___440, ___90                          ___441) { REQUIRE(___1188 >= 0); REQUIRE(VALID_ENUM(___4236, ArrayListType_e)); ___134 ___3359 = ALLOC_ITEM(___135, "ArrayList structure"); if (___3359 != NULL) { ___3359->Array           = NULL; ___3359->___4236            = ___4236; ___3359->___2102        = GetElementSize(___4236); ___3359->___684           = 0; ___3359->___439        = 0; ___3359->___2080 = ___1305; if (___440 != NULL) { ___3359->___440           = ___440; ___3359->___441 = ___441; } else { ___3359->___440           = AdjustCapacityRequest; ___3359->___441 = 0; } if (!ArrayListEnlargeCapacity(___3359, ___1188)) ArrayListDealloc(&___3359, NULL, 0); } ENSURE(ArrayListIsValid(___3359) || ___3359 == NULL); ENSURE(IMPLICATION(___3359 != NULL, ___3359->___439 >= ___1188)); return ___3359; } void ArrayListDealloc(___134*              ___94, ArrayListItemDestructor_pf ___2094, ___90                 ___494) { REQUIRE(VALID_REF(___94)); REQUIRE(ArrayListIsValid(*___94) || *___94 == NULL); REQUIRE(VALID_FN_REF(___2094) || ___2094 == NULL); if (*___94 != NULL) { if (___2094 != NULL && (*___94)->___684 != 0) DestroyItems(*___94, 0, (*___94)->___2102, (*___94)->___684, ___2094, ___494); if ((*___94)->___439 != 0)
___1530((*___94)->Array, "array list"); ___1531(*___94, "ArrayList structure"); *___94 = NULL; } ENSURE(*___94 == NULL); }
 #if !defined USE_MACROS_FOR_FUNCTIONS
___2227 ArrayListGetCount_FUNC(___134 ___94) { REQUIRE(ArrayListIsValid(___94)); ___2227 ___3359 = ArrayListGetCount_MACRO(___94); ENSURE(___3359 >= 0); return ___3359; }
 #endif
void ArrayListDeleteAllItems(___134               ___94, ArrayListItemDestructor_pf ___2094, ___90                 ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(VALID_FN_REF(___2094) || ___2094 == NULL); REQUIRE(!___94->___2080); if (___2094 != NULL && ___94->___684 != 0) DestroyItems(___94, 0, ___94->___2102, ___94->___684, ___2094, ___494); if (___94->___684 != 0) memset(&___94->Array[0], 0, ___94->___684*___94->___2102); ___94->___684 = 0; ENSURE(ArrayListIsValid(___94) && ___94->___684 == 0); } void ArrayListDeleteItems(___134               ___94, ___2227                  ___2097, ___2227                  ___684, ArrayListItemDestructor_pf ___2094, ___90                 ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); REQUIRE(1 <= ___684 && ___2097 + ___684 <= ___94->___684); REQUIRE(VALID_FN_REF(___2094) || ___2094 == NULL); REQUIRE(!___94->___2080); if (___2094 != NULL) DestroyItems(___94, ___2097, ___94->___2102, ___684, ___2094, ___494); if (___2097 + ___684 < ___94->___684) CopyArrayItems(___94->Array, ___2097, ___94->Array, ___2097 + ___684, ___94->___684 - (___2097 + ___684), ___94->___2102); memset(&___94->Array[(___94->___684 - ___684)*___94->___2102], 0, ___684*___94->___2102); ___94->___684 -= ___684; ENSURE(ArrayListIsValid(___94)); } void ArrayListDeleteItem(___134               ___94, ___2227                  ___2097, ArrayListItemDestructor_pf ___2094, ___90                 ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); REQUIRE(VALID_FN_REF(___2094) || ___2094 == NULL); ArrayListDeleteItems(___94, ___2097, 1, ___2094, ___494); ENSURE(ArrayListIsValid(___94)); } ___134 ArrayListRemoveItems(___134 ___94, ___2227    ___2097, ___2227    ___684) { ___134 ___3359; REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); REQUIRE(1 <= ___684 && ___2097 + ___684 <= ___94->___684); REQUIRE(!___94->___2080); ___3359 = ArrayListGetItems(___94, ___2097, ___684); if (___3359 != NULL) ArrayListDeleteItems(___94, ___2097, ___684, NULL, 0); ENSURE(ArrayListIsValid(___94)); ENSURE(ArrayListIsValid(___3359) || ___3359 == NULL); return ___3359; } ArrayListItem_u ArrayListRemoveItem(___134 ___94, ___2227    ___2097) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); REQUIRE(!___94->___2080); ArrayListItem_u ___3359; CopyArrayItems(static_cast<char*>(&___3359.___472), 0, ___94->Array, ___2097, 1, ___94->___2102); ArrayListDeleteItems(___94, ___2097, 1, NULL, 0); ENSURE(ArrayListIsValid(___94)); return ___3359; } ___372 ArrayListInsert(___134 ___3946, ___2227    ___2097, ___134 ___3642) { REQUIRE(ArrayListIsValid(___3946)); REQUIRE(___2097 >= 0); REQUIRE(ArrayListIsValid(___3642)); REQUIRE(___3946 != ___3642); REQUIRE(___3946->___4236 == ___3642->___4236); REQUIRE(!___3946->___2080); ___372 ___2040 = ___4226; if (___3642->___684 != 0) { ___2227 NeededCapacity; if (___2097 > ___3946->___684) NeededCapacity = ___2097 + ___3642->___684; else NeededCapacity = ___3946->___684 + ___3642->___684; if (NeededCapacity > ___3946->___439) ___2040 = ArrayListEnlargeCapacity(___3946, NeededCapacity); if (___2040) { if (___2097 < ___3946->___684) { CopyArrayItems(___3946->Array, ___2097 + ___3642->___684, ___3946->Array, ___2097, ___3946->___684 - ___2097, ___3946->___2102); ___3946->___684 += ___3642->___684; } else { if (___2097 > ___3946->___684) ___3946->___684 = ___2097 + ___3642->___684; else ___3946->___684 += ___3642->___684; } CopyArrayItems(___3946->Array, ___2097, ___3642->Array, 0, ___3642->___684, ___3642->___2102); } } ENSURE(ArrayListIsValid(___3946)); ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___372 ArrayListInsertItem(___134    ___94, ___2227       ___2097, ArrayListItem_u ___2086) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(___2097 >= 0); REQUIRE(!___94->___2080); ___372 ___2040 = ___4226; ___2227 NeededCapacity; if (___2097 > ___94->___684) NeededCapacity = ___2097 + 1; else NeededCapacity = ___94->___684 + 1; if (NeededCapacity > ___94->___439) ___2040 = ArrayListEnlargeCapacity(___94, NeededCapacity); if (___2040) { if (___2097 < ___94->___684) { CopyArrayItems(___94->Array, ___2097 + 1, ___94->Array, ___2097, ___94->___684 - ___2097, ___94->___2102); ___94->___684++; } else { if (___2097 > ___94->___684) ___94->___684 = ___2097 + 1; else ___94->___684++; } CopyArrayItems(___94->Array, ___2097,
static_cast<char*>(&___2086.___472), 0, 1, ___94->___2102); } ENSURE(ArrayListIsValid(___94)); ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___372 ArrayListVisitItems(___134            ___94, ___2227               ___2097, ___2227               ___684, ArrayListItemVisitor_pf ___2103, ___90              ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(VALID_FN_REF(___2103)); ___372 ___2080 = ___94->___2080; ___94->___2080 = ___4226; ___2227   ___1926; int32_t ___2102; ___372   ___1096 = ___4226; for (___1926 = 0, ___2102 = ___94->___2102; ___1926 < ___684 && ___1096; ___1926++) { ___2227 ___2096 = (___1926 + ___2097) * ___2102; ___1096 = ___2103(static_cast<void*>(&___94->Array[___2096]), ___494); } ___94->___2080 = ___2080; ENSURE(___94->___2080 == ___2080); ENSURE(VALID_BOOLEAN(___1096)); return ___1096; } ___134 ArrayListGetItems(___134 ___94, ___2227    ___2097, ___2227    ___684) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); REQUIRE(1 <= ___684 && ___2097 + ___684 <= ___94->___684); ___134 ___3359 = ArrayListAlloc(___684, ___94->___4236, ___94->___440, ___94->___441); if (___3359 != NULL) { CopyArrayItems(___3359->Array, 0, ___94->Array, ___2097, ___684, ___94->___2102); ___3359->___684 = ___684; } ENSURE(ArrayListIsValid(___94)); ENSURE(ArrayListIsValid(___3359) || ___3359 == NULL); return ___3359; } ArrayListItem_u ArrayListGetItem(___134 ___94, ___2227    ___2097) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); ArrayListItem_u ___3359; CopyArrayItems(static_cast<char*>(&___3359.___472), 0, ___94->Array, ___2097, 1, ___94->___2102); return ___3359; }
 #if !defined USE_MACROS_FOR_FUNCTIONS
void const* ArrayListGetItemInternalRef_FUNC(___134 ___94, ___2227    ___2097) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(0 <= ___2097 && ___2097 <= ___94->___684 - 1); void const* ___3359 = ArrayListGetItemInternalRef_MACRO(___94, ___2097); ENSURE(___3359 == NULL || VALID_REF(___3359)); return ___3359; }
 #endif
___372 ArrayListSetItem(___134               ___94, ___2227                  ___2097, ArrayListItem_u            ___2086, ArrayListItemDestructor_pf ___2094, ___90                 ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(___2097 >= 0); REQUIRE(VALID_FN_REF(___2094) || ___2094 == NULL); REQUIRE(IMPLICATION(___2097 + 1 > ___94->___684, !___94->___2080)); ___372 ___2040 = ___4226; if (___2094 != NULL && ___2097 < ___94->___684) DestroyItems(___94, ___2097, ___94->___2102, 1, ___2094, ___494); if (___2097 + 1 > ___94->___439) ___2040 = ArrayListEnlargeCapacity(___94, ___2097 + 1); if (___2040) { if (___2097 + 1 > ___94->___684) ___94->___684 = ___2097 + 1; CopyArrayItems(___94->Array, ___2097, static_cast<char*>(&___2086.___472), 0, 1, ___94->___2102); } ENSURE(ArrayListIsValid(___94)); ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___372 ArrayListAppendItem(___134    ___94, ArrayListItem_u ___2086) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(!___94->___2080); ___372 ___2040 = ArrayListInsertItem(___94, ___94->___684, ___2086); ENSURE(ArrayListIsValid(___94)); ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___372 ArrayListAppend(___134 ___3946, ___134 ___3642) { REQUIRE(ArrayListIsValid(___3946)); REQUIRE(ArrayListIsValid(___3642)); REQUIRE(___3946 != ___3642); REQUIRE(___3946->___4236 == ___3642->___4236); REQUIRE(!___3946->___2080); ___372 ___2040 = ArrayListInsert(___3946, ___3946->___684, ___3642); ENSURE(ArrayListIsValid(___3946)); ENSURE(VALID_BOOLEAN(___2040)); return ___2040; } ___134 ArrayListCopy(___134               ___94, ArrayListItemDuplicator_pf ___2095, ___90                 ___494) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(VALID_FN_REF(___2095) || ___2095 == NULL); ___134 ___3359 = ArrayListAlloc(___94->___684, ___94->___4236, ___94->___440, ___94->___441); if (___3359 != NULL && ___94->___684 != 0) { ___372 ___2040 = ___4226; if (___2095 != NULL) ___2040 = DuplicateItems(___3359->Array, 0, ___94->Array, 0, ___94->___2102, ___94->___684, ___2095, ___494); else CopyArrayItems(___3359->Array, 0, ___94->Array, 0, ___94->___684, ___94->___2102); if (___2040) ___3359->___684 = ___94->___684; else ArrayListDealloc(&___3359, NULL, 0); } ENSURE(___3359 == NULL || (ArrayListIsValid(___3359) && ___3359->___684 == ___94->___684)); return ___3359; } void* ArrayListToArray(___134               ___3642, ArrayListItemDuplicator_pf ___2095, ___90                 ___494) { REQUIRE(ArrayListIsValid(___3642)); REQUIRE(VALID_FN_REF(___2095) || ___2095 == NULL); void* ___3359; if (___3642->___684 != 0) ___3359 = static_cast<void*>(___23(___3642->___684 * ___3642->___2102, char, "native array")); else ___3359 = NULL; if (___3359 != NULL) { ___372 ___2040 = ___4226; if (___2095 != NULL) ___2040 = DuplicateItems((char*)___3359, 0, ___3642->Array, 0, ___3642->___2102, ___3642->___684, ___2095, ___494); else CopyArrayItems(static_cast<char*>(___3359), 0, ___3642->Array, 0, ___3642->___684, ___3642->___2102); if (!___2040) { char* Tmp = static_cast<char*>(___3359); ___1530(Tmp, "native array"); } } ENSURE(VALID_REF(___3359) || ___3359 == NULL); return ___3359; } ___134 ArrayListFromArray(void*                      ___3642, ___2227                  ___684, ArrayListType_e            ___4236, ArrayListItemDuplicator_pf ___2095, ___90                 ___494) { REQUIRE(VALID_REF(___3642)); REQUIRE(___684 >= 0); REQUIRE(VALID_ENUM(___4236, ArrayListType_e)); REQUIRE(VALID_FN_REF(___2095) || ___2095 == NULL); ___134 ___3359 = ArrayListAlloc(___684, ___4236, NULL, 0); if (___3359 != NULL && ___684 != 0) { ___372 ___2040 = ___4226; if (___2095 != NULL) ___2040 = DuplicateItems(___3359->Array, 0, (char*)___3642, 0, ___3359->___2102, ___684, ___2095, ___494); else CopyArrayItems(___3359->Array, 0, static_cast<char*>(___3642), 0, ___684, ___3359->___2102); if (___2040) ___3359->___684 = ___684; else ArrayListDealloc(&___3359, NULL, 0); } ENSURE(ArrayListIsValid(___3359) || ___3359 == NULL); return ___3359; } ___372 ArrayListBSearch(___134               ___94, ArrayListItem_u            ___2086, ArrayListItemComparator_pf ___535, ___90                 ___494, ___2227*                 ___2096) { REQUIRE(ArrayListIsValid(___94)); REQUIRE(VALID_FN_REF(___535)); REQUIRE(___2096 == NULL || VALID_REF(___2096)); ___2227 MiddleItemIndex = 0; ___2227 FirstItemIndex  = 0; ___2227 NumItems        = ___101(___94); ___2227 LastItemIndex   = NumItems - 1; ___372 Found = ___1305; while (FirstItemIndex <= LastItemIndex && !Found) { MiddleItemIndex = (FirstItemIndex + LastItemIndex) / 2; int CompareResult = ___535(ArrayListGetItem(___94, MiddleItemIndex), ___2086, ___494);
if (CompareResult > 0) LastItemIndex = MiddleItemIndex - 1; else if (CompareResult < 0) FirstItemIndex = MiddleItemIndex + 1; else Found = ___4226; } if (___2096 != NULL) { if (Found || NumItems == 0 || FirstItemIndex < NumItems) *___2096 = MiddleItemIndex; else *___2096 = NumItems; } ENSURE(IMPLICATION(___2096 != NULL, 0 <= *___2096 && *___2096 <= ___101(___94))); ENSURE(VALID_BOOLEAN(Found)); return Found; }
 #if !defined USE_MACROS_FOR_FUNCTIONS
void const* ArrayListGetInternalRef_FUNC(___134 ___94) { REQUIRE(ArrayListIsValid(___94)); void const* ___3359 = ___113(___94); ENSURE(___3359 == NULL || VALID_REF(___3359)); return ___3359; }
 #endif
