#include "ThirdPartyHeadersBegin.h"
#include <float.h>
#include <algorithm>
#include <cctype>
#include <limits>
 #if defined DO_SUBZONE_HISTOGRAM || defined DO_ITEMANDSUBZONE_HISTOGRAM
#include <set>
 #endif
#include <sstream>
#include <stdexcept>
#include <string>
#include <boost/assign.hpp>
 #if !defined TECIOMPI
#include <boost/atomic.hpp>
 #endif
#include <boost/foreach.hpp>
#include <boost/make_shared.hpp>
#include <boost/ref.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include "ThirdPartyHeadersEnd.h"
#include "exportSubzonePlt.h"
#include "AltTecUtil.h"
#include "FEZoneInfo.h"
#include "fileStuff.h"
#include "FileStreamWriter.h"
#include "IJKZoneInfo.h"
#include "ItemSetIterator.h"
 #if defined DO_SUBZONE_HISTOGRAM || defined DO_ITEMANDSUBZONE_HISTOGRAM
#include "FileSystem.h"
#include "ItemAddress.h"
#include "NodeMap.h"
 #endif
#include "writeValueArray.h"
#include "ZoneInfoCache.h"
#include "zoneUtil.h"
#include "ZoneVarMetadata.h"
#include "ZoneWriterAbstract.h"
#include "ZoneWriterFactory.h"
 #define HEADER_STRING_FORMAT "%-14s"
 #define SZPLT_REVISION "$Revision: 1.1.2.1 $"
namespace tecplot { namespace ___3933 { namespace { char ___849(DataFileType_e ___844) { REQUIRE(VALID_ENUM(___844, DataFileType_e)); if (___844 == ___845) return 'F'; else if (___844 == ___846) return 'G'; else return 'S'; } } namespace { ___372 ___4516( FileWriterInterface& file, char const*    ___1407, uint32_t const fileVersion, ___372      includeRevisionNumber, uint64_t       dataSetHeaderLocation) { ___372 ___2039 = ___4226; try { size_t const headerBufferSize = 128; char headerBuffer[headerBufferSize]; ___2039 = snprintf(headerBuffer, headerBufferSize, "#!%s %3.3" PRIu32 "%c%c", ___1407, fileVersion, file.___2002() ? 'T' : 'B', ___849(file.___844())) < static_cast<int>(headerBufferSize); std::string header(headerBuffer); if (includeRevisionNumber) header.append(" ").append(SZPLT_REVISION); ___2039 = ___2039 && file.fprintf(HEADER_STRING_FORMAT"\r\n", header.c_str()) >= SZPLT_FILE_HEADER_MIN_SIZE      && writeValue<uint64_t, true, 0>(file, ___1386, ___1385) && writeValue<uint64_t, true, 0>(file, ___895, dataSetHeaderLocation); } catch (std::bad_alloc const&) { ___2039 = ___1305; } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4515( FileWriterInterface& file, char const*          ___1407, uint32_t const       fileVersion, ___372            includeRevisionNumber, ___3945 const&   headerTagMap) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(VALID_NON_ZERO_LEN_STR(___1407) && strlen(___1407) <= 7); REQUIRE(fileVersion <= 999); ___3942 tagDescriptionMap = ___1406; uint64_t dataSetHeaderLocation = 0; ___2039 = ___2039 && ___4516(file, ___1407, fileVersion, includeRevisionNumber, dataSetHeaderLocation); dataSetHeaderLocation = file.fileLoc(); ___2039 = ___2039 && file.___3460() && ___4516(file, ___1407, fileVersion, includeRevisionNumber, dataSetHeaderLocation); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___2839, static_cast<uint16_t>(headerTagMap.size())); UInt16Array tagArray; ___2039 = ___2039 && tagArray.alloc(headerTagMap.size()); if (___2039) { size_t numTags = 0; BOOST_FOREACH(___3945::value_type const& ___4314, headerTagMap) tagArray[numTags++] = ___4314.first; ___2039 = ___2039 && ___4563<uint16_t, false, 0>(file, ___3943, ___2745, numTags, &tagArray[0]); } BOOST_FOREACH(___3945::value_type const& ___4314, headerTagMap) ___2039 = ___2039 && writeValue<uint64_t, true, 0>(file, tagDescriptionMap[___4314.first].c_str(), ___4314.second); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 writePerDataSetFileHeader( FileWriterInterface& szpltFile, ___3945&         ___3944, char const*          dataSetTitle) { REQUIRE(szpltFile.___2041()); REQUIRE(VALID_REF(dataSetTitle)); ___3944[DATA_SET_TITLE_TAG] = szpltFile.fileLoc(); uint32_t dataSetTitleLength = static_cast<uint32_t>(strlen(dataSetTitle)); ___372 ___2039 = writeValue<uint32_t, false, 0>(szpltFile, DATA_SET_TITLE_LENGTH, dataSetTitleLength) && ___4544(szpltFile, DATA_SET_TITLE_DESCRIPTION, dataSetTitle); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4545( FileWriterInterface& file, char const*          ___972, size_t               ___2812, ___3816 const&   itemNames) { REQUIRE(file.___2041()); REQUIRE(VALID_DESCRIPTION(___972)); REQUIRE(___2812>0); REQUIRE(itemNames.size() == ___2812); uint64_t totalStringListSize = 0; if (file.___2002()) totalStringListSize = ___206 + 2; for (size_t ___2085 = 0; ___2085 < ___2812; ___2085++) { totalStringListSize += itemNames[___2085].size(); if (file.___2002()) totalStringListSize += 2; else totalStringListSize += 1; } if (___972) { char ___1418[___206 + 1]; sprintf(___1418, "%sTotalSize", ___972); writeValue<uint64_t, false, 0>(file, ___1418, totalStringListSize); } else writeValue<uint64_t, false, 0>(file, NULL , totalStringListSize); ___372 ___2039 = ___4226; if (file.___2002()) { ___2039 = ___2039 && (file.fprintf("%*s\r\n", -___206, ___972) != 0); for (size_t ___2085 = 0; ___2085 < ___2812; ___2085++) ___2039 = ___2039 && (file.fprintf("%s\r\n", itemNames[___2085].c_str()) != 0); } else { for (size_t ___2085 = 0; ___2085 < ___2812; ___2085++) ___2039 = ___2039 && (file.fprintf("%s\r", itemNames[___2085].c_str()) != 0); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4541( FileWriterInterface&   file, ___3945&           ___3944, ___4352 const       ___2843, ___4707 const& ___4706) { REQUIRE(file.___2041()); REQUIRE(___4706.m_varNames.size() == size_t(___2843)); ___372 ___2039 = ___4226; if (___2843 > 0) { ___3944[___4365] = file.fileLoc(); ___2039 = ___4545(file, ___4364, ___2843, ___4706.m_varNames);
} ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4543( FileWriterInterface&   file, ___3945&           ___3944, ___4636 const      ___2846, ___1392 const&    ___4629, ___4707 const& ___4706) { REQUIRE(file.___2041()); REQUIRE(___4706.m_zoneNames.size() == size_t(___2846)); ___372 ___2039 = ___4226; if (___2846 > 0) { ___3944[___4651] = file.fileLoc(); ___2039 = ___4545(file, ___4650, ___2846, ___4706.m_zoneNames); ___3944[ZONE_TYPE_FILE_LOC_TAG] = file.fileLoc(); ___2039 = ___2039 && ___4563<char, false, 0>(file, ___4694, ___2745, ___2846, &___4706.m_zoneTypes[0]); ___3944[___4610] = file.fileLoc(); ___2039 = ___2039 && ___4563<uint8_t, false, 0>(file, ___4609, ___2745, ___2846, &___4706.m_zoneFaceNeighborModes[0]); ___3944[___4676] = file.fileLoc(); ___2039 = ___2039 && ___4563<double, false, 0>(file, ___4675, ___2745, ___2846, &___4706.m_zoneSolutionTimes[0]); ___3944[___4686] = file.fileLoc(); ___2039 = ___2039 && ___4563<uint32_t, false, 0>(file, ___4685, ___2745, ___2846, &___4706.m_zoneStrandIDs[0]); ___3944[___4670] = file.fileLoc(); ___2039 = ___2039 && ___4563<int32_t, false, 0>(file, ___4669, ___2745, ___2846, &___4706.m_zoneParentZones[0]); ___3944[ZONE_IMAX_OR_NUM_NODES_FILE_LOC_TAG] = file.fileLoc(); ___2039 = ___2039 && ___4563<uint64_t, false, 0>(file, ZONE_IMAX_OR_NUM_NODES_ARRAY_DESCRIPTION, ___2745, ___2846, &___4706.m_zoneIMaxOrNumNodes[0]); ___3944[ZONE_JMAX_OR_NUM_CELLS_FILE_LOC_TAG] = file.fileLoc(); ___2039 = ___2039 && ___4563<uint64_t, false, 0>(file, ZONE_JMAX_OR_NUM_CELLS_ARRAY_DESCRIPTION, ___2745, ___2846, &___4706.m_zoneJMaxOrNumCells[0]); ___3944[ZONE_KMAX_OR_NUM_CORNERS_FILE_LOC_TAG] = file.fileLoc(); ___2039 = ___2039 && ___4563<uint64_t, false, 0>(file, ZONE_KMAX_OR_NUM_CORNERS_ARRAY_DESCRIPTION, ___2745, ___2846, &___4706.m_zoneKMaxOrNumCorners[0]); ___3944[___4674] = file.fileLoc(); ___2039 = ___2039 && ___4563<int32_t, false, 0>(file, ___4673, ___2745, ___2846, &___4706.m_zoneShareConnectivityWithZone[0]); ___3944[___4630] = file.fileLoc(); ___2039 = ___2039 && ___4563<uint64_t, true, 0>(file, ___4628, ___2745, ___2846, &___4629[0]); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4542( FileWriterInterface&   file, ___3945&           ___3944, ___4352 const       ___2843, ___4636 const      ___2846, ___4707 const& ___4706) { REQUIRE(file.___2041()); if (___2846 == 0 || ___2843 == 0) return ___4226; REQUIRE(___4706.m_vzMinMaxes.size() == size_t(___2843)); REQUIRE(___4706.m_vzMinMaxes[0].size() == size_t(___2846) && ___4706.m_vzMinMaxes[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzMinMaxes[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzValueLocations.size() == size_t(___2843)); REQUIRE(___4706.m_vzValueLocations[0].size() == size_t(___2846) && ___4706.m_vzValueLocations[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzValueLocations[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzFieldDataTypes.size() == size_t(___2843)); REQUIRE(___4706.m_vzFieldDataTypes[0].size() == size_t(___2846) && ___4706.m_vzFieldDataTypes[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzFieldDataTypes[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzIsPassive.size() == size_t(___2843)); REQUIRE(___4706.m_vzIsPassive[0].size() == size_t(___2846) && ___4706.m_vzIsPassive[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzIsPassive[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzShareVarWithZone.size() == size_t(___2843)); REQUIRE(___4706.m_vzShareVarWithZone[0].size() == size_t(___2846) && ___4706.m_vzShareVarWithZone[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzShareVarWithZone[___2843 - 1].size() == size_t(___2846)); ___372 ___2039 = ___4226; ___3944[VAR_ZONE_MIN_MAX_FILE_LOC_TAG] = file.fileLoc(); bool minMaxesMustBeDouble = false; for (___4352 ___4336 = 0; !minMaxesMustBeDouble && ___4336 < ___2843; ++___4336) { for (___4636 zone = 0; !minMaxesMustBeDouble && zone < ___2846; ++zone) { FieldDataType_e ___1363 = (FieldDataType_e)___4706.m_vzFieldDataTypes[___4336][zone]; if (___1363 == FieldDataType_Double || ___1363 == FieldDataType_Int32)
minMaxesMustBeDouble = true; } } for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ++___4336) { if (minMaxesMustBeDouble) ___2039 = ___2039 && ___4528<double>(file, VAR_ZONE_MIN_MAX_ARRAY_DESCRIPTION, ___4336, ___2846, &___4706.m_vzMinMaxes[___4336][0], ___946 / 2); else ___2039 = ___2039 && ___4528<float>(file, VAR_ZONE_MIN_MAX_ARRAY_DESCRIPTION, ___4336, ___2846, &___4706.m_vzMinMaxes[___4336][0], ___946 / 2); } ___3944[___4393] = file.fileLoc(); for (___4352 ___4336 = 0; ___4336 < ___2843; ___4336++) ___2039 = ___2039 && ___4563<uint8_t, false, 0>(file, ___4392, ___4336, ___2846, &___4706.m_vzValueLocations[___4336][0]); ___3944[___4384] = file.fileLoc(); for (___4352 ___4336 = 0; ___4336 < ___2843; ___4336++) ___2039 = ___2039 && ___4563<uint8_t, false, 0>(file, ___4383, ___4336, ___2846, &___4706.m_vzFieldDataTypes[___4336][0]); ___3944[___4387] = file.fileLoc(); for (___4352 ___4336 = 0; ___4336 < ___2843; ___4336++) ___2039 = ___2039 && ___4563<uint8_t, false, 0>(file, ___4386, ___4336, ___2846, &___4706.m_vzIsPassive[___4336][0]); ___3944[___4390] = file.fileLoc(); for (___4352 ___4336 = 0; ___4336 < ___2843; ___4336++) ___2039 = ___2039 && ___4563<int32_t, false, 0>(file, ___4389, ___4336, ___2846, &___4706.m_vzShareVarWithZone[___4336][0]); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4517( FileWriterInterface&          szpltFile, ___372                     includeRevisionNumber, ___37&                   ___36, ___4352                    ___2843, ___4636                   ___2846, ___3945&                  headerTagMap, ___4707 const&        ___4706, ___1392 const&           szpltZoneHeaderFileLocs, ___936& ___935, ___372                     overwriteFiles) { REQUIRE(szpltFile.___2041()); if (___36.___896()) { REQUIRE(___2843>0); REQUIRE(___4706.m_varNames.size() == size_t(___2843)); REQUIRE(___4706.m_varNames[0].size() > 0 && ___4706.m_varNames[___2843 / 2].size() > 0 && ___4706.m_varNames[___2843 - 1].size() > 0); REQUIRE(___2846>0); REQUIRE(___4706.m_zoneNames.size() == size_t(___2846)); REQUIRE(___4706.m_zoneNames[0].size() > 0 && ___4706.m_zoneNames[___2846 / 2].size() > 0 && ___4706.m_zoneNames[___2846 - 1].size() > 0); REQUIRE(szpltZoneHeaderFileLocs.size() == size_t(___2846)); REQUIRE(VALID_FILE_LOC(szpltZoneHeaderFileLocs[0]) && VALID_FILE_LOC(szpltZoneHeaderFileLocs[___2846 / 2]) && VALID_FILE_LOC(szpltZoneHeaderFileLocs[___2846 - 1])); REQUIRE(___4706.m_vzMinMaxes.size() == size_t(___2843)); REQUIRE(___4706.m_vzMinMaxes[0].size() == size_t(___2846) && ___4706.m_vzMinMaxes[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzMinMaxes[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzValueLocations.size() == size_t(___2843)); REQUIRE(___4706.m_vzValueLocations[0].size() == size_t(___2846) && ___4706.m_vzValueLocations[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzValueLocations[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzValueLocations[0][0] < ___4329 && ___4706.m_vzValueLocations[___2843 / 2][___2846 / 2] < ___4329 && ___4706.m_vzValueLocations[___2843 - 1][___2846 - 1] < ___4329); REQUIRE(___4706.m_vzFieldDataTypes.size() == size_t(___2843)); REQUIRE(___4706.m_vzFieldDataTypes[0].size() == size_t(___2846) && ___4706.m_vzFieldDataTypes[___2843 / 2].size() == size_t(___2846) && ___4706.m_vzFieldDataTypes[___2843 - 1].size() == size_t(___2846)); REQUIRE(___4706.m_vzFieldDataTypes[0][0] < ___1369 && ___4706.m_vzFieldDataTypes[___2843 / 2][___2846 / 2] < ___1369 && ___4706.m_vzFieldDataTypes[___2843 - 1][___2846 - 1] < ___1369); } REQUIRE(VALID_BOOLEAN(overwriteFiles)); ___372 ___2039 = ___4226; try { std::string dataSetTitle; if (___36.___896()) { char* ___4177 = 0; ___36.datasetGetTitle(&___4177); dataSetTitle = ___4177; ___36.___3817(&___4177); } if (!overwriteFiles) ___2039 = ___2039 && szpltFile.___3460(); ___2039 = ___2039 && ___4515(szpltFile, SZPLT_FILE_TYPE, SZPLT_CUR_WRITE_VERSION, includeRevisionNumber, headerTagMap); ___2039 = ___2039 && writePerDataSetFileHeader(szpltFile, headerTagMap, dataSetTitle.c_str()); ___2039 = ___2039 && ___4543(szpltFile, headerTagMap, ___2846, szpltZoneHeaderFileLocs, ___4706); ___2039 = ___2039 && ___4541(szpltFile, headerTagMap, ___2843, ___4706);
___2039 = ___2039 && ___4542(szpltFile, headerTagMap, ___2843, ___2846, ___4706);
 #ifdef PROFILE_FILE_ACCESS
if (___2039) { FileStreamWriter* fileWriter = dynamic_cast<FileStreamWriter*>(&szpltFile); if (fileWriter) ___935.___7(fileWriter->statistics().___2780); }
 #else
___4278(___935);
 #endif
} catch(std::bad_alloc const&) { ___2039 = ___1186("Out of memory while writing file header."); } catch(...) { ___2039 = ___1186("Unrecoverable error while writing file header."); } return ___2039; } } namespace { ___372 ___4484( FileWriterInterface& file, uint32_t             numAuxData) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; if (file.___2002()) ___2039 = writeValue<uint32_t, false, 0>(file, SZPLT_AUX_DATA_MARKER_DESCRIPTION, SZPLT_AUX_DATA_MARKER); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___233, numAuxData); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4483( FileWriterInterface& file, ___37&          ___36, ___264           auxData, AuxDataLocation_e    auxDataLocation, ___1172           auxDataEntity, uint32_t&            numItemsWritten) { REQUIRE(file.___2041()); REQUIRE(VALID_REF(auxData)); REQUIRE(VALID_ENUM(auxDataLocation, AuxDataLocation_e)); REQUIRE(auxDataEntity >= 0); int32_t ___2812 = ___36.___247(auxData); numItemsWritten = 0; ___372 ___2039 = ___4226; for (int32_t index = 1; ___2039 && index <= ___2812; ++index) { char* itemName = 0; ___90 itemValue = 0; AuxDataType_e itemType; ___372 ___3361; ___36.___243(auxData, index, &itemName, &itemValue, &itemType, &___3361); ___478(itemType == ___270); if (___3361) { ++numItemsWritten; char const* itemValueString = reinterpret_cast<char const*>(itemValue); ___2039 = (writeValue<uint8_t, false, 0>(file, ___252, static_cast<uint8_t>(auxDataLocation)) && writeValue<uint32_t, false, 0>(file, ___239, static_cast<uint32_t>(auxDataEntity)) && writeValue<uint32_t, false, 0>(file, ___262, static_cast<uint32_t>(strlen(itemName))) && ___4544(file, ___261, itemName) && writeValue<uint8_t, false, 0>(file, ___268, static_cast<uint8_t>(itemType)) && writeValue<uint32_t, false, 0>(file, ___272, static_cast<uint32_t>(strlen(itemValueString))) && ___4544(file, ___271, itemValueString)); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4482( FileWriterInterface& file, ___37&          ___36, ItemSetIterator&     varIter, ItemSetIterator&     zoneIter, ___3945&         headerTagMap) { REQUIRE(file.___2041()); headerTagMap[___241] = file.fileLoc(); uint32_t numAuxData = 0; ___372 ___2039 = ___4484(file, numAuxData); if (___2039 && ___36.___896()) { ___264 auxData = ___36.___235(); uint32_t numItemsWritten = 0; if (auxData) { ___2039 = ___2039 && ___4483( file, ___36, auxData, ___253, 0, numItemsWritten); numAuxData += numItemsWritten; } varIter.reset(); ___4352 const baseVar = varIter.baseItem(); while (___2039 && varIter.hasNext()) { ___4352 const datasetVar = varIter.next(); ___4636 const fileVar = datasetVar - baseVar; auxData = ___36.___273(datasetVar + 1); if (auxData) { ___2039 = ___2039 && ___4483( file, ___36, auxData, ___258, fileVar+1, numItemsWritten); numAuxData += numItemsWritten; } } zoneIter.reset(); ___4636 const ___341 = zoneIter.baseItem(); while (___2039 && zoneIter.hasNext()) { ___4636 const ___904 = zoneIter.next(); ___4636 const fileZone = ___904 - ___341; if (!___36.___4638(___904 + 1)) continue; auxData = ___36.___274(___904 + 1); if (auxData) { ___2039 = ___2039 && ___4483( file, ___36, auxData, ___259, fileZone+1, numItemsWritten); numAuxData += numItemsWritten; } } } uint64_t finalFileLoc = file.fileLoc(); ___2039 = ___2039 && file.___3459(headerTagMap[___241]) && ___4484(file, numAuxData) && file.___3459(finalFileLoc); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4522( FileWriterInterface& file, uint32_t             numGeoms) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; if (file.___2002()) ___2039 = writeValue<uint32_t, false, 0>(file, SZPLT_GEOMETRY_MARKER_DESCRIPTION, SZPLT_GEOMETRY_MARKER); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, NUM_GEOMS_DESCRIPTION, numGeoms); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4523( FileWriterInterface& file, ___37&          ___36, GeomID_t             geomID) { REQUIRE(file.___2041()); uint32_t ___2835 = (uint32_t)___36.___1620(geomID); bool is3D = (___36.___1603(geomID) == CoordSys_Grid3D); ___372 ___2039 = writeValue<uint32_t, false, 0>(file, ___1623, ___2835); for(uint32_t segment = 0; ___2039 && segment < ___2835; ++segment) { uint32_t numPts = (uint32_t)___36.___1619(geomID, static_cast<int32_t>(segment + 1)); ___1105 xPts; ___1105 yPts; ___1105 zPts; ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___1622, numPts) &&
xPts.alloc(static_cast<uint64_t>(numPts)) && yPts.alloc(static_cast<uint64_t>(numPts)); if (is3D) ___2039 = ___2039 && zPts.alloc(static_cast<uint64_t>(numPts)); for(uint32_t i = 0; i < numPts; ++i) { if (is3D) ___36.___1560(geomID, static_cast<int32_t>(segment + 1), static_cast<___2227>(i + 1), &xPts[i], &yPts[i], &zPts[i]); else ___36.___1557(geomID, static_cast<int32_t>(segment + 1), static_cast<___2227>(i + 1), &xPts[i], &yPts[i]); } ___2039 = ___2039 && ___4563<double, false, 0>(file, ___1654, segment, static_cast<size_t>(numPts), &xPts[0]) && ___4563<double, false, 0>(file, ___1656, segment, static_cast<size_t>(numPts), &yPts[0]); if (is3D) ___2039 && ___4563<double, false, 0>(file, ___1659, segment, static_cast<size_t>(numPts), &zPts[0]); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4521( FileWriterInterface& file, ___37&          ___36, ___4636          ___341, GeomID_t             geomID) { REQUIRE(file.___2041()); double ___4574; double ___4591; double ___4715; ___36.___1591(geomID, &___4574, &___4591, &___4715); ___372 ___2039 = writeValue<double, false, 0>(file, ___1653, ___4574) && writeValue<double, false, 0>(file, ___1655, ___4591) && writeValue<double, false, 0>(file, ___1658, ___4715); uint8_t ___3159 = (uint8_t)___36.___1603(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1627, ___3159); uint8_t ___2004 = ___36.___1610(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1611, ___2004); ___4636 zone = ___36.___1607(geomID); ___2039 = ___2039 && writeValue<int32_t, false, 0>(file, ___1657, zone - ___341); uint16_t color = (uint16_t)___36.___1594(geomID); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___1571, color); uint16_t ___1411 = (uint16_t)___36.___1596(geomID); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___1582, ___1411); uint8_t ___2022 = (uint8_t)___36.___1597(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1612, ___2022); uint8_t ___1651 = (uint8_t)___36.___1606(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, GEOM_GEOM_TYPE, ___1651); uint8_t ___2263 = (uint8_t)___36.___1598(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1613, ___2263); double ___2986 = ___36.___1602(geomID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1625, ___2986); double ___2289 = ___36.___1599(geomID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1614, ___2289); if (___1651 == (uint8_t)GeomType_Circle || ___1651 == (uint8_t)GeomType_Ellipse) { uint16_t ___2793 = static_cast<uint16_t>(___36.___1576(geomID)); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___1621, ___2793); } else { ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___1621, 0); } if (___1651 == (uint8_t)GeomType_LineSegs) { uint8_t arrowheadStyle = (uint8_t)___36.___1567(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1569, arrowheadStyle); uint8_t arrowheadAttachment = (uint8_t)___36.___1565(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1563, arrowheadAttachment); double arrowheadSize = ___36.___1566(geomID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1568, arrowheadSize); double arrowheadAngle = ___36.___1564(geomID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1562, arrowheadAngle); } else { ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1569, 0); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1563, 0); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1568, 0); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1562, 0); } uint8_t geomScope = (uint8_t)___36.___1605(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___1633, geomScope); uint8_t geomClipping = (uint8_t)___36.___1593(geomID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, GEOM_CLIPPING, geomClipping); char* ___2330 = 0; if (___36.___1600(geomID, &___2330) && ___2330 != 0) { uint32_t length = static_cast<uint32_t>(strlen(___2330)); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___1616, length); if (length > 0) ___4544(file, ___1615, ___2330); ___36.___3817(&___2330); } else { ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___1616, 0);
} switch (___36.___1606(geomID)) { case GeomType_LineSegs: { ___2039 = ___2039 && ___4523(file, ___36, geomID); } break; case GeomType_Rectangle: { double ___4458; double ___1826; ___36.___1628(geomID, &___4458, &___1826); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1630, ___4458) && writeValue<double, false, 0>(file, ___1629, ___1826); } break; case GeomType_Square: { ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1649, ___36.___1648(geomID)); } break; case GeomType_Circle: { ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1608, ___36.___1570(geomID)); } break; case GeomType_Ellipse: { double horizontalAxis; double verticalAxis; ___36.___1577(geomID, &horizontalAxis, &verticalAxis); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___1578, horizontalAxis) && writeValue<double, false, 0>(file, ___1579, verticalAxis); } break; default: ___478(___1305); break; } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4524( FileWriterInterface& file, ___37&          ___36, ___4636          ___341, ___3945&         headerTagMap) { REQUIRE(file.___2041()); headerTagMap[___1581] = file.fileLoc(); uint32_t numGeoms = 0; ___372 ___2039 = ___4522(file, numGeoms); for(GeomID_t geomID = ___36.___1592(); ___2039 && geomID != ___4035; geomID = ___36.___1601(geomID)) { if (___36.___1606(geomID) != GeomType_Image) { ___2039 = ___4521(file, ___36, ___341, geomID); ++numGeoms; } } uint64_t finalFileLoc = file.fileLoc(); ___2039 = ___2039 && file.___3459(headerTagMap[___1581]) && ___4522(file, numGeoms) && file.___3459(finalFileLoc); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4547( FileWriterInterface& file, uint32_t             numTexts) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; if (file.___2002()) ___2039 = writeValue<uint32_t, false, 0>(file, SZPLT_TEXT_MARKER_DESCRIPTION, SZPLT_TEXT_MARKER); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, NUM_TEXTS_DESCRIPTION, numTexts); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4546( FileWriterInterface& file, ___37&          ___36, ___4636          ___341, TextID_t             textID) { REQUIRE(file.___2041()); double ___4574 = 0.0; double ___4591 = 0.0; double ___4715 = 0.0; ___36.___4085(textID, &___4574, &___4591, &___4715); ___372 ___2039 = writeValue<double, false, 0>(file, ___4136, ___4574) && writeValue<double, false, 0>(file, ___4137, ___4591) && writeValue<double, false, 0>(file, ___4140, ___4715); uint16_t ___4080 = (uint16_t)___36.___4089(textID); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___4082, ___4080); uint16_t ___4059 = (uint16_t)___36.___4064(textID); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___4060, ___4059); uint16_t ___4061 = (uint16_t)___36.___4065(textID); ___2039 = ___2039 && writeValue<uint16_t, false, 0>(file, ___4062, ___4061); double ___4071 = ___36.___4066(textID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___4072, ___4071); double ___4073 = ___36.___4067(textID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___4074, ___4073); uint8_t ___4078 = (uint8_t)___36.___4068(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, TEXT_BOX_TYPE, ___4078); uint8_t ___4043 = (uint8_t)___36.___4084(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___4044, ___4043); double ___4056 = ___36.___4086(textID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___4057, ___4056); uint8_t ___4079 = (uint8_t)___36.___4088(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, TEXT_CLIPPING, ___4079); double ___4103 = ___36.___4090(textID); ___2039 = ___2039 && writeValue<double, false, 0>(file, TEXT_HEIGHT, ___4103); double ___4107 = ___36.___4091(textID); ___2039 = ___2039 && writeValue<double, false, 0>(file, ___4108, ___4107); uint8_t ___4115 = (uint8_t)___36.___4094(textID); ___2039 = ___2039 &&  writeValue<uint8_t, false, 0>(file, ___4116, ___4115); uint8_t ___4119 = (uint8_t)___36.___4096(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___4120, ___4119); uint8_t ___4124 = (uint8_t)___36.___4097(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___4125, ___4124); char* ___4126 = 0; ___36.___4098(textID, &___4126); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___4128, static_cast<uint32_t>(strlen(___4126)));
if (strlen(___4126) > 0) ___2039 = ___2039 && ___4544(file, ___4127, ___4126); ___36.___3817(&___4126); char* ___4129 = ___36.___4099(textID); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___4131, static_cast<uint32_t>(strlen(___4129))); if (strlen(___4129) > 0) ___2039 = ___2039 && ___4544(file, ___4130, ___4129); ___36.___3817(&___4129); uint8_t ___4132 = (uint8_t)___36.___4100(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___4133, ___4132); uint8_t ___4134 = (uint8_t)___36.___4101(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___4135, ___4134); int32_t ___4138 = (int32_t)___36.___4102(textID); ___2039 = ___2039 && writeValue<int32_t, false, 0>(file, ___4139, ___4138 - ___341); uint8_t ___4105 = (uint8_t)___36.___4105(textID); ___2039 = ___2039 && writeValue<uint8_t, false, 0>(file, ___4106, ___4105); char* ___4109 = 0; if (___36.___4092(textID, &___4109) && ___4109 != 0) { ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___4111, static_cast<uint32_t>(strlen(___4109))); if (strlen(___4109) > 0) ___2039 = ___2039 && ___4544(file, ___4110, ___4109); ___36.___3817(&___4109); } else { ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___4111, 0); } ___36.___3817(&___4109); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4548( FileWriterInterface& file, ___37&          ___36, ___4636          ___341, ___3945&         headerTagMap) { REQUIRE(file.___2041()); headerTagMap[___4083] = file.fileLoc(); uint32_t numTexts = 0; for(TextID_t textID = ___36.___4087(); textID != ___4035; textID = ___36.___4093(textID)) ++numTexts; ___372 ___2039 = ___4547(file, numTexts); for(TextID_t textID = ___36.___4087(); ___2039 && textID != ___4035; textID = ___36.___4093(textID)) ___2039 = ___4546(file, ___36, ___341, textID); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4504( FileWriterInterface& file, uint32_t             numCustomLabelSets) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; if (file.___2002()) ___2039 = writeValue<uint32_t, false, 0>(file, SZPLT_CUSTOM_LABELS_MARKER_DESCRIPTION, SZPLT_CUSTOM_LABELS_MARKER); ___2039 = ___2039 && writeValue<uint32_t, false, 0>(file, ___793, numCustomLabelSets); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4503( FileWriterInterface& file, ___37&          ___36, int32_t              customLabelNum) { REQUIRE(file.___2041()); ___3839 ___2171 = 0; ___3816 customLabels; ___372 ___2039 = ___36.___796(&___2171, customLabelNum); int32_t numLabels = 0; if (___2039) { numLabels = (int32_t)___36.___3832(___2171); ___2039 = ___2039 && customLabels.alloc(static_cast<uint64_t>(numLabels)) && writeValue<uint32_t, false, 0>(file, ___2820, numLabels); } for(int32_t i = 1; ___2039 && i <= ___36.___3832(___2171); ++i) { char* label = ___36.___3833(___2171, i); customLabels[i - 1] = label; ___36.___3817(&label); } ___2039 = ___2039 && ___4545(file, ___794, (size_t)numLabels, customLabels); if (___2171) ___36.___3827(&___2171); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___4502( FileWriterInterface& file, ___37&          ___36, ___3945&         headerTagMap) { REQUIRE(file.___2041()); headerTagMap[___795] = file.fileLoc(); int32_t numCustomLabelSets = ___36.___896() ? static_cast<int32_t>(___36.___797()) : 0; ___372 ___2039 = ___4504(file, numCustomLabelSets); for(int32_t customLabelNum = 1; ___2039 && customLabelNum <= numCustomLabelSets; ++customLabelNum) ___2039 = ___4503(file, ___36, customLabelNum); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } }
 #if defined DO_SUBZONE_HISTOGRAM || defined DO_ITEMANDSUBZONE_HISTOGRAM
namespace { ___372 ___2881( std::string const& pltFileName, ___4636        zone, char const*        ___2504, FILE*&             fileHandle) { REQUIRE(!pltFileName.empty()); REQUIRE(zone>=0); REQUIRE(VALID_NON_ZERO_LEN_STR(___2504)); REQUIRE(fileHandle==NULL); char histogramFileName[1000]; sprintf(histogramFileName, "%s.zone%" PRIu64 ".histogram.csv", pltFileName.c_str(), uint64_t(zone+1)); ___372 ___2039 = ___4226; fileHandle = tecplot::filesystem::fileOpen(histogramFileName, ___2504); if (fileHandle == NULL) ___2039 = ___1186("Cannot open histogram file %s", histogramFileName); return ___2039; } }
 #endif
 #ifdef DO_SUBZONE_HISTOGRAM
___372 OutputSubzoneHistograms( char const*       szpltFileName, ___37&       ___36, ___4636       zone, boost::shared_ptr<___1350 const> ___1349) { ___372 ___2039 = ___4226; REQUIRE(VALID_NON_ZERO_LEN_STR(szpltFileName)); REQUIRE(VALID_REF(___1349.get())); ___2090::SubzoneOffset_t const ___2783 = ___1349->___2783(); ___2090::SubzoneOffset_t const ___2823 = ___1349->___2823(); SubzoneOffsetArray cszRefsByNszHistogram; SubzoneOffsetArray nszRefsByCszHistogram; ___2039 = ___2039 && cszRefsByNszHistogram.alloc(___2783+1, ___2090::SubzoneOffset_t(0)); ___2039 = ___2039 && nszRefsByCszHistogram.alloc(___2823+1, ___2090::SubzoneOffset_t(0)); SubzoneOffsetSetArray cszRefsByNsz; ___2039 = ___2039 && cszRefsByNsz.alloc(___2823); if (___2039) { ___2729 ___2723 = boost::make_shared<___2724>(&___36, zone+1); if (!___2723->___2067()) return ___1305; ___682 const ___2789 = ___1349->___1767(); for (___2090::SubzoneOffset_t ___469 = 0; ___469 < ___2783; ___469++) { SubzoneOffsetSet nszRefs; ___2090::ItemOffset_t const ___2782 = ___1349->___2782(___469); for (___2090::ItemOffset_t cszOffset = 0; cszOffset < ___2782; cszOffset++) { ___2090 const ___688(0, ___469, cszOffset); ___465 const datasetCell = ___1349->___4608(___688); ___478(datasetCell<___1349->___1766()); for (___682 ___681 = 0; ___681 < ___2789; ___681++) { ___2718 const datasetNode = ___2723->___1763(datasetCell+1, ___681+1) - 1; ___478(datasetNode<___1349->___1768()); ___2090 const ___2759 = ___1349->___3924(datasetNode); ___2090::SubzoneOffset_t const ___2734 = ___2759.subzoneOffset(); nszRefs.insert(___2734); cszRefsByNsz[___2734].insert(___469); } } if (___2039) { size_t const numNszRefs = nszRefs.size(); ___478(numNszRefs<nszRefsByCszHistogram.size()); nszRefsByCszHistogram[numNszRefs]++; } } for (___2090::SubzoneOffset_t ___2734 = 0; ___2734 < ___2823; ___2734++) { size_t const numCszRefs = cszRefsByNsz[___2734].size(); ___478(numCszRefs<cszRefsByNszHistogram.size()); cszRefsByNszHistogram[numCszRefs]++; } } if (___2039) { FILE* histogramFile = NULL; ___2039 = ___2881(szpltFileName, zone, "wt", histogramFile); if (___2039) { fprintf(histogramFile,"\nZone %" PRIu64 " (%" PRIu64 " cells, %" PRIu64 " cell subzones, %" PRIu64 " nodes, %" PRIu64 " node subzones)\n", uint64_t(zone+1), uint64_t(___1349->___1766()), uint64_t(___2783), uint64_t(___1349->___1768()), uint64_t(___2823)); fprintf(histogramFile,"\nNszs per Cell Subzone Histogram\n"); fprintf(histogramFile,"\nNumNodeSubzonesReferenced,Count\n"); for (___2090::SubzoneOffset_t nodeSubzoneCount = 0; nodeSubzoneCount <= ___2823; nodeSubzoneCount++) if (nszRefsByCszHistogram[nodeSubzoneCount] > 0) fprintf(histogramFile,"%" PRIu64 "\t%" PRIu64 "\n", uint64_t(nodeSubzoneCount), uint64_t(nszRefsByCszHistogram[nodeSubzoneCount])); fprintf(histogramFile,"\nCszs per Node Subzone Histogram\n"); fprintf(histogramFile,"\nNumCellSubzonesReferenced,Count\n"); for (___2090::SubzoneOffset_t cellSubzoneCount = 0; cellSubzoneCount <= ___2783; cellSubzoneCount++) if (cszRefsByNszHistogram[cellSubzoneCount] > 0) fprintf(histogramFile,"%" PRIu64 "\t%" PRIu64 "\n", uint64_t(cellSubzoneCount), uint64_t(cszRefsByNszHistogram[cellSubzoneCount])); } ___4195(histogramFile); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #endif
 #ifdef DO_ITEMANDSUBZONE_HISTOGRAM
___372 OutputItemAndSubzoneHistograms( char const*       szpltFileName, ___37&       ___36, ___4636       zone, boost::shared_ptr<___1350 const> ___1349) { ___372 ___2039 = ___4226; REQUIRE(VALID_NON_ZERO_LEN_STR(szpltFileName)); REQUIRE(VALID_REF(___1349.get())); ___465 const ___2781 = ___1349->___1766(); ___2718 const ___2821 = ___1349->___1768(); ___464 cellRefsByNszHistogram; ___2717 nodeRefsByCszHistogram; ___2039 = ___2039 && cellRefsByNszHistogram.alloc(___2781+1, ___465(0)); ___2039 = ___2039 && nodeRefsByCszHistogram.alloc(___2821+1, ___2718(0)); typedef std::set<___465> CellIndexSet; ___2240<CellIndexSet> cellsRefsByNsz; ___2039 = ___2039 && cellsRefsByNsz.alloc(___2821); if (___2039) { ___2729 ___2723 = boost::make_shared<___2724>(&___36, zone+1); if (!___2723->___2067()) return ___1305; ___682 const ___2789 = ___1349->___1767(); ___2090::SubzoneOffset_t const ___2783 = ___1349->___2783(); for (___2090::SubzoneOffset_t ___469 = 0; ___469 < ___2783; ___469++) { CellIndexSet nodeRefs; ___2090::ItemOffset_t const ___2782 = ___1349->___2782(___469); for (___2090::ItemOffset_t cszOffset = 0; cszOffset < ___2782; cszOffset++) { ___2090 const ___688(0, ___469, cszOffset); ___465 const datasetCell = ___1349->___4608(___688); ___478(datasetCell < ___2781); for (___682 ___681 = 0; ___681 < ___2789; ___681++) { ___2718 const datasetNode = ___2723->___1763(datasetCell+1, ___681+1) - 1; ___478(datasetNode<___2821); ___2090 const ___2759 = ___1349->___3924(datasetNode); ___2090::SubzoneOffset_t const ___2734 = ___2759.subzoneOffset(); nodeRefs.insert(datasetNode); cellsRefsByNsz[___2734].insert(datasetCell); } } if (___2039) { size_t const numNodeRefs = nodeRefs.size(); ___478(numNodeRefs < nodeRefsByCszHistogram.size()); nodeRefsByCszHistogram[numNodeRefs]++; } } ___2090::SubzoneOffset_t const ___2823 = ___1349->___2823(); for (___2090::SubzoneOffset_t ___2734 = 0; ___2734 < ___2823; ___2734++) { size_t const numCellRefs = cellsRefsByNsz[___2734].size(); ___478(numCellRefs < cellRefsByNszHistogram.size()); cellRefsByNszHistogram[numCellRefs]++; } } if (___2039) { FILE* histogramFile = NULL; ___2039 = ___2881(szpltFileName, zone, "at", histogramFile); if (___2039) { fprintf(histogramFile,"\nZone %" PRIu64 " (%" PRIu64 " cells, %" PRIu64 " cell subzones, %" PRIu64 " nodes, %" PRIu64 " node subzones)\n", uint64_t(zone+1), uint64_t(___1349->___1766()), uint64_t(___2781), uint64_t(___1349->___1768()), uint64_t(___2821)); fprintf(histogramFile,"\nNodes per Cell Subzone Histogram\n"); fprintf(histogramFile,"\nNumNodesReferenced,Count\n"); for (___2090::SubzoneOffset_t nodeSubzoneCount = 0; nodeSubzoneCount <= ___2821; nodeSubzoneCount++) if (nodeRefsByCszHistogram[nodeSubzoneCount] > 0) fprintf(histogramFile,"%" PRIu64 "\t%" PRIu64 "\n", uint64_t(nodeSubzoneCount), uint64_t(nodeRefsByCszHistogram[nodeSubzoneCount])); fprintf(histogramFile,"\nCells per Node Subzone Histogram\n"); fprintf(histogramFile,"\nNumCellsReferenced,Count\n"); for (___2090::SubzoneOffset_t cellSubzoneCount = 0; cellSubzoneCount <= ___2781; cellSubzoneCount++) if (cellRefsByNszHistogram[cellSubzoneCount] > 0) fprintf(histogramFile,"%" PRIu64 "\t%" PRIu64 "\n", uint64_t(cellSubzoneCount), uint64_t(cellRefsByNszHistogram[cellSubzoneCount])); } ___4195(histogramFile); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #endif
namespace { inline ___372 ___479(___37& ___36) { ___372 ___2039 = ___4226; if (!___36.___896() && ___36.___1592() == ___4035 && ___36.___4087() == ___4035) ___2039 = ___1186("Cannot export dataset: The active frame has no data, texts or geoms to export."); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { inline ___372 ___481(___37& ___36, ___4352  ___4336) { REQUIRE(___36.___896()); REQUIRE(___4336<___36.___890()); ___372 ___2039 = ___4226; if (!___36.___4353(___4336 + 1)) ___2039 = ___1186("Cannot export dataset: Variable %" PRIu64 " is disabled and cannot be exported.", uint64_t(___4336 + 1)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { inline ___372 ___483(___37& ___36, ___4636 zone) { REQUIRE(___36.___896()); REQUIRE(zone < ___36.___891()); ___372 ___2039 = ___4226; if (!___36.___4638(zone + 1)) ___2039 = ___1186("Cannot export dataset: Zone %" PRIu64 " is disabled and cannot be exported.", uint64_t(zone + 1)); else if ((___4646(___36, zone) || ___4643(___36, zone)) && !___4642(___36, zone) && !___4644(___36, zone)) ___2039 = ___1186("Cannot export dataset: Zone %" PRIu64 " is unsupported type", uint64_t(zone + 1)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ___480( ___37&      ___36, ItemSetIterator& varIter, ItemSetIterator& zoneIter, DataFileType_e   ___844) { REQUIRE(VALID_ENUM(___844, DataFileType_e)); ___372 ___2039 = ___479(___36); if (___2039) { ___4352 const numVarsToWrite = varIter.___2812(); varIter.reset(); while (___2039 && varIter.hasNext()) ___2039 = ___481(___36, varIter.next()); ___372 hasVolumeZones     = ___1305; ___372 atLeastOneZoneIsFE = ___1305; zoneIter.reset(); while (___2039 && zoneIter.hasNext()) { ___4636 const ___904 = zoneIter.next(); if (___4646(___36, ___904)) hasVolumeZones = ___4226; if (___36.___4640(___904 + 1)) atLeastOneZoneIsFE = ___4226; ___2039 = ___483(___36, ___904); } if (___2039 && hasVolumeZones) { if ((___844 != ___848) && (numVarsToWrite < 3                 || !___36.___4353(1) || !___36.___4353(2) || !___36.___4353(3))) { ___2039 = ___1305; ___1186("Err:  Variables 1,2 and 3 are needed to calculate subzones and must be enabled to export a szplt file"); } else if (___36.___1513() == ___3115) { if (___844 != ___848 && atLeastOneZoneIsFE && (___36.___4345('X') != 1 || ___36.___4345('Y') != 2 || ___36.___4345('Z') != 3)) { ___1931("Warning:\n" "Calculations to determine subzones for szl zones assumes the first 3 variables in the dataset are X,Y, and Z.\n" "The X,Y,Z axis assignments in the current frame are not the first 3 variables and thus the resulting subzone distribution may not be optimal"); } } else if (___844 != ___848) { ___1931("Warning:\n" "Calculations to determine subzones for szl zones assumes the first 3 variables in the dataset are X,Y, and Z.\n" "If the first 3 variables in the current dataset do not represent X,Y, and Z the resulting subzone distribution may not be optimal"); } } } return ___2039; } } namespace { ___372 ___25( ___1392& szpltZoneHeaderFileLocs, ___37&   ___36, ___4636   ___2846, bool          fillWithValidValues) { szpltZoneHeaderFileLocs.___937(); return IMPLICATION(___36.___896(), szpltZoneHeaderFileLocs.alloc( ___2846, fillWithValidValues ? ___1393(0): ___330)); } } ___372 ___1242( ___37&                   ___36, FileWriterInterface&          szpltFile, ___1388 const&        ___1387, ___372                     includeRevisionNumber, DataSetWriter&                dataSetWriter, ___3501                        vars, ___3501                        ___4671, ___936& ___935) { REQUIRE(szpltFile.___2041()); REQUIRE(___1387.getFileVersion() == SZPLT_CUR_WRITE_VERSION); REQUIRE(VALID_REF_OR_NULL(vars)); REQUIRE(VALID_REF_OR_NULL(___4671));
 #if !defined TECIOMPI
REQUIRE(boost::atomic<double>().is_lock_free());
 #endif
szpltFile.___3494(___1387.___2002()); szpltFile.setDataFileType(___1387.___844()); ItemSetIterator varIter(___36, ___36.___896() ? ___36.___890() : 0, vars); ItemSetIterator zoneIter(___36, ___36.___896() ? ___36.___891() : 0, ___4671); ___372 ___2039 = ___480(___36, varIter, zoneIter, szpltFile.___844()); if (___2039) { ___36.___3779("Exporting szplt file...", ___4226 , ___4226/*___3580*/); ___2039 = ___2039 && ___36.___3769(0); ___4352 numVarsToWrite = 0; ___4636 numZonesToWrite = 0; uint64_t numPartitionFiles = 0; if (___36.___896()) { numVarsToWrite = varIter.___2812(); numZonesToWrite = zoneIter.___2812(); numPartitionFiles = static_cast<uint64_t>(___36.datasetGetNumPartitionFiles()); } ___1392 szpltZoneHeaderFileLocs; ___2039 = ___2039 && ___25(szpltZoneHeaderFileLocs, ___36, numZonesToWrite, true); try { ___3945 headerTagMap = boost::assign::map_list_of<uint16_t, uint64_t> (DATA_SET_TITLE_TAG, 0) (___2849, static_cast<uint64_t>(numZonesToWrite)) (___2845, static_cast<uint64_t>(numVarsToWrite)) (SUBZONE_MAX_I_SIZE_TAG, static_cast<uint64_t>(___1387.___1757().i())) (SUBZONE_MAX_J_SIZE_TAG, static_cast<uint64_t>(___1387.___1757().___2105())) (SUBZONE_MAX_K_SIZE_TAG, static_cast<uint64_t>(___1387.___1757().___2134())) (SUBZONE_MAX_FE_SIZE_TAG, ___1387.___1756()) (___241, 0) (___1581, 0) (___795, 0) (___4083, 0) (___4651, 0) (ZONE_TYPE_FILE_LOC_TAG, 0) (___4630, 0) (___4610, 0) (___4676, 0) (___4686, 0) (___4670, 0) (ZONE_IMAX_OR_NUM_NODES_FILE_LOC_TAG, 0) (ZONE_JMAX_OR_NUM_CELLS_FILE_LOC_TAG, 0) (ZONE_KMAX_OR_NUM_CORNERS_FILE_LOC_TAG, 0) (___4674, 0) (___4365, 0) (VAR_ZONE_MIN_MAX_FILE_LOC_TAG, 0) (___4393, 0) (___4384, 0) (___4387, 0) (___4390, 0) ; if (numPartitionFiles > 0) headerTagMap[NUM_PARTITION_FILES_TAG] = numPartitionFiles; ___2039 = ___2039 && ___4517(szpltFile, includeRevisionNumber, ___36, numVarsToWrite, numZonesToWrite, headerTagMap, dataSetWriter.___4706(), szpltZoneHeaderFileLocs, ___935, ___4226 ); ___2039 = ___2039 && ___4482(szpltFile, ___36, varIter, zoneIter, headerTagMap) && ___4524(szpltFile, ___36, zoneIter.baseItem(), headerTagMap) && ___4548(szpltFile, ___36, zoneIter.baseItem(), headerTagMap) && ___4502(szpltFile, ___36, headerTagMap); ___2039 = ___2039 && ___25(szpltZoneHeaderFileLocs, ___36, numZonesToWrite, false) && dataSetWriter.writeDataSet(szpltFile, szpltZoneHeaderFileLocs); if (___2039) { ___2039 = ___2039 && ___4517(szpltFile, includeRevisionNumber, ___36, numVarsToWrite, numZonesToWrite, headerTagMap, dataSetWriter.___4706(), szpltZoneHeaderFileLocs, ___935, ___1305 ); }
 #ifdef PROFILE_FILE_ACCESS
FileStreamWriter* fileWriter = dynamic_cast<FileStreamWriter*>(&szpltFile); if (fileWriter) ___935.___7(fileWriter->statistics().___2780);
 #endif
} catch (std::bad_alloc const&) { ___2039 = ___1186("Out of memory while writing file."); } catch (std::runtime_error const& e) { std::ostringstream ___2892; ___2892 << "Error encountered while writing file: " << e.what(); ___2039 = ___1186(___2892.str().c_str()); } catch (...) { ___2039 = ___1186("Unrecoverable error while writing file."); } ___36.___3770(); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 exportSubzonePartitionFile( ___37&            ___36, FileWriterInterface&   szptnFile, ___1388 const& ___1387, DataSetWriter&         dataSetWriter) { ___4278(___36); ___4278(szptnFile); ___4278(___1387); ___4278(dataSetWriter); return ___4226; } }}
