 #pragma once
#include "ThirdPartyHeadersBegin.h"
#include <fstream>
#include <map>
#include <sstream>
#include <vector>
#include <boost/foreach.hpp>
#include <boost/shared_ptr.hpp>
#include "ThirdPartyHeadersEnd.h"
namespace tecplot { namespace tecioszl { template <typename T> inline void writeScalar(std::ofstream& outputFile, T ___4298, bool ___4480) { if (___4480) outputFile << ___4298 << ' ' << std::endl; else outputFile.write((char const*)&___4298, sizeof(___4298)); } template <typename T> inline void readScalar(std::ifstream& inputFile, T& ___4298, bool readASCII) { if (readASCII) { std::string line; std::getline(inputFile, line); std::istringstream inputStream(line); inputStream >> ___4298; } else { inputFile.read((char*)&___4298, sizeof(___4298)); } } inline void ___4544(std::ofstream& outputFile, std::string const& str, bool ___4480) { uint64_t length = str.size(); writeScalar(outputFile, length, ___4480); if (___4480) outputFile << str << std::endl; else outputFile.write(str.c_str(), str.size()); } inline void readString(std::ifstream& inputFile, std::string& str, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); str.resize((size_t)length); if (readASCII) getline(inputFile, str); else inputFile.read(&str[0], (size_t)length); } template <typename T> inline void writeVector(std::ofstream& outputFile, std::vector<T> const& vec, bool ___4480) { uint64_t length = vec.size(); writeScalar(outputFile, length, ___4480); if (vec.size() > 0) { if (___4480) { BOOST_FOREACH(T ___4298, vec) { outputFile << ___4298 << ' '; } outputFile << std::endl; } else { outputFile.write((char const*)&(vec[0]), vec.size() * sizeof(T)); } } } template <typename T> inline void readVector(std::ifstream& inputFile, std::vector<T>& vec, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); vec.resize((size_t)length); if (length > 0) { if (readASCII) { std::string line; std::getline(inputFile, line); std::istringstream inputStream(line); for(uint64_t i = 0; i < length; ++i) { inputStream >> vec[i]; } } else { inputFile.read((char*)(&vec[0]), (size_t)length * sizeof(T)); } } } template <> inline void writeVector<std::string>(std::ofstream& outputFile, std::vector<std::string> const& vec, bool ___4480) { uint64_t length = vec.size(); writeScalar(outputFile, length, ___4480); for(size_t i = 0; i < vec.size(); ++i) ___4544(outputFile, vec[i], ___4480); } template <> inline void readVector<std::string>(std::ifstream& inputFile, std::vector<std::string>& vec, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); vec.resize((size_t)length); for(size_t i = 0; i < vec.size(); ++i) readString(inputFile, vec[i], readASCII); } template <typename T> inline void writeVectorOfObjects(std::ofstream& outputFile, std::vector<T> const& vec, bool ___4480) { uint64_t length = vec.size(); writeScalar(outputFile, length, ___4480); for(size_t i = 0; i < vec.size(); ++i) vec[i].writeToFile(outputFile, ___4480); } template <typename T> inline void readVectorOfObjects(std::ifstream& inputFile, std::vector<T>& vec, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); vec.reserve((size_t)length); for(uint64_t i = 0; i < length; ++i) vec.push_back(T(inputFile, readASCII)); } template <typename T> inline void writeVectorOfPtrs(std::ofstream& outputFile, std::vector<boost::shared_ptr<T> > const& vec, bool ___4480) { uint64_t length = vec.size(); writeScalar(outputFile, length, ___4480); for(size_t i = 0; i < vec.size(); ++i) vec[i]->writeToFile(outputFile, ___4480); } template <typename T> inline void readVectorOfPtrs(std::ifstream& inputFile, std::vector<boost::shared_ptr<T> >& vec, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); vec.resize(0); vec.reserve((size_t)length); for(uint64_t i = 0; i < length; ++i) vec.push_back(T::makePtr(inputFile, readASCII)); } template <typename T, typename U> inline void writeMapOfScalarsToObjects(std::ofstream& outputFile, std::map<T, U> const& m, bool ___4480) { uint64_t length = m.size(); writeScalar(outputFile, length, ___4480); typedef std::pair<T, U> ValuePair; BOOST_FOREACH (ValuePair const& valuePair, m) { writeScalar(outputFile, valuePair.first, ___4480); valuePair.second.writeToFile(outputFile, ___4480); } } template <typename T, typename U> inline void writeMapOfScalarsToPtrs(std::ofstream& outputFile, std::map<T, boost::shared_ptr<U> > const& m, bool ___4480) { uint64_t length = m.size(); writeScalar(outputFile, length, ___4480); typedef std::pair<T, boost::shared_ptr<U> > ValuePair; BOOST_FOREACH (ValuePair const& valuePair, m) { writeScalar(outputFile, valuePair.first, ___4480); valuePair.second->writeToFile(outputFile, ___4480); } } template <typename T, typename U> inline void readMapOfScalarsToPtrs(std::ifstream& inputFile, std::map<T, boost::shared_ptr<U> >& m, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); for(uint64_t i = 0; i < length; ++i) { T key; readScalar(inputFile, key, readASCII); m[key] = U::makePtr(inputFile, readASCII); } } template <typename T, typename U> inline void writeMapOfPairsToObjects(std::ofstream& outputFile, std::map<T, U> const& m, bool ___4480)
{ uint64_t length = m.size(); writeScalar(outputFile, length, ___4480); typedef std::pair<T, U> ValuePair; BOOST_FOREACH (ValuePair const& valuePair, m) { writeScalar(outputFile, valuePair.first.first, ___4480); writeScalar(outputFile, valuePair.first.second, ___4480); valuePair.second.writeToFile(outputFile, ___4480); } } template <typename T, typename U> inline void readMapOfPairsToObjects(std::ifstream& inputFile, std::map<T, U>& m, bool readASCII) { uint64_t length; readScalar(inputFile, length, readASCII); for(uint64_t i = 0; i < length; ++i) { T key; readScalar(inputFile, key.first, readASCII); readScalar(inputFile, key.second, readASCII); m[key] = U(inputFile, readASCII); } } }}
