#include "importSzPltFile.h"
#include "ThirdPartyHeadersBegin.h"
#  include <cctype>
#  include <cfloat>
#  include <locale>
#  include <string>
#  include <boost/assign.hpp>
#  include <boost/foreach.hpp>
#include "ThirdPartyHeadersEnd.h"
#include "MASTER.h"
#include "GLOBAL.h"
#include "CszConnectivity.h"
#include "FECellSubzoneCompressor.h"
#include "FEZoneInfo.h"
#include "fileStuff.h"
#include "FileReaderInterface.h"
#include "gatherOffsets.h"
#include "IJK.h"
#include "IJKPartitionTree.h"
#include "IJKZoneInfo.h"
#include "PartitionMetadata.h"
#include "Scanner.h"
#include "readValueArray.h"
#include "xyz.h"
#include "ZoneMetadata.h"
#include "zoneUtil.h"
namespace tecplot { namespace ___3933 { ___372 readDataFileHeader( ___1399& file, uint32_t&            fileVersion, ___372&           ___2002, DataFileType_e&      ___844, uint32_t&            codeRevision, uint64_t&            byteOrderIndicator, uint64_t&            dataSetHeaderLocation) { ___372 ___2039 = ___4226; char textOrBinary = '\0'; if (!file.___3460()) ___2039 = ___1186("Can't read SZPLT file."); tecplot::___3441 headerScanner; size_t const headerBufferSize = 128; char headerBuffer[headerBufferSize]; if (___2039 && !(file.fgets(headerBuffer, headerBufferSize) != NULL && headerBuffer[strlen(headerBuffer)-1] == '\n')) ___2039 = ___1186("SZPLT file has incorrect header. Cannot parse file header info."); if (___2039) { headerScanner.reset(headerBuffer); char const* const fileTypeID = "#!" SZPLT_FILE_TYPE; if (___2039 && !(headerScanner.next(strlen(fileTypeID)) == fileTypeID && headerScanner.next(1) == " ")) ___2039 = ___1186("SZPLT file has incorrect header. File type is not correct."); if (___2039 && !headerScanner.hasNextInt64Token("BT")) ___2039 = ___1186("SZPLT file has incorrect header. Version format is not correct."); if (___2039) fileVersion = static_cast<uint32_t>(headerScanner.nextInt64Token("BT")); if (___2039 && fileVersion < SZPLT_MIN_READ_VERSION) ___2039 = ___1186("SZPLT file is an older version %" PRIu32 " that is no longer supported.", fileVersion); if (___2039 && fileVersion > SZPLT_MAX_READ_VERSION ) ___2039 = ___1186("SZPLT file is an newer version %" PRIu32 " that is not supported by the current loader. Try updating your Tecplot.", fileVersion); if (___2039 && !headerScanner.hasNextChar()) ___2039 = ___1186("SZPLT file has incorrect header. Missing text or binary designator."); if (___2039) textOrBinary = headerScanner.nextChar(); if (___2039 && textOrBinary != 'B' && textOrBinary != 'T') ___2039 = ___1186("SZPLT file has incorrect header. Cannot determine binary or text file type."); } if (___2039) { ___2002 = textOrBinary == 'T'; ___844 = ___845; if (fileVersion >= 105) { char dataFileTypeChar = '\0'; ___2039 = headerScanner.hasNextChar(); if (___2039) dataFileTypeChar = headerScanner.nextChar(); if (___2039) { if (dataFileTypeChar == 'F') ___844 = ___845; else if (dataFileTypeChar == 'G') ___844 = ___846; else if (dataFileTypeChar == 'S') ___844 = ___848; else ___2039 = ___1186("SZPLT file has incorrect header. Expected data file type identifier."); } else { ___2039 = ___1186("SZPLT file has incorrect header. Expected data file type identifier."); } } } if (___2039 && headerScanner.hasNextToken() && headerScanner.nextToken() == " $Revision: " && headerScanner.hasNextInt64Token()) codeRevision = static_cast<uint32_t>(headerScanner.nextInt64Token()); else codeRevision = 0; if ( ___2039 ) file.___3494(___2002); byteOrderIndicator = 0; ___2039 = ___2039 && readValue<uint64_t, true>(file, byteOrderIndicator, IODescription(___1386)); ___478(IMPLICATION(___2039, byteOrderIndicator == ___1385)); dataSetHeaderLocation = 0; ___2039 = ___2039 && readValue<uint64_t, true>(file, dataSetHeaderLocation, IODescription(___895)); ___478(IMPLICATION(___2039, dataSetHeaderLocation != 0)); return ___2039; } namespace { ___372 readTagList( ___1399& file, ___3942&   tagDescriptionMap, ___3945&         ___3944) { uint16_t numTags; ___372 ___2039 = readValue<uint16_t, false>(file, numTags, IODescription(___2839)); UInt16Array tagArray; size_t arraySize = static_cast<size_t>(numTags); ___2039 = ___2039 && tagArray.alloc(arraySize); ___2039 = ___2039 && readValueArray<uint16_t, false, 0>(file, 0, arraySize, tagArray, IODescription(___3943)); try { for(size_t i = 0; ___2039 && i < arraySize; ++i) { uint16_t tag = tagArray[i]; ___3942::const_iterator it = tagDescriptionMap.find(tag); if (it == tagDescriptionMap.end()) { ___2039 = ___1931("Unrecognized tag while reading file header: %d. Attempting to continue...", tag); if (___2039) { if (file.___2002()) { int c = file.getc(); while(!file.feof() && c != '\n') c = file.getc(); if (file.feof()) ___2039 = ___1186("End-of-file encountered attempting to skip unrecognized tag."); } else { uint64_t unused; if (file.fread(&unused, sizeof(unused), size_t(1)) != 1) ___2039 = ___1186("Read error while attempting to skip unrecognized tag."); } } } else { ___2039 = ___2039 && readValue<uint64_t, true>(file, ___3944[tag], IODescription(tagDescriptionMap[tag].c_str())); } } } catch(...) { ___2039 = ___1186("Error while reading file tags, possibly out of memory."); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 ensureRequiredHeaderTagValuesArePresent( const char* headerTypeString, ___3945 const& ___3944, ___3942& tagDescriptionMap, std::vector<uint16_t> const& tagList) { BOOST_FOREACH(uint16_t tag, tagList) { ___3945::const_iterator it = ___3944.find(tag);
if (it == ___3944.end()) return ___1186("Missing required %s header tag %" PRIu64 ", '%s'.", headerTypeString, uint64_t(tag), tagDescriptionMap[tag].c_str()); } return ___4226; } } namespace { template <typename T> ___372 retrieveRequiredNonZeroValue(___3945 const& ___3944, uint16_t tag, char const* ___2685, T& ___4314) { ___372 ___2039 = ___4226; ___3945::const_iterator it = ___3944.find(tag); if (it == ___3944.end()) ___2039 = ___1186("Missing value for '%s' while reading file header.", ___2685); else ___4314 = static_cast<T>(it->second); if (___2039 && ___4314 == static_cast<T>(0)) ___2039 = ___1186("Invalid value (0) for '%s' while reading file header.", ___2685); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readFileHeaderTags( ___1399& file, ___1388&     ___1387, ___3945&         ___3944) { REQUIRE(file.___2041()); uint32_t       fileVersion; ___372      ___2002; DataFileType_e ___844; uint32_t       codeRevision; uint64_t       byteOrderIndicator; uint64_t       dataSetHeaderLocation; ___372 ___2039 = readDataFileHeader( file, fileVersion, ___2002, ___844, codeRevision, byteOrderIndicator, dataSetHeaderLocation); if (___2039) { file.___3494(___2002); file.setDataFileType(___844); ___1387.setFileVersion(fileVersion); ___1387.___3494(___2002); ___1387.setDataFileType(___844); ___1387.setCodeRevision(codeRevision); } static ___3942 tagDescriptionMap = ___1406; ___2039 = ___2039 && file.___3459(dataSetHeaderLocation); ___2039 = ___2039 && readTagList(file, tagDescriptionMap, ___3944); static std::vector<uint16_t> const tagList = boost::assign::list_of (___2849) (___2845) (SUBZONE_MAX_I_SIZE_TAG) (SUBZONE_MAX_J_SIZE_TAG) (SUBZONE_MAX_K_SIZE_TAG) (SUBZONE_MAX_FE_SIZE_TAG) (___241) (___1581) (___795) (___4083) (___4651) (ZONE_TYPE_FILE_LOC_TAG) (___4630) (___4610) (___4676) (___4686) (___4670) (ZONE_IMAX_OR_NUM_NODES_FILE_LOC_TAG) (ZONE_JMAX_OR_NUM_CELLS_FILE_LOC_TAG) (ZONE_KMAX_OR_NUM_CORNERS_FILE_LOC_TAG) (___4674) (___4365) (VAR_ZONE_MIN_MAX_FILE_LOC_TAG) (___4393) (___4384) (___4387) (___4390); ___2039 = ___2039 && ensureRequiredHeaderTagValuesArePresent("file", ___3944, tagDescriptionMap, tagList); if (___2039) { ___81 subzoneMaxISize; ___81 subzoneMaxJSize; ___81 subzoneMaxKSize; ___2090::ItemOffset_t subzoneMaxFESize; if (retrieveRequiredNonZeroValue(___3944, SUBZONE_MAX_I_SIZE_TAG, SUBZONE_MAX_I_SIZE_DESCRIPTION, subzoneMaxISize) && retrieveRequiredNonZeroValue(___3944, SUBZONE_MAX_J_SIZE_TAG, SUBZONE_MAX_J_SIZE_DESCRIPTION, subzoneMaxJSize) && retrieveRequiredNonZeroValue(___3944, SUBZONE_MAX_K_SIZE_TAG, SUBZONE_MAX_K_SIZE_DESCRIPTION, subzoneMaxKSize) && retrieveRequiredNonZeroValue(___3944, SUBZONE_MAX_FE_SIZE_TAG, SUBZONE_MAX_FE_SIZE_DESCRIPTION, subzoneMaxFESize)) { ___1387.setMaxIJKSubzoneSize(___1844(subzoneMaxISize, subzoneMaxJSize, subzoneMaxKSize)); ___1387.setMaxFESubzoneSize(subzoneMaxFESize); } else { ___2039 = ___1305; } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { template <typename T> ___372 retrieveRequiredValue(___3945 const& ___3944, uint16_t tag, char const* ___2685, T& ___4314) { ___372 ___2039 = ___4226; ___3945::const_iterator it = ___3944.find(tag); if (it == ___3944.end()) ___2039 = ___1186("Missing value for '%s' while reading file header.", ___2685); else ___4314 = static_cast<T>(it->second); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 applyFileHeaderScalarTagValues( ___3945 const& ___3944, ___4352& ___2843, ___4636& ___2846) { ___372 ___2039 = retrieveRequiredValue(___3944, ___2845, NUM_VARS_DESCRIPTION, ___2843); ___2039 = ___2039 && retrieveRequiredValue(___3944, ___2849, NUM_ZONES_DESCRIPTION, ___2846); if (___2843 > MAX_NUM_VARS) ___2039 = ___1186("File exceeds SZL variable limit"); else if (___2846 > MAX_NUM_ZONES) ___2039 = ___1186("File exceeds SZL zone limit"); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readDatasetTitle( ___1399& file, ___3945&         ___3944, std::string&         datasetTitle) { REQUIRE(file.___2041()); if ( ___3944[DATA_SET_TITLE_TAG] == 0 ) return ___4226; ___372 ___2039 = file.___3459(___3944[DATA_SET_TITLE_TAG]); uint32_t titleLength = 0; ___2039 = ___2039 && readValue<uint32_t, false>(file, titleLength, IODescription(DATA_SET_TITLE_LENGTH)); if (___2039 && titleLength > 0) { try { ___473 ___4177; ___2039 = ___2039 && ___4177.alloc(titleLength); ___2039 = ___2039 && readString(file, titleLength, ___4177, IODescription(DATA_SET_TITLE_DESCRIPTION));
if ( ___2039 ) datasetTitle = std::string(&___4177[0], titleLength); } catch (std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading dataset title."); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readPerVarFileHeader( ___1399& file, ___3945&         ___3944, ___4352           varOffset, ___3816&         varNameArray) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; try { size_t ___2843 = static_cast<size_t>(___3944[___2845]); if (___2843 == 0) return ___4226; REQUIRE(IMPLICATION(varNameArray.empty(), varOffset == 0)); REQUIRE(IMPLICATION(!varNameArray.empty(), varOffset+___2843 <= varNameArray.size())); uint64_t varNameLocation = ___3944[___4365]; if (varNameLocation == 0) { ___2039 = ___1186("Missing file header tag %" PRIu64 " '%s'.", uint64_t(___4365), VAR_NAME_FILE_LOC_DESCRIPTION); } else { ___2039 = file.___3459(varNameLocation); ___2039 = ___2039 && readStringArray(file, varOffset, ___2843, varNameArray, IODescription(___4364)); } } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading file header."); } catch(...) { ___2039 = ___1186("Unrecoverable error while reading file header."); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 readZoneHeaderFileLocArray( ___1399& file, ___4636          zoneOffset, ___4636          ___2846, ___1392&        zoneFileLocArray) { REQUIRE(file.___2041()); REQUIRE(___2846>0); REQUIRE(IMPLICATION(zoneFileLocArray.empty(), zoneOffset == 0)); REQUIRE(IMPLICATION(!zoneFileLocArray.empty(), size_t(zoneOffset+___2846) <= zoneFileLocArray.size())); REQUIRE("file is at correct file loc"); ___372 ___2039 = readValueArray<uint64_t, true, 0>(file, zoneOffset, ___2846, zoneFileLocArray, IODescription(___4628)); if ( ___2039 ) { if ( zoneFileLocArray[zoneOffset] == ___1393(0) || zoneFileLocArray[zoneOffset] == ___330 || zoneFileLocArray[zoneOffset + ___2846/2] == ___1393(0) || zoneFileLocArray[zoneOffset + ___2846/2] == ___330 || zoneFileLocArray[zoneOffset + ___2846-1] == ___1393(0) || zoneFileLocArray[zoneOffset + ___2846-1] == ___330 ) { ___2039 = ___1186("This file has invalid zone file locations."); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readPerZoneFileHeader( ___1399&             file, ___3945&                     ___3944, ___4636                      zoneOffset, ___1392&                    ___4629, ___2240<ZoneMetadata>& zoneMetadata, ___2240<___4636>&  zoneShareConnectivityArray) { REQUIRE(file.___2041()); REQUIRE(IMPLICATION(___4629.empty(), zoneOffset == 0)); REQUIRE(IMPLICATION(!___4629.empty(), ___3944[___2849] <= ___4629.size())); REQUIRE(IMPLICATION(zoneShareConnectivityArray.empty(), zoneOffset == 0)); REQUIRE(IMPLICATION(!zoneShareConnectivityArray.empty(), zoneOffset+___3944[___2849] <= zoneShareConnectivityArray.size())); REQUIRE(zoneMetadata.size() == ___3944[___2849]); ___372 ___2039 = ___4226; try { size_t const ___2846 = size_t(___3944[___2849]); if (___2846 == 0) return ___4226; if ( ___2039 && ___3944[___4630] == 0 ) ___2039 = ___1186("File does not contain zone header file locations."); ___2039 = ___2039 && file.___3459(___3944[___4630]); ___2039 = ___2039 && readZoneHeaderFileLocArray(file, 0, ___4636(___2846), ___4629); ___3816 zoneNameArray; ___473 zoneTypeArray; UInt8Array faceNeighborModeArray; ___1105 solutionTimeArray; UInt32Array strandIDArray; ___1965 parentZoneArray; UInt64Array iMaxOrNumNodesArray; UInt64Array jMaxOrNumCellsArray; UInt64Array kMaxOrNumCornersArray; static ___3942 tagDescriptionMap = ___1406; static std::vector<uint16_t> const tagList = boost::assign::list_of (___4651) (ZONE_TYPE_FILE_LOC_TAG) (___4610) (___4676) (___4686) (___4670) (ZONE_IMAX_OR_NUM_NODES_FILE_LOC_TAG) (ZONE_JMAX_OR_NUM_CELLS_FILE_LOC_TAG) (ZONE_KMAX_OR_NUM_CORNERS_FILE_LOC_TAG) (___4674); ___2039 = ___2039 && ensureRequiredHeaderTagValuesArePresent("file", ___3944, tagDescriptionMap, tagList); ___2039 = ___2039 && zoneNameArray.alloc(___2846) && file.___3459(___3944[___4651]) && readStringArray(file, 0, ___2846, zoneNameArray, IODescription(___4650)) && zoneTypeArray.alloc(___2846) && file.___3459(___3944[ZONE_TYPE_FILE_LOC_TAG]) && readValueArray<char, false, 0>(file, 0, ___2846, zoneTypeArray, IODescription(___4694)) && faceNeighborModeArray.alloc(___2846) && file.___3459(___3944[___4610]) && readValueArray<uint8_t, false, 0>(file, 0, ___2846, faceNeighborModeArray, IODescription(___4609)) &&
solutionTimeArray.alloc(___2846) && file.___3459(___3944[___4676]) && readValueArray<double, false, 0>(file, 0, ___2846, solutionTimeArray, IODescription(___4675)) && strandIDArray.alloc(___2846) && file.___3459(___3944[___4686]) && readValueArray<uint32_t, false, 0>(file, 0, ___2846, strandIDArray, IODescription(___4685)) && parentZoneArray.alloc(___2846) && file.___3459(___3944[___4670]) && readValueArray<int32_t, false, 0>(file, 0, ___2846, parentZoneArray, IODescription(___4669)) && iMaxOrNumNodesArray.alloc(___2846) && file.___3459(___3944[ZONE_IMAX_OR_NUM_NODES_FILE_LOC_TAG]) && readValueArray<uint64_t, false, 0>(file, 0, ___2846, iMaxOrNumNodesArray, IODescription(ZONE_IMAX_OR_NUM_NODES_ARRAY_DESCRIPTION)) && jMaxOrNumCellsArray.alloc(___2846) && file.___3459(___3944[ZONE_JMAX_OR_NUM_CELLS_FILE_LOC_TAG]) && readValueArray<uint64_t, false, 0>(file, 0, ___2846, jMaxOrNumCellsArray, IODescription(ZONE_JMAX_OR_NUM_CELLS_ARRAY_DESCRIPTION)) && kMaxOrNumCornersArray.alloc(___2846) && file.___3459(___3944[ZONE_KMAX_OR_NUM_CORNERS_FILE_LOC_TAG]) && readValueArray<uint64_t, false, 0>(file, 0, ___2846, kMaxOrNumCornersArray, IODescription(ZONE_KMAX_OR_NUM_CORNERS_ARRAY_DESCRIPTION)); if (zoneShareConnectivityArray.empty()) ___2039 = ___2039 && zoneShareConnectivityArray.alloc(___2846); ___2039 = ___2039 && file.___3459(___3944[___4674]) && readValueArray<int32_t, false, 0>(file, zoneOffset, ___2846, zoneShareConnectivityArray, IODescription(___4673)); if (___2039 && zoneOffset != 0) { for (___4636 zone = 0; zone < ___4636(___2846); ++zone) if (zoneShareConnectivityArray[zoneOffset + zone] != NOT_SHARED) zoneShareConnectivityArray[zoneOffset + zone] += zoneOffset; } static std::map<char, ZoneType_e> zoneTypeMap = boost::assign::map_list_of (___4705, ___4704) (ZONETYPE_FETRIANGLE_CHAR, ___4702) (ZONETYPE_FEQUAD_CHAR, ___4700) (ZONETYPE_FETETRA_CHAR, ___4701) (ZONETYPE_FEBRICK_CHAR, ___4695) (ZONETYPE_FELINESEG_CHAR, ___4696) (ZONETYPE_FEPOLYGON_CHAR, ___4698) (ZONETYPE_FEPOLYHEDRON_CHAR, ___4699) (ZONETYPE_FEMIXEDVOLUME_CHAR, ___4697); if (___2039) { for(size_t zone = 0; zone < ___2846; ++zone) { ZoneType_e ___4692 = zoneTypeMap[static_cast<char>(std::tolower(zoneTypeArray[zone]))]; zoneMetadata[zone].setZone(static_cast<___4636>(zone)); zoneMetadata[zone].setZoneType(___4692); if (___4692 == ___4704) { ___1844 ___1843( static_cast<___81>(iMaxOrNumNodesArray[zone]), static_cast<___81>(jMaxOrNumCellsArray[zone]), static_cast<___81>(kMaxOrNumCornersArray[zone])); zoneMetadata[zone].setIJKMax(___1843); } else { zoneMetadata[zone].setFEDescription( static_cast<___465>(jMaxOrNumCellsArray[zone]), static_cast<___682>(kMaxOrNumCornersArray[zone]), static_cast<___2718>(iMaxOrNumNodesArray[zone])); } zoneMetadata[zone].setIsSZL(isupper(zoneTypeArray[zone]) ? true : false); zoneMetadata[zone].setName(zoneNameArray[zone]); zoneMetadata[zone].setFaceNeighborMode(static_cast<FaceNeighborMode_e>(faceNeighborModeArray[zone])); zoneMetadata[zone].setSolutionTime(solutionTimeArray[zone]); zoneMetadata[zone].setStrandID(strandIDArray[zone]); zoneMetadata[zone].setParentZone(zoneOffset + parentZoneArray[zone]); } } } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading file header."); } catch(...) { ___2039 = ___1186("Unrecoverable error while reading file header."); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readPerVarZoneFileHeader( ___1399&       file, ___3945&               ___3944, ___4352                 varOffset, ___4636                zoneOffset, VarZoneMinMaxArray&        varZoneMinMaxArray, ___4391& varZoneValueLocationArray, ___4382& varZoneFieldDataTypeArray, ___4385&     varZoneIsPassiveArray, ___4388&         varZoneShareArray) { REQUIRE(file.___2041()); REQUIRE(IMPLICATION(varZoneMinMaxArray.empty(), varOffset == 0)); REQUIRE(IMPLICATION(!varZoneMinMaxArray.empty(), varOffset+___3944[___2845] <= varZoneMinMaxArray.size())); REQUIRE(varZoneValueLocationArray.size() == varZoneMinMaxArray.size()); REQUIRE(varZoneFieldDataTypeArray.size() == varZoneMinMaxArray.size()); REQUIRE(varZoneIsPassiveArray.size() == varZoneMinMaxArray.size()); REQUIRE(varZoneShareArray.size() == varZoneMinMaxArray.size()); ___372 ___2039 = ___4226; try { ___4352 ___2843 = static_cast<___4352>(___3944[___2845]); ___4636 ___2846 = static_cast<___4636>(___3944[___2849]); if (___2843 == 0 || ___2846 == 0) return ___4226; static ___3942 tagDescriptionMap = ___1406;
static std::vector<uint16_t> const tagList = boost::assign::list_of (VAR_ZONE_MIN_MAX_FILE_LOC_TAG) (___4393) (___4384) (___4387) (___4390); ___2039 = ___2039 && ensureRequiredHeaderTagValuesArePresent("file", ___3944, tagDescriptionMap, tagList); ___2039 = ___2039 && file.___3459(___3944[___4384]); for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ___4336++) ___2039 = ___2039 && readValueArray<uint8_t, false, 0>(file, zoneOffset, ___2846, varZoneFieldDataTypeArray[varOffset + ___4336], IODescription(VAR_ZONE_FIELD_DATA_TYPE_FILE_LOC_DESCRIPTION,___4336)); ___2039 = ___2039 && file.___3459(___3944[VAR_ZONE_MIN_MAX_FILE_LOC_TAG]); if (___2039) { bool minMaxesAreDouble = false; for (___4352 ___4336 = 0; !minMaxesAreDouble && ___4336 < ___2843; ++___4336) { for (___4636 zone = 0; !minMaxesAreDouble && zone < ___2846; ++zone) { FieldDataType_e ___1363 = (FieldDataType_e)varZoneFieldDataTypeArray[varOffset + ___4336][zoneOffset + zone]; if (___1363 == FieldDataType_Double || ___1363 == FieldDataType_Int32) minMaxesAreDouble = true; } } if (minMaxesAreDouble) { for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ___4336++) ___2039 = ___2039 && readMinMaxArray<double>(file, zoneOffset, ___2846, varZoneMinMaxArray[varOffset + ___4336], IODescription(VAR_ZONE_MIN_MAX_FILE_LOC_DESCRIPTION, ___4336)); } else { for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ___4336++) ___2039 = ___2039 && readMinMaxArray<float>(file, zoneOffset, ___2846, varZoneMinMaxArray[varOffset + ___4336], IODescription(VAR_ZONE_MIN_MAX_FILE_LOC_DESCRIPTION, ___4336)); } } ___2039 = ___2039 && file.___3459(___3944[___4393]); for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ___4336++) ___2039 = ___2039 && readValueArray<uint8_t, false, 0>(file, zoneOffset, ___2846, varZoneValueLocationArray[varOffset + ___4336], IODescription(VAR_ZONE_VALUE_LOCATION_FILE_LOC_DESCRIPTION,___4336)); ___2039 = ___2039 && file.___3459(___3944[___4387]); for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ___4336++) ___2039 = ___2039 && readValueArray<uint8_t, false, 0>(file, zoneOffset, ___2846, varZoneIsPassiveArray[varOffset + ___4336], IODescription(VAR_ZONE_IS_PASSIVE_FILE_LOC_DESCRIPTION,___4336)); ___2039 = ___2039 && file.___3459(___3944[___4390]); for (___4352 ___4336 = 0; ___2039 && ___4336 < ___2843; ___4336++) ___2039 = ___2039 && readValueArray<int32_t, false, 0>(file, zoneOffset, ___2846, varZoneShareArray[varOffset + ___4336], IODescription(VAR_ZONE_SHARE_FILE_LOC_DESCRIPTION,___4336)); if (___2039 && zoneOffset != 0) { for (___4352 ___4336 = 0; ___4336 < ___2843; ++___4336) for (___4636 zone = 0; zone < ___2846; ++zone) if (varZoneShareArray[varOffset + ___4336][zoneOffset + zone] != NOT_SHARED) varZoneShareArray[varOffset + ___4336][zoneOffset + zone] += zoneOffset; } } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading file header."); } catch(...) { ___2039 = ___1186("Unrecoverable error while reading file header."); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 readAuxDataItem( ___1399& file, ___4352           varOffset, ___4636          zoneOffset, ___230&             auxData) { uint8_t auxDataLocation = 0; uint32_t auxDataEntity = 0; uint32_t auxDataNameLength = 0; ___473 auxDataName; uint8_t auxDataType = 0; uint32_t auxDataValueLength = 0; ___473 auxDataValue; ___372 ___2039 = readValue<uint8_t, false>(file, auxDataLocation, IODescription(___252)) && readValue<uint32_t, false>(file, auxDataEntity, IODescription(___239)) && readValue<uint32_t, false>(file, auxDataNameLength, IODescription(___262)) && auxDataName.alloc(static_cast<uint64_t>(auxDataNameLength)) && readString(file, auxDataNameLength, auxDataName, IODescription(___261)) && readValue<uint8_t, false>(file, auxDataType, IODescription(___268)) && readValue<uint32_t, false>(file, auxDataValueLength, IODescription(___272)) && auxDataValue.alloc(static_cast<uint64_t>(auxDataValueLength)) && readString(file, auxDataValueLength, auxDataValue, IODescription(___271)); if (___2039) { try { AuxDataLocation_e location = static_cast<AuxDataLocation_e>(auxDataLocation); ___1172 entity = static_cast<___1172>(auxDataEntity); AuxDataType_e type = static_cast<AuxDataType_e>(auxDataType); ___478(type == ___270); if (location == ___258) entity += varOffset; else if (location == ___259) entity += zoneOffset; auxData = ___230(std::string(&auxDataName[0], auxDataNameLength), std::string(&auxDataValue[0], auxDataValueLength), location, entity, type); } catch (std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading auxiliary data."); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readAuxDataCount( ___1399& file, ___3945&         ___3944, uint32_t&            auxDataCount)
{ REQUIRE(file.___2041()); auxDataCount = 0; if (___3944[___241] == 0) return ___4226; ___372 ___2039 = file.___3459(___3944[___241]); if (file.___2002()) ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, SZPLT_AUX_DATA_MARKER, IODescription(SZPLT_AUX_DATA_MARKER_DESCRIPTION)); ___2039 = ___2039 && readValue<uint32_t, false>(file, auxDataCount, IODescription(___233)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readAuxData( ___1399& file, ___3945&         ___3944, ___4352           varOffset, ___4636          zoneOffset, uint32_t             auxDataOffset, AuxDataArray&        auxDataArray) { REQUIRE(file.___2041()); if (___3944[___241] == 0) return ___4226; uint32_t  auxDataCount = 0; ___372 ___2039 = readAuxDataCount(file, ___3944, auxDataCount); for(uint32_t i = 0; ___2039 && i < auxDataCount; ++i) ___2039 = readAuxDataItem(file, varOffset, zoneOffset, auxDataArray[auxDataOffset + i]); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 readGeomLineSegData( ___1399& file, ___1556&                ___1555) { REQUIRE(file.___2041()); REQUIRE(___1555.___2466 == GeomType_LineSegs); uint32_t ___2835; bool is3D = (___1555.___2616 == CoordSys_Grid3D);
 #if 0
std::vector<std::vector<class ___4580> > ___2464;
 #endif
___372 ___2039 = readValue<uint32_t, false>(file, ___2835, IODescription(___1623)); if (___2039) { try { ___1555.___2464.resize(static_cast<size_t>(___2835)); } catch(...) { ___2039 = ___1186("Out of memory while reading geometry data."); } } for(uint32_t segment = 0; ___2039 && segment < ___2835; ++segment) { uint32_t numPts = 0; ___1105 xPts; ___1105 yPts; ___1105 zPts; ___2039 = ___2039 && readValue<uint32_t, false>(file, numPts, IODescription(___1622)) && xPts.alloc(static_cast<uint64_t>(numPts)) && yPts.alloc(static_cast<uint64_t>(numPts)); if (is3D) ___2039 = ___2039 && zPts.alloc(static_cast<uint64_t>(numPts)); ___2039 = ___2039 && readValueArray<double, false, 0>(file, 0, static_cast<size_t>(numPts), xPts, IODescription(___1654)) && readValueArray<double, false, 0>(file, 0, static_cast<size_t>(numPts), yPts, IODescription(___1656)); if (is3D) ___2039 && readValueArray<double, false, 0>(file, 0, static_cast<size_t>(numPts), zPts, IODescription(___1659)); for(uint32_t i = 0; ___2039 && i < numPts; ++i) { try { if (is3D) ___1555.___2464[segment].push_back(___4580(xPts[i], yPts[i], zPts[i])); else ___1555.___2464[segment].push_back(___4580(xPts[i], yPts[i], 0.0)); } catch(...) { ___2039 = ___1186("Out of memory while reading geometry data."); } } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 readGeometry( ___1399& file, ___1556&                ___1555) { REQUIRE(file.___2041()); ___372 ___2039 = readValue<double, false>(file, ___1555.___2617[0], IODescription(___1653)) && readValue<double, false>(file, ___1555.___2617[1], IODescription(___1655)) && readValue<double, false>(file, ___1555.___2617[2], IODescription(___1658)); uint8_t ___3159 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___3159, IODescription(___1627)); ___1555.___2616 = static_cast<CoordSys_e>(___3159); uint8_t ___2004 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___2004, IODescription(___1611)); ___1555.___2484 = static_cast<___372>(___2004); int32_t zone = 0; ___2039 = ___2039 && readValue<int32_t, false>(file, zone, IODescription(___1657)); ___1555.___2677 = static_cast<___1172>(zone); uint16_t color = 0; ___2039 = ___2039 && readValue<uint16_t, false>(file, color, IODescription(___1571)); ___1555.___2395 = static_cast<___516>(color); uint16_t ___1411 = 0; ___2039 = ___2039 && readValue<uint16_t, false>(file, ___1411, IODescription(___1582)); ___1555.___2462 = static_cast<___516>(___1411); uint8_t ___2022 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___2022, IODescription(___1612)); ___1555.___2486 = static_cast<___372>(___2022); uint8_t ___1651 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___1651, IODescription(GEOM_GEOM_TYPE)); ___1555.___2466 = static_cast<GeomType_e>(___1651); uint8_t ___2263 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___2263, IODescription(___1613)); ___1555.___2489 = static_cast<LinePattern_e>(___2263); ___2039 = ___2039 && readValue<double, false>(file, ___1555.___2615, IODescription(___1625)); ___2039 = ___2039 && readValue<double, false>(file, ___1555.___2490, IODescription(___1614)); ___2039 = ___2039 && readValue<uint16_t, false>(file, ___1555.___2502, IODescription(___1621)); uint8_t arrowheadStyle = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, arrowheadStyle, IODescription(___1569)); ___1555.___2343 = static_cast<ArrowheadStyle_e>(arrowheadStyle); uint8_t arrowheadAttachment = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, arrowheadAttachment, IODescription(___1563)); ___1555.___2341 = static_cast<ArrowheadAttachment_e>(arrowheadAttachment); ___2039 = ___2039 && readValue<double, false>(file, ___1555.___2342, IODescription(___1568)); ___2039 = ___2039 && readValue<double, false>(file, ___1555.___2340, IODescription(___1562)); uint8_t geomScope = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, geomScope, IODescription(___1633)); ___1555.___2619 = static_cast<Scope_e>(geomScope); uint8_t geomClipping = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, geomClipping, IODescription(GEOM_CLIPPING)); ___1555.___2394 = static_cast<Clipping_e>(geomClipping); uint32_t macroFunctionCommandLength = 0; ___2039 = ___2039 && readValue<uint32_t, false>(file, macroFunctionCommandLength, IODescription(___1616)); if (___2039 && macroFunctionCommandLength > 0) { try { ___473 ___2330; ___2039 = ___2039 && ___2330.alloc(static_cast<uint64_t>(macroFunctionCommandLength)) && readString(file, static_cast<size_t>(macroFunctionCommandLength), ___2330, IODescription(___1615)); if (___2039) ___1555.___2491 = std::string(&___2330[0], static_cast<size_t>(macroFunctionCommandLength)); } catch (std::bad_alloc const&)
{ ___2039 = ___1186("Out-of-memory error while reading geometries."); } } ___4580 basicGeomData; ___478(!basicGeomData.___2067()); switch (___1555.___2466) { case GeomType_LineSegs: { ___2039 = ___2039 && readGeomLineSegData(file, ___1555); } break; case GeomType_Rectangle: { double ___4458 = 0.0; double ___1826 = 0.0; ___2039 = ___2039 && readValue<double, false>(file, ___4458, IODescription(___1630)) && readValue<double, false>(file, ___1826, IODescription(___1629)); if (___2039) basicGeomData = ___4580(___4458, ___1826, 0.0); } break; case GeomType_Square: { double squareSize = 0.0; ___2039 = ___2039 && readValue<double, false>(file, squareSize, IODescription(___1649)); if (___2039) basicGeomData = ___4580(squareSize, 0.0, 0.0); } break; case GeomType_Circle: { double radius = 0.0; ___2039 = ___2039 && readValue<double, false>(file, radius, IODescription(___1608)); if (___2039) basicGeomData = ___4580(radius, 0.0, 0.0); } break; case GeomType_Ellipse: { double horizontalAxis = 0.0; double verticalAxis = 0.0; ___2039 = ___2039 && readValue<double, false>(file, horizontalAxis, IODescription(___1578)) && readValue<double, false>(file, verticalAxis, IODescription(___1579)); if (___2039) basicGeomData = ___4580(horizontalAxis, verticalAxis, 0.0); } break; default: ___478(___1305); break; } if (___2039 && basicGeomData.___2067()) { try { ___1555.___2464.resize(1); ___1555.___2464[0].push_back(basicGeomData); } catch(...) { ___2039 = ___1186("Out of memory reading square geometry."); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readGeometriesCount( ___1399& file, ___3945&         ___3944, uint32_t&            geomCount) { REQUIRE(file.___2041()); geomCount = 0; if (___3944[___1581] == 0) return ___4226; ___372 ___2039 = file.___3459(___3944[___1581]); if (file.___2002()) ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, SZPLT_GEOMETRY_MARKER, IODescription(SZPLT_GEOMETRY_MARKER_DESCRIPTION)); ___2039 = ___2039 && readValue<uint32_t, false>(file, geomCount, IODescription(NUM_GEOMS_DESCRIPTION)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readGeometries( ___1399& file, ___3945&         ___3944, uint32_t             geomOffset, GeomArray&           geomArray) { REQUIRE(file.___2041()); if (___3944[___1581] == 0) return ___4226; uint32_t geomCount; ___372 ___2039 = readGeometriesCount(file, ___3944, geomCount); for(uint32_t i = 0; ___2039 && i < geomCount; ++i) ___2039 = readGeometry(file, geomArray[geomOffset + i]); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 readText( ___1399& file, Text&                ___4042) { REQUIRE(file.___2041()); ___372 ___2039 = readValue<double, false>(file, ___4042.___2626[0], IODescription(___1653)) && readValue<double, false>(file, ___4042.___2626[1], IODescription(___1655)) && readValue<double, false>(file, ___4042.___2626[2], IODescription(___1658)); uint16_t ___4080 = 0; ___2039 = ___2039 && readValue<uint16_t, false>(file, ___4080, IODescription(___4082)); ___4042.___2634 = static_cast<___516>(___4080); uint16_t ___4059 = 0; ___2039 = ___2039 && readValue<uint16_t, false>(file, ___4059, IODescription(___4060)); ___4042.___2628 = static_cast<___516>(___4059); uint16_t ___4061 = 0; ___2039 = ___2039 && readValue<uint16_t, false>(file, ___4061, IODescription(___4062)); ___4042.___2629 = static_cast<___516>(___4061); ___2039 = ___2039 && readValue<double, false>(file, ___4042.___2630, IODescription(___4072)); ___2039 = ___2039 && readValue<double, false>(file, ___4042.___2631, IODescription(___4074)); uint8_t ___4078 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4078, IODescription(TEXT_BOX_TYPE)); ___4042.___2632 = static_cast<TextBox_e>(___4078); uint8_t ___4043 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4043, IODescription(___4044)); ___4042.___2625 = static_cast<TextAnchor_e>(___4043); ___2039 = ___2039 && readValue<double, false>(file, ___4042.___2627, IODescription(___4057)); uint8_t ___4079 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4079, IODescription(TEXT_CLIPPING)); ___4042.___2633 = static_cast<Clipping_e>(___4079); ___2039 = ___2039 && readValue<double, false>(file, ___4042.___2635, IODescription(TEXT_HEIGHT)); ___2039 = ___2039 && readValue<double, false>(file, ___4042.___2637, IODescription(___4108)); uint8_t ___4115 = 0; ___2039 = ___2039 &&  readValue<uint8_t, false>(file, ___4115, IODescription(___4116)); ___4042.___2639 = static_cast<CoordSys_e>(___4115); uint8_t ___4119 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4119, IODescription(___4120)); ___4042.___2641 = static_cast<Scope_e>(___4119); uint8_t ___4124 = 0;
___2039 = ___2039 && readValue<uint8_t, false>(file, ___4124, IODescription(___4125)); ___4042.___2642 = static_cast<Units_e>(___4124); uint32_t textStringLength = 0; ___2039 = ___2039 && readValue<uint32_t, false>(file, textStringLength, IODescription(___4128)); try { if (textStringLength > 0) { ___473 ___4126; ___2039 = ___2039 && ___4126.alloc(static_cast<size_t>(textStringLength)) && readString(file, static_cast<size_t>(textStringLength), ___4126, IODescription(___4127)); if (___2039) ___4042.___2643 = std::string(&___4126[0], static_cast<size_t>(textStringLength)); } uint32_t textTypefaceFamilyLength = 0; ___2039 = ___2039 && readValue<uint32_t, false>(file, textTypefaceFamilyLength, IODescription(___4131)); if (___2039 && textTypefaceFamilyLength > 0) { ___473 ___4129; ___2039 = ___2039 && ___4129.alloc(static_cast<size_t>(textTypefaceFamilyLength)) && readString(file, static_cast<size_t>(textTypefaceFamilyLength), ___4129, IODescription(___4130)); if (___2039) ___4042.___2644 = std::string(&___4129[0], static_cast<size_t>(textTypefaceFamilyLength)); } uint8_t ___4132 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4132, IODescription(___4133)); ___4042.___2645 = static_cast<___372>(___4132); uint8_t ___4134 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4134, IODescription(___4135)); ___4042.___2646 = static_cast<___372>(___4134); int32_t ___4138 = 0; ___2039 = ___2039 && readValue<int32_t, false>(file, ___4138, IODescription(___4139)); ___4042.___2647 = static_cast<___1172>(___4138); uint8_t ___4105 = 0; ___2039 = ___2039 && readValue<uint8_t, false>(file, ___4105, IODescription(___4106)); ___4042.___2636 = static_cast<___372>(___4105); uint32_t textMacroFunctionCmdLength = 0; ___2039 = ___2039 && readValue<uint32_t, false>(file, textMacroFunctionCmdLength, IODescription(___4111)); if (___2039 && textMacroFunctionCmdLength > 0) { ___473 ___4109; ___2039 = ___2039 && ___4109.alloc(static_cast<size_t>(textMacroFunctionCmdLength)) && readString(file, static_cast<size_t>(textMacroFunctionCmdLength), ___4109, IODescription(___4110)); if (___2039) ___4042.___2638 = std::string(&___4109[0], static_cast<size_t>(textMacroFunctionCmdLength)); } } catch (std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading text."); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readTextsCount( ___1399& file, ___3945&         ___3944, uint32_t&            textCount) { REQUIRE(file.___2041()); textCount = 0; if (___3944[___4083] == 0) return ___4226; ___372 ___2039 = file.___3459(___3944[___4083]); if (file.___2002()) ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, SZPLT_TEXT_MARKER, IODescription(SZPLT_TEXT_MARKER_DESCRIPTION)); ___2039 = ___2039 && readValue<uint32_t, false>(file, textCount, IODescription(NUM_TEXTS_DESCRIPTION)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readTexts( ___1399& file, ___3945&         ___3944, uint32_t             textOffset, TextArray&           textArray) { REQUIRE(file.___2041()); if (___3944[___4083] == 0) return ___4226; uint32_t textCount = 0; ___372 ___2039 = readTextsCount(file, ___3944, textCount); for(uint32_t i = 0; ___2039 && i < textCount; ++i) ___2039 = readText(file, textArray[textOffset + i]); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 readCustomLabelSet( ___1399& file, CustomLabelSet&      customLabelSet) { REQUIRE(file.___2041()); ___372 ___2039 = readValue<uint32_t, false>(file, customLabelSet.m_numLabels, IODescription(___2820)) && readStringArray(file, 0, size_t(customLabelSet.m_numLabels), customLabelSet.m_labels, IODescription(___794)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readCustomLabelsCount( ___1399& file, ___3945&         ___3944, uint32_t&            customLabelsCount) { REQUIRE(file.___2041()); ___372 ___2039 = ___4226; customLabelsCount = 0; if (___3944[___795] == 0) return ___4226; ___2039 = file.___3459(___3944[___795]); if (file.___2002()) ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, SZPLT_CUSTOM_LABELS_MARKER, IODescription(SZPLT_CUSTOM_LABELS_MARKER_DESCRIPTION)); ___2039 = ___2039 && readValue<uint32_t, false>(file, customLabelsCount, IODescription(___793)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readCustomLabels( ___1399& file, ___3945&         ___3944, uint32_t&            customLabelsOffset, CustomLabelsArray&   customLabelsArray)
{ REQUIRE(file.___2041()); if (___3944[___795] == 0) return ___4226; uint32_t  customLabelsCount = 0; ___372 ___2039 = readCustomLabelsCount(file, ___3944, customLabelsCount); for(uint32_t i = 0; ___2039 && i < customLabelsCount; ++i) ___2039 = readCustomLabelSet(file, customLabelsArray[customLabelsOffset + i]); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readZoneHeaderTags( ___1399& file, ___4636          expectedZone, ___3945&         ___3944) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(expectedZone>=0); if ( file.___2002() ) { ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, SZPLT_ZONE_MARKER, IODescription(SZPLT_ZONE_MARKER_DESCRIPTION)); ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, uint32_t(expectedZone + 1), IODescription(SZPLT_ZONE_NUM_DESCRIPTION)); } ___3942 tagDescriptionMap = ___4689; ___2039 = ___2039 && readTagList(file, tagDescriptionMap, ___3944); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 checkArrayHeaderTag( uint16_t             tag, ___3945 const&   ___3944, IODescription const& ___972) { REQUIRE(!___972.isEmpty() && ___972.zone()!=IODescription::NO_ZONE); ___372 ___2039 = ___4226; ___3945::const_iterator iter = ___3944.find(tag); if ( iter == ___3944.end() ) { if ( ___972.___2977() == IODescription::NO_PARTITION ) ___2039 = ___1186("Missing zone header tag '%s' for zone %" PRIu64 ".", ___972.___2685(), uint64_t(___972.zone()+1)); else ___2039 = ___1186("Missing partition header tag '%s' for partition %" PRIu64 " of zone %" PRIu64 ".", ___972.___2685(), uint64_t(___972.___2977()+1), uint64_t(___972.zone()+1)); } else if ( iter->second == 0 || iter->second == ___330 ) { if ( ___972.___2977() == IODescription::NO_PARTITION ) ___2039 = ___1186("Invalid value for zone header tag '%s' for zone %" PRIu64, ___972.___2685(), uint64_t(___972.zone()+1)); else ___2039 = ___1186("Invalid value for partition header tag '%s' for partition %" PRIu64 " of zone %" PRIu64 ".", ___972.___2685(), uint64_t(___972.___2977()+1), uint64_t(___972.zone()+1)); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 applyZoneHeaderScalarTagValues( ___3945&  ___3944, ZoneMetadata& zoneMetadata) { ___372 ___2039 = ___4226; try { zoneMetadata.m_classicZoneFileLocations.___2498 = (___3944[___2725] ? ___3944[___2725] : ___330); zoneMetadata.m_classicZoneFileLocations.___2663 = (___3944[USER_FACE_NBR_FILE_LOC_TAG] ? ___3944[USER_FACE_NBR_FILE_LOC_TAG] : ___330); ___2090::___2980 const numPartitions = ___2090::___2980(___3944[NUM_PARTITIONS_TAG]); if ( numPartitions == 0 ) zoneMetadata.setNumPartitions(1); else zoneMetadata.setNumPartitions(numPartitions); } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while retrieving file tags."); } catch(...) { ___2039 = ___1186("Unrecoverable error while retrieving file tags."); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { template<typename T> ___372 readHeaderTagArray( ___1399&  file, ___3945&          ___3944, uint16_t              tagValue, size_t                ___2865, size_t                numValues, ___2240<T>& valueArray, ___372           (*readValueArrayFunc)(___1399& file, size_t ___2865, size_t ___2795, ___2240<T>& valueArray, IODescription const& ___972), IODescription const&  ___972) { ___372 ___2039 = checkArrayHeaderTag(tagValue, ___3944, ___972); if ( ___2039 ) { ___1393 const fileLoc = ___3944[tagValue]; ___478(fileLoc != ___330 && fileLoc != 0); ___2039 = file.___3459(fileLoc) && readValueArrayFunc(file, ___2865, numValues, valueArray, ___972); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 readNonSZLZoneHeaderArrays( ___1399& file, ___3945&         ___3944, ___4352           numVarsInFile, ZoneMetadata&        zoneMetadata) { ___372 ___2039 = ___4226; REQUIRE(!zoneMetadata.isSZL()); ___4636 zone = zoneMetadata.zone(); try { ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, ___4342, 0, numVarsInFile, zoneMetadata.m_classicZoneFileLocations.___2673, readValueArray<uint64_t, true, 0>, IODescription(VAR_FILE_LOC_DESCRIPTION, IODescription::NO_VAR, zone)); } catch (std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading zone %" PRIu64 " header.", uint64_t(zone + 1)); } catch (...) { ___2039 = ___1186("Unrecoverable error while reading zone %" PRIu64 " header.", uint64_t(zone + 1)); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { inline uint64_t minMaxBlockSize(FieldDataType_e ___1363, ___2090::SubzoneOffset_t numSubzones, bool ___2002) { REQUIRE(VALID_ENUM(___1363, FieldDataType_e));
REQUIRE(numSubzones > 0); switch (___1363) { case FieldDataType_Float: return arraySizeInFile<std::pair<float, float>, false >(numSubzones, ___2002); case FieldDataType_Double: return arraySizeInFile<std::pair<double, double>, false >(numSubzones, ___2002); case FieldDataType_Int32: return arraySizeInFile<std::pair<int32_t, int32_t>, false >(numSubzones, ___2002); case FieldDataType_Int16: return arraySizeInFile<std::pair<int16_t, int16_t>, false >(numSubzones, ___2002); case FieldDataType_Byte: case ___1365: return arraySizeInFile<std::pair<uint8_t, uint8_t>, false >(numSubzones, ___2002); default: ___478(___1305); return 0; } } } namespace { ___372 readSZLNonPartitionedZoneHeaderArrays( ___1399&      file, ___1388 const&    ___1387, ___3945&              ___3944, ___4352                varOffset, ___4352                numVarsInFile, VarZoneMinMaxArray const& vzMinMax, ___4382 const& vzFieldDataTypes, ZoneMetadata&             zoneMetadata) { REQUIRE(file.___2041()); REQUIRE(numVarsInFile>0); REQUIRE(IMPLICATION(vzMinMax.empty(), varOffset == 0)); REQUIRE(IMPLICATION(!vzMinMax.empty(), size_t(varOffset+numVarsInFile) <= vzMinMax.size())); REQUIRE(zoneMetadata.isSZL()); REQUIRE(zoneMetadata.getNumPartitions()==1); ___4636 const zone = zoneMetadata.zone(); ___478(zoneMetadata.m_ptnFileNums.empty()); ___478(zoneMetadata.m_ptnHeaderFileLocs.empty()); ___372 ___2039 = ___4226; try { ___2039 = ___2039 && zoneMetadata.m_ptnNumCells.alloc(1); ___2039 = ___2039 && zoneMetadata.m_ptnNumNodes.alloc(1); ___2039 = ___2039 && zoneMetadata.m_ptnFirstCell.alloc(1); ___2039 = ___2039 && zoneMetadata.m_ptnFirstNode.alloc(1); if ( zoneMetadata.getZoneType() == ___4704 ) { ___2039 = ___2039 && zoneMetadata.m_ptnNodeMinIJKs.alloc(1); ___2039 = ___2039 && zoneMetadata.m_ptnNodeMaxIJKs.alloc(1); } ___2039 = ___2039 && zoneMetadata.m_ptnNumCszs.alloc(1); ___2039 = ___2039 && zoneMetadata.m_ptnNumNszs.alloc(1); if ( ___2039 ) { ___465 const ___2781 = zoneMetadata.___1766(); ___2718 const ___2821 = zoneMetadata.___1768(); zoneMetadata.m_ptnNumCells[0] = ___2781; zoneMetadata.m_ptnNumNodes[0] = ___2821; zoneMetadata.m_ptnFirstCell[0] = 0; zoneMetadata.m_ptnFirstNode[0] = 0; if ( zoneMetadata.getZoneType() == ___4704 ) { ___2039 = ___2039 && zoneMetadata.m_ijkZoneInfos.alloc(1); if (___2039) { zoneMetadata.m_ijkZoneInfos[0] = ___1881(zoneMetadata.getZoneIJK(), ___1387.___1757()); zoneMetadata.m_ptnNodeMinIJKs[0] = ___1844(0,0,0); zoneMetadata.m_ptnNodeMaxIJKs[0] = zoneMetadata.getZoneIJK()-1; zoneMetadata.m_ptnNumCszs[0] = zoneMetadata.m_ijkZoneInfos[0].getNumCszs(); zoneMetadata.m_ptnNumNszs[0] = zoneMetadata.m_ijkZoneInfos[0].getNumNszs(); } } else { zoneMetadata.m_ptnNumCszs[0] = getNumSzFromNumItems(___2781); zoneMetadata.m_ptnNumNszs[0] = getNumSzFromNumItems(___2821); } } ___2039 = ___2039 && zoneMetadata.m_varPtnMinMaxTrees.alloc(numVarsInFile); for ( ___4352 ___4336 = 0; ___2039 && ___4336 < numVarsInFile; ++___4336 ) zoneMetadata.m_varPtnMinMaxTrees[___4336].populateTreeFromMinMax(vzMinMax[varOffset + ___4336][zone]); ___2039 = ___2039 && zoneMetadata.m_ptnMetadata.alloc(1); if ( ___2039 ) { PartitionMetadata& partitionMetadata = zoneMetadata.m_ptnMetadata[0]; ___2039 = ___2039 && partitionMetadata.m_cszMinMaxFileLocs.alloc(numVarsInFile); ___2039 = ___2039 && partitionMetadata.m_szDataStartFileLocs.alloc(numVarsInFile); ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, ___4342, 0, numVarsInFile, partitionMetadata.m_nszMinMaxFileLocs, readValueArray<uint64_t, true, 0>, IODescription(VAR_FILE_LOC_DESCRIPTION,IODescription::NO_VAR,zone)); if ( ___2039 ) { ___2090::SubzoneOffset_t const numCszs = zoneMetadata.getNumCszsInPartition(0); ___2090::SubzoneOffset_t const numNszs = zoneMetadata.getNumNszsInPartition(0); uint64_t nszMinMaxBlockSize; uint64_t cszMinMaxBlockSize; for ( ___4352 ___4336 = 0; ___4336 < numVarsInFile; ++___4336 ) { nszMinMaxBlockSize = minMaxBlockSize((FieldDataType_e)vzFieldDataTypes[varOffset + ___4336][zone], numNszs, ___1387.___2002() ? true : false); cszMinMaxBlockSize = minMaxBlockSize((FieldDataType_e)vzFieldDataTypes[varOffset + ___4336][zone], numCszs, ___1387.___2002() ? true : false); if (partitionMetadata.m_nszMinMaxFileLocs[___4336] != ___330) { partitionMetadata.m_cszMinMaxFileLocs[___4336]   = partitionMetadata.m_nszMinMaxFileLocs[___4336] + nszMinMaxBlockSize; partitionMetadata.m_szDataStartFileLocs[___4336] = partitionMetadata.m_cszMinMaxFileLocs[___4336] + cszMinMaxBlockSize; } else { partitionMetadata.m_cszMinMaxFileLocs[___4336]   = ___330; partitionMetadata.m_szDataStartFileLocs[___4336] = ___330; } } if (___3894(zoneMetadata.getZoneType()) && ___1387.___844() != ___848) { if (___3944.find(NSZ_CONNECT_FILE_LOC_TAG) != ___3944.end() && ___3944.find(NSZ_CONNECT_FILE_LOC_TAG)->second != ___330) { ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, NSZ_CONNECT_FILE_LOC_TAG, 0, numNszs,
partitionMetadata.m_nszConnectivityFileLocs, readValueArray<uint64_t, true, 0>, IODescription(NSZ_CONNECT_FILE_LOC_DESCRIPTION,IODescription::NO_VAR,zone)); ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, CSZ_CONNECT_FILE_LOC_TAG, 0, numCszs, partitionMetadata.m_cszConnectivityFileLocs, readValueArray<uint64_t, true, 0>, IODescription(CSZ_CONNECT_FILE_LOC_DESCRIPTION,IODescription::NO_VAR,zone)); if (___1387.getFileVersion() > 104) { ___2039 = ___2039 && readHeaderTagArray<uint16_t>( file, ___3944, NUM_REF_NODE_SUBZONES_TAG, 0, numCszs, partitionMetadata.m_cszNumRefNszs, readValueArray<uint16_t, false, 0>, IODescription(NUM_REF_NODE_SUBZONES_DESCRIPTION,IODescription::NO_VAR,zone)); ___2039 = ___2039 && readHeaderTagArray<uint16_t>( file, ___3944, NUM_REF_CELL_SUBZONES_TAG, 0, numNszs, partitionMetadata.m_nszNumRefCszs, readValueArray<uint16_t, false, 0>, IODescription(NUM_REF_CELL_SUBZONES_DESCRIPTION,IODescription::NO_VAR,zone)); } } else { ___2039 = ((___3944.find(NSZ_CONNECT_FILE_LOC_TAG) != ___3944.end() && ___3944.find(NSZ_CONNECT_FILE_LOC_TAG)->second == ___330) && (___3944.find(CSZ_CONNECT_FILE_LOC_TAG) != ___3944.end() && ___3944.find(CSZ_CONNECT_FILE_LOC_TAG)->second == ___330) && IMPLICATION(___1387.getFileVersion() > 104, (___3944.find(NUM_REF_NODE_SUBZONES_TAG) != ___3944.end() && ___3944.find(NUM_REF_NODE_SUBZONES_TAG)->second == ___330) && (___3944.find(NUM_REF_CELL_SUBZONES_TAG) != ___3944.end() && ___3944.find(NUM_REF_CELL_SUBZONES_TAG)->second == ___330))); if (!___2039) ___1186("Connectivity integrity error while reading SZL zone %" PRIu64 " header.", uint64_t(zone+1)); } } } } else { throw std::bad_alloc(); } } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading SZL zone %" PRIu64 " header.", uint64_t(zone+1)); } catch(...) { ___2039 = ___1186("Unrecoverable error while reading SZL zone %" PRIu64 " header.", uint64_t(zone+1)); } if ( !___2039 ) { zoneMetadata.m_ptnNumCells.___937(); zoneMetadata.m_ptnNumNodes.___937(); zoneMetadata.m_ptnFirstCell.___937(); zoneMetadata.m_ptnFirstNode.___937(); zoneMetadata.m_ptnNumCszs.___937(); zoneMetadata.m_ptnNumNszs.___937(); zoneMetadata.m_varPtnMinMaxTrees.___937(); zoneMetadata.m_ptnMetadata.___937(); } ENSURE(zoneMetadata.m_ptnFileNums.empty()); ENSURE(zoneMetadata.m_ptnHeaderFileLocs.empty()); ENSURE(zoneMetadata.m_varPtnMinMaxFileLocs.empty()); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumCells.size()==1)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumCells.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumNodes.size()==1)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumNodes.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnFirstCell.size() == 1)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnFirstCell.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnFirstNode.size() == 1)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnFirstNode.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumCszs.size()==1)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumCszs.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumNszs.size()==1)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumNszs.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_varPtnMinMaxTrees.size()==size_t(numVarsInFile))); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_varPtnMinMaxTrees.empty())); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 readSZLPartitionedZoneHeaderArrays( ___1399&      file, ___1388 const&    ___1387, ___3945&              ___3944, ___4352                ASSERT_ONLY(varOffset), ___4352                ___2843, VarZoneMinMaxArray const& ASSERT_ONLY(vzMinMax), ___4382 const& vzFieldDataTypes, ZoneMetadata&             zoneMetadata) { REQUIRE(file.___2041()); REQUIRE(___2843>0); REQUIRE(IMPLICATION(vzMinMax.empty(), varOffset == 0)); REQUIRE(IMPLICATION(!vzMinMax.empty(), size_t(varOffset+___2843) <= vzMinMax.size())); REQUIRE(zoneMetadata.isSZL()); REQUIRE(zoneMetadata.getNumPartitions()>1); ___372 ___2039 = ___4226; ___4636 const zone = zoneMetadata.zone(); ___2090::___2980 const numPartitions = zoneMetadata.getNumPartitions(); try { ___2039 = ___2039 && zoneMetadata.m_ptnMetadata.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnNumCszs.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnNumNszs.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnFirstNode.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnFirstCell.alloc(numPartitions); ___2039 = ___2039 && readHeaderTagArray<uint32_t>( file, ___3944, PARTITION_FILE_NUM_TAG, 0, numPartitions, zoneMetadata.m_ptnFileNums, readValueArray<uint32_t, false, 0>, IODescription(PARTITION_FILE_NUM_DESCRIPTION,IODescription::NO_VAR,zone)); ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, PARTITION_FILE_LOC_TAG, 0, numPartitions, zoneMetadata.m_ptnHeaderFileLocs, readValueArray<uint64_t, true, 0>,
IODescription(PARTITION_FILE_LOC_DESCRIPTION,IODescription::NO_VAR,zone)); if (___3894(zoneMetadata.getZoneType())) { ___2039 = ___2039 && zoneMetadata.m_ptnNumCells.alloc(numPartitions) && zoneMetadata.m_ptnNumNodes.alloc(numPartitions); ___2240<uint32_t> tempArray; ___2039 = ___2039 && readHeaderTagArray<uint32_t>( file, ___3944, PARTITION_NUM_CELLS_TAG, 0, numPartitions, tempArray, readValueArray<uint32_t, false, 0>, IODescription(PARTITION_NUM_CELLS_DESCRIPTION, IODescription::NO_VAR, zone)); for (___2090::___2980 i = 0; ___2039 && i < numPartitions; ++i) zoneMetadata.m_ptnNumCells[i] = tempArray[i]; ___2039 = ___2039 && readHeaderTagArray<uint32_t>( file, ___3944, PARTITION_NUM_NODES_TAG, 0, numPartitions, tempArray, readValueArray<uint32_t, false, 0>, IODescription(PARTITION_NUM_NODES_DESCRIPTION, IODescription::NO_VAR, zone)); for (___2090::___2980 i = 0; ___2039 && i < numPartitions; ++i) zoneMetadata.m_ptnNumNodes[i] = tempArray[i]; tempArray.___937(); if ( ___2039 ) { ___465 totalNumCells = 0; ___2718 totalNumNodes = 0; for ( ___2090::___2980 ___2977 = 0; ___2977 < numPartitions; ___2977++ ) { ___465 const ___2781 = zoneMetadata.m_ptnNumCells[___2977]; zoneMetadata.m_ptnNumCszs[___2977] = getNumSzFromNumItems(___2781); zoneMetadata.m_ptnFirstCell[___2977] = totalNumCells; totalNumCells += ___2781; ___2718 const ___2821 = zoneMetadata.m_ptnNumNodes[___2977]; zoneMetadata.m_ptnNumNszs[___2977] = getNumSzFromNumItems(___2821); zoneMetadata.m_ptnFirstNode[___2977] = totalNumNodes; totalNumNodes += ___2821; } if ( totalNumCells != zoneMetadata.___1766() ) ___2039 = ___1186("Mismatch of number of cell between zone and partitions in partitioned zone %" PRIu64 ".", uint64_t(zone+1)); else if ( totalNumNodes != zoneMetadata.___1768() ) ___2039 = ___1186("Mismatch of number of node between zone and partitions in partitioned zone %" PRIu64 ".", uint64_t(zone+1)); } } else { ___478(supportedOrderedVolumeZoneType(zoneMetadata.getZoneType(), zoneMetadata.getZoneIJK())); ___478(zoneMetadata.m_ptnNumNodes.empty()); ___478(zoneMetadata.m_ptnNumCells.empty()); ___2039 = ___2039 && zoneMetadata.m_ptnNumNodes.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnNumCells.alloc(numPartitions); ___2240<uint64_t> ptnMinNodeNumbers; ___2240<uint64_t> ptnMaxNodeNumbers; ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, PARTITION_MIN_NODE_NUMBERS_TAG, 0, numPartitions, ptnMinNodeNumbers, readValueArray<uint64_t, false, 0>, IODescription(PARTITION_MIN_NODE_NUMBERS_DESCRIPTION, IODescription::NO_VAR, zone)); ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, PARTITION_MAX_NODE_NUMBERS_TAG, 0, numPartitions, ptnMaxNodeNumbers, readValueArray<uint64_t, false, 0>, IODescription(PARTITION_MAX_NODE_NUMBERS_DESCRIPTION, IODescription::NO_VAR, zone)); ___2039 = ___2039 && zoneMetadata.m_ijkZoneInfos.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnNodeMinIJKs.alloc(numPartitions); ___2039 = ___2039 && zoneMetadata.m_ptnNodeMaxIJKs.alloc(numPartitions); if (___2039) { ___465 totalNumCells = 0; ___2718 totalNumNodes = 0; for (___2090::___2980 ___2977 = 0; ___2977 < numPartitions; ___2977++) { zoneMetadata.m_ptnNodeMinIJKs[___2977] = zoneMetadata.getZoneIJK().ijkAtOffset(static_cast<___81>(ptnMinNodeNumbers[___2977])); zoneMetadata.m_ptnNodeMaxIJKs[___2977] = zoneMetadata.getZoneIJK().ijkAtOffset(static_cast<___81>(ptnMaxNodeNumbers[___2977])); ___1844 nodeDimensionIJK = zoneMetadata.m_ptnNodeMaxIJKs[___2977] - zoneMetadata.m_ptnNodeMinIJKs[___2977] + 1; IJKSubzoneInfo nodeSubzoneInfo(nodeDimensionIJK, ___1387.___1757(), ___2977, true  ); ___1844 cellDimensionIJK = nodeDimensionIJK; if (zoneMetadata.m_ptnNodeMaxIJKs[___2977].i() == zoneMetadata.getZoneIJK().i() - 1) cellDimensionIJK.setI(nodeDimensionIJK.i() - 1); if (zoneMetadata.m_ptnNodeMaxIJKs[___2977].___2105() == zoneMetadata.getZoneIJK().___2105() - 1) cellDimensionIJK.setJ(nodeDimensionIJK.___2105() - 1); if (zoneMetadata.m_ptnNodeMaxIJKs[___2977].___2134() == zoneMetadata.getZoneIJK().___2134() - 1) cellDimensionIJK.___3497(nodeDimensionIJK.___2134() - 1); IJKSubzoneInfo cellSubzoneInfo(cellDimensionIJK, ___1387.___1757(), ___2977, true); zoneMetadata.m_ijkZoneInfos[___2977] = ___1881(___2977, nodeSubzoneInfo, cellSubzoneInfo); zoneMetadata.m_ptnNumCells[___2977] = zoneMetadata.m_ijkZoneInfos[___2977].___1766(); zoneMetadata.m_ptnFirstCell[___2977] = totalNumCells; totalNumCells += zoneMetadata.m_ptnNumCells[___2977]; zoneMetadata.m_ptnNumCszs[___2977] = zoneMetadata.m_ijkZoneInfos[___2977].getNumCszs(); zoneMetadata.m_ptnNumNodes[___2977] = zoneMetadata.m_ijkZoneInfos[___2977].___1768(); zoneMetadata.m_ptnFirstNode[___2977] = totalNumNodes; totalNumNodes += zoneMetadata.m_ptnNumNodes[___2977]; zoneMetadata.m_ptnNumNszs[___2977] = zoneMetadata.m_ijkZoneInfos[___2977].getNumNszs();
zoneMetadata.addPartitionTreeItem(___2977, zoneMetadata.m_ptnNodeMinIJKs[___2977], zoneMetadata.m_ptnNodeMaxIJKs[___2977]); } if (totalNumCells != zoneMetadata.___1766()) ___2039 = ___1186("Mismatch of number of cell between zone and partitions in partitioned zone %s" PRIu64 ".", uint64_t(zone + 1)); else if (totalNumNodes != zoneMetadata.___1768()) ___2039 = ___1186("Mismatch of number of node between zone and partitions in partitioned zone %s" PRIu64 ".", uint64_t(zone + 1)); } ptnMinNodeNumbers.___937(); ptnMaxNodeNumbers.___937(); } ___2039 = ___2039 && checkArrayHeaderTag(VAR_PARTITION_MIN_MAX_TAG, ___3944, IODescription(VAR_PARTITION_MIN_MAX_DESCRIPTION,IODescription::NO_VAR,zone)); ___2039 = ___2039 && zoneMetadata.m_varPtnMinMaxFileLocs.alloc(___2843, ___330); ___2039 = ___2039 && zoneMetadata.m_varPtnMinMaxTrees.alloc(___2843); if ( ___2039 ) { size_t const headerSize = file.___2002() ? ___206 + ASCII_SPACING_LEN : 0 ; ___1393 fileLoc = ___3944[VAR_PARTITION_MIN_MAX_TAG]; zoneMetadata.m_varPtnMinMaxFileLocs[0] = fileLoc; for ( ___4352 ___4336 = 1; ___4336 < ___2843; ++___4336 ) { size_t sizePerMinMax; switch ((FieldDataType_e)vzFieldDataTypes[___4336][zone]) { case FieldDataType_Float: sizePerMinMax = file.___2002() ? ASCII_FLOAT_MINMAX_LEN + ASCII_SPACING_LEN : 2 * sizeof(float); break; case FieldDataType_Double: sizePerMinMax = file.___2002() ? ASCII_DOUBLE_MINMAX_LEN + ASCII_SPACING_LEN : 2 * sizeof(double); break; case FieldDataType_Int32: sizePerMinMax = file.___2002() ? ASCII_INT32_MINMAX_LEN + ASCII_SPACING_LEN : 2 * sizeof(int32_t); break; case FieldDataType_Int16: sizePerMinMax = file.___2002() ? ASCII_INT16_MINMAX_LEN + ASCII_SPACING_LEN : 2 * sizeof(int16_t); break; case FieldDataType_Byte: case ___1365: sizePerMinMax = file.___2002() ? ASCII_UINT8_MINMAX_LEN + ASCII_SPACING_LEN : 2 * sizeof(uint8_t); break; default: ___478(___1305); sizePerMinMax = 0; break; } fileLoc += headerSize + numPartitions * sizePerMinMax; zoneMetadata.m_varPtnMinMaxFileLocs[___4336] = fileLoc; } } } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading partitioned zone %" PRIu64 " header.", uint64_t(zone+1)); } catch(...) { ___2039 = ___1186("Unrecoverable error while reading partitioned zone %" PRIu64 " header.", uint64_t(zone+1)); } if ( !___2039 ) { zoneMetadata.m_ptnFileNums.___937(); zoneMetadata.m_ptnHeaderFileLocs.___937(); zoneMetadata.m_ptnNumCells.___937(); zoneMetadata.m_ptnNumNodes.___937(); zoneMetadata.m_ptnFirstCell.___937(); zoneMetadata.m_ptnFirstNode.___937(); zoneMetadata.m_ptnNumCszs.___937(); zoneMetadata.m_ptnNumNszs.___937(); zoneMetadata.m_ptnNodeMinIJKs.___937(); zoneMetadata.m_ptnNodeMaxIJKs.___937(); zoneMetadata.m_varPtnMinMaxFileLocs.___937(); zoneMetadata.m_varPtnMinMaxTrees.___937(); } ENSURE(VALID_BOOLEAN(___2039)); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnFileNums.size()==size_t(numPartitions))); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnFileNums.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnHeaderFileLocs.size()==size_t(numPartitions) && zoneMetadata.m_ptnHeaderFileLocs[0] != ___330 && zoneMetadata.m_ptnHeaderFileLocs[numPartitions/2] != ___330 && zoneMetadata.m_ptnHeaderFileLocs[numPartitions-1] != ___330)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnHeaderFileLocs.empty())); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumCells.empty())); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumNodes.empty())); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnFirstCell.empty())); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnFirstNode.empty())); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNodeMinIJKs.empty())); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNodeMaxIJKs.empty())); if (___3894(zoneMetadata.getZoneType())) { ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumCells.size() == size_t(numPartitions) && zoneMetadata.m_ptnNumCells[0] > 0 && zoneMetadata.m_ptnNumCells[numPartitions / 2] > 0 && zoneMetadata.m_ptnNumCells[numPartitions - 1] > 0)); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumNodes.size() == size_t(numPartitions) && zoneMetadata.m_ptnNumNodes[0] > 0 && zoneMetadata.m_ptnNumNodes[numPartitions / 2] > 0 && zoneMetadata.m_ptnNumNodes[numPartitions - 1] > 0)); } else { ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNodeMaxIJKs.size() == size_t(numPartitions))); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNodeMaxIJKs.size() == size_t(numPartitions) && zoneMetadata.m_ptnNodeMaxIJKs[0].blockSize() > 0 && zoneMetadata.m_ptnNodeMaxIJKs[numPartitions / 2].blockSize() > 0 && zoneMetadata.m_ptnNodeMaxIJKs[numPartitions - 1].blockSize() > 0)); } ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumCszs.size()==size_t(numPartitions) && zoneMetadata.m_ptnNumCszs[0] > 0 && zoneMetadata.m_ptnNumCszs[numPartitions/2] > 0 && zoneMetadata.m_ptnNumCszs[numPartitions-1] > 0)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumCszs.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_ptnNumNszs.size()==size_t(numPartitions) &&
zoneMetadata.m_ptnNumNszs[0] > 0 && zoneMetadata.m_ptnNumNszs[numPartitions/2] > 0 && zoneMetadata.m_ptnNumNszs[numPartitions-1] > 0)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_ptnNumNszs.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_varPtnMinMaxFileLocs.size() == size_t(___2843) && zoneMetadata.m_varPtnMinMaxFileLocs[0] != ___330 && zoneMetadata.m_varPtnMinMaxFileLocs[___2843/2] != ___330 && zoneMetadata.m_varPtnMinMaxFileLocs[___2843-1] != ___330)); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_varPtnMinMaxFileLocs.empty())); ENSURE(IMPLICATION(___2039, zoneMetadata.m_varPtnMinMaxTrees.size()==size_t(___2843))); ENSURE(IMPLICATION(!___2039, zoneMetadata.m_varPtnMinMaxTrees.empty())); return ___2039; } } ___372 readZoneHeaders( ___1399&             file, ___1388 const&           ___1387, ___4636                      expectedZone, ___4352                       varOffset, ___4352                       numFileVars, VarZoneMinMaxArray const&        vzMinMax, ___4382 const& vzFieldDataType, ZoneMetadata&                    zoneMetadata) { ___3945 ___3944; ___372 ___2039 = readZoneHeaderTags(file, expectedZone, ___3944); ___2039 = ___2039 && applyZoneHeaderScalarTagValues(___3944, zoneMetadata); if (zoneMetadata.isSZL()) { if (___2039) { if (zoneMetadata.getNumPartitions() == 1) { ___2039 = ___2039 && readSZLNonPartitionedZoneHeaderArrays( file, ___1387, ___3944, varOffset, numFileVars, vzMinMax, vzFieldDataType, zoneMetadata); } else { ___2039 = ___2039 && readSZLPartitionedZoneHeaderArrays( file, ___1387, ___3944, varOffset, numFileVars, vzMinMax, vzFieldDataType, zoneMetadata); } } ___478(IMPLICATION(___2039 && zoneMetadata.getZoneType() == ___4704, !zoneMetadata.m_ijkZoneInfos.empty())); } else { ___2039 = ___2039 && readNonSZLZoneHeaderArrays( file, ___3944, numFileVars, zoneMetadata); } return ___2039; } namespace { ___372 readUserFaceNeighborHeader( ___1399& file, ___4636          expectedZone) { REQUIRE(expectedZone >= 0); REQUIRE(file.___2002()); ___372 ___2039 = (readAndVerifyValue<uint32_t, false>( file, SZPLT_USER_FACE_NEIGHBOR_MARKER, IODescription(SZPLT_USER_FACE_NEIGHBOR_MARKER_DESCRIPTION)) && readAndVerifyValue<uint32_t, false>( file, expectedZone + 1, IODescription(SZPLT_ZONE_NUM_DESCRIPTION))); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readFaceNeighbors( ___1399& file, ___4636          expectedZone, uint64_t&            numValues, ___1965&          ___4299) { ___372 ___2039 = ___4226; if (file.___2002()) ___2039 = readUserFaceNeighborHeader(file, expectedZone); ___2039 = ___2039 && readValue<uint64_t, false>(file, numValues, IODescription(SZPLT_USER_FACE_NEIGHBORS_COUNT_DESCRIPTION)); if (numValues) ___2039 = ___2039 && readValueArray<int32_t, false, 0>(file, 0, numValues, ___4299, IODescription(SZPLT_USER_FACE_NEIGHBORS_DESCRIPTION)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } namespace { ___372 readPartitionHeaderTags( ___1399&     file, ___4636              expectedZone, ___2090::___2980 expectedPartition, ___3945&             ___3944) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(expectedZone>=0); if ( file.___2002() ) { ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, SZPLT_PARTITION_MARKER, IODescription(SZPLT_PARTITION_MARKER_DESCRIPTION)); ___2039 = ___2039 && readAndVerifyValue<uint32_t, false>(file, uint32_t(expectedPartition + 1), IODescription(SZPLT_PARTITION_NUM_DESCRIPTION, IODescription::NO_VAR, expectedZone)); } static ___3942 tagDescriptionMap = PARTITION_TAG_DESCRIPTIONS_MAP_INITIALIZER; ___2039 = ___2039 && readTagList(file, tagDescriptionMap, ___3944); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 applyPartitionHeaderScalarTagValues( ___3945&       ___3944, PartitionMetadata& partitionMetadata) { ___372 ___2039 = ___4226; if ( ___2039 ) { try { partitionMetadata.m_numRefPartitions = ___2090::___2980(___3944[NUM_REF_PARTITIONS_TAG]); } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while retrieving partition tags."); } catch(...) { ___2039 = ___1186("Unrecoverable error while retrieving partition tags."); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readVarLocations( ___1399&             file, ___1388 const&           ___1387, ___3945&                     ___3944, ___4352                       varOffset, ___4352                       ___2843, ___2090::SubzoneOffset_t     numCszsInPartition, ___2090::SubzoneOffset_t     numNszsInPartition, PartitionMetadata&               partitionMetadata, ___4636                      zone, ___2090::___2980         ___2977, ___4382 const& vzFieldDataTypes) { ___372 ___2039 = readHeaderTagArray<uint64_t>( file, ___3944, ___4342, 0, ___2843, partitionMetadata.m_nszMinMaxFileLocs, readValueArray<uint64_t, true, 0>,
IODescription(VAR_FILE_LOC_DESCRIPTION, IODescription::NO_VAR, zone, ___2977)); ___2039 = ___2039 && partitionMetadata.m_cszMinMaxFileLocs.alloc(___2843); ___2039 = ___2039 && partitionMetadata.m_szDataStartFileLocs.alloc(___2843); if (___2039) { for (___4352 ___4336 = 0; ___4336 < ___2843; ++___4336) { size_t const nszMinMaxBlockSize = minMaxBlockSize((FieldDataType_e)vzFieldDataTypes[varOffset + ___4336][zone], numNszsInPartition, ___1387.___2002() ? true : false); size_t const cszMinMaxBlockSize = minMaxBlockSize((FieldDataType_e)vzFieldDataTypes[varOffset + ___4336][zone], numCszsInPartition, ___1387.___2002() ? true : false); partitionMetadata.m_cszMinMaxFileLocs[___4336] = partitionMetadata.m_nszMinMaxFileLocs[___4336] + nszMinMaxBlockSize; partitionMetadata.m_szDataStartFileLocs[___4336] = partitionMetadata.m_cszMinMaxFileLocs[___4336] + cszMinMaxBlockSize; } } return ___2039; } ___372 readOrderedPartitionHeaderArrays( ___1399&             file, ___1388 const&           ___1387, ___3945&                     ___3944, ___4352                       varOffset, ___4352                       ___2843, ___2090::SubzoneOffset_t     numCszsInPartition, ___2090::SubzoneOffset_t     numNszsInPartition, PartitionMetadata&               partitionMetadata, ___4636                      zone, ___2090::___2980         ___2977, ___4382 const& vzFieldDataTypes) { REQUIRE(file.___2041()); REQUIRE(___2843>0); REQUIRE(VALID_ITEM_ADDRESS_SUBZONE_OFFSET(numCszsInPartition-1)); REQUIRE(VALID_ITEM_ADDRESS_SUBZONE_OFFSET(numNszsInPartition-1)); REQUIRE(zone >= 0); REQUIRE(VALID_ITEM_ADDRESS_PARTITION(___2977)); ___372 ___2039 = ___4226; ___2039 = ___2039 && readVarLocations(file, ___1387, ___3944, varOffset, ___2843, numCszsInPartition, numNszsInPartition, partitionMetadata, zone, ___2977, vzFieldDataTypes); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readFEPartitionHeaderArrays( ___1399&             file, ___1388 const&           ___1387, ___3945&                     ___3944, ___4352                       varOffset, ___4352                       ___2843, ___2090::SubzoneOffset_t     numCszsInPartition, ___2090::SubzoneOffset_t     numNszsInPartition, PartitionMetadata&               partitionMetadata, ___4636                      zone, ___2090::___2980         ___2977, ___4382 const& vzFieldDataTypes) { REQUIRE(file.___2041()); REQUIRE(___2843>0); REQUIRE(VALID_ITEM_ADDRESS_SUBZONE_OFFSET(numCszsInPartition-1)); REQUIRE(VALID_ITEM_ADDRESS_SUBZONE_OFFSET(numNszsInPartition-1)); REQUIRE(partitionMetadata.m_numRefPartitions >= 0); REQUIRE(zone>=0); REQUIRE(VALID_ITEM_ADDRESS_PARTITION(___2977)); ___372 ___2039 = ___4226; try { if (___1387.___844() != ___848) { ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, CSZ_CONNECT_FILE_LOC_TAG, 0, numCszsInPartition, partitionMetadata.m_cszConnectivityFileLocs, readValueArray<uint64_t, true, 0>, IODescription(CSZ_CONNECT_FILE_LOC_DESCRIPTION,IODescription::NO_VAR,zone,___2977)); ___2039 = ___2039 && readHeaderTagArray<uint64_t>( file, ___3944, NSZ_CONNECT_FILE_LOC_TAG, 0, numNszsInPartition, partitionMetadata.m_nszConnectivityFileLocs, readValueArray<uint64_t, true, 0>, IODescription(NSZ_CONNECT_FILE_LOC_DESCRIPTION,IODescription::NO_VAR,zone,___2977)); } else { ___478(___3944.find(CSZ_CONNECT_FILE_LOC_TAG) != ___3944.end() && ___3944.find(CSZ_CONNECT_FILE_LOC_TAG)->second == ___330); ___478(___3944.find(NSZ_CONNECT_FILE_LOC_TAG) != ___3944.end() && ___3944.find(NSZ_CONNECT_FILE_LOC_TAG)->second == ___330); } ___2039 = ___2039 && readVarLocations(file, ___1387, ___3944, varOffset, ___2843, numCszsInPartition, numNszsInPartition, partitionMetadata, zone, ___2977, vzFieldDataTypes); if (___3944[NUM_REF_PARTITIONS_TAG] > 0) ___2039 = ___2039 && readHeaderTagArray<uint32_t>( file, ___3944, REF_PARTITIONS_TAG, 0, partitionMetadata.m_numRefPartitions, partitionMetadata.m_refPartitions, readValueArray<uint32_t, false, 0>, IODescription(REF_PARTITIONS_DESCRIPTION, IODescription::NO_VAR, zone, ___2977)); if (___1387.___844() != ___848) { ___2039 = ___2039 && readHeaderTagArray<uint16_t>( file, ___3944, NUM_REF_NODE_SUBZONES_TAG, 0, numCszsInPartition, partitionMetadata.m_cszNumRefNszs, readValueArray<uint16_t, false, 0>, IODescription(NUM_REF_NODE_SUBZONES_DESCRIPTION,IODescription::NO_VAR,zone,___2977)); ___2039 = ___2039 && readHeaderTagArray<uint16_t>( file, ___3944, NUM_REF_CELL_SUBZONES_TAG, 0, numNszsInPartition, partitionMetadata.m_nszNumRefCszs, readValueArray<uint16_t, false, 0>, IODescription(NUM_REF_CELL_SUBZONES_DESCRIPTION,IODescription::NO_VAR,zone,___2977)); ___2039 = ___2039 && readHeaderTagArray<uint8_t>( file, ___3944, CELL_SUBZONE_INCLUDES_PARTITIONS_TAG, 0, (numCszsInPartition+7)/8, partitionMetadata.m_cszIncludesPtn, readValueArray<uint8_t, true, 0>,
IODescription(CELL_SUBZONE_INCLUDES_PARTITIONS_DESCRIPTION,IODescription::NO_VAR,zone,___2977)); ___2039 = ___2039 && readHeaderTagArray<uint8_t>( file, ___3944, NODE_SUBZONE_INCLUDES_PARTITIONS_TAG, 0, (numNszsInPartition+7)/8, partitionMetadata.m_nszIncludesPtn, readValueArray<uint8_t, true, 0>, IODescription(NODE_SUBZONE_INCLUDES_PARTITIONS_DESCRIPTION,IODescription::NO_VAR,zone,___2977)); } else { ___478(___3944.find(NUM_REF_NODE_SUBZONES_TAG) != ___3944.end() && ___3944.find(NUM_REF_NODE_SUBZONES_TAG)->second == ___330); ___478(___3944.find(NUM_REF_CELL_SUBZONES_TAG) != ___3944.end() && ___3944.find(NUM_REF_CELL_SUBZONES_TAG)->second == ___330); ___478(___3944.find(CELL_SUBZONE_INCLUDES_PARTITIONS_TAG) != ___3944.end() && ___3944.find(CELL_SUBZONE_INCLUDES_PARTITIONS_TAG)->second == ___330); ___478(___3944.find(NODE_SUBZONE_INCLUDES_PARTITIONS_TAG) != ___3944.end() && ___3944.find(NODE_SUBZONE_INCLUDES_PARTITIONS_TAG)->second == ___330); } } catch(std::bad_alloc const&) { ___2039 = ___1186("Out-of-memory error while reading partition %" PRIu64 " header of zone %" PRIu64 ".", uint64_t(___2977+1), uint64_t(zone+1)); } catch(...) { ___2039 = ___1186("Unrecoverable error while reading partition %" PRIu64 " header of zone %" PRIu64 ".", uint64_t(___2977+1), uint64_t(zone+1)); } if ( !___2039 ) { partitionMetadata.m_nszConnectivityFileLocs.___937(); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readPartitionHeader( ___1399&             file, ___1388 const&           ___1387, ___4352                       numFileVars, ___4352                       targetBaseVarOffset, ___4636                      fileInfoZoneOffset, ___2090::___2980         ___2977, ZoneMetadata const&              zoneMetadata, ___4382 const& vzFieldDataType, PartitionMetadata&               partitionMetadata) { ___3945 ___3944; ___372 ___2039 = readPartitionHeaderTags(file, fileInfoZoneOffset, ___2977, ___3944); ___2039 = ___2039 && applyPartitionHeaderScalarTagValues(___3944, partitionMetadata); if (zoneMetadata.getZoneType() == ___4704) ___2039 = ___2039 && readOrderedPartitionHeaderArrays( file, ___1387, ___3944, targetBaseVarOffset, numFileVars, zoneMetadata.getNumCszsInPartition(___2977), zoneMetadata.getNumNszsInPartition(___2977), partitionMetadata, fileInfoZoneOffset, ___2977, vzFieldDataType); else ___2039 = ___2039 && readFEPartitionHeaderArrays( file, ___1387, ___3944, targetBaseVarOffset, numFileVars, zoneMetadata.getNumCszsInPartition(___2977), zoneMetadata.getNumNszsInPartition(___2977), partitionMetadata, fileInfoZoneOffset, ___2977, vzFieldDataType); return ___2039; } namespace { ___372 readCompressedRefSzAddresses( ___1399&         fileWrapper, ___2090::___2980     numRefPtns, ___2090::___2980     curPartition, PartitionArray const&        refPartitions, RefSubzoneOffset_t           numRefSzs, ___2090::SubzoneAddress* refSubzoneAddresses, IODescription const&         ioDescription) { REQUIRE(fileWrapper.___2041()); REQUIRE(numRefPtns != 1); REQUIRE(refPartitions.size() == numRefPtns); REQUIRE(VALID_REF(refSubzoneAddresses) && "refSubzoneAddresses size is numRefSzs"); REQUIRE(ioDescription.___2067()); ___372 ___2039 = ___4226; static size_t const MAX_BYTES_FOR_STACK_REF_PTN_OFFSETS = 1024; uint8_t  stackRefPtnOffsets[MAX_BYTES_FOR_STACK_REF_PTN_OFFSETS]; uint8_t* refPtnOffsets = NULL; size_t numBytesForRefPtnOffsets = 0; if ( numRefPtns != 0 ) { if ( numRefPtns <= MAX_ENTRIES_FOR_2_BIT_COMPRESSION ) numBytesForRefPtnOffsets = numBytesFor2BitCompression(numRefSzs); else if ( numRefPtns <= MAX_ENTRIES_FOR_4_BIT_COMPRESSION ) numBytesForRefPtnOffsets = numBytesFor4BitCompression(numRefSzs); else if ( numRefPtns <= MAX_ENTRIES_FOR_8_BIT_COMPRESSION ) numBytesForRefPtnOffsets = numRefSzs; else numBytesForRefPtnOffsets = numRefSzs*sizeof(uint16_t); if ( numBytesForRefPtnOffsets > MAX_BYTES_FOR_STACK_REF_PTN_OFFSETS ) { refPtnOffsets = (uint8_t*)malloc(numBytesForRefPtnOffsets); if ( refPtnOffsets == NULL ) ___2039 = ___1186("Cannot allocate memory for reading referenced subzone addresses"); } else refPtnOffsets = stackRefPtnOffsets; if ( numRefPtns <= MAX_ENTRIES_FOR_2_BIT_COMPRESSION ) ___2039 = ___2039 && readValues<uint8_t, true, 0>(fileWrapper, numBytesForRefPtnOffsets, refPtnOffsets, IODescription(SZ_CONNECT_REF_PTN_OFFSET_2BIT_ARRAY_DESCRIPTION)); else if ( numRefPtns <= MAX_ENTRIES_FOR_4_BIT_COMPRESSION ) ___2039 = ___2039 && readValues<uint8_t, true, 0>(fileWrapper, numBytesForRefPtnOffsets, refPtnOffsets, IODescription(SZ_CONNECT_REF_PTN_OFFSET_4BIT_ARRAY_DESCRIPTION)); else if ( numRefPtns <= MAX_ENTRIES_FOR_8_BIT_COMPRESSION ) ___2039 = ___2039 && readValues<uint8_t, true, 0>(fileWrapper, numBytesForRefPtnOffsets, refPtnOffsets, IODescription(SZ_CONNECT_REF_PTN_OFFSET_8BIT_ARRAY_DESCRIPTION)); else ___2039 = ___2039 && readValues<uint16_t, true, 0>(fileWrapper, numRefSzs, (uint16_t*)refPtnOffsets, IODescription(SZ_CONNECT_REF_PTN_OFFSET_16BIT_ARRAY_DESCRIPTION));
} ___478(sizeof(___2090::SubzoneAddress)>sizeof(uint32_t)); uint32_t * const szOffsetArray = (uint32_t*)refSubzoneAddresses; ___2039 = ___2039 && readValues<uint32_t, false, 1>(fileWrapper, numRefSzs, szOffsetArray, ioDescription); if ( ___2039 ) { if ( numRefPtns == 0 ) { ___2090::SubzoneAddress* szAddressPtr = &refSubzoneAddresses[numRefSzs]; uint32_t* szOffsetPtr = &szOffsetArray[numRefSzs]; while ( szAddressPtr > refSubzoneAddresses  ) { ___2090::SubzoneOffset_t const subzoneOffset = *(--szOffsetPtr); *(--szAddressPtr) = ___2090::SubzoneAddress(curPartition,subzoneOffset); } ___478(szAddressPtr==refSubzoneAddresses && szOffsetPtr==szOffsetArray); } else if ( numRefPtns <= MAX_ENTRIES_FOR_2_BIT_COMPRESSION ) { ___2090::SubzoneAddress* szAddressPtr = &refSubzoneAddresses[numRefSzs]; uint32_t* szOffsetPtr = &szOffsetArray[numRefSzs]; RefSubzoneOffset_t refSz = numRefSzs; while ( szAddressPtr > refSubzoneAddresses  ) { ___2090::SubzoneOffset_t const subzoneOffset = *(--szOffsetPtr); RefSubzoneOffset_t const           refPtnOffset = getValueFrom2BitCompressedArray(--refSz, refPtnOffsets); ___2090::SubzoneOffset_t const ___2977 = refPartitions[refPtnOffset]; *(--szAddressPtr) = ___2090::SubzoneAddress(___2977,subzoneOffset); } ___478(szAddressPtr==refSubzoneAddresses && szOffsetPtr==szOffsetArray && refSz==0); } else if ( numRefPtns <= MAX_ENTRIES_FOR_4_BIT_COMPRESSION ) { ___2090::SubzoneAddress* szAddressPtr = &refSubzoneAddresses[numRefSzs]; uint32_t* szOffsetPtr = &szOffsetArray[numRefSzs]; RefSubzoneOffset_t refSz = numRefSzs; while ( szAddressPtr > refSubzoneAddresses  ) { ___2090::SubzoneOffset_t const subzoneOffset = *(--szOffsetPtr); RefSubzoneOffset_t const           refPtnOffset = getValueFrom4BitCompressedArray(--refSz, refPtnOffsets); ___2090::SubzoneOffset_t const ___2977 = refPartitions[refPtnOffset]; *(--szAddressPtr) = ___2090::SubzoneAddress(___2977,subzoneOffset); } ___478(szAddressPtr==refSubzoneAddresses && szOffsetPtr==szOffsetArray && refSz==0); } else if ( numRefPtns <= MAX_ENTRIES_FOR_8_BIT_COMPRESSION ) { ___2090::SubzoneAddress* szAddressPtr = &refSubzoneAddresses[numRefSzs]; uint32_t* szOffsetPtr = &szOffsetArray[numRefSzs]; uint8_t* refPtnOffsetPtr = &refPtnOffsets[numRefSzs]; while ( szAddressPtr > refSubzoneAddresses  ) { ___2090::SubzoneOffset_t const szOffset = *(--szOffsetPtr); RefSubzoneOffset_t const           refPtnOffset = *(--refPtnOffsetPtr); ___2090::SubzoneOffset_t const ___2977 = refPartitions[refPtnOffset]; *(--szAddressPtr) = ___2090::SubzoneAddress(___2977,szOffset); } ___478(szAddressPtr==refSubzoneAddresses && szOffsetPtr==szOffsetArray && refPtnOffsetPtr==refPtnOffsets); } else { ___2090::SubzoneAddress* szAddressPtr = &refSubzoneAddresses[numRefSzs]; uint32_t* szOffsetPtr = &szOffsetArray[numRefSzs]; uint16_t* refPtnOffsetPtr = &((uint16_t*)refPtnOffsets)[numRefSzs]; while ( szAddressPtr > refSubzoneAddresses  ) { ___2090::SubzoneOffset_t const szOffset = *(--szOffsetPtr); RefSubzoneOffset_t const           refPtnOffset = *(--refPtnOffsetPtr); ___2090::SubzoneOffset_t const ___2977 = refPartitions[refPtnOffset]; *(--szAddressPtr) = ___2090::SubzoneAddress(___2977,szOffset); } ___478(szAddressPtr==refSubzoneAddresses && szOffsetPtr==szOffsetArray && refPtnOffsetPtr==(uint16_t*)refPtnOffsets); } } if ( numBytesForRefPtnOffsets > MAX_BYTES_FOR_STACK_REF_PTN_OFFSETS ) free(refPtnOffsets); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } ___372 readCszConnectivity( ___1399&         fileWrapper, ___1388 const&       ___1387, ZoneMetadata const&          zoneMetadata, ___2090::___2980     curPartition, ___2090::SubzoneOffset_t cszOffset, CszConnectivity&             cszConnectivity) { REQUIRE(fileWrapper.___2041()); REQUIRE(cszConnectivity.empty()); RefSubzoneOffset_t numRefNszs; if (___1387.getFileVersion() == 104) numRefNszs = 0; else numRefNszs = zoneMetadata.m_ptnMetadata[curPartition].m_cszNumRefNszs[cszOffset]; ___2090::___2980 numRefPtns; if (zoneMetadata.m_ptnMetadata[curPartition].m_cszIncludesPtn.empty()) { ___478(zoneMetadata.getNumPartitions() == 1); ___478(curPartition == 0); numRefPtns = 0; } else { ___478(___1387.getFileVersion() > 104); if (bitValue(zoneMetadata.m_ptnMetadata[curPartition].m_cszIncludesPtn, cszOffset)) numRefPtns = zoneMetadata.m_ptnMetadata[curPartition].m_numRefPartitions; else numRefPtns = 0; } PartitionArray emptyPartitionList; PartitionArray const& refPartitions = (numRefPtns == 0) ? emptyPartitionList : zoneMetadata.m_ptnMetadata[curPartition].m_refPartitions; ___478(refPartitions.size() == size_t(numRefPtns)); ___2090::ItemOffset_t ___2781; if (cszOffset + 1 == zoneMetadata.getNumCszsInPartition(curPartition)) ___2781 = ___2090::ItemOffset_t(((zoneMetadata.m_ptnNumCells[curPartition] - 1)&___2090::MAX_ITEM_OFFSET) + 1); else ___2781 = ___2090::MAX_ITEM_OFFSET + 1; uint32_t const ___2795 = uint32_t(___2781) * uint32_t(zoneMetadata.___1767());
___372 ___2039 = ___4226; if ( ___1387.getFileVersion() == 104 ) ___2039 = readValue<uint16_t, false>(fileWrapper, numRefNszs, IODescription(CSZ_CONNECT_NUM_REF_NSZ)); if ( ___2039 && ( numRefNszs == 0 || numRefNszs > ___2795 ) ) ___2039 = ___1186("Bad value for %s.", CSZ_CONNECT_NUM_REF_NSZ); if ( ___2039 && !cszConnectivity.alloc(___2795, numRefNszs) ) ___2039 = ___1186("Cannot allocate memory for cell connectivity (%" PRIu64 " entries, %" PRIu64 " ref subzones).", uint64_t(___2795), uint64_t(numRefNszs)); ___2039 = ___2039 && readCompressedRefSzAddresses(fileWrapper, numRefPtns, curPartition, refPartitions, numRefNszs, cszConnectivity.getRefNszArray(), IODescription(CSZ_CONNECT_REF_NSZ_ARRAY_DESCRIPTION)); if ( ___2039 ) { uint16_t* const rszOffsetArray = cszConnectivity.getRszOffsetArray(); uint16_t* const rszOffsetArrayEnd = rszOffsetArray + ___2795; if ( numRefNszs <= MAX_ENTRIES_FOR_2_BIT_COMPRESSION && ___1387.getFileVersion() > 104 ) { ___478(___2795%4==0); uint32_t const ___2779 = numBytesFor2BitCompression(___2795); uint8_t* rszCompressedPtr = ((uint8_t*)rszOffsetArrayEnd) - ___2779; ___2039 = readValues<uint8_t, true, 0>(fileWrapper, ___2779, rszCompressedPtr, IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_2BIT_ARRAY_DESCRIPTION)); if ( ___2039 ) { uint16_t* rszOffsetPtr = rszOffsetArray; while ( rszOffsetPtr < rszOffsetArrayEnd ) { uint8_t const bits = *rszCompressedPtr++; *rszOffsetPtr++ = bits>>6; *rszOffsetPtr++ = (bits>>4)&0x03; *rszOffsetPtr++ = (bits>>2)&0x03; *rszOffsetPtr++ = bits&0x03; } ___478(rszOffsetPtr==rszOffsetArrayEnd && rszCompressedPtr==(uint8_t*)rszOffsetArrayEnd); } } else if ( numRefNszs <= MAX_ENTRIES_FOR_4_BIT_COMPRESSION ) { ___478(___2795%2==0); uint32_t const ___2779 = numBytesFor4BitCompression(___2795); uint8_t* rszCompressedPtr = ((uint8_t*)rszOffsetArrayEnd) - ___2779; if ( ___1387.getFileVersion() == 104 ) ___2039 = readValues<uint8_t, false, 0>(fileWrapper, ___2779, rszCompressedPtr, IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_4BIT_ARRAY_DESCRIPTION)); else ___2039 = readValues<uint8_t, true, 0>(fileWrapper, ___2779, rszCompressedPtr, IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_4BIT_ARRAY_DESCRIPTION)); if ( ___2039 ) { uint16_t* rszOffsetPtr = rszOffsetArray; while ( rszOffsetPtr < rszOffsetArrayEnd ) { uint8_t const bits = *rszCompressedPtr++; *rszOffsetPtr++ = bits>>4; *rszOffsetPtr++ = bits&0x0F; } ___478(rszOffsetPtr==rszOffsetArrayEnd && rszCompressedPtr==(uint8_t*)rszOffsetArrayEnd); } } else if ( numRefNszs <= MAX_ENTRIES_FOR_8_BIT_COMPRESSION ) { uint8_t* rszCompressedPtr = ((uint8_t*)rszOffsetArrayEnd) - ___2795; if ( ___1387.getFileVersion() == 104 ) ___2039 = readValues<uint8_t, false, 0>(fileWrapper, ___2795, rszCompressedPtr, IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_8BIT_ARRAY_DESCRIPTION)); else ___2039 = readValues<uint8_t, true, 0>(fileWrapper, ___2795, rszCompressedPtr, IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_8BIT_ARRAY_DESCRIPTION)); if ( ___2039 ) { uint16_t* rszOffsetPtr = rszOffsetArray; while ( rszOffsetPtr < rszOffsetArrayEnd ) *rszOffsetPtr++ = *rszCompressedPtr++; ___478(rszOffsetPtr==rszOffsetArrayEnd && rszCompressedPtr==(uint8_t*)rszOffsetArrayEnd); } } else { if ( ___1387.getFileVersion() == 104 ) ___2039 = readValues<uint16_t, false, 0>(fileWrapper, ___2795, &rszOffsetArray[0], IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_16BIT_ARRAY_DESCRIPTION)); else ___2039 = readValues<uint16_t, true, 0>(fileWrapper, ___2795, &rszOffsetArray[0], IODescription(CSZ_CONNECT_REF_NSZ_OFFSET_16BIT_ARRAY_DESCRIPTION)); } } if ( ___2039 ) { uint8_t* offsetArray = cszConnectivity.getItemOffsetArray(); ___2039 = readValues<uint8_t, false, 0>(fileWrapper, ___2795, offsetArray, IODescription(CSZ_CONNECT_NSZ_OFFSET_ARRAY_DESCRIPTION)); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readNszConnectivity( ___1399&     fileWrapper, ___1388 const&   ___1387, ___2090::___2980 numRefPtns, ___2090::___2980 curPartition, PartitionArray const&    refPartitions, RefSubzoneOffset_t       numRefCszs, NszConnectivity&         nszConnectivity) { REQUIRE(fileWrapper.___2041()); REQUIRE(IMPLICATION(___1387.getFileVersion() == 104, numRefPtns == 0)); REQUIRE(refPartitions.size() == numRefPtns); REQUIRE(___1387.getFileVersion() == 104 ? numRefCszs == 0 : numRefCszs>0); REQUIRE(nszConnectivity.empty()); ___372 ___2039 = ___4226; if ( ___1387.getFileVersion() == 104 ) ___2039 = readValue<uint16_t, false>(fileWrapper, numRefCszs, IODescription(NSZ_CONNECT_NUM_REF_CSZ)); if ( ___2039 && !nszConnectivity.setNumRszs(numRefCszs) ) ___2039 = ___1186("Cannot allocate memory for node connectivity referenced cell subzones (%" PRIu64 " subzones).", uint64_t(numRefCszs)); if ( ___2039 && numRefCszs > 0 ) ___2039 = ___2039 && readCompressedRefSzAddresses(fileWrapper, numRefPtns, curPartition, refPartitions, numRefCszs, &nszConnectivity.m_refCszs[0], IODescription(NSZ_CONNECT_REF_CSZS)); ENSURE(VALID_BOOLEAN(___2039));
return ___2039; } }}
