#include "readValueArray.h"
#include "ThirdPartyHeadersBegin.h"
#include <utility>
#include <boost/algorithm/string.hpp>
#include <boost/static_assert.hpp>
#include "ThirdPartyHeadersEnd.h"
#include "fileStuff.h"
#include "MinMax.h"
#include "writeValueArray.h"
namespace tecplot { namespace ___3933 { template <typename T, bool ___2025> struct ___198; template <> struct ___198 < char, false >     { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint8_t, false >  { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < int16_t, false >  { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint16_t, false > { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < int32_t, false >  { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint32_t, false > { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint64_t, false > { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < float, false >    { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < double, false >   { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint8_t, true >   { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint16_t, true >  { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < uint64_t, true >  { static char const* ___1474; static char const* typeName; }; template <> struct ___198 < std::pair<uint8_t, uint8_t>, false > { static char const* typeName; }; template <> struct ___198 < std::pair<int16_t, int16_t>, false > { static char const* typeName; }; template <> struct ___198 < std::pair<int32_t, int32_t>, false > { static char const* typeName; }; template <> struct ___198 < std::pair<float, float>, false >     { static char const* typeName; }; template <> struct ___198 < std::pair<double, double>, false >   { static char const* typeName; }; char const* ___198<char, false>::___1474 = "%c"; char const* ___198<uint8_t, false>::___1474 = "%" PRIu32; char const* ___198<int16_t, false>::___1474 = "%" PRId32; char const* ___198<uint16_t, false>::___1474 = "%" PRIu32; char const* ___198<int32_t, false>::___1474 = "%" PRId32; char const* ___198<uint32_t, false>::___1474 = "%" PRIu32; char const* ___198<uint64_t, false>::___1474 = "%" PRIu64; char const* ___198<float, false>::___1474 = "%f"; char const* ___198<double, false>::___1474 = "%lf"; char const* ___198<uint8_t, true>::___1474 = "%" PRIx32; char const* ___198<uint16_t, true>::___1474 = "%" PRIx32; char const* ___198<uint64_t, true>::___1474 = "%" PRIx64; char const* ___198<char, false>::typeName = "single character"; char const* ___198<uint8_t, false>::typeName = "1-byte unsigned integer"; char const* ___198<int16_t, false>::typeName = "2-byte unsigned integer"; char const* ___198<uint16_t, false>::typeName = "2-byte signed integer"; char const* ___198<int32_t, false>::typeName = "4-byte signed integer"; char const* ___198<uint32_t, false>::typeName = "4-byte unsigned integer"; char const* ___198<uint64_t, false>::typeName = "8-byte unsigned integer"; char const* ___198<float, false>::typeName = "float"; char const* ___198<double, false>::typeName = "double"; char const* ___198<uint8_t, true>::typeName = "1-byte unsigned integer"; char const* ___198<uint16_t, true>::typeName = "2-byte unsigned integer"; char const* ___198<uint64_t, true>::typeName = "8-byte hexadecimal"; char const* ___198<std::pair<uint8_t, uint8_t>, false >::typeName = "MinMax<uint8_t>"; char const* ___198<std::pair<int16_t, int16_t>, false >::typeName = "MinMax<int16_t>"; char const* ___198<std::pair<int32_t, int32_t>, false >::typeName = "MinMax<int32_t>"; char const* ___198<std::pair<float, float>, false >::typeName = "MinMax<float>"; char const* ___198<std::pair<double, double>, false >::typeName = "MinMax<double>"; template <typename T, bool ___2025, int baseValue> ___372 readAsciiValue( ___1399& file, T&                   ___4298) { char const* ___1474 = ___198<T, ___2025>::___1474; ___372 ___2039 = (file.fscanf(___1474, &___4298) == 1); if (___2039 && baseValue) ___4298 -= baseValue; ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #define INSTANTIATE_READ_ASCII_UINT_VALUE(T, ___2025) \
 template <> \
 ___372 readAsciiValue < T, ___2025, 0 >(___1399& file, T& ___4298) \
 { \
 char const* ___1474 = ___198<T, ___2025>::___1474; \
 uint32_t valFromFile; \
 ___372 ___2039 = (file.fscanf(___1474, &valFromFile) == 1); \
 if (___2039) \
 ___2039 = (valFromFile <= T(-1));    \
 if (___2039) \
 ___4298 = static_cast<T>(valFromFile); \
 ENSURE(VALID_BOOLEAN(___2039)); \
 return ___2039; \
 }
INSTANTIATE_READ_ASCII_UINT_VALUE(uint8_t, false) INSTANTIATE_READ_ASCII_UINT_VALUE(uint8_t, true) INSTANTIATE_READ_ASCII_UINT_VALUE(uint16_t, false) INSTANTIATE_READ_ASCII_UINT_VALUE(uint16_t, true) template <> ___372 readAsciiValue < int16_t, false, 0 >( ___1399& file, int16_t&             ___4298) { char const* ___1474 = ___198<int16_t, false>::___1474; int32_t valFromFile; ___372 ___2039 = (file.fscanf(___1474, &valFromFile) == 1); if (___2039) ___2039 = (-std::numeric_limits<int16_t>::max() <= valFromFile && valFromFile <= std::numeric_limits<int16_t>::max()); if (___2039) ___4298 = static_cast<int16_t>(valFromFile); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #define INSTANTIATE_READ_ASCII_VALUE_PAIR(T) \
 template <> \
 ___372 readAsciiValue<std::pair<T, T>, false, 0 >(___1399& file, std::pair<T, T>& minMax) \
 { \
 ___372 ___2039 = (readAsciiValue<T, false, 0>(file, minMax.first) == 1 && \
 readAsciiValue<T, false, 0>(file, minMax.second) == 1); \
 ENSURE(VALID_BOOLEAN(___2039)); \
 return ___2039; \
 }
INSTANTIATE_READ_ASCII_VALUE_PAIR(uint8_t) INSTANTIATE_READ_ASCII_VALUE_PAIR(int16_t) INSTANTIATE_READ_ASCII_VALUE_PAIR(int32_t) INSTANTIATE_READ_ASCII_VALUE_PAIR(float) INSTANTIATE_READ_ASCII_VALUE_PAIR(double) namespace { inline bool isWhitespace(___2718 const ch) { return ch == ' ' || ch == '\n' || ch == '\r'; } } namespace { ___372 consumeWhitespace(___1399& file) { REQUIRE(file.___2041()); while (!file.feof()) { int ch = file.getc(); if (!isWhitespace(ch)) { file.ungetc(ch); break; } } return ___4226; } } namespace { ___372 checkDescription( char const*          stringToCheck, IODescription const& ___972) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___372 const ___2039 = (boost::iequals(stringToCheck, formattedDescription) ? ___4226 : ___1305); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } namespace { ___372 readAndVerifyDescription( ___1399& file, IODescription const& ___972) { REQUIRE(file.___2041()); char encounteredString[STRING_SIZE]; ___372 ___2039 = (file.fscanf(STRING_FORMAT, encounteredString) == 1); ___2039 = ___2039 && consumeWhitespace(file); if (!___2039) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Cannot read description for %s.", formattedDescription); } else { if (!checkDescription(encounteredString, ___972)) { static TagDescriptionToDescriptionMap altTagDescriptions = ALT_TAG_DESCRIPTIONS_MAP_INITIALIZER; char const* nameToCheck = ___972.___2685(); ___478(VALID_REF(nameToCheck)); while (___2039) { TagDescriptionToDescriptionMap::const_iterator altTagDescIter = altTagDescriptions.find(nameToCheck); if (altTagDescIter == altTagDescriptions.end()) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___2039 = ___1186("Mismatched descriptions: looking for '%s', found '%s' instead.", formattedDescription, encounteredString); } else { nameToCheck = altTagDescIter->second.c_str(); IODescription altDescription(nameToCheck, ___972.___4336(), ___972.zone(), ___972.___2977(), ___972.segment(), ___972.suffix()); if (checkDescription(encounteredString, altDescription)) break; } } } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } } template<typename T, bool ___2025  > ___372 readValue( ___1399& file, T&                   ___4298, IODescription const& ___972) { REQUIRE(file.___2041()); REQUIRE(___972.___2067()); ___372 ___2039 = ___4226; if (file.___2002()) { ___2039 = ___2039 && readAndVerifyDescription(file, ___972); ___2039 = ___2039 && readAsciiValue<T, ___2025, 0>(file, ___4298); ___2039 = ___2039 && consumeWhitespace(file); } else { ___2039 = (file.fread(&___4298, sizeof(T), 1) == 1); } if (!___2039) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Cannot read %s value.", formattedDescription); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #define INSTANTIATE_READ_VALUE_FOR_TYPE(T, ___2025) \
 template ___372 readValue<T, ___2025>( \
 ___1399& file, \
 T&                   ___4298, \
 IODescription const& ___972);
INSTANTIATE_READ_VALUE_FOR_TYPE(uint8_t,  false) INSTANTIATE_READ_VALUE_FOR_TYPE(uint16_t, false) INSTANTIATE_READ_VALUE_FOR_TYPE(int32_t,  false) INSTANTIATE_READ_VALUE_FOR_TYPE(uint32_t, false) INSTANTIATE_READ_VALUE_FOR_TYPE(uint64_t, true) INSTANTIATE_READ_VALUE_FOR_TYPE(uint64_t, false) INSTANTIATE_READ_VALUE_FOR_TYPE(float,    false) INSTANTIATE_READ_VALUE_FOR_TYPE(double,   false) template<typename T, bool ___2025, int baseValue> ___372 readValues( ___1399& file, size_t               ___2796, T*                   ___4299, IODescription const& ___972) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(___2796>0); REQUIRE(VALID_REF(___4299)); REQUIRE(___972.___2067()); if (file.___2002()) { if (!___972.isEmpty()) ___2039 = readAndVerifyDescription(file, ___972); for (size_t ___1841 = 0; ___2039 && ___1841 < ___2796; ___1841++) { ___2039 = readAsciiValue<T, ___2025, baseValue>(file, ___4299[___1841]); ___2039 = ___2039 && consumeWhitespace(file); } } else { ___2039 = (file.fread(&___4299[0], sizeof(T), ___2796) == ___2796); } if ( !___2039 && !___972.isEmpty() ) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Error reading %" PRIu64 " %s values for %s data block.", uint64_t(___2796), ___198<T, ___2025>::typeName, formattedDescription); } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #define INSTANTIATE_READ_VALUES_FOR_TYPE(T, ___2025, baseValue) \
 template ___372 readValues<T, ___2025, baseValue>( \
 ___1399& file, \
 size_t               ___2796, \
 T*                   ___4299, \
 IODescription const& ___972);
INSTANTIATE_READ_VALUES_FOR_TYPE(char,     false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint8_t,  false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint8_t,  true,  0) INSTANTIATE_READ_VALUES_FOR_TYPE(int16_t,  false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint16_t, false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint16_t, true,  0) INSTANTIATE_READ_VALUES_FOR_TYPE(int32_t,  false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint32_t, false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint32_t, false, 1) INSTANTIATE_READ_VALUES_FOR_TYPE(uint64_t, false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(uint64_t, true,  0) INSTANTIATE_READ_VALUES_FOR_TYPE(float,    false, 0) INSTANTIATE_READ_VALUES_FOR_TYPE(double,   false, 0) template<typename T, bool ___2025, int baseValue> ___372 readValueArray( ___1399&  file, size_t                ___2865, size_t                ___2795, ___2240<T>& ___4299, IODescription const&  ___972) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(IMPLICATION(___4299.empty(), ___2865 == 0)); REQUIRE(IMPLICATION(!___4299.empty(), ___2865 + ___2795 <= ___4299.size())); REQUIRE(___2795 > 0); REQUIRE(___972.___2067()); if (___4299.empty()) { ___2039 = ___4299.alloc(___2795); if (!___2039) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Cannot allocate memory for %s data block of %" PRIu64 " %s values.", formattedDescription, uint64_t(___2795), ___198<T, ___2025>::typeName); } } ___2039 = ___2039 && readValues<T, ___2025, baseValue>(file, ___2795, &___4299[___2865], ___972); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #define INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(T, ___2025, baseValue) \
 template ___372 readValueArray<T, ___2025, baseValue>( \
 ___1399&  file, \
 size_t                ___2865, \
 size_t                ___2795, \
 ___2240<T>& ___4299, \
 IODescription const&  ___972);
INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(char,     false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint8_t,  false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint8_t,  true,  0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(int16_t,  false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint16_t, false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint16_t, true,  0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(int32_t,  false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint32_t, false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint32_t, false, 1) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint64_t, false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(uint64_t, true,  0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(float,    false, 0) INSTANTIATE_READ_VALUE_ARRAY_FOR_TYPE(double,   false, 0) template<typename T> ___372 readMinMaxArray( ___1399& file, size_t               ___2865, size_t               ___2795, ___2481&         ___2480, IODescription const& ___972) { REQUIRE(file.___2041()); REQUIRE(___972.___2067()); REQUIRE(___2795 > 0); REQUIRE(IMPLICATION(___2480.empty(), ___2865 == 0)); REQUIRE(IMPLICATION(!___2480.empty(), ___2865 + ___2795 <= ___2480.size())); ___372 ___2039 = ___4226; char const* typeName = "min-max value"; if (___2480.empty()) { ___2039 = ___2480.alloc(___2795); if (!___2039) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Cannot allocate memory for %s data block (%" PRIu64 " %s values).", formattedDescription, uint64_t(___2795), typeName); } } if (file.___2002() && !___972.isEmpty()) ___2039 = readAndVerifyDescription(file, ___972); IODescription emptyDescription; size_t const maxValsPerChunk = 1024; std::pair<T, T> valsFromFile[maxValsPerChunk]; INVARIANT(sizeof(valsFromFile[0]) == 2 * sizeof(T)); size_t numValsRead = 0; while (___2039 && numValsRead < ___2795) { size_t const numChunkedValsToRead = std::min(maxValsPerChunk, ___2795 - numValsRead); ___2039 = readValues<std::pair<T, T>, false, 0>(file, numChunkedValsToRead, valsFromFile, emptyDescription); if (___2039) { for (size_t ___1841 = 0; ___1841 < numChunkedValsToRead; ++___1841) ___2480[___2865 + numValsRead + ___1841].___3499(static_cast<double>(valsFromFile[___1841].first), static_cast<double>(valsFromFile[___1841].second)); numValsRead += numChunkedValsToRead; } else { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Error reading %" PRIu64 " %s values for %s data block.", uint64_t(___2795), ___198<std::pair<T, T>, false>::typeName, formattedDescription); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; }
 #define INSTANTIATE_READ_MINMAX_ARRAY_FOR_TYPE(T) \
 template \
 ___372 readMinMaxArray<T>( \
 ___1399& file, \
 size_t               ___2865, \
 size_t               ___2795, \
 ___2481&         ___2480, \
 IODescription const& ___972);
INSTANTIATE_READ_MINMAX_ARRAY_FOR_TYPE(uint8_t) INSTANTIATE_READ_MINMAX_ARRAY_FOR_TYPE(int16_t) INSTANTIATE_READ_MINMAX_ARRAY_FOR_TYPE(int32_t) INSTANTIATE_READ_MINMAX_ARRAY_FOR_TYPE(float) INSTANTIATE_READ_MINMAX_ARRAY_FOR_TYPE(double) template<typename T, bool ___2025> ___372 readAndVerifyValue( ___1399& file, T const              expectedVal, IODescription const& ___972) { REQUIRE(file.___2041()); REQUIRE(___972.___2067()); T ___4298 = 0; ___372 ___2039 = readValue<T, ___2025>(file, ___4298, ___972); if (___2039 && ___4298 != expectedVal) { ___2039 = ___1305; char expectedValStr[STRING_SIZE]; char valStr[STRING_SIZE]; if (encodeAsciiValue<T, ___2025, 0>(expectedValStr, STRING_SIZE, expectedVal) && encodeAsciiValue<T, ___2025, 0>(valStr, STRING_SIZE, ___4298)) { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Expected value mismatch for %s %s (expecting %s, found %s).", ___198<T, ___2025>::typeName, formattedDescription, expectedValStr, valStr); } else { char formattedDescription[STRING_SIZE]; ___972.getFormattedDescription(formattedDescription, STRING_SIZE); ___1186("Expected value mismatch for %s %s.", ___198<T, ___2025>::typeName, formattedDescription); } } ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } template ___372 readAndVerifyValue<unsigned int, false>( ___1399& file, unsigned int const   expectedVal, IODescription const& ___972); ___372 readString( ___1399& file, size_t               length, ___473&           ___4298, IODescription const& ___972) { ___372 ___2039 = ___4226; REQUIRE(file.___2041()); REQUIRE(___972.___2067() && !___972.isEmpty()); REQUIRE(length > 0); REQUIRE(___4298.size() == length); if (file.___2002()) ___2039 = ___2039 && readAndVerifyDescription(file, ___972); ___2039 = ___2039 && (file.fread(&___4298[0], 1, length) == length); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } ___372 readStringArray( ___1399& file, size_t               ___2865, size_t               ___2812, ___3816&         itemNameArray, IODescription const& ___972) { REQUIRE(file.___2041()); REQUIRE(IMPLICATION(itemNameArray.empty(), ___2865 == 0)); REQUIRE(IMPLICATION(!itemNameArray.empty(), ___2865 + ___2812 <= itemNameArray.size())); REQUIRE(___2812 > 0); REQUIRE(___972.___2067() && !___972.isEmpty()); ___372 ___2039 = ___4226; if (itemNameArray.empty()) { if (!itemNameArray.alloc(___2812)) ___2039 = ___1186("Cannot resize string array."); } uint64_t totalStringListSize = 0; IODescription totalSizeDescription(___972.___2685(), ___972.___4336(), ___972.zone(), ___972.___2977(), ___972.segment(), "TotalSize" ); ___2039 = ___2039 && readValue<uint64_t, false>(file, totalStringListSize, totalSizeDescription); ASSERT_ONLY(___1393 startFileLoc = ___2039 ? file.fileLoc() : 0;) if (file.___2002()) ___2039 = ___2039 && readAndVerifyDescription(file, ___972); for (size_t ___2085 = 0; ___2039 && ___2085 < ___2812; ___2085++) { char ___2685[500]; for (size_t pos = 0; ___2039 && pos < sizeof(___2685); pos++) { int ch = file.getc(); if (ch == EOF) { ___2039 = ___1186("Unexpected end of file reading string array."); break; } else if (ch == '\r') { ___2685[pos] = '\0'; ___478(strlen(___2685) < sizeof(___2685)); itemNameArray[___2865 + ___2085] = ___2685; break; } else { ___2685[pos] = char(ch); } } if (___2039 && file.___2002()) if (file.getc() != '\n') ___2039 = ___1186("Problem with end of line in ascii string array."); } ASSERT_ONLY(___1393 curFileLoc = ___2039 ? file.fileLoc() : 0;) ___478(IMPLICATION(___2039, curFileLoc - startFileLoc == totalStringListSize)); ENSURE(VALID_BOOLEAN(___2039)); return ___2039; } }}
