/*! This file is the record of changes on compiler data structures in attempt to move
  the variable-base data and rule-based data into  sched_db, so that existential_analysis
  might be  or close to be const to compilers.
*/

/*!
  Introduction:
  
  During installation of randomized memory greedy scheduler,
  function existential_analysis of graph_compiler need to be called twice.
  The first time is to gather the memory allocation information;
  the second time is for actual scheduling.
  
  Chem test passed in series, but failed in parallel.

  The reason might be:
  
  During first time existential_analysis, the compilers store some information in
  their own data structure and in sched_db, or even in fact_db.
  The information is not cleared and
  cause the errors during the second time existential analysis and scheduling.

  One solution is to use local sched_db, fact_db and graph_compiler. Make sure
  that all information except for memeroy allocation is wiped out after the first time
  existential_analysis.

  The second solution is analyzing the information the compilers stored in their own data structure,
  separating data(variable_based or rule_based) from structure(sequence),
  and moving the information into sched_db.
  
  If during existential analysis, compilers can store all the info into sched_db, or another database, 
  then set_var_existence  and process_var_request will be const to rule_compiler and all the derived classes,
  it will make the future maintenance of Loci
  much easier.
  
 
*/


/*!
  If set_var_existence and process_var_request become const, barrier_compiler, chomp_compiler, loop_compiler,
  impl_recurse_compiler and recurse_compiler will need their data member changed.
 
  This file document the data members of compilers and how they are modified
  by set_var_existence and process_var_request.
  
*/ 



/*!
  comp_tools.cc
  line 2202:  send_entities = barrier_existential_rule_analysis(barrier_vars, facts, scheds) ;
  line 2243:  plist = put_precomm_info(send_requested, facts) ;
  line 2224:  clist = request_comm ;
  line 2225:  clist = sort_comm(request_comm,facts) ;
*/
 struct comm_info {
    variable v ;
    int processor ;
    entitySet send_set ;
    sequence recv_set ;
 } ;

class barrier_compiler : public rule_compiler {
  variableSet barrier_vars ;
   
  /*! line 2202: send_entities = barrier_existential_rule_analysis(barrier_vars, facts, scheds) ;
    in set_var_existence */
  /*! the entities I suppose to send, generated by
    exinfo[exent[i]] - d->my_entities used to generate pre_comm info*/
  std::vector<std::pair<variable,entitySet> > send_entities ;
  /*! clist and plist in process_var_request */

  /*! line 2224:  clist = request_comm ;
    line 2225:  clist = sort_comm(request_comm,facts) ;
    in  process_var_request */
  /*! during process_var_request, first clist is generated by send_request():
     for(int vid= 0; vid <num_variables; vid++){
     for(int pid = 0; pid < num_procs; pid++){
     slist.push_back(recv_comm);
     }
     for(int vid= 0; vid <num_variables; vid++){
     for(int pid = 0; pid < num_procs; pid++){
     slist.push_back(send_comm);
     } 
  */
  std::list<comm_info> clist ;
   
  /*! line 2243:  plist = put_precomm_info(send_requested, facts) ;
    in process_var_request */
  /*! first half of plist is send info, second half is recv info.
    iteration:
    for (int pid = 0; pid < num_procs; pid++){
    for(int vid = 0; vid < num_variables; vid++){
    slist.push_back(send_comm);
    }
    for (int pid = 0; pid < num_procs; pid++){
    for(int vid = 0; vid < num_variables; vid++){
    slist.push_back(recv_comm);
    }
  */
    
  std::list<comm_info> plist ;
}


/* comp_reduce.cc
   line 65:   exec_seq = process_applyrule_requests(apply, unit_tag, output_mapping, facts, scheds);
   line 581:  rlist = sort_comm(slist,facts) ;
   line 584:  clist = sort_comm(request_comm,facts) ;
*/

  class apply_compiler : public rule_compiler {
    rule apply,unit_tag ;  // rule to applyement
    /*!
      line 65:   exec_seq = process_applyrule_requests(apply, unit_tag, output_mapping, facts, scheds);
    */
    // existential analysis info
    entitySet exec_seq ;
    bool output_mapping ;
  }
  class reduce_store_compiler{  
    variable reduce_var ;
    rule unit_rule ;
    CPTR<joiner> join_op ;
    
    /*! rlist and clist  generated by process_var_requests, used by create_execution_schedule
      set_var_existence function is empty for this compiler
    */


    /*! line 581:  rlist = sort_comm(slist,facts) ;
      in process_var_request
    */
    std::list<comm_info> rlist ;  // reduction communication

    /*! line 584:  clist = sort_comm(request_comm,facts) ;
      in process_var_request
    */ 
    std::list<comm_info> clist ;  // comm from owner to requester

  }

  

  /* comp_loop.cc

     line 411:  advance_variables_barrier = barrier_process_rule_requests(var_requests, facts, scheds);
     line 412: advance_variables_barrier = sort_comm(advance_variables_barrier, facts);
     line 349, 373: iterator 

  */
    class loop_compiler : public rule_compiler {
    public:
      int cid ; // id number of this compiler
      std::vector<rule_compilerP> collapse_comp ; 
      variable cond_var ;
      std::vector<rule_compilerP> advance_comp ;
      variableSet advance_vars ;
      time_ident tlevel ;
      variableSet all_loop_vars ;
      ////////////
      variableSet collapse_vars ; // the collapse variables
      std::vector<digraph::vertexSet> collapse_sched ;
      std::vector<digraph::vertexSet> advance_sched ;
      // the rotate list
      std::list<std::list<variable> > rotate_lists ;
      ////////////////
      // the internal loop graph and the rulecomp map
      digraph loop_gr ;
      digraph collapse_gr ;
      digraph advance_gr ;
      rulecomp_map rule_compiler_map ;
      ////////////////

      //To add communication manually for advance variable at the end of advance_comp
      /*! if(facts.isDistributed()) {
        line 411:  advance_variables_barrier = barrier_process_rule_requests(var_requests, facts, scheds);
        line 412: advance_variables_barrier = sort_comm(advance_variables_barrier, facts);
        }
        in process_var_request */
       
      std::list<comm_info> advance_variables_barrier;
    }
    /*! comp_chomp.cc
      line 295:   vector<pair<rule,rule_compilerP> >::iterator i ;
      line 335:     barrier_sets.push_back(tvars); 
      line 404:    vector<pair<rule,rule_compilerP> >::reverse_iterator ri ;
      line 436:    rule_seq.push_front(exec_seq) ;
      line 439:    chomp_comp.clear() ;
      line 442:    chomp_comp.push_back(*di) ;
    */
      
    /*!new data structure old_barrier_set and old_chomp_comp are added to chomp_compiler.
      They will record the result generated by visitors.
      barrier_set, rule_seq and chomp_comp will be initialized
      in set_var_existence and process_var_request
      
    */
      
      class chomp_compiler: public rule_compiler {
      public:
        digraph chomp_graph ;
        variableSet chomp_vars ;
        std::vector<digraph::vertexSet> chomp_sched ;
            
        /*! line 439: chomp_comp.clear() ;
          ...
          line 442: chomp_comp.push_back(*di) ;
          in procee_var_request */
        std::vector<std::pair<rule,rule_compilerP> > chomp_comp ;
        /*! line 436: rule_seq.push_front(exec_seq) ;
          in process_var_request */
        std::deque<entitySet> rule_seq ;
        
        std::map<rule,rule> apply2unit ;
        
        /*! line 335:  barrier_sets.push_back(tvars);
          in set_var_existence
        this data is also modified by compChompVisitor  
        */
        std::vector<variableSet> barrier_sets;
      }


      /*! comp_recurse.cc
        line 51:  fcontrol &fctrl = control_set ;
        line 59:  pre_send_entities = barrier_existential_rule_analysis(recurse_vars,facts, scheds) ;
        line 97: fctrl.recursion_maps.push_back(minfo) ;
        line 222: fastseq += sequence(sdelta) ;
        line 429: clist = sort_comm(request_comm,facts) ;
      */
      /*! add  fctrl.recursion_maps.clear();
        fastseq = EMPTY;
        at line 52
      */
        class impl_recurse_compiler{

          rule impl ;  // rule to implement
          struct fcontrol {
            std::list<entitySet> control_list ;
            std::map<variable,entitySet> generated ;
            bool use_constraints ;
            entitySet nr_sources, constraints ;
            struct mapping_info {
              entitySet total ;
              std::vector<MapRepP> mapvec ;
              std::vector<variable> mapvar ;
              variable v ;
            } ;
            std::vector<mapping_info> recursion_maps, target_maps ;
          } ;

          /*! line 51: fcontrol &fctrl = control_set ;
            ...
        
            line 97: fctrl.recursion_maps.push_back(minfo);
            in set_var_existence()
          */
          fcontrol  control_set ;  /*! DATA IS MODIFIED BY PUSH_BACK OR += */
          /*! line 222: fastseq += sequence(sdelta) ;
            in set_var_existence */
          sequence fastseq ;
         
          std::vector<entitySet > par_schedule ; /*! never used anywhere */
          
          /*! line 59: pre_send_entities = barrier_existential_rule_analysis(recurse_vars,facts, scheds)
            in set_var_existence */
          std::vector<std::pair<variable,entitySet> > pre_send_entities ;//assigned, never used
          /*! line 429: clist = sort_comm(request_comm,facts) ;
            in process_var_request */
          std::list<comm_info> clist ;//assigned, but never used

        }

        /*! comp_recurse.cc
          line 448: pre_send_entities = barrier_existential_rule_analysis(recurse_vars,facts, scheds) ;
          line 452: control_set.clear() ; //clear up everything
          line 461: fcontrol &fctrl = control_set[*fi] ;
          line 491: fctrl.recursion_maps.push_back(minfo) ;
          line 552: fctrl.recursion_maps[i].total += sdelta ;
          line 647:  recurse_send_entities.back().push_back(make_pair(*vi,tvar_other)) ;
          line 655: recurse_send_entities.back().push_back(make_pair(*vi,tvar_other)) ;
          line 675:  fcontrol &fctrl = control_set[*fi] ;
          line 730:  pre_plist = put_precomm_info(send_requested, facts) ;
          line 732, 757: fcontrol &fctrl = control_set[*fi] ;
          ...
          line 839: pre_clist = sort_comm(pre_req_comm,facts) ;
          line 840: post_clist = sort_comm(post_req_comm,facts) ;
        */
        /*!   recurse_send_entities.clear();
          send_req_var.clear();
          added at line 455
          */
          class recurse_compiler : public rule_compiler {
            rulecomp_map &rule_process ;
  
            rule_compilerP calc(const rule &r) 
            {return rule_process[r] ;}
 
     
            ruleSet recurse_rules ;
            variableSet recurse_vars ;
            struct fcontrol {
              std::list<entitySet> control_list ;

              std::map<variable,entitySet> generated ;
              bool use_constraints ;
              entitySet nr_sources, constraints ;
              struct mapping_info {
                entitySet total ;
                std::vector<MapRepP> mapvec ;
                variable v ;
              } ;
              std::vector<mapping_info> recursion_maps, target_maps ;
            } ;

            /*!
              line 452: control_set.clear() ;
              line 461: fcontrol &fctrl = control_set[*fi] ; 
              line 552: fctrl.recursion_maps[i].total += sdelta ;
              line 675, 732, 757: fcontrol &fctrl = control_set[*fi] ;
              line 773: (rpos[*ri] == control_set[*ri].control_list.rend())
              in set_var_existence */
            std::map<rule,fcontrol > control_set ;


            /*! line 647:  recurse_send_entities.back().push_back(make_pair(*vi,tvar_other)) ;
              line 655: recurse_send_entities.back().push_back(make_pair(*vi,tvar_other)) ;
              in set_var_existence */ 
            std::list<std::vector<std::pair<variable,entitySet> > > recurse_send_entities ;
      
            /*!   send_req_var[*vi].push_back(sort_comm(req_comm,facts)) ;
              in process_var_request */
            std::map<variable,std::vector<std::list<comm_info> > > send_req_var ;

            std::list<std::list<comm_info> > recurse_clist ;/*! never been used anywhere*/
            std::list<std::list<comm_info> > recurse_plist ;/*! never been used anywhere*/

            /*! line 448: pre_send_entities = barrier_existential_rule_analysis()
              in set_var_existence */   
            std::vector<std::pair<variable,entitySet> > pre_send_entities ;
   
            /*! line 839: pre_clist = sort_comm(pre_req_comm,facts) ;
              in process_var_request
            */
            std::list<comm_info> pre_clist ;
            /*  line 840: post_clist = sort_comm(post_req_comm,facts) ;
                in process_var_request
            */
            std::list<comm_info> post_clist ;

            /*! line 730:  pre_plist = put_precomm_info(send_requested, facts) ;
              in process_var_request
            */
            std::list<comm_info> pre_plist ;
          }
   

          /* the change to other compilers are trival, just iterator become const or exec_seq
             comp_map.cc: line 133, exec_seq,  for map_compiler
             comp_constraint.cc: line 90, exec_seq, for constraint_compiler
             comp_dynamic.cc, line 58, 65, iterator, for dynamic_compiler
             comp_cond.cc, line 114, 119, iterator, for conditional_compiler
             comp_dag.cc, line 80, 86, iterator, for dag_compiler
          */
     
      
          /* exec_seq:
             impl_compiler, apply_compiler, constraint_compiler, map_compiler and blackbox_compiler
          */
          

          

            
            
            
